#ifndef GABA_DEFINE
struct unix_user
{
  struct user super;
  gid_t gid;
  struct lsh_string *passwd;
  struct lsh_string *home;
  struct lsh_string *shell;
};
extern struct lsh_class unix_user_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_unix_user_free(struct lsh_object *o)
{
  struct unix_user *i = (struct unix_user *) o;
  lsh_string_free(i->passwd);
  lsh_string_free(i->home);
  lsh_string_free(i->shell);
}

struct lsh_class unix_user_class =
{ STATIC_HEADER,
  &user_class, "unix_user", sizeof(struct unix_user),
  NULL,
  do_unix_user_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct unix_user_db
{
  struct user_db super;
  int allow_root;
};
extern struct lsh_class unix_user_db_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class unix_user_db_class =
{ STATIC_HEADER,
  &user_db_class, "unix_user_db", sizeof(struct unix_user_db),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

