#ifndef GABA_DEFINE
struct dh_server_exchange
{
  struct keyexchange_algorithm super;
  struct dh_method *dh;
};
extern struct lsh_class dh_server_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dh_server_exchange_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_server_exchange *i = (struct dh_server_exchange *) o;
  mark((struct lsh_object *) i->dh);
}

struct lsh_class dh_server_exchange_class =
{ STATIC_HEADER,
  &keyexchange_algorithm_class, "dh_server_exchange", sizeof(struct dh_server_exchange),
  do_dh_server_exchange_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dh_server
{
  struct packet_handler super;
  struct dh_instance dh;
  struct signer *signer;
  struct object_list *algorithms;
};
extern struct lsh_class dh_server_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dh_server_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_server *i = (struct dh_server *) o;
  dh_instance_mark(&i->dh, mark);
  mark((struct lsh_object *) i->signer);
  mark((struct lsh_object *) i->algorithms);
}

static void do_dh_server_free(struct lsh_object *o)
{
  struct dh_server *i = (struct dh_server *) o;
  dh_instance_free(&i->dh);
}

struct lsh_class dh_server_class =
{ STATIC_HEADER,
  &packet_handler_class, "dh_server", sizeof(struct dh_server),
  do_dh_server_mark,
  do_dh_server_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_server_instance
{
  struct lsh_object super;
  struct dh_instance dh;
  struct object_list *algorithms;
  struct user_db *db;
  struct lsh_user *user;
  struct srp_entry *entry;
};
extern struct lsh_class srp_server_instance_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_server_instance_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_server_instance *i = (struct srp_server_instance *) o;
  dh_instance_mark(&i->dh, mark);
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->db);
  mark((struct lsh_object *) i->user);
  mark((struct lsh_object *) i->entry);
}

static void do_srp_server_instance_free(struct lsh_object *o)
{
  struct srp_server_instance *i = (struct srp_server_instance *) o;
  dh_instance_free(&i->dh);
}

struct lsh_class srp_server_instance_class =
{ STATIC_HEADER,
  0, "srp_server_instance", sizeof(struct srp_server_instance),
  do_srp_server_instance_mark,
  do_srp_server_instance_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_server_handler
{
  struct packet_handler super;
  struct srp_server_instance *srp;
};
extern struct lsh_class srp_server_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_server_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_server_handler *i = (struct srp_server_handler *) o;
  mark((struct lsh_object *) i->srp);
}

struct lsh_class srp_server_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "srp_server_handler", sizeof(struct srp_server_handler),
  do_srp_server_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_init_continuation
{
  struct command_continuation super;
  struct srp_server_instance *srp;
  struct ssh_connection *connection;
};
extern struct lsh_class srp_init_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_init_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_init_continuation *i = (struct srp_init_continuation *) o;
  mark((struct lsh_object *) i->srp);
  mark((struct lsh_object *) i->connection);
}

struct lsh_class srp_init_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "srp_init_continuation", sizeof(struct srp_init_continuation),
  do_srp_init_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct srp_server_exchange
{
  struct keyexchange_algorithm super;
  struct dh_method *dh;
  struct user_db *db;
};
extern struct lsh_class srp_server_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_srp_server_exchange_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct srp_server_exchange *i = (struct srp_server_exchange *) o;
  mark((struct lsh_object *) i->dh);
  mark((struct lsh_object *) i->db);
}

struct lsh_class srp_server_exchange_class =
{ STATIC_HEADER,
  &keyexchange_algorithm_class, "srp_server_exchange", sizeof(struct srp_server_exchange),
  do_srp_server_exchange_mark,
  NULL
};
#endif /* !GABA_DECLARE */

