#ifndef GABA_DEFINE
struct dsa_public
{
  mpz_t p;
  mpz_t q;
  mpz_t g;
  mpz_t y;
};
extern void dsa_public_mark(struct dsa_public *i, 
    void (*mark)(struct lsh_object *o));
extern void dsa_public_free(struct dsa_public *i);
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
void dsa_public_mark(struct dsa_public *i, 
    void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
}

void dsa_public_free(struct dsa_public *i)
{
  (void) i;
  mpz_clear(i->p);
  mpz_clear(i->q);
  mpz_clear(i->g);
  mpz_clear(i->y);
}

#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dsa_signer
{
  struct signer super;
  struct randomness *random;
  struct dsa_public public;
  mpz_t a;
};
extern struct lsh_class dsa_signer_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dsa_signer_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_signer *i = (struct dsa_signer *) o;
  mark((struct lsh_object *) i->random);
  dsa_public_mark(&i->public, mark);
}

static void do_dsa_signer_free(struct lsh_object *o)
{
  struct dsa_signer *i = (struct dsa_signer *) o;
  dsa_public_free(&i->public);
  mpz_clear(i->a);
}

struct lsh_class dsa_signer_class =
{ STATIC_HEADER,
  &signer_class, "dsa_signer", sizeof(struct dsa_signer),
  do_dsa_signer_mark,
  do_dsa_signer_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct dsa_verifier
{
  struct verifier super;
  struct dsa_public public;
};
extern struct lsh_class dsa_verifier_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_dsa_verifier_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_verifier *i = (struct dsa_verifier *) o;
  dsa_public_mark(&i->public, mark);
}

static void do_dsa_verifier_free(struct lsh_object *o)
{
  struct dsa_verifier *i = (struct dsa_verifier *) o;
  dsa_public_free(&i->public);
}

struct lsh_class dsa_verifier_class =
{ STATIC_HEADER,
  &verifier_class, "dsa_verifier", sizeof(struct dsa_verifier),
  do_dsa_verifier_mark,
  do_dsa_verifier_free
};
#endif /* !GABA_DECLARE */

