#ifndef GABA_DEFINE
struct accept_service_handler
{
  struct packet_handler super;
  int service;
  struct command_continuation *c;
  struct exception_handler *e;
};
extern struct lsh_class accept_service_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_accept_service_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct accept_service_handler *i = (struct accept_service_handler *) o;
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->e);
}

struct lsh_class accept_service_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "accept_service_handler", sizeof(struct accept_service_handler),
  do_accept_service_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct exit_handler
{
  struct channel_request super;
  int * exit_status;
};
extern struct lsh_class exit_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class exit_handler_class =
{ STATIC_HEADER,
  &channel_request_class, "exit_handler", sizeof(struct exit_handler),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct session_open_command
{
  struct channel_open_command super;
  struct ssh_channel *session;
};
extern struct lsh_class session_open_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_session_open_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct session_open_command *i = (struct session_open_command *) o;
  mark((struct lsh_object *) i->session);
}

struct lsh_class session_open_command_class =
{ STATIC_HEADER,
  &channel_open_command_class, "session_open_command", sizeof(struct session_open_command),
  do_session_open_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct exec_request
{
  struct channel_request_command super;
  struct lsh_string *command;
};
extern struct lsh_class exec_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_exec_request_free(struct lsh_object *o)
{
  struct exec_request *i = (struct exec_request *) o;
  lsh_string_free(i->command);
}

struct lsh_class exec_request_class =
{ STATIC_HEADER,
  &channel_request_command_class, "exec_request", sizeof(struct exec_request),
  NULL,
  do_exec_request_free
};
#endif /* !GABA_DECLARE */

