#ifndef GABA_DEFINE
struct client_session
{
  struct ssh_channel super;
  struct lsh_fd *in;
  struct lsh_fd *out;
  struct lsh_fd *err;
  int * exit_status;
};
extern struct lsh_class client_session_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_session *i = (struct client_session *) o;
  mark((struct lsh_object *) i->in);
  mark((struct lsh_object *) i->out);
  mark((struct lsh_object *) i->err);
}

struct lsh_class client_session_class =
{ STATIC_HEADER,
  &ssh_channel_class, "client_session", sizeof(struct client_session),
  do_client_session_mark,
  NULL
};
#endif /* !GABA_DECLARE */

