/*
CLASS:ssh2_print_to:command
*/
#ifndef GABA_DEFINE
struct ssh2_print_to
{
  struct command super;
  struct alist *algorithms;
  const char * subject;
  const char * comment;
  struct abstract_write *dest;
};
extern struct lsh_class ssh2_print_to_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_ssh2_print_to_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct ssh2_print_to *i = (struct ssh2_print_to *) o;
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->dest);
}

struct lsh_class ssh2_print_to_class =
{ STATIC_HEADER,
  &command_class, "ssh2_print_to", sizeof(struct ssh2_print_to),
  do_ssh2_print_to_mark,
  NULL
};
#endif /* !GABA_DECLARE */

/*
CLASS:ssh2_print_command:command_simple
*/
#ifndef GABA_DEFINE
struct ssh2_print_command
{
  struct command_simple super;
  struct alist *algorithms;
  const char * subject;
  const char * comment;
};
extern struct lsh_class ssh2_print_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_ssh2_print_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct ssh2_print_command *i = (struct ssh2_print_command *) o;
  mark((struct lsh_object *) i->algorithms);
}

struct lsh_class ssh2_print_command_class =
{ STATIC_HEADER,
  &command_simple_class, "ssh2_print_command", sizeof(struct ssh2_print_command),
  do_ssh2_print_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

static struct lsh_object *
make_export_key(struct command *read, struct command *print, struct abstract_write *dest)
{
  /* (B (print dest) read) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return MAKE_TRACE("make_export_key", 
    B2(A(((struct lsh_object *) print), ((struct lsh_object *) dest)), ((struct lsh_object *) read))
  );
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
/*
CLASS:export_key_options:
*/
#ifndef GABA_DEFINE
struct export_key_options
{
  struct lsh_object super;
  sexp_argp_state input;
  struct alist *algorithms;
  const char * infile;
  const char * outfile;
  const char * subject;
  const char * comment;
  struct command *print;
};
extern struct lsh_class export_key_options_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_export_key_options_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct export_key_options *i = (struct export_key_options *) o;
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->print);
}

struct lsh_class export_key_options_class =
{ STATIC_HEADER,
  0, "export_key_options", sizeof(struct export_key_options),
  do_export_key_options_mark,
  NULL
};
#endif /* !GABA_DECLARE */

