#line 9 "macros.m4"

#line 1 "bignum-test.m4"

#if HAVE_CONFIG_H
#include "config.h"
#endif

#if HAVE_LIBGMP
#include "bignum.h"

#include <stdlib.h>
#include <string.h>

static void
test_bignum(const char *hex, unsigned length, const uint8_t *base256)
{
  mpz_t a;
  mpz_t b;
  uint8_t *buf;
  
  mpz_init_set_str(a, hex, 16);
  nettle_mpz_init_set_str_256(b, length, base256);

  if (mpz_cmp(a, b))
    abort();

  buf = alloca(length + 1);
  memset(buf, 17, length + 1);

  nettle_mpz_get_str_256(length, buf, a);
  if (!(!memcmp (buf, base256, length)))
    abort();

  if (buf[length] != 17)
    abort();

  mpz_clear(a); mpz_clear(b);
}
#endif /* HAVE_LIBGMP */


#line 39
#include "testutils.h"
#line 39

#line 39
#include <string.h>
#line 39
#include <stdlib.h>
#line 39

#line 39
int main (int argc, char **argv)
#line 39
{
#line 39


#if HAVE_LIBGMP
test_bignum("0", 0, "");
test_bignum("010203040506", 7, decode_hex_dup("00010203040506"));

#else /* !HAVE_LIBGMP */
exit(77)
#endif /* !HAVE_LIBGMP */
#line 5 "macros.m4"
  /* Avoid warnings for argc and argv unused */
  (void) argc; (void) argv;
  return 0;
}
