/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>   
#include "header.h"

/* return hashing value for variable s*/
long
varkey(char *s)
{
  long  n = 0;
  while (*s) { n = (n<<1) ^ *s; s++; }
  return n;
}

int newctx(int flag)
{
  if (nctx>=ctx_alloc)
  {
    ctx_alloc=nctx+10;
    if (debug) fprintf(stderr,"ctxstack=%x alloc ctx: %d/%d\n",(unsigned int)ctxstack,nctx,ctx_alloc);
    ctxstack=realloc(ctxstack,ctx_alloc*sizeof(*ctxstack));
    if (tree==NULL)
      fprintf(stderr,"Oups... alloc ctx: %d/%d\n",nctx,ctx_alloc);
  }
  ctxstack[nctx].flag=flag;
  return nctx++;
}

int newaff(int func, int idx)
{
  if (idx<0)
    die(-1,"Internal error: unknown var");
  if (naff>=aff_alloc)
  {
    aff_alloc=naff+10;
    if (debug) fprintf(stderr,"affstack=%x alloc aff: %d/%d\n",(unsigned int)affstack,naff,aff_alloc);
    affstack=realloc(affstack,aff_alloc*sizeof(*affstack));
    if (tree==NULL)
      fprintf(stderr,"Oups... alloc aff: %d/%d\n",naff,aff_alloc);
  }
  affstack[naff].f=func;
  affstack[naff].idx=idx;
  return naff++;
}

int newblock(void)
{
  if (nbloc>=bloc_alloc)
  {
    bloc_alloc=nbloc+10;
    if (debug) fprintf(stderr,"block=%x alloc bloc: %d/%d\n",(unsigned int)block,nbloc,bloc_alloc);
    block=realloc(block,bloc_alloc*sizeof(*block));
    if (tree==NULL)
      fprintf(stderr,"Oups... alloc bloc: %d/%d\n",nbloc,bloc_alloc);
  }
  block[nbloc].c=NULL;
  block[nbloc].n=0;
  block[nbloc].ret=-1;
  block[nbloc].gc=0;
  block[nbloc].gcvar=NULL;
  block[nbloc].ngc=0;
  return nbloc++;
}
int pushvar(int n, int flag, Gtype t, int initval)
{
  int c=newctx(flag);
  int v=tree[n].x;
  ctxstack[c].var=value[v].val.str;
  ctxstack[c].key=varkey(value[v].val.str);
  ctxstack[c].t=t;
  ctxstack[c].initval=initval;
  ctxstack[c].val=-1;
  return c;
}
int getvarinstack(char *s, int n, const ctxvar *ctx)
{
  int i,key;
  key=varkey(s);
  for(i=n-1;i>=0 && (ctx[i].key!=key || strcmp(ctx[i].var,s));i--);
  return i;
}
int getvarbyname(char *s)
{
  return getvarinstack(s,nctx,ctxstack);
}
int getvar(int n)
{
  if(tree[n].f!=Fentry && tree[n].f!=Frefarg)
    die(n,"Internal error : Not a Fentry in getvar");
  return getvarbyname(value[tree[n].x].val.str);
}
ctxvar *getvarinblock(int n, context *fc)
{  
  if(tree[n].f!=Fentry && tree[n].f!=Frefarg)
    die(n,"Internal error : Not a Fentry in getvarinblock");
  return fc->c+getvarinstack(value[tree[n].x].val.str,fc->n,fc->c);
}
int getvarerr(int n)
{
  int v=getvar(n);
  if (v==-1)
    die(n,"Internal error: variable %s appears from nowhere",
	value[tree[n].x].val.str);
  return v;
}
void restorectx(int c)
{
  int i,j;
  for(i=c,j=c;i<nctx;i++)
    if (ctxstack[i].flag&(1<<Cglobal))
    {
      if (i!=j)
	ctxstack[j]=ctxstack[i];
      /*      ctxstack[j].flag=ctxstack[i].flag&~(1<<Cparent);*/
      j++;
    }
  if(j>nctx) die(-1,"Internal error: restorectx");
  nctx=j;
}
void copyctx(int c, context *fc)
{
  ctxvar *ct;
  int nb;
  size_t size;
  int i,j;
  for (i=c,nb=0;i<nctx;i++)
  {
    if (!(ctxstack[i].flag&(1<<Cglobal)))
      nb++;
  }
  size=nb*sizeof(ctxvar);
  if (size)
  {
    ct=malloc(size);
    for (i=c,j=0;i<nctx;i++)
      if (!(ctxstack[i].flag&(1<<Cglobal)))
      {
	ct[j]=ctxstack[i];
	j++;
      }
    if (j!=nb) die(-1,"Internal error: copyctx");
  }
  else ct=NULL;
  if (fc->c)
    free(fc->c);
  fc->c=ct;
  fc->n=nb;
}

void pushctx(context *fc)
{
  int nb=fc->n;
  size_t size=nb*sizeof(ctxvar);
  if (size)
  {
    if (nctx+nb-1>=ctx_alloc)
    {
      ctx_alloc=nctx+nb-1+10;
      if (debug) fprintf(stderr,"ctxstack=%x alloc ctx: %d/%d\n",(unsigned int)ctxstack,nctx,ctx_alloc);
      ctxstack=realloc(ctxstack,ctx_alloc*sizeof(*ctxstack));
      if (tree==NULL)
	fprintf(stderr,"Oups... alloc ctx: %d/%d\n",nctx,ctx_alloc);
    } 
    memcpy(ctxstack+nctx,fc->c,size);
    nctx+=nb;
  }
}
