/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
#include "optable.h"
#include "memberfunc.h"
int indent=0;
extern int indentlevel;
void genindent(FILE *fout)
{
  int i;
  for (i=0;i<indent*indentlevel;i++)
    fputc(' ',fout);
}
void genindentseq(FILE *fout, int n)
{
  if (n==-1 || (tree[n].m&(1<<Msemicomma)))
    return;
  genindent(fout);
}
void gensemicomma(FILE *fout, int x)
{
  if (x!=-1 && !(tree[x].m&(1<<Msemicomma)))
    fprintf(fout,";\n");
}
void genparens(FILE *fout, int x)
{
  if (x!=-1 && !(tree[x].m&(1<<Mparens)))
    fprintf(fout,"(");
  gencode(fout,x);
  if (x!=-1 && !(tree[x].m&(1<<Mparens)))
    fprintf(fout,")");
}
extern int optcleanvar;
void genbrace(FILE *fout, int x)
{
  if (x==-1) return;
  /*If it is an empty block, cross it*/
  if (tree[x].f==Fblock && (tree[x].m&(1<<Mbrace)) && !optcleanvar )
    genbrace(fout,tree[x].y);
  else
  {
    int brace=(tree[x].f==Fseq || (tree[x].m&(1<<Melse)));
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"{\n");
    }
    indent++;
    genindentseq(fout,x);
    gencode(fout,x);
    gensemicomma(fout,x);
    indent--;
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"}\n");
    }
  }
}

void gencaststoi(FILE *fout, int n, Gtype t)
{
  if (tree[n].f==Fconst && value[tree[n].x].type==Vsmall)
    if(value[tree[n].x].val.small>=0 && value[tree[n].x].val.small<=2)
    {
      gensmallval(fout,value[tree[n].x].val.small,Gint);
      return;
    }
  if (tree[n].f==Fsmall && tree[n].x>=0 &&  tree[n].x<=2)
  {
    gensmallval(fout,tree[n].x,Gint);
    return;
  }
  if (tree[n].f==Fgnil)
  {
    gensmallval(fout,0,Gint);
    return;
  }
  fprintf(fout,"stoi(");
  gencast(fout,n,t);
  fprintf(fout,")");
}
void gencastf(FILE *fout, int n, Gtype nt, int f);
int gencastcode(FILE *fout, int n, Gtype t, Gtype nt, int f)
{
#ifdef DEBUG_CAST
  fprintf(fout,"/*%s:%s:%s*/",Gtypename[tree[n].t],Gtypename[t],Gtypename[nt]);
#endif
  switch(nt)
  {
  case Gbool:
    switch(t)
    {
    case Gvoid:
      fprintf(fout,"0");
      break;
    case Gnegbool:
      fprintf(fout,"!");
      gencastf(fout,n,t,1);
      break;
    case Gsmall:
      gencastf(fout,n,t,f);
      break;
    case Gbptr:
      fprintf(fout,"*");
      gencastf(fout,n,t,1);
      break;
    case Ggen:
    case Gmp:
    case Gint:
      fprintf(fout,"!gcmp0(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gnegbool:
    switch(t)
    {
    case Gbool:
    case Gsmall:
      fprintf(fout,"!");
      gencastf(fout,n,t,1);
      break;
    case Gbptr:
      fprintf(fout,"!*");
      gencastf(fout,n,t,1);
      break;
    case Gint:
    case Gmp:
    case Ggen:
      fprintf(fout,"gcmp0(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gsmall:
    switch(t)
    {
    case Gbool:
      gencastf(fout,n,t,f);
      break;
    case Gbptr:
      fprintf(fout,"*");
      gencastf(fout,n,t,1);
      break;
    case Gint:
      fprintf(fout,"itos(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gint:
    switch(t)
    {
    case Gsmall:
    case Gbool:
      gencaststoi(fout,n,t);
      break;
    case Gmp:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gmp:
    switch(t)
    {
    case Gint:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Ggen:
    switch(t)
    {
    case Gint:
    case Gmp:
      gencastf(fout,n,t,f);
      break;
    case Gstr:
      fprintf(fout,"strtoGENstr(");
      gencastf(fout,n,t,0);
      fprintf(fout,",0)");
      break;
    default:
      return 0;
    }
    break;
  case Gstr:
    switch(t)
    {
    case Gint:
    case Gmp:
    case Ggen:  
      fprintf(fout,"GENtostr(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gtyp:
    switch(t)
    {
    case Gstr:
      if (tree[n].f==Fstring)
      {
	/*A little hack to make Karim impressed.*/
	char *s=value[tree[n].x].val.str;
	if ( s[0]=='t' && s[1]=='_' )
	  fprintf(fout,"%s",s);
	else
	  fprintf(fout,"t_%s",s);
      }
      else
      {
	fprintf(fout,"get_type_num(");
	gencastf(fout,n,t,0);
	fprintf(fout,")");
      }
      break;
    default:
      return 0;
    }
    break;
  default:
    return 0;
  }
  return 1;
}
void gencastf(FILE *fout, int n, Gtype nt, int f)
{
  int t=tree[n].t;
  int i;
  if (t==nt)
  {
    /*bottom of the recursion*/
    if (f)
      genparens(fout,n);
    else
      gencode(fout,n);
    return;
  }
  if (gencastcode(fout,n,t,nt,f))
    return;
  /*the interesting case */
  if( typemax[t][nt]==nt )
    for(i=0;i<Gnbtype;i++)
      if (typemax[t][i]==i && typemax[i][nt]==nt)
	if (gencastcode(fout,n,i,nt,f))
	  return;
  if( typemax[t][nt]==t )
    for(i=0;i<Gnbtype;i++)
      if (typemax[t][i]==t && typemax[i][nt]==i)
	if (gencastcode(fout,n,i,nt,f))
	  return;
  die(-1,"No conversion method defined for %s->%s",Gname[t],Gname[nt]);
}
void gencast(FILE *fout, int n, Gtype nt)
{
  if (nt<Gnbtype)
    gencastf(fout,n,nt,0);
  else
    gencode(fout,n);
}
void gensmallval(FILE *fout, int val, Gtype t)
{
  switch(val)
  {
  case 0:
    fprintf(fout,(ctype[t]==Vsmall)?"0":"gzero");
    break;
  case 1:
    fprintf(fout,(ctype[t]==Vsmall)?"1":"gun");
    break;
  case 2:
    fprintf(fout,(ctype[t]==Vsmall)?"2":"gdeux");
    break;
  default:
    die(-1,"Internal error:val %d unhandled in gensmallval",val);
  }
}
void genopbool(FILE *fout, int x, int y, int opnum)
{
  int op=optable[opnum-OPADJ].num;
  gencastf(fout,x,Gbool,1);
  fprintf(fout," %s ",opbool[op]);
  gencastf(fout,y,Gbool,1);
}
void genopcomp(FILE *fout, int x, int y, int opnum)
{
  int op=optable[opnum-OPADJ].num;
  int tx=tree[x].t;
  int ty=tree[y].t;
  int tm=typemax[tx][ty];
  switch(tm)
  {
  case Gbool:
  case Gsmall:
    genparens(fout,x);
    fprintf(fout," %s ",opcomp[op]);
    genparens(fout,y);
    break;
  case Gint:
    fprintf(fout,"cmp%c%c(",(tx==Gint?'i':'s'),(ty==Gint?'i':'s'));
    gencode(fout,x);
    fprintf(fout,",");
    gencode(fout,y);
    fprintf(fout,") %s 0",opcomp[op]);
    break;
  case Gmp:
    fprintf(fout,"mpcmp(");
    gencast(fout,x,Gmp);
    fprintf(fout,", ");
    gencast(fout,y,Gmp);
    fprintf(fout,") %s 0",opcomp[op]);
    break;
  case Ggen:
    if ((opnum==FexprEQ || opnum==FexprNE) && tx==Ggen && ty==Ggen)
    {
      if (opnum==FexprNE)
	fprintf(fout,"!");
      fprintf(fout,"gegal(");
      gencast(fout,x,Ggen);
      fprintf(fout,", ");
      gencast(fout,y,Ggen);
      fprintf(fout,")");
    }
    else
    {
      fprintf(fout,"gcmp%s(",(ctype[tx]==Vsmall?"sg":(ctype[ty]==Vsmall?"gs":"")));
      gencode(fout,x);
      fprintf(fout,", ");
      gencode(fout,y);
      fprintf(fout,") %s 0",opcomp[op]);
    }
    break;
  case Gstr:
    fprintf(fout,"strcmp(");
    gencast(fout,x,Gstr);
    fprintf(fout,", ");
    gencast(fout,y,Gstr);
    fprintf(fout,") %s 0",opcomp[op]);
    break;
  case Gtyp:
    gencast(fout,x,Gtyp);
    fprintf(fout," %s ",opcomp[op]);
    gencast(fout,y,Gtyp);
  }
}
void genopshift(FILE *fout, int x, int y, int opnum)
{
  int op=optable[opnum-OPADJ].num;
  int tx=tree[x].t;
  switch(tx)
  {
  case Gbool:
  case Gsmall:
    /*do not use << since the risk of overflow is too high*/
    /* probably we could still use >> ??*/
  case Gint:
    fprintf(fout,"shifti(");
    gencast(fout,x,Gint);
    fprintf(fout,", %s",op?"-":"");
    gencast(fout,y,Gsmall);
    fprintf(fout,")");
    break;
  case Gmp:
    fprintf(fout,"mpshift(");
    gencode(fout,x);
    fprintf(fout,", %s",op?"-":"");
    gencast(fout,y,Gsmall);
    fprintf(fout,")");
    break;
  default:
    fprintf(fout,"gshift(");
    gencast(fout,x,Ggen);
    fprintf(fout,", %s",op?"-":"");
    gencast(fout,y,Gsmall);
    fprintf(fout,")");
    break;
  }
}
void genoparith(FILE *fout, int x, int y, int opnum)
{
  int op=optable[opnum-OPADJ].num;
  int tx=tree[x].t;
  int ty=tree[y].t;
  int tm=max(tx,ty);
  switch(tm)
  {
  case Gbool:
  case Gsmall:
    genparens(fout,x);
    fprintf(fout," %s ",oparith[op][0]);
    genparens(fout,y);
    break;
  case Gint:
    fprintf(fout,"%s%c%c(",oparith[op][1],(tx==Gint?'i':'s'),(ty==Gint?'i':'s'));
    gencode(fout,x);
    fprintf(fout,", ");
    gencode(fout,y);
    fprintf(fout,")");
    break;
  case Gmp:
    fprintf(fout,"mp%s(",oparith[op][1]);
    gencast(fout,x,Gmp);
    fprintf(fout,", ");
    gencast(fout,y,Gmp);
    fprintf(fout,")");
    break;
  default:
    fprintf(fout,"g%s%s(",oparith[op][1],(ctype[tx]==Vsmall?"sg":(ctype[ty]==Vsmall?"gs":"")));
    gencode(fout,x);
    fprintf(fout,", ");
    gencode(fout,y);
    fprintf(fout,")");
    break;
  }
}
void genoppow(FILE *fout, int x, int y)
{
  int arg[2];
  int tx=tree[x].t;
  int ty=tree[y].t;
  arg[0]=x;
  arg[1]=y;
  switch(ty)
  {
  case Gbool:
  case Gsmall:
    if (tree[y].f==Fsmall && tree[y].x==2)
    {
      /*generate nice square*/
      switch(tx)
      {
      case Gbool:
      case Gsmall:
      case Gint:
	gencallfunc(fout,"sqri",arg,1,"G");
	break;
      default:
	gencallfunc(fout,"gsqr",arg,1,"G");
	break;
      }
    }
    else
      gencallfunc(fout,"gpowgs",arg,2,"GL");
    break;
  case Gint:
    gencallfunc(fout,"powgi",arg,2,"GG");
    break;
  default:
    gencallfunc(fout,"gpow",arg,2,"GGp");
    break;
  }
}
void genopneg(FILE *fout, int x)
{
  int tx=tree[x].t;
  switch(tx)
  {
  case Gbool:
  case Gsmall:
    fprintf(fout,"-");
    genparens(fout,x);
    break;
  case Gint:
    fprintf(fout,"negi(");
    gencode(fout,x);
    fprintf(fout,")");
    break;
  case Gmp:
    fprintf(fout,"mpneg(");
    gencode(fout,x);
    fprintf(fout,")");
    break;
  default:
    fprintf(fout,"gneg(");
    gencode(fout,x);
    fprintf(fout,")");
    break;
  }
}
void genfacteurPS(FILE *fout, int x, int tx, int fy)
{
  /*  fprintf(fout,"(");*/
  switch(tx)
  {
  case Gbptr:
  case Gbool:
  case Gsmall:
    fprintf(fout,"%s",(fy==FaffectPP?"++":"--"));
    gencode(fout,x);
    break;
  case Gint:
    gencode(fout,x);
    fprintf(fout," = addis(");
    gencode(fout,x);
    fprintf(fout,",%d)",(fy==FaffectPP?1:-1));
    break;
  case Gmp:
    gencode(fout,x);
    fprintf(fout," = %s(",(fy==FaffectPP?"mpadd":"mpsub"));
    gencode(fout,x);
    fprintf(fout,",gun)");
    break;
  default:
    gencode(fout,x);
    fprintf(fout," = gaddgs(");
    gencode(fout,x);
    fprintf(fout,",%d)",(fy==FaffectPP?1:-1));
    break;
  }
  /*  fprintf(fout,")");*/
}
void genfacteuraff(FILE *fout, int x, int z, int fy)
{
  int op;
  int tx=tree[x].t;
  int tz;
  if (fy==FaffectPP || fy==FaffectSS)
  {
    genfacteurPS(fout,x,tx,fy);
    return;
  }
  if (fy>=FaffectS)
    op=optable[fy-AFFOPADJ].num;
  tz=tree[z].t;
  gencode(fout,x);
  switch(fy)
  {
  case Faffect:
    fprintf(fout," = ");
    if (tree[x].f==Ffacteurmat && tree[z].f==Fentry && ctype[tree[z].t]==Vgen) 
      fprintf(fout,"gcopy(");
    gencast(fout,z,tx);
    if (tree[x].f==Ffacteurmat && tree[z].f==Fentry && ctype[tree[z].t]==Vgen)
      fprintf(fout,")");
    break;
  case FaffectSR:
  case FaffectSL:
    if (ctype[tx]==Vsmall)
    {
      /* since the type of x is not allowed to change there are no risk of overflow*/
      fprintf(fout," %s= ",opshift[op]);
      gencast(fout,z,Gsmall);
    }
    else if (ctype[tx]==Vgen)
    {
      fprintf(fout," = ");
      genopshift(fout,x,z,fy-AFFADJ);
    }
    else 
      die(x,"<<= not implemented for this type");
    break;
  case FaffectDR:
  case FaffectEUC:
      die(x,"Sorry, not implemented");
    break;
  case FaffectD:
  case FaffectMOD:
  case FaffectM:
  case FaffectP:
  case FaffectS:
    if (tx<=Gsmall)
    {
      fprintf(fout," %s= ", oparith[op][0]);
      gencast(fout,z,Gsmall);
    }
    else
    {
      fprintf(fout," = ");
      genoparith(fout,x,z,fy-AFFADJ);
      break;
    }
    break;
  }
}
void 
genfacteurmat(FILE *fout, int x, int y)
{ 
  int yx=tree[y].x;
  int yy=tree[y].y;
  switch(tree[y].f)
  { 
  case FmatrixR:
  case Fmatrix:
    if(yy==-1)
    {
      fprintf(fout,"((GEN)");      
      gencode(fout,x);
      fprintf(fout,"[");
      gencast(fout,yx,Gsmall);
      fprintf(fout,"])");
    }
    else
    {
      fprintf(fout,"gcoeff(");
      gencode(fout,x);
      fprintf(fout,",");
      gencast(fout,yx,Gsmall);
      fprintf(fout,",");
      gencast(fout,yy,Gsmall);
      fprintf(fout,")");
    }
    break; 
  case FmatrixL:
    die(y,"[n,] not implemented, sorry");
    break;
  default:
    die(y,"Internal error:genfacteurmat: unhandled func %d",tree[y].f);
  }
}
void genmember(FILE *fout, int n, int x, int y)
{
  /*FIXME: this is very broken*/
  int i;
  char *name=value[y].val.str;
  for (i=0; memberlist[i].m && strcmp(name,memberlist[i].m);i++);
  if (!memberlist[i].m)
    die(n,"unknown member function %s",name);
  if (memberlist[i].offset<=0)
    die(n,"member %s not implemented",name);
  fprintf(fout,"((GEN)");
  gencode(fout,x);
  fprintf(fout,"[%d])",memberlist[i].offset);
}
/*If there is no suitable GP prototype, just print nothing*/
void geninstall(FILE *fout, int nf)
{
  int i;
  int nargs=0;
  gpfunc *gp=&lfunc[nf].gp;
  context *fc=block+lfunc[nf].bl;
  char *c;
  switch(ctype[gp->type])
  {
  case Vgen:
    c="";
    break;
  case Vsmall:
    c="l";
    break;
  case Vvoid:
    c="v";
    break;
  default:
    return;
  }
  for (i=0;i<fc->n;i++)
    if ( fc->c[i].flag&(1<<Carg) )
      switch(ctype[fc->c[i].t])
      {
      case Vsmall:
      case Vgen:
      case Vstr:
	nargs++;
	break;
      default:
	return;
      }
  fprintf(fout,"install(\"%s\",\"%s",gp->cname,c);
  for (i=0;i<fc->n;i++)
    if ( fc->c[i].flag&(1<<Carg) )
    {
      if (ctype[fc->c[i].t]==Vsmall || ctype[fc->c[i].t]==Vgen)
      {
	fprintf(fout,"D");
	if (fc->c[i].initval>=0)
	  printnode(fout,fc->c[i].initval);
	else
	  fprintf(fout,"0");
      }
      switch(ctype[fc->c[i].t])
      {
      case Vsmall:
	fprintf(fout,",L,");
	break;
      case Vgen:
	fprintf(fout,",G,");
	break;
      case Vstr:
	fprintf(fout,"s");
	break;
      default:
	die(-1,"Argument type not supported by GP.");
      }
    }
  if (gp->mode&(1<<Mprec))
    fputc('p',fout);
  fprintf(fout,"\",\"%s_c\",\"./%s.so\")\n",gp->gpname,nameparse);
}
void genheader(FILE *fout)
{
  int i;
  printf("/*-*- compile-command: \"gcc -c %s.c -Wall -O3 -DGCC_INLINE;"
	 "ld %s.o -o %s.so -shared\"; -*-*/\n",nameparse,nameparse,nameparse);
  printf("#include <pari/pari.h>\n");
  printf("/*\n");
  for(i=0;i<nfunc;i++)
    geninstall(fout,i);
  printf("*/\n");
  for(i=0;i<nfunc;i++)
  {
    genprototype(fout,i);
    fprintf(fout,";\n");
  }
  fprintf(fout,"/*End of prototype*/\n\n");
  for(i=0;i<nctx;i++)
  {
    ctxvar *v=ctxstack+i;
    fprintf(fout,"static ");
    fprintf(fout,cname[ctype[v->t]],v->var);
    fprintf(fout,";\n");
  }
  if (nctx)
    fprintf(fout,"/*End of global vars*/\n\n");
}

void gencode(FILE *fout, int n)
{
  int x=tree[n].x;
  int y=tree[n].y;
  if (n<0)
    return; 
  if (debug>=3) fprintf(fout,"/*%s:%d*/",Gname[tree[n].t],tree[n].m);
  switch(tree[n].f)
  {
  case Fseq:
    genindentseq(fout,x);
    gencode(fout,x);
    gensemicomma(fout,x);
    genindentseq(fout,y);
    gencode(fout,y);
    gensemicomma(fout,y);
    break;
  case Fmatrix:
  case FmatrixL:
  case FmatrixR:
    die(-1,"Internal error: Fmatrix* in gencode");
    /*all this stuff is handled by Ffacteurmat*/
    break;
  case Faffect:
  case FaffectPP:
  case FaffectSS:
  case FaffectM:
  case FaffectD:
  case FaffectEUC:
  case FaffectDR:
  case FaffectMOD:
  case FaffectSR:
  case FaffectSL:
  case FaffectP:
  case FaffectS:
    die(-1,"Internal error: Faffect*");
    /*all this stuff is handled by Ffacteuraff*/
    break;
  case FexprOR:
  case FexprAND:
    genopbool(fout,x,y,tree[n].f);
    break;
  case FexprEQ:
  case FexprNE:
  case FexprGE:
  case FexprG:
  case FexprLE:
  case FexprL:
    genopcomp(fout,x,y,tree[n].f);
    break;
  case FexprS:
  case FexprP:
  case FexprM:
  case FexprMOD:
    genoparith(fout,x,y,tree[n].f);
    break;
  case FexprSL:
  case FexprSR:
    genopshift(fout,x,y,tree[n].f);
    break;
  case FexprDR:/* \ */
    fprintf(fout,"gdivround(");
    gencast(fout,x,Gint);
    fprintf(fout,",");
    gencast(fout,y,Gint);
    fprintf(fout,")");
    break;
  case FexprEUC:/* \/ */
    fprintf(fout,"gdivent(");
    gencast(fout,x,Gint);
    fprintf(fout,",");
    gencast(fout,y,Gint);
    fprintf(fout,")");
    break;
  case FexprD:
    fprintf(fout,"gdiv(");
    gencast(fout,x,Ggen);
    fprintf(fout,",");
    gencast(fout,y,Ggen);
    fprintf(fout,")");
    break;
  case FfacteurP:
    gencode(fout,x);
    break;
  case FfacteurS:
    genopneg(fout,x);
    break;
  case FfacteurT:
    fprintf(fout,"gtrans(");
    gencode(fout,x);
    fprintf(fout,")");
    break;
  case FfacteurQ:
    fprintf(fout,"deriv(");
    gencode(fout,x);
    fprintf(fout,",-1)");
    break;
  case FfacteurB:
    fprintf(fout,"mpfact(");
    gencast(fout,x,Gsmall);
    fprintf(fout,")");
    break;
  case FfacteurC:
    genoppow(fout,x,y);
    break;
  case Ffacteurmat:
    genfacteurmat(fout,x,y);
    break;
  case Ffacteuraff:
    genfacteuraff(fout,x,tree[y].x,tree[y].f);
    break;
  case Ffacteurmem:
    genmember(fout,n,x,y);
    break;
  case Fconst:
    if (value[x].type==Vsmall)
      fprintf(fout,"%ld",value[x].val.small);
    else
      fprintf(fout,"flisexpr(\"%s\")",value[x].val.str);
    break;
  case Fstring:
    fprintf(fout,"\"%s\"",value[x].val.str);
    break;
  case Fsmall:
    fprintf(fout,"%d",tree[n].x);
    break;
  case FtrucB:
    gencast(fout,x,Gnegbool);
    break;
  case FtrucQ:
    fprintf(fout,"polx[fetch_user_var(\"%s\")]",value[x].val.str);
    break;
  case Femptyvec:
    fprintf(fout,"cgetg(1,t_VEC)");
    break;
  case Femptymat:
    fprintf(fout,"cgetg(1,t_MAT)");
    break;
  case Fmatrixelts:
  case Fmatrixlines:
  case Fmat:
    /*handled by genblockmatrix*/
  case Flistarg:
    /*handle by Fentry*/
    die(-1,"Internal error: %s in gencode",Ffuncname[tree[n].f]);
    break;
  case Fentry:/*It can be an hidden function call.*/
  case Fentryfunc:
    genentry(fout,n);
    break;
  case Frefarg:
    fprintf(fout,"&");
    genentry(fout,n);
    break;
  case Fdeffunc:
    gendeffunc(fout,n);
    break;
  case Fblock:
    gendefblock(fout,n);
    break;
  case Fgnil:
    fprintf(fout,"0");
    break;
  case Ftag:
    gencast(fout,x,y);
    break;
  default:
    die(n,"Internal error : unknow func %s in gencode",Ffuncname[tree[n].f]);
    break;
  }
}
