/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

void gerepilelist(affnode *an, int nmod, context *bl, int savb)
{
  int *res;
  int nb=0;
  int i;
  if (!nmod)
  {
    bl->gcvar=NULL;
    bl->ngc=0;
    return;
  }
  res=calloc(nmod,sizeof(*res));
  for(i=0;i<nmod;i++)
  {
    int idx=an[i].idx;
    /*If i is affected or referenced*/
    if (an[i].f!=AFaccess)
    {
      int j;
      /*search the first occurence of i*/
      for(j=0;j<i;j++)
	if (an[j].idx==idx)
	  break;
      /*FIXME:if the variable is local and the first occurence
	is an affectation, do nothing 
      if (an[j].idx>=savb &&  an[j].f==AFaffect)
	continue;*/

      /*else check if it is not already in the list*/
      for(j=0;j<nb;j++)
	if (res[j]==idx)
	  break;
      /*if it is already, do nothing*/
      if (j<nb) continue;
      /*add to list*/
      res[nb++]=idx;
    }
  }
  if (debug)
  {
    int i;
    fprintf(stderr,"/*");
    for(i=0;i<nmod;i++)
      fprintf(stderr,"%s%s ",ctxstack[an[i].idx].var,an[i].f==AFaffect?"=":"");
    fprintf(stderr,"*/\n");
  }
  if (!nb)
  {
    bl->gcvar=NULL;
    bl->ngc=0;
    return;
  }
  bl->ngc=nb;
  bl->gcvar=realloc(res,nb*sizeof(*res));
  
  if (nb==1 && an[nmod-1].idx==res[0])
    bl->gc|=(1<<GCupto);
}
int listaff(int sava, int savc, affnode **ran)
{
  affnode *an;
  int nb;
  size_t size;
  int i,j;
  for (i=sava,nb=0;i<naff;i++)
  {
    if (affstack[i].idx<savc)
      nb++;
  }
  size=nb*sizeof(affnode);
  if (size)
  {
    an=malloc(size);
    for (i=sava,j=0;i<naff;i++)
      if (affstack[i].idx<savc)
      {
	an[j]=affstack[i];
	j++;
      }
    if (j!=nb) die(-1,"Internal error: listaff");
  }
  else an=NULL;
  *ran=an;
  return nb;
}
void pilelistblock(context *bl, int sava, int savb)
{
  affnode *an;
  int nb;
  nb=listaff(sava,savb,&an);
  gerepilelist(an,nb,bl,savb);
  if (an)
    free(an);
}
void pilelistvar(int idx)
{
  ctxvar *v=ctxstack+idx;
  if ((v->flag&(1<<Cconst)) && v->val!=-1)
    return;
  if (v->flag&(1<<Carg))
    return;
  if (v->t==Gnotype)
  {
    if (findnewentry(v->var)==-1)
      newaff(AFaffect,idx); 
    /*else it was a very hidden function call*/
  }
  else if (ctype[v->t]!=Vgen)
    return;
  else
  {
     if (v->initval>=0)
    {
      pilelist(v->initval);
      newaff(AFaffect,idx); 
    }
  }
}
void pilelist(int n)
{
  int i,x,y;
  int v,savc,sava,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Ffacteuraff:
    if (tree[x].f!=Fentry)
      pilelist(x);
    pilelist(y);
    while(tree[x].f!=Fentry)
      /*FIXME: do some sanity checking*/
      x=tree[x].x;
    if (tree[x].f==Fentry && ctype[tree[x].t]==Vgen)
    {
      v=getvar(x);
      if (tree[y].f!=Faffect)
	newaff(AFaccess,v);
      newaff(AFaffect,v); 
    }
    break;
  case Ffacteurmem:
  case Ftag:
    pilelist(x);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
  case FtrucQ:
    break;
  case Frefarg:
    v=getvarerr(n);
    if (ctype[tree[n].t]==Vgen)
      newaff(AFrefarg,v);
    break;
  case Fentry:
    v=getvar(n);
    if (v>=0 && ctype[tree[n].t]==Vgen)
      newaff(AFaccess,v);
    /*else it is an hidden function call*/
    break;
  case Fentryfunc:
    pilelist(y);
    break;
  case Fdeffunc:
    pilelist(y);
    break;
  case Fblock:
    savc=nctx;
    sava=naff;
    bl=block+tree[n].x;
    pushctx(bl);
    savb=nctx;
    for(i=0;i<bl->n;i++)
      pilelistvar(savc+i);
    pilelist(y);
    if (bl->gc&(1<<GCneeded))
      pilelistblock(bl,sava,savb);
    if ((bl->gc&(1<<GCneeded)) && (!bl->ngc || (bl->gc&(1<<GCupto))))
    {
      /*A bit kludgy*/
      int w=getvarbyname("lim"),v=getvarbyname("bptr");
      int vv=getvarbyname("gptr");
      if (v>=savc && v<savb)
      {
	ctxstack[v].t=Gvoid;
	if (w<savc && w>=savb)
	  warning(-1,"Internal error: we loose `lim'!");
	ctxstack[w].t=Gvoid;
      }
      else if (vv>=savc && vv<savb)
	ctxstack[vv].t=Gvoid;
    }
    copyctx(savc,bl);
    nctx=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in pilelist",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    pilelist(x);
    pilelist(y);
  }
}
