/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

int debug;
char *nameparse;
int currfunc;
int lastpass;
int autogc;

#define OPADJ (FexprOR)
#define AFFOPADJ (FaffectS-FexprS+FexprOR)
#define AFFADJ (FaffectS-FexprS)
#define STACKSZ (1024)
#define GNIL    (0)

static   inline int min(int x, int y) { return (x<=y)?x:y; }    
static   inline int max(int x, int y) { return (x>=y)?x:y; }    
typedef enum {Fseq,
	      Fmatrix,FmatrixL,FmatrixR,
	      Faffect,FaffectPP,FaffectSS,
	      FaffectS,FaffectP,FaffectSL,FaffectSR,FaffectMOD,FaffectEUC,FaffectDR,FaffectD,
	      FaffectM,
	      FexprOR,FexprAND,FexprEQ,FexprNE,FexprGE,FexprG,FexprLE,FexprL,
	      FexprS,FexprP,FexprSL,FexprSR,FexprMOD,FexprEUC,FexprDR,FexprD,FexprM,
	      FfacteurP,FfacteurS,FfacteurT,FfacteurQ,FfacteurB,FfacteurC,
	      Ffacteurmat,Ffacteuraff,
	      FtrucB,
	      Fmatrixelts,Fmatrixlines,
	      Femptyvec,Femptymat,Fmat,
	      Flistarg,

	      Fconst,Fstring,Fsmall,
	      Frefarg,FtrucQ,Ffacteurmem,Ftag,
	      Fentry,Fentryfunc,Fdeffunc,

	      /*This node are generated by genblock, not by parser*/
	      Fblock,Fgnil
} Ffunc;
#define FneedENTRY (Fconst)

/*see parse.y for definition.
Fblock x: block number y:seq
Fgnil   : it's a noop, but if evalued lead to 0.
*/
extern char *Ffuncname[];

typedef enum {Mvar, Msidef, Mterm, Mprec, Msemicomma, Mparens, Mbrace, Melse
} Mmode;
/*gentype:
  Mvar :  value cannot be determined at compile time
  Msidef: Statement has (probably) a side effect
  Mterm:  Statement never return.
  Mprec:  function need the prec arg.
  Melse     :  This is an if else block, (try to) be clever...
  If there is doubt, set Mvar, Msidef and Mprec but not Mterm.
  moveblock:
  Msemicomma:  This is a full statement, no need of ';'
  Mparens   :  This is a leaf, no need of ','
  Mbrace    :  This is a false block, no need of '{}'
*/ 
#include "type.h"
typedef enum {Cuser,Cauto,Cglobal,Cconst,Carg} Ctype;
/*
  Cuser: Variable defined by user in the source
  Cauto: Variable get type of initialisation
  Cglobal: Global variable for this module.
  Cconst:  Variable affected exactly once in the code.
  Cargs:   Variable is a function's parameter.
 */
typedef struct node_s
{
  Ffunc f;          /*node function*/
  int x;            /*node left child*/
  int y;            /*node right child*/
  Gtype t;          /*node type*/
  int m;            /*node mode, Mmode bitmask*/
} node;

typedef struct
{
  int flag;         /*context type, Ctype bitmask*/
  int key;          /*context hashkey*/
  char *var;        /*context var name*/
  Gtype t;          /*context var type*/
  int initval;      /*context initial value of var*/
  int val;          /*context value, if constant*/
} ctxvar;

typedef struct
{
  enum {AFaccess,AFaffect,AFrefarg} f;
  int idx;
} affnode;

enum {GCneeded, GCupto, GCglobal} GCenum;
typedef struct
{
  ctxvar *c;       /*context stack*/
  int n;           /*size of stack*/
  int ret;         /*if not -1 , node number of var holding return
                     value*/
  long gc;         /*garbage collecting attribute, bitmask of GCenum*/
  int *gcvar;      /*List of var that need to be gerepiled*/
  int ngc;        /*number of gcvar*/
} context;

typedef struct
{
  enum {AAtype,AAsmall,AAreftype} t;
  int v;
}descargatom;
typedef struct
{
  enum {PAvar,PAextra,PArefvar} t;
  int v;
}descprotoatom;

typedef struct
{
  char *cname;              /* C name*/
  Gtype type;               /*return type*/
  int nargs;                /*nb args*/
  descargatom *args;        /*type of args*/
  int nproto;               /*nb args*/
  descprotoatom *proto;     /*type of args*/
} gpdescarg;

typedef struct
{
  int nb;          /*nb of description*/
  gpdescarg *a;    /*array of description*/
} gpdesc;

typedef struct
{
  char *gpname;    /*name for GP*/ 
  char *cname;     /*name for the C library*/
  int sec;         /*manual section*/
  char *code;      /*prototype  code*/
  Gtype type;      /*type of function*/
  int mode;
  int spec;        /*Spec name for spec function*/
  gpdesc *dsc;     /*Description or NULL*/
} gpfunc;

typedef struct
{
  gpfunc gp;
  int bl;
  int bctx;
} userfunc;

typedef struct
{
  Vtype type;     /*type of data*/
  union value_u  
  {
    long small;
    char *str;
  }val;
} value_t;


node *tree;
value_t *value;
userfunc *lfunc;
ctxvar *ctxstack;
affnode *affstack;
context *block;

int nnode,node_alloc;
int nvalue,value_alloc;
int nfunc,func_alloc;
int nctx,ctx_alloc;
int naff,aff_alloc;
int nbloc,bloc_alloc;


#ifdef __GNUC__
/*Avoid spurious warning*/
void die(int n, char *format, ...) __attribute__ ((noreturn));
#else
void die(int n, char *format, ...);
#endif
void warning(int n, char *format, ...);

int listtostack(int n, int f, int *stack, int nbmax, char *error,int nerr);
int listtostackparent(int n, int f, int *stack, int nbmax, char *error,int nerr);
int genlistargs(int n,int *stack,int min,int max);

int newnode(Ffunc f, int x, int y);
int newvalue(Ffunc f, char *s);
int newconstnode(char *s);
int newentry(char *s);
int newleaf(int n);

int newfunc(char *gpname);
int newblock(void);
int listtoseq(int *stack, int nb);
int newdecl(int flag, Gtype t, int initval, int *v);
int newcall(char *s, int y);
int findentry(const char *s);
int findnewentry(const char *s);
int findfunction(int n, gpfunc **gp);
void genequal(int aff, char *func, int *var, int *binf);

void printnode(FILE *fout, int n);
void maketree(FILE *fout,int n);
Gtype gentype(int n);
void genblockdeclaration(int args, int n, int flag);

void genheader(FILE *fout);
void gencode(FILE *fout, int n);
void genblock(int n, int p);
void moveblock(int n, int p, int r);
void pilelist(int n);

void gensemicomma(FILE *fout,int x);
void genparens(FILE *fout, int x);
void genbrace(FILE *fout, int x);
void genindent(FILE *fout);
void genindentseq(FILE *fout, int x);

void gencast(FILE *fout, int n, Gtype nt);

void gensmallval(FILE *fout, int val, Gtype t);
void gentypedec(FILE *fout, Gtype t);
void gendecvar(FILE *fout, context *fc, int idx);

void gencallfunc(FILE *fout, char *name, int *stack, int nb, char *proto);
void genentry(FILE *fout, int n);
void genprototype(FILE *fout,int nf);
void gendeffunc(FILE *fout, int n);
void gendefblock(FILE *fout, int n);

void genblockfuncspec(int n, int p, gpfunc *gp);
int gentypefuncspec(int n, gpfunc *gp);
void genentryspec(FILE *fout, int n, gpfunc *gp);

int getvar(int n);
int getvarerr(int n);
int getvarbyname(char *s);
ctxvar *getvarinblock(int n, context *fc);
int pushvar(int n, int ctype, Gtype t, int initval);
void pushctx(context *fc);
void restorectx(int c);
void copyctx(int n, context *fc);
int newaff(int func, int idx);
void copyaff(int sava, int savc, context *fc);

int isanint(char *s);
int isasmall(char *s, long *res);
Gtype strtotype(char *s);
Gtype nodetype(char *s);
int geninsertvar(int seq, int ret, Ffunc func);
void makeblock(int bl, int n, int aseq, int ret, int savx);
void makeblocks(int bl1, int bl2, int n, int bseq, int aseq, int ret, int savx);
int gengerepilelist(context *fc,int **gc);
void gengerepileend(int bl);
