%{      
#include <unistd.h>
#include "header.h"
#include "parse.h"
int linecount=1;
int yydebug;
static enum {Mread_lines,Min_braces,Mafter_equal} mode=Mread_lines;
static int terminate=-1,start=0;
static void countline(char *text,int len)
{
  int i; 
  for (i=0; i<len; i++) 
    linecount+=(text[i]=='\n');
}
%}
NUMBER [0-9]+
EXPO ("e"|"E")("+"|"-")?{NUMBER}
CONST ({NUMBER}("."[0-9]*)?|"."{NUMBER}){EXPO}?
STRING \"([^"\\]|(\\.))*\"
/*"*/
ENTRY [A-Za-z][A-Za-z0-9_]*
%%
{ENTRY}	{ 	
		char *p2=yylval.str, *p1=yytext;
		int i,l=min(sizeof(yylval.str)/sizeof(char),yyleng);
		for (i=0; i<l; i++) p2[i]=p1[i];
		p2[l]=0;
		if (yydebug) fprintf(stderr,"[%s]",p2);
		return KENTRY;
	}
{CONST}	{ 
		char *p2=yylval.str, *p1=yytext;
	  	int i,l=min(sizeof(yylval.str)/sizeof(char),yyleng);
		for (i=0; i<l; i++) p2[i]=p1[i];
		p2[l]=0;
		if (yydebug) fprintf(stderr,"[%s]",p2);
		return KCONST;
	}
{STRING} { 
              char *p2=yylval.str, *p1=yytext;
              int i,l=min(sizeof(yylval.str)/sizeof(char), yyleng);
              for (i=1; i<l-1; i++) p2[i-1]=p1[i];
	      p2[i-1]=0;
	      if (yydebug) fprintf(stderr,"[%s]",p2);
	      countline(yytext,yyleng);
	      return KSTRING; 
         }
<<EOF>>         {if (terminate++) return KEOC; else yyterminate();}


"\\/"           { if (yydebug) fprintf(stderr,"[%s]",yytext);return KDR;}
">>"            return KSR;
"<<"            return KSL;
"<="            return KLE;
">="            return KGE;
"!="|"<>"       return KNE;
"=="            return KEQ;
"&&"            return KAND;
"||"            return KOR;

"++"            return KPP;
"--"            return KSS;
"+="            return KPE;
"-="            return KSE;
"*="            return KME;
"/="            return KDE;
"\\="           return KEUCE;
"\\/="          return KDRE;
"%="            return KMODE;
">>="           return KSRE;
"<<="           return KSLE;

"\\\n"		{linecount++;}
"\n"            {linecount++;if (mode==Mread_lines) {unput('@');return KEOC;}}
"{"             {mode=Min_braces;}
"}"             {mode=Mread_lines;unput('@');return KEOC;}
"@"             {if (!start++) return KSTART; else return KEOC;/*mega kludge*/}
"="([ \t\n]*)      {countline(yytext,yyleng);return yytext[0];}


[ \t]+
"/*"(([^*]*)|"*"[^/])*"*/" {countline(yytext,yyleng);}
"\\\\"[^\n]*\n	           {linecount++;}
. return yytext[0];
%%
