/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "stack.h"
int debug;
char *nameparse, *namelib;
int currfunc;
int lastpass;
int autogc;
int warn;

#define STACKSZ (1024)
#define GNIL    (0)
#define GNOARG  (1)
static   inline int min(int x, int y) { return (x<=y)?x:y; }    
static   inline int max(int x, int y) { return (x>=y)?x:y; }    

typedef struct
{
  stack s;
  char *txt;
} comment;

typedef struct
{
  char s[1025];
  int c;
} strcom;
typedef enum {Fseq,
	      Fmatrix,FmatrixL,FmatrixR,
	      Faffect,
	      Ffacteurmat,
	      Fmatrixelts,Fmatrixlines,
	      Femptyvec,Femptymat,Fmat,
	      Flistarg,

	      Fconst,Fstring,Fsmall,Fgnil,
	      Frefarg,FtrucQ,Ftag,
	      Fentry,Fentryfunc,Fdeffunc,

	      /*This node is generated by genblock, not by parser*/
	      Fblock
} Ffunc;
#define FneedENTRY (Fconst)
#define Flastfunc  (Fblock)

/*see parse.y for definition.
Fblock x: block number y:seq
Fgnil   : it's a noop, but if evaluated leads to 0.
*/
extern char *Ffuncname[];


#include "type.h"
#include "optable.h"
typedef enum {Cuser,Cauto,Cglobal,Cconst,Carg,Creturn,Cimmutable} Ctype;
/*
  Cuser: Variable defined by user in the source
  Cauto: Variable get type of initialisation
  Cglobal: Global variable for this module.
  Cconst:  Variable affected exactly once in the code.
  Cargs:   Variable is a function's parameter.
  Creturn: Variable is to be passed to return.
  Cimmutable: Variable affected exactly once in the run.
 */
typedef struct node_s
{
  Ffunc f;          /*node function*/
  int x;            /*node left child*/
  int y;            /*node right child*/
  Gtype t;          /*node type*/
  int m;            /*node mode, Mmode bitmask*/
  int lineno;       /*linenumber of corresponding code*/
  int comment;
} node;

typedef struct
{
  int flag;         /*context type, Ctype bitmask*/
  int key;          /*context hashkey*/
  char *var;        /*context var name*/
  Gtype t;          /*context var type*/
  int initval;      /*context initial value of var*/
  int val;          /*context value, if constant*/
} ctxvar;

typedef struct
{
  enum {AFaccess,AFaffect,AFaffectcompo,AFaffectcopy,AFrefarg, AFhide, AFclone} f;
  int idx;
} affnode;

enum {GCneeded, GCupto, GCglobal} GCenum;
typedef struct
{
  ctxvar *c;       /*context stack*/
  stack s;        
  int ret;         /*if not -1 , node number of var holding return
                     value*/
  affnode *var;        /*Data about variable*/
  stack v;
  int savb;
  int egc;         /*Extra var to be gerepiled*/
  long gc;         /*garbage collecting attribute, bitmask of GCenum*/
  int *gcvar;      /*List of var that need to be gerepiled*/
  stack g;
} context;

typedef struct
{
  enum {AAtype,AAnoarg,AAsmall,AAreftype,AAherevalue,AAlvalue,AAmulti} t;
  int v;
} descargatom;

typedef struct
{
  char *cname;              /* C code */
  Gtype type;               /*return type*/
  int mode;                 /*return mode*/
  int nargs;                /*nb args*/
  descargatom *args;        /*type of args*/
} gpdescarg;

typedef struct
{
  int nb;          /*nb of description*/
  gpdescarg *a;    /*array of description*/
} gpdesc;

typedef struct
{
  char *cname;  	/* C name */
  char *code;		/* GP code */
  char *origin;		/* library name of the symbol, NULL for gp/libpari*/
} gpproto;

typedef struct
{
  int node;
  int bl;
  int bctx;
  affnode *var;        /*Data about variable*/
  stack v;
  int savb;
  int *gcvar;      /*List of var that need to be gerepiled*/
  stack g;
} userfunc;

/*Positive enum are private to funcspec.c/patchfunc.h*/
typedef enum {GPinstalled=-2,GPpari=-1,GPuser=0} GPspec;

typedef struct
{
  char *gpname;    /*name for GP*/ 
  Gtype type;      /*type of function (maybe overriden by dsc)*/
  int mode;	   /*mode of function (maybe overriden by dsc)*/
  GPspec spec;     /*Spec name for spec function*/
  gpproto proto;
  gpdesc *dsc;     /*Description or NULL*/
  userfunc *user;
} gpfunc;

typedef struct
{
  Vtype type;     /*type of data*/
  union value_u  
  {
    long small;
    char *str;
  } val;
} value_t;

node *tree;
value_t *value;
gpfunc *lfunc;
ctxvar *ctxstack;
affnode *affstack;
context *block;
comment *com;

stack s_node,s_value,s_func,s_ctx,s_aff,s_bloc,s_comment;

Gtype default_type;

#ifdef __GNUC__
/*Avoid spurious warning*/
void die(int n, char *format, ...) __attribute__ ((noreturn));
#else
void die(int n, char *format, ...);
#endif
void warning(int n, char *format, ...);

int listtostack(int n, int f, int *stack, int nbmax, char *error,int nerr);
int listtostackparent(int n, int f, int *stack, int nbmax, char *error,int nerr);
int genlistargs(int n,int *stack,int min,int max);

int newcomment(void);
void pushcomment(int n, char x);
void gencomment(FILE *fout, int n);

typedef enum {PPend,PPstd,PPdefault,PPdefaultmulti,PPsep} PPproto;

PPproto parseproto(char const **q, char *c);

int newnode(Ffunc f, int x, int y);
int newvalue(Ffunc f, const char *s);
int newconstnode(const char *s, int c);
int newentry(const char *s);
int newuserentry(const char *s);
int newmember(const char *s);
int newleaf(int n);
int newopcall(OPerator s, int x, int y);

char *entryname(int n);
int newuserfunc(const char *gpname);
int newblock(void);
int listtoseq(int *stack, int nb);
int newdecl(int flag, Gtype t, int initval, int *v);
int newcall(char *s, int y);
int findfunction(const char *name);
void genequal(int aff, char *func, int *var, int *binf, Gtype *t);
int addseqright(int seq, int n);
int addseqleft(int n, int seq);
int getfunc(char *gpname);
  
char *funcname(int f);
void printnode(FILE *fout, int n);
void maketree(FILE *fout,int n);
Gtype gentype(int n);
void genblockdeclaration(int args, int n, int flag);

void genheader(FILE *fout);
void gencode(FILE *fout, int n);
void gencodeg(FILE *fout, int n);
void genblock(int n, int p);
void gentoplevel(int n);
int addinitfunc(int n);
void gendeblock(int n, int p, int ps, int *r, int *rs);
void moveblock(int n, int p, int ps, int *r, int *rs);
void pilelist(int n);
void pileclean(int n);
void varlist(int n);

void gensemicomma(FILE *fout,int x);
void genparens(FILE *fout, int x);
void genparensg(FILE *fout, int x);
void genbrace(FILE *fout, int x);
void genindent(FILE *fout);
void genindentseq(FILE *fout, int x);

void gencast(FILE *fout, int n, Gtype nt);
void gencastf(FILE *fout, int n, Gtype nt, int f);
void gencastl(FILE *fout, int n, Gtype nt, int f);

void gensmallval(FILE *fout, int val, Gtype t);
void gentypedec(FILE *fout, Gtype t);
void gendecvar(FILE *fout, context *fc, int idx);

void gencallfunc(int nerr, FILE *fout, char *name, int *stack, int nb, char *proto);
void genentry(FILE *fout, int n);
void genentryfunc(FILE *fout, int n);
void genprotocode(FILE *fout,int nf);
void genprototype(FILE *fout,int nf);
void gendeffunc(FILE *fout, int n);
void gendefblock(FILE *fout, int n);

void genblockfuncspec(int n, int p, gpfunc *gp);
int gentypefuncspec(int n, gpfunc *gp);
void genentryspec(FILE *fout, int n, gpfunc *gp);

gpdescarg *descfindrules(int nb, int *arg, gpfunc *gp);
int genentrydesc(FILE *fout, int n, gpfunc *gp);
void gencodedesc(FILE *fout, int nb, int *arg, gpdescarg *rule, int nerr);

int detag(int n);
int getlvalue(int n);
int getlvaluerr(int n);
int getvar(int n);
int getvarerr(int n);
int getvarbyname(char *s);
ctxvar *getvarinblock(int n, context *fc);
int pushvar(int n, int ctype, Gtype t, int initval);
void pushctx(context *fc);
void restorectx(int c);
void copyctx(int n, context *fc);
int newctx(int flag);
int newaff(int func, int idx);
void copyaff(int sava, int savc, context *fc);

int isfunc(int n, const char *s);
int isanint(const char *s);
int isasmall(const char *s, long *res);
Gtype strtotype(char *s);
Gtype nodetype(char *s);
Mmode strtomode(char *s);
Mmode nodemode(char *s);
int geninsertvar(int seq, int ret);
int geninsertvarop(int seq, int ret, OPerator op);
void makeblock(int bl, int n, int aseq, int ret, int savx);
void makeblocks(int bl1, int bl2, int n, int bseq, int aseq, int ret, int savx);
int gengerepilelist(context *fc,int **gc);
void gengerepileend(int bl);
