/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include "stack.h"

void ** stack_base(stack *s)
{
  return ((void *)s)+s->offset;
}

void stack_init(stack *s, int size, void **data)
{
  s->offset=(void *)data-(void *)s;
  *data=NULL;
  s->n=0;
  s->alloc=0;
  s->size=size;
}

void stack_alloc(stack *s, int nb)
{
  void **sdat=((void *)s)+s->offset;
  if (s->n+nb <= s->alloc)
    return;
  while (s->n+nb > s->alloc)
    s->alloc=s->alloc?s->alloc<<1:1;
  if (debug_stack)
    fprintf(stderr,"data=%x (%d/%d)\n",
        (unsigned int) sdat,s->n,s->alloc);
  *sdat=realloc(*sdat,s->alloc*s->size);
  if (*sdat==NULL)
    fprintf(stderr,"Cannot alloc memory (%d bytes)\n",s->alloc*s->size);
}

int stack_new(stack *s)
{
  stack_alloc(s, 1);
  return s->n++;
}

/*Push stack t on stack s*/
void stack_push(stack *s, stack *t)
{
  if ( s->size!=t->size )
    fprintf(stderr,"Incompatible stack size in stack_push: %d!=%d\n",s->size,t->size);
  if ( t->n>0 )
  {
    void **sdat=((void *)s)+s->offset;
    void **tdat=((void *)t)+t->offset;
    stack_alloc(s, t->n);
    memcpy(*(sdat)+s->n*s->size,*tdat,t->n*t->size);
    s->n+=t->n;
  }
}

void stack_replace(stack *s, stack *t)
{
  void **sdat=((void *)s)+s->offset;
  void **tdat=((void *)t)+t->offset;
  *sdat=realloc(*sdat,0);
  *sdat=*tdat;
  s->n=t->n;
  s->alloc=t->alloc;
}
  
