/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
extern gpfunc listfunc[];
gpdesc *newdesc(int nb)
{
  gpdesc *gd;
  gd=malloc(sizeof(*gd));
  gd->nb=nb;
  gd->a=calloc(nb,sizeof(*(gd->a)));
  return gd;
}

int strtoextra(char *s)
{
  int i;
  for(i=0;i<Enbextra;i++)
  {
    if (!strcmp(s,Ename[i]))
      return i;
  }
  return -1;
}

descprotoatom strtoproto(char *s)
{
  descprotoatom pa;
  int t=strtoextra(s);
  if (t==-1)
  {
    if (s[0]=='&' && s[1]=='x')
    {
      pa.t=PArefvar;
      pa.v=atol(s+2)-1;
    }
    else if (s[0]=='x')
    {
      pa.t=PAvar;
      pa.v=atol(s+1)-1;
    }
    else die(-1,"bad proto atom %s",s);
  }
  else
  {
    pa.t=PAextra;
    pa.v=t;
  }
  return pa;
}

descargatom strtoargs(char *s)
{
  descargatom aa;
  int t;
  if (*s=='&')
  {
    t=strtotype(s+1);
    if (t==-1)
      die(-1,"bad reference in description file");
    aa.t=AAreftype;
    aa.v=t;
    return aa;
  }
  t=strtotype(s);
  if (t==-1)
  {
    aa.t=AAsmall;
    aa.v=atol(s);
  }
  else
  {
    aa.t=AAtype;
    aa.v=t;
  }
  return aa;
}
void readentry(FILE *f, char *buf, int len)
{
  if (!fgets(buf,len,f))
    perror("gp2c");
  if (!*buf)
    die(-1,"Bad description file");
  buf[strlen(buf)-1]=0;
}

int readnumber(FILE *f, char *buf, int len)
{
  readentry(f,buf,len);
  return atol(buf);
}

void initdesc(char *descfile)
{
  char buf[1024];
  FILE *dfile;
  if (!(dfile=fopen(descfile,"r")))
  {
    fprintf(stderr,"Cannot find description file %s\n",descfile);
    exit(1);
  }
  while(!feof(dfile))
  {
    int i;
    int nf,nb;
    gpdesc *gd;
    if (!fgets(buf,1024,dfile))
      break;
    if (!*buf)
      die(-1,"Bad description file");
    buf[strlen(buf)-1]=0;
    nf=findentry(buf);
    if (nf==-1)
      die(-1,"Incorrect description file %s: function %s not found",descfile,buf);
    nb=readnumber(dfile,buf,1024);
    gd=newdesc(nb);
    for(i=0;i<nb;i++)
    { 
      int j;
      readentry(dfile,buf,1024);
      gd->a[i].cname=strdup(buf);
      readentry(dfile,buf,1024);
      gd->a[i].type=strtotype(buf);
      gd->a[i].nargs=readnumber(dfile,buf,1024);
      gd->a[i].args=calloc(gd->a[i].nargs,sizeof(*gd->a[i].args));
      for(j=0;j<gd->a[i].nargs;j++)
      {
	readentry(dfile,buf,1024);
	gd->a[i].args[j]=strtoargs(buf);
      }
      gd->a[i].nproto=readnumber(dfile,buf,1024);
      gd->a[i].proto=calloc(gd->a[i].nproto,sizeof(*gd->a[i].proto));
      for(j=0;j<gd->a[i].nproto;j++)
      {
	readentry(dfile,buf,1024);
	gd->a[i].proto[j]=strtoproto(buf);
      }
    }
    listfunc[nf].dsc=gd;
    
  }
  fclose(dfile);
}

gpdescarg *descfindrules(int nb, int *arg, gpdesc *dsc)
{
  int i;
  int best=-1,score;
  gpdescarg *ga=dsc->a;
  for(i=0;i<dsc->nb;i++)
  {
    int sc=0;
    int j;
    descargatom *da=ga[i].args;
    if (nb!=ga[i].nargs)
      continue;
    for(j=0;j<nb;j++)
    {
      int t=tree[arg[j]].t;
      switch(da[j].t)
      {
      case AAtype:
	if (arg[j]>=0 && typemax[t][da[j].v]==da[j].v)
	  continue;
	if (arg[j]>=0 && typemax[t][da[j].v]==t)
	{
	  sc++;
	  continue;
	}
	break;
      case AAsmall:
	if (arg[j]>=0 && tree[arg[j]].f==Fsmall && tree[arg[j]].x==da[j].v)
	  continue;
	break;
      case AAreftype:
	if (arg[j]>=0 && tree[arg[j]].f==Frefarg)
	  continue;
      }
      break;
    }
    if (j<nb)
      continue;
    if (sc==0)
    {
      best=i;
      break;
    }
    if (best==-1 || sc<score)
    {
      score=sc;
      best=i;
    }
  }
  return (best==-1)?NULL:ga+best;
}
Gtype gentypefuncdesc(int n, gpfunc *gp)
{
  int m=0;
  int i;
  int arg[STACKSZ];
  int nb;
  int y=tree[n].y;
  gpdescarg *rule;
  gentype(y);
  nb=genlistargs(n,arg,0,STACKSZ);
  rule=descfindrules(nb,arg,gp->dsc);
  if (!rule)
  {
    warning(n,"no rules matching %s()",gp->gpname);
    return Gnotype;
  }
  for(i=0;i<rule->nproto;i++)
  {
    switch(rule->proto[i].t)
    {
    case PAvar:
      break;
    case PArefvar:
      m|=(1<<Msidef);
      break;
    case PAextra:
      if (rule->proto[i].v==Eprec)
	m|=(1<<Mprec);
      break;
    }
  }
  tree[n].m|=m;
  return rule->type;
}
void genentrydesc(FILE *fout, int n, gpfunc *gp)
{
  int i;
  int arg[STACKSZ];
  int nb;
  gpdescarg *rule;
  descprotoatom *p;
  nb=genlistargs(n,arg,0,STACKSZ);
  rule=descfindrules(nb,arg,gp->dsc);
  if (!rule)
  {
    die(n,"no rules matching %s()",gp->gpname);
    return ;
  }
  fprintf(fout,"%s(",rule->cname);
  p=rule->proto;
  for(i=0;i<rule->nproto;i++)
  {
    if (i) fprintf(fout,", ");
    switch(p[i].t)
    {
    case PAvar:
      //      fprintf(stderr,"%d %s %s\n",p[i].v,Gtypename[tree[arg[p[i].v]].t],Gtypename[rule->args[p[i].v].v]);
      if (p[i].v>=nb)
	die(n,"Too few args for function description %s",rule->cname);
      gencast(fout,arg[p[i].v],rule->args[p[i].v].v);
      break;
    case PArefvar:
      if (p[i].v>=nb)
	die(n,"Too few args for function description %s",rule->cname);
      gencode(fout,arg[p[i].v]);
      break;
    case PAextra:
      if (p[i].v==Eprec)
	fprintf(fout,"prec");
      else if (p[i].v==Enull)
	fprintf(fout,"NULL");
      break;
    }
  }
  fprintf(fout,")");
}
