/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "header.h"
char *Ffuncname[]={"Fseq",
		   "Fmatrix","FmatrixL","FmatrixR",
		   "Faffect","FaffectPP","FaffectSS",
		   "FaffectS","FaffectP","FaffectSL","FaffectSR",
		   "FaffectMOD","FaffectEUC","FaffectDR","FaffectD",
		   "FaffectM",
		   "FexprOR","FexprAND","FexprEQ","FexprNE","FexprGE",
		   "FexprG","FexprLE","FexprL",
		   "FexprS","FexprP","FexprSL","FexprSR","FexprMOD",
		   "FexprEUC","FexprDR","FexprD","FexprM",
		   "FfacteurP","FfacteurS","FfacteurT","FfacteurQ",
		   "FfacteurB","FfacteurC",
		   "Ffacteurmat","Ffacteuraff",
		   "FtrucB",
		   "Fmatrixelts","Fmatrixlines",
		   "Femptyvec","Femptymat","Fmat",
		   "Flistarg",

		   "Fconst","Fstring","Fsmall",
		   "Frefarg","FtrucQ","Ffacteurmem","Ftag",
		   "Fentry","Fentryfunc","Fdeffunc",

		   /*These nodes are generated by genblock, not by parser*/
		   "Fblock","Fgnil"
};

int isanint(char *s)
{
  do
    if (*s<'0' || *s>'9')
      return 0;
  while(*++s);
  return 1;
}
int isasmall(char *s, long *res)
{
  char *endptr;
  if (!isanint(s))
    return 0;
  errno=0;
  *res=strtol(s,&endptr,10);
  if (!*endptr && !errno)
    return 1;
  else 
    return 0;
}
int newnode(Ffunc f, int x, int y)
{
  if (nnode>=node_alloc)
  {
    node_alloc=nnode+100;
    if (debug) fprintf(stderr,"tree=%x alloc node: %d/%d\n",(unsigned int)tree,nnode,node_alloc);
    tree=realloc(tree,node_alloc*sizeof(*tree));
    if (tree==NULL)
      fprintf(stderr,"Oups... alloc node: %d/%d\n",nnode,node_alloc);
  }
  tree[nnode].f=f;
  tree[nnode].x=x;
  tree[nnode].y=y;
  tree[nnode].t=Gnotype;
  tree[nnode].m=0;
  return nnode++;
}
int newvalue(Ffunc func, char *s)
{
  long small;
  if (nvalue>=value_alloc)
  {
    value_alloc=nvalue+100;
    if (debug) fprintf(stderr,"alloc value: %d/%d\n",nvalue,value_alloc);
    value=realloc(value,value_alloc*sizeof(*value));
    if (value==NULL)
      fprintf(stderr,"Oups... alloc value: %d/%d\n",nvalue,value_alloc);
  }
  switch(func)
  {
  case Fconst:
    if (isasmall(s,&small))
    {
      value[nvalue].type=Vsmall;
      value[nvalue].val.small=small;
    }
    else
    {
      value[nvalue].type=Vstr;
      value[nvalue].val.str=strdup(s);
    }
    break;
  case FtrucQ:/*should be special*/
  case Fstring:
    value[nvalue].type=Vstr;
    value[nvalue].val.str=strdup(s);
    break;
  default:
    die(-1,"Internal error: unhandled func %d in newvalue", func);
  }
  return nvalue++;
}
int newconstnode(char *s)
{
  long small;
  if (isasmall(s,&small))
    return newnode(Fsmall,small,-1);
  else
    return newnode(Fconst,newvalue(Fconst,s),-1);
}
int newentry(char *s)
{
  return newvalue(Fstring,s);
}
int newleaf(int n)
{
  int r;
  if (n==-1)
    return newnode(Fgnil,-1,-1);
  r=newnode(tree[n].f,tree[n].x,tree[n].y);
  tree[r]=tree[n];
  return r;
}
Gtype strtotype(char *s)
{
  int i;
  for(i=0;i<Gnbtype;i++)
  {
    if (!strcmp(s,Gname[i]))
      return i;
  }
  return -1;
}
Gtype nodetype(char *s)
{
  int t=strtotype(s);
  if (t==-1)
    die(-1,"unknow type %s",t);
  return t;
}
int listtoseq(int *stack, int nb)
{
  int n,i;
  if (nb==-1) return -1;
  for(n=stack[0],i=1;i<nb;n=newnode(Flistarg,n,stack[i++]));
  return n;
}
static int hasproto=0;
void printnode(FILE *fout, int n)
{
  int i,v;
  context *fc;
  if (n<0)
    return;
  if (debug>=3) fprintf(fout,"/*%s:%d:%s*/",Gname[tree[n].t],tree[n].m,Ffuncname[tree[n].f]);
  switch(tree[n].f)
  {
  case Fseq:
    printnode(fout,tree[n].x);
    if (tree[n].x>=0 && tree[tree[n].x].f!=Fblock && 
	(tree[tree[n].x].f!=Fseq || tree[tree[tree[n].x].y].f!=Fblock))
      fprintf(fout,";\n");
    printnode(fout,tree[n].y);
    break;
  case Fmatrix:
    fprintf(fout,"[");
    printnode(fout,tree[n].x);
    fprintf(fout,"]");
    break;
  case FmatrixL:
    fprintf(fout,"[");
    printnode(fout,tree[n].x);
    fprintf(fout,",]");
    break;
  case FmatrixR:
    fprintf(fout,"[");
    printnode(fout,tree[n].x);
    fprintf(fout,",]");
    break;
  case Faffect:
    fprintf(fout,"=");
    printnode(fout,tree[n].x);
    break;
  case FaffectPP:
    fprintf(fout,"++");
    break;
  case FaffectSS:
    fprintf(fout,"--");
    break;
  case FaffectM:
    fprintf(fout,"*=");
    printnode(fout,tree[n].x);
    break;
  case FaffectD:
    fprintf(fout,"/=");
    printnode(fout,tree[n].x);
    break;
  case FaffectEUC:
    fprintf(fout,"\\=");
    printnode(fout,tree[n].x);
    break;
  case FaffectDR:
    fprintf(fout,"\\/=");
    printnode(fout,tree[n].x);
    break;
  case FaffectMOD:
    fprintf(fout,"%%=");
    printnode(fout,tree[n].x);
    break;
  case FaffectSR:
    fprintf(fout,">>=");
    printnode(fout,tree[n].x);
    break;
  case FaffectSL:
    fprintf(fout,"<<=");
    printnode(fout,tree[n].x);
    break;
  case FaffectP:
    fprintf(fout,"+=");
    printnode(fout,tree[n].x);
    break;
  case FaffectS:
    fprintf(fout,"-=");
    printnode(fout,tree[n].x);
    break;
  case FexprOR:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"||");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprAND:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"&&");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprEQ:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"==");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprNE:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"!=");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprGE:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,">=");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprG:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,">");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprLE:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"<=");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprL:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"<");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprS:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"-");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprP:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"+");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprSL:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"<<");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprSR:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,">>");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprMOD:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"%%");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprDR:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"\\/");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprEUC:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"\\");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprD:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"/");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FexprM:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"*");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case FfacteurP:
    fprintf(fout,"+");
    printnode(fout,tree[n].x);
    break;
  case FfacteurS:
    fprintf(fout,"-");
    printnode(fout,tree[n].x);
    break;
  case FfacteurT:
    printnode(fout,tree[n].x);
    fprintf(fout,"~");
    break;
  case FfacteurQ:
    printnode(fout,tree[n].x);
    fprintf(fout,"'");
    break;
  case FfacteurB:
    printnode(fout,tree[n].x);
    fprintf(fout,"!");
    break;
  case FfacteurC:
    fprintf(fout,"(");
    printnode(fout,tree[n].x);
    fprintf(fout,"^");
    printnode(fout,tree[n].y);
    fprintf(fout,")");
    break;
  case Ffacteurmat:
    printnode(fout,tree[n].x);
    printnode(fout,tree[n].y);
    break;
  case Ffacteuraff:
    printnode(fout,tree[n].x);
    printnode(fout,tree[n].y);
    break;
  case Ffacteurmem:
    printnode(fout,tree[n].x);
    fprintf(fout,".%s",value[tree[n].y].val.str);
    break;
  case Fconst:
  case Fstring:
    if (value[tree[n].x].type==Vsmall)
      fprintf(fout,"%ld",value[tree[n].x].val.small);
    else
      fprintf(fout,"%s",value[tree[n].x].val.str);
    break;
  case Fsmall:
    fprintf(fout,"%d",tree[n].x);
    break;
  case FtrucB:
    fprintf(fout,"!");
    printnode(fout,tree[n].x);
    break;
  case FtrucQ:
    fprintf(fout,"'");
    printnode(fout,tree[n].x);
    break;
  case Fmatrixelts:
    printnode(fout,tree[n].x);
    fprintf(fout,",");
    printnode(fout,tree[n].y);
    break;
  case Fmatrixlines:
    printnode(fout,tree[n].x);
    fprintf(fout,";");
    printnode(fout,tree[n].y);
    break;
  case Femptyvec:
    fprintf(fout,"[]");
    break;
  case Femptymat:
    fprintf(fout,"[;]");
    break;
  case Fmat:
    fprintf(fout,"[");
    printnode(fout,tree[n].x);
    fprintf(fout,"]");
    break;
  case Flistarg:
    printnode(fout,tree[n].x);
    fprintf(fout,",");
    printnode(fout,tree[n].y);
    break;
  case Fentry:
    fprintf(fout,"%s",value[tree[n].x].val.str);
    break;  
  case Fentryfunc:
    if (!hasproto || strcmp(value[tree[n].x].val.str,"local"))
    {
      fprintf(fout,"%s",value[tree[n].x].val.str);
      fprintf(fout,"(");
      printnode(fout,tree[n].y);
      fprintf(fout,")");
    }
    break;
  case Frefarg:
    fprintf(fout,"&%s",value[tree[n].x].val.str);
    break;
  case Fdeffunc:
    printnode(fout,tree[n].x);
    fprintf(fout,"=\n");
    printnode(fout,tree[n].y);
    fprintf(fout,"\n");
    break;
  case Fblock:
    fprintf(fout,"{");
    fc=block+tree[n].x;
    v=fc->ret;
    if (v>=0)
      fprintf(fout,"/*=%s*/",value[tree[v].x].val.str);
    fprintf(fout,"\n");
    if (fc->n)
    {
      fprintf(fout,"local(");
      for(i=0;i<fc->n;i++)
	fprintf(fout,"%s%c",fc->c[i].var,i==fc->n-1?')':',');
      fprintf(fout,";\n");
    }    
    printnode(fout,tree[n].y);
    fprintf(fout,"\n}\n");
    break;
  case Fgnil:
    fprintf(fout,"gnil");
    break;
  case Ftag:
    printnode(fout,tree[n].x);    
    fprintf(fout,":%s",Gname[tree[n].y]);
    break;
  }
}
void maketree(FILE *fout,int n)
{
  switch(tree[n].f)
  {
  case Ftag:
    fprintf(fout,"(");
    maketree(fout,tree[n].x);
    fprintf(fout,",");
    fprintf(fout,"%s",Gname[tree[n].y]);
    fprintf(fout,")");
    break;
  default:
    if (tree[n].f<FneedENTRY)
    {
      if (tree[n].x!=-1)
      {
	fprintf(fout,"(");
	maketree(fout,tree[n].x);
	if (tree[n].y!=-1 )
	{
	  fprintf(fout,",");
	  maketree(fout,tree[n].y);
	}
	fprintf(fout,")");
      }
    }
    else
    {
      if (tree[n].y!=-1)
      {
	fprintf(fout,"(");
	maketree(fout,tree[n].y);
	fprintf(fout,")");
      }
    }
  }
  fprintf(fout,"%s_%d",Ffuncname[tree[n].f],n);
}
