/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*Patch for list of gp functions. Must be include after header.h.*/
typedef enum {GPpari=-1,GPuser=0,GPconst,
	      GPgpmany,GPgplist,
	      GPgrandO,
	      GPbreak,GPfor,GPforstep,GPforprime,GPglobal,GPif,GPlocal,GPprod,GPreturn,GPsum,GPuntil,GPwhile,GPprint,GPerror,GPmakevec,GPmakemat,GPvector,GPvectorv
} GPspec;

gpfunc patchfunc[]={
{"O",NULL,7,NULL,Ggen,0,GPgrandO},
{"break",NULL,11,NULL,Gvoid,0,GPbreak},
{"for",NULL,11,"EEIE",Gnotype,(1<<Msemicomma),GPfor},
{"forstep",NULL,11,"EEEIE",Gnotype,(1<<Msemicomma),GPforstep},
{"forprime",NULL,11,"EEEEIE",Gnotype,(1<<Msemicomma),GPforprime},
{"if",NULL,11,"EII",Gnotype,(1<<Msemicomma),GPif},
{"prod",NULL,11,"EEIE",Gnotype,(1<<Msemicomma),GPprod},
{"return",NULL,11,NULL,Gnotype,(1<<Mterm),GPreturn},
{"sum",NULL,11,"EEIE",Gnotype,(1<<Msemicomma),GPsum},
{"until",NULL,11,"EI",Gnotype,(1<<Msemicomma),GPuntil},
{"vector",NULL,11,"EEEEIE",Gnotype,(1<<Msemicomma),GPvector},
{"vectorv",NULL,11,"EEEEIE",Gnotype,(1<<Msemicomma),GPvectorv},
{"while",NULL,11,"EI",Gnotype,(1<<Msemicomma),GPwhile},

{"Euler","mpeuler",3,"p",Gmp,(1<<Mvar)|(1<<Mprec),GPpari},
{"Pi","mppi",3,"p",Gmp,(1<<Mvar)|(1<<Mprec),GPpari},
{"I","gi",3,"",Ggen,(1<<Mparens),GPconst},

{NULL,NULL,0,NULL,Gnotype,0,-1}
};
