/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
#include "patchfunc.h"
#include "listfunc.h"
extern int indent;
int findentry(const char *s)
{
  int i;
  for(i=0;listfunc[i].gpname && strcmp(listfunc[i].gpname,s);i++);
  return listfunc[i].gpname?i:-1;
}
int findentrybycname(const char *s)
{
  int i;
  for(i=0;listfunc[i].gpname 
	&& (!listfunc[i].cname || strcmp(listfunc[i].cname,s));i++);
  return listfunc[i].gpname?i:-1;
}

void patchfunclist(void)
{
  int i;
  for(i=0;patchfunc[i].gpname;i++)
  {
    int nf=findentry(patchfunc[i].gpname);
    if (nf==-1)
      die(-1,"Incorrect patchfunc.h file: function not found");
    listfunc[nf]=patchfunc[i];
  }
}
void printlistfunc(FILE *fout)
{
  int i;
  for(i=0;listfunc[i].gpname;i++)
    fprintf(fout,"%s %s %s\n",listfunc[i].gpname,listfunc[i].cname,listfunc[i].code);
}
void genequal(int aff, char *func, int *var, int *binf)
{
  int y;
  if (tree[aff].f!=Ffacteuraff)
    die(aff,"incorrect syntax for %s",func);
  *var=tree[aff].x;
  y=tree[aff].y;
  if ((tree[*var].f!=Fentry && tree[*var].f!=Ftag) || tree[y].f!=Faffect)
    die(aff,"incorrect syntax for %s",func);
  *binf=tree[y].x;
}

int addseqright(int seq, int n);
/*it is like newleaf but newleaf(-1)=Fgnil*/
int newvar(int n)
{
  int r;
  if (n==-1)
    return -1;
  r=newnode(tree[n].f,tree[n].x,tree[n].y);
  tree[r]=tree[n];
  return r;
}
int gengerepile(int bl)
{
  int arg[4];
  block[bl].gc|=(1<<GCneeded);
  arg[0]=newnode(Fentry,newentry("btop"),-1);
  pushvar(arg[0],1<<Cuser,Gulong,newcall("_avma",-1));
  arg[1]=newnode(Fentry,newentry("st_lim"),-1);
  pushvar(arg[1],1<<Cuser,Gulong,
	  newcall("_stack_lim",newnode(Flistarg,arg[0],
					newnode(Fsmall,1,-1))));
  arg[2]=newnode(Fentry,newentry("bptr"),-1);
  arg[3]=newnode(Fsmall,bl,-1);
  return listtoseq(arg,4);
}
void gengerepileend(int bl)
{
  int gptr=newnode(Fentry,newentry("bptr"),-1);
  int blo=newnode(Fsmall,bl,-1);
  pushvar(gptr,1<<Cuser,Ggptr,newcall("_gerepilelist",blo));
}
/*
  The 6 operations which order is very important are
  are:

  pushvar/newdecl(var)
  gpm=gengerepile(bl2);
  geninsertvar(arg,var)
  genblock(arg,p)
  seq=addseqright(seq,newcall("_gerepilemany",gpm));
  gengerepileend(bl2);
  savx=nctx
  
  savx=nctx start the recording of var in the block
  pushvar/newdecl(var) must be before geninsert(arg,var) obviously,

  if you use geninsertvar to store the value a a node, then
  geninsertvar must be called before genblock and genblock must be
  called with p=1 since the return value is really ignored. 
  G.N.^H^H^H^HB.A.*/
void genblockfuncspec(int n, int p, gpfunc *gp)
{
  int arg[STACKSZ];
  int nb;
  int y=tree[n].y;
  int binf,bsup,bstep,seq;
  int var,vinf,vsup,vstep;
  int bseq=-1,aseq=-1,ret=-1;
  int val,vprime;
  int gpm,bl1,bl2;
  int savx;
  switch(gp->spec)
  {
  case GPgrandO:
    if (tree[y].f==Fentryfunc && tree[y].x==OPpow)
      tree[y]=tree[tree[y].y];
    else
      tree[n].y=newnode(Flistarg,y,newnode(Fsmall,1,-1));
    genblock(y,n);
    break;
  case GPif:
    nb=genlistargs(n,arg,2,3);
    if (nb==3 && arg[2]==-1)
      /*Some people type 'if(x=0,print(x),)'*/
      nb--;
    if (tree[arg[0]].f==Fsmall && tree[arg[0]].x)
    {
      /*if(1,,) expr are often used to create block. We honor it here*/
      if (p>=0 && tree[p].f!=Fseq)
	newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&ret);
      arg[1]=geninsertvar(arg[1],ret,Faffect);
      genblock(arg[1],-1);
      aseq=arg[1];
    }
    else
    {
      if(nb==3)
	val=-1;
      else
	val=newnode(Fgnil,-1,-1);
      if (p>=0 && tree[p].f!=Fseq)
	newdecl(1<<Cauto,Gvoid,val,&ret);
      genblock(arg[0],n);
      arg[1]=geninsertvar(arg[1],ret,Faffect);
      genblock(arg[1],-1);
      if(nb==3)
      {
        arg[2]=geninsertvar(arg[2],newvar(ret),Faffect);
        genblock(arg[2],-1);
      }
      aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,nb));
    }
    makeblock(newblock(),n,aseq,ret,nctx);
    break;
  case GPfor:
    nb=genlistargs(n,arg,3,3);
    genequal(arg[0],gp->gpname,&var,&binf);
    bsup=arg[1];seq=arg[2];
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vinf);
    bseq=addseqright(bseq,geninsertvar(binf,newleaf(vinf),Faffect));
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vsup);
    bseq=addseqright(bseq,geninsertvar(bsup,newleaf(vsup),Faffect));
    genblock(binf,-1);
    genblock(bsup,-1);
    savx=nctx; 
    bl1=newblock();
    bl2=newblock();
    if (autogc)
      gpm=gengerepile(bl2);
    if  (tree[binf].f==Fsmall 
	 && (tree[binf].x<(1<<30) || tree[bsup].f==Fsmall))
      pushvar(var,1<<Cuser,Gsmall,-1);
    else
      pushvar(var,1<<Cuser,Ggen,-1);
    genblock(seq,-1);
    if (autogc)
    {
      seq=addseqright(seq,newcall("_gerepilemany",gpm));
      gengerepileend(bl2);
    }
    arg[0]=newnode(Ffacteuraff,var,newnode(Faffect,vinf,-1));
    arg[1]=newopcall(OPle,newleaf(var),vsup);
    arg[2]=seq;
    arg[3]=newopcall(OPpp,newleaf(var),-1);
    aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,4));
    makeblocks(bl1,bl2,n,bseq,aseq,ret,savx);
    break;
  case GPforstep:
    nb=genlistargs(n,arg,4,4);
    genequal(arg[0],gp->gpname,&var,&binf);
    bsup=arg[1];bstep=arg[2];seq=arg[3];
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vinf);
    bseq=addseqright(bseq,geninsertvar(binf,newleaf(vinf),Faffect));
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vsup);
    bseq=addseqright(bseq,geninsertvar(bsup,newleaf(vsup),Faffect));
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vstep);
    bseq=addseqright(bseq,geninsertvar(bstep,newleaf(vstep),Faffect));
    genblock(binf,-1);
    genblock(bsup,-1);
    genblock(bstep,-1);
    savx=nctx;
    bl1=newblock();
    bl2=newblock();
    if (autogc)
      gpm=gengerepile(bl2);
    if  (tree[binf].f==Fsmall 
	 && (tree[binf].x<(1<<30) || tree[bsup].f==Fsmall))
      pushvar(var,1<<Cuser,Gsmall,-1);
    else
      pushvar(var,1<<Cuser,Ggen,-1);
    genblock(seq,-1);
    if (autogc)
    {
      seq=addseqright(seq,newcall("_gerepilemany",gpm));
      gengerepileend(bl2);
    }
    arg[0]=newnode(Ffacteuraff,var,newnode(Faffect,vinf,-1));
    if ( tree[bstep].f==Fsmall )
    {
	if ( tree[bstep].x>0 )
    	  arg[3]=newopcall(OPle,newleaf(var),vsup);
	else  
    	  arg[3]=newopcall(OPge,newleaf(var),vsup);
	nb=4;
    }
    else
    {
    	arg[3]=newopcall(OPg,newleaf(vstep),0);
    	arg[4]=newopcall(OPle,newleaf(var),vsup);
    	arg[5]=newopcall(OPge,newleaf(var),vsup);
	nb=6;
    }
    arg[1]=seq;
    arg[2]=newopcall(OPpe,var,vstep);
    aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,nb));
    makeblocks(bl1,bl2,n,bseq,aseq,ret,savx);
    break;
  case GPforprime:
#if 0 
  if (bsup > maxprime()) err(primer1);
  for (p = 2, primepointer = diffptr; p<=bsup; p += *++primepointer)
  {
    if (p < binf) continue;
    {SEQ}
  }
#endif
    nb=genlistargs(n,arg,3,3);
    genequal(arg[0],gp->gpname,&var,&binf);
    bsup=arg[1];seq=arg[2];
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vinf);
    bseq=addseqright(bseq,geninsertvar(binf,newleaf(vinf),Faffect));
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vsup);
    bseq=addseqright(bseq,geninsertvar(bsup,newleaf(vsup),Faffect));
    genblock(binf,-1);
    genblock(bsup,-1);
    savx=nctx; 
    bl1=newblock();
    bl2=newblock();
    if (autogc)
      gpm=gengerepile(bl2);
    pushvar(var,1<<Cuser,Gsmall,-1);
    vprime=newnode(Fentry,newentry("primepointer"),-1);
    pushvar(vprime,1<<Cuser,Gbptr,-1);/*Well the user is K.B. this time:-)*/
    genblock(seq,-1);
    if (autogc)
    {
      seq=addseqright(seq,newcall("_gerepilemany",gpm));
      gengerepileend(bl2);
    }
    /*vsup<maxprime()*/
    arg[0]=newopcall(OPg,vsup,newnode(Fentryfunc,newentry("_maxprime"),-1));
    /*var=2*/
    arg[1]=newnode(Ffacteuraff,var,newnode(Faffect,newnode(Fsmall,2,-1),-1));
    /*var<=vsup*/
    arg[2]=newopcall(OPle,newleaf(var),newleaf(vsup));
    /*++primepointer*/
    arg[3]=newopcall(OPpp,newleaf(vprime),-1);
    /*var+=*++primepointer*/
    arg[3]=geninsertvarop(arg[3],newleaf(var),OPpe);
    /*var<vinf*/
    arg[4]=newopcall(OPl,newleaf(var),vinf);
    arg[5]=seq;
    aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,6));
    makeblocks(bl1,bl2,n,bseq,aseq,ret,savx);
    break;
  case GPsum:
  case GPprod:
    nb=genlistargs(n,arg,3,4);
    genequal(arg[0],gp->gpname,&var,&binf);
    bsup=arg[1];seq=arg[2];
    if(nb==3)
      arg[3]=newnode(Fsmall,(gp->spec==GPsum?0:1),-1);
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vinf);
    bseq=addseqright(bseq,geninsertvar(binf,newleaf(vinf),Faffect));
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vsup);
    bseq=addseqright(bseq,geninsertvar(bsup,newleaf(vsup),Faffect));
    newdecl(0,Ggen,-1,&ret);
    bseq=addseqright(bseq,geninsertvar(arg[3],newleaf(ret),Faffect));
    genblock(binf,-1);
    genblock(bsup,-1);
    genblock(arg[3],-1);
    savx=nctx;
    bl1=newblock();
    bl2=newblock();
    if (autogc)
      gpm=gengerepile(bl2);
    if  (tree[binf].f==Fsmall && 
	 (tree[binf].x<(1<<30) || tree[bsup].f==Fsmall))
      pushvar(var,1<<Cuser,Gsmall,-1);
    else
      pushvar(var,1<<Cuser,Ggen,-1);
    arg[2]=geninsertvarop(seq,ret,(gp->spec==GPsum?OPpe:OPme));
    genblock(arg[2],-1);
    if (autogc)
    {
      arg[2]=addseqright(arg[2],newcall("_gerepilemany",gpm));
      gengerepileend(bl2);
    }
    arg[0]=newnode(Ffacteuraff,var,newnode(Faffect,vinf,-1));
    arg[1]=newopcall(OPle,newleaf(var),vsup);
    arg[3]=newopcall(OPpp,newleaf(var),-1);
    aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,4));
    makeblocks(bl1,bl2,n,bseq,aseq,ret,savx);
    break;
  case GPuntil:
  case GPwhile:
    nb=genlistargs(n,arg,2,2);
    bl1=newblock();
    savx=nctx;
    if(autogc)
      gpm=gengerepile(bl1);
    genblock(arg[0],n);
    genblock(arg[1],-1);
    if (autogc)
    {
      gengerepileend(bl1);
      arg[1]=addseqright(arg[1],newcall("_gerepilemany",gpm));
    }
    aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,nb));
    makeblock(bl1,n,aseq,ret,savx);
    break;
  case GPvector:
  case GPvectorv:
    nb=genlistargs(n,arg,1,3);
    var=arg[1];bsup=arg[0];seq=arg[2];
    newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vsup);
    bseq=addseqright(bseq,geninsertvar(bsup,newleaf(vsup),Faffect));
    genblock(bsup,-1);
    newdecl(0,Ggen,-1,&ret);
    savx=nctx;
    bl1=newblock();
    bl2=newblock();
    if (nb>=2)
      pushvar(var,1<<Cuser,Gsmall,-1);
    else
      newdecl(0,Gsmall,-1,&var);
    if(nb<3)
      seq=newnode(Fsmall,0,-1);
    arg[0]=ret;
    if (tree[bsup].f==Fsmall)
      arg[1]=newnode(Fsmall,tree[bsup].x+1,-1);
    else
      arg[1]=newopcall(OPp,newleaf(vsup),newnode(Fsmall,1,-1));
    arg[2]=newnode(Ffacteuraff,var,newnode(Faffect,newnode(Fsmall,1,-1),-1));
    arg[3]=newopcall(OPle,newleaf(var),vsup);
    arg[4]=newnode(Ffacteurmat,newvar(ret),newnode(Fmatrix,newleaf(var),-1));
    arg[4]=geninsertvar(seq,arg[4],Faffect);
    genblock(arg[4],-1);
    arg[5]=newopcall(OPpp,newleaf(var),-1);
    aseq=newnode(tree[n].f,tree[n].x,listtoseq(arg,6));
    makeblocks(bl1,bl2,n,bseq,aseq,ret,savx);
    break;
  case GPlocal:
    genblockdeclaration(tree[n].y,n,(1<<Cuser));
    break;
  case GPglobal:
    genblockdeclaration(tree[n].y,n,(1<<Cuser)|(1<<Cglobal));
    break;
  case GPreturn:
    /*    if (p>=0 && tree[p].f!=Fseq)
	  die(n,"return cannot be evaluate.");*/
    nb=genlistargs(n,arg,0,1);
    if (nb)
      genblock(arg[0],n);
    else
      arg[0]=newnode(Fgnil,-1,-1);
    savx=nctx;
    bl1=newblock();
    newdecl((1<<Cauto)|(1<<Cconst)|(1<<Creturn),Gvoid,-1,&var);
    aseq=geninsertvar(arg[0],var,Faffect);
    arg[0]=newleaf(var);
    if (autogc)
    {
      int arg[4];
      block[bl1].gc|=(1<<GCneeded)|(1<<GCglobal);
      arg[0]=newnode(Fentry,newentry("ltop"),-1);
      arg[1]=-1;
      arg[2]=newnode(Fentry,newentry("gptr"),-1);
      arg[3]=newnode(Fsmall,bl1,-1);
      gpm=listtoseq(arg,4);
      aseq=addseqright(aseq,newcall("_gerepilemany",gpm));
      pushvar(newvar(arg[2]),1<<Cuser,Ggptr,newcall("_gerepilelist",arg[3]));
    }
    aseq=addseqright(aseq,newnode(tree[n].f,tree[n].x,listtoseq(arg,1)));
    makeblock(bl1,n,aseq,ret,savx);
    break;
    /*  case GPbreak:
	if (p>=0 && tree[p].f!=Fseq)
	die(n,"break cannot be evaluate.");
	break;*/
  default:
    /*treat as a normal function*/
    genblock(tree[n].y,n);
  }
}
int gentypefuncspec(int n, gpfunc *gp)
{
  int arg[STACKSZ];
  int i,nb;
  int y=tree[n].y;
  switch(gp->spec)
  {
  case GPif:
    nb=genlistargs(n,arg,2,3);
    gentype(arg[0]);
    gentype(arg[1]);
    tree[n].m=(tree[arg[0]].m|(tree[arg[1]].m&~(1<<Mterm)))&MODHERIT;
    if (nb==3)
    {
      gentype(arg[2]);
      /*We must not set Gterm if we are not sure.
	In this case we must set Gsidef instead.*/
      tree[n].m|=(1<<Melse)|(tree[arg[2]].m&(~(1<<Mterm)));
      if ((tree[arg[1]].m&(1<<Mterm)) && (tree[arg[2]].m&(1<<Mterm)))
	tree[n].m|=(1<<Mterm);
      else
	if ((tree[arg[1]].m&(1<<Mterm)) || (tree[arg[2]].m&(1<<Mterm)))
	  tree[n].m|=(1<<Msidef);
      return max(tree[arg[1]].t,tree[arg[2]].t);
    }
    if ((tree[arg[1]].m&(1<<Mterm)))
      tree[n].m|=(1<<Msidef);
    return tree[arg[1]].t;
  case GPfor:
  case GPsum:
  case GPprod:
    nb=genlistargs(n,arg,4,4);
    gentype(arg[0]);
    gentype(arg[1]);
    gentype(arg[2]);
    gentype(arg[3]);
    tree[n].m=(tree[arg[0]].m|tree[arg[1]].m
      |(tree[arg[2]].m&~(1<<Mterm))|(tree[arg[3]].m&~(1<<Mterm)))&MODHERIT;
    return Gvoid;
  case GPforstep:
    nb=genlistargs(n,arg,4,6);
    tree[n].m=0;
    for (i=0;i<nb;i++)
    {
    	gentype(arg[i]);
    	tree[n].m|=tree[arg[i]].m;
    }
    return Gvoid;
  case GPforprime:
  case GPvector:
  case GPvectorv:
    nb=genlistargs(n,arg,6,6);
    gentype(arg[0]);
    gentype(arg[1]);
    gentype(arg[2]);
    gentype(arg[3]);
    gentype(arg[4]);
    gentype(arg[5]);
    tree[n].m=(tree[arg[0]].m|tree[arg[1]].m|tree[arg[2]].m |tree[arg[3]].m
	    |(tree[arg[4]].m&~(1<<Mterm))|(tree[arg[5]].m&~(1<<Mterm)))&MODHERIT;
    return Gvoid;
  case GPuntil:
  case GPwhile:
    nb=genlistargs(n,arg,2,2);
    gentype(arg[0]);
    gentype(arg[1]);
    if(gp->spec==GPwhile)
      tree[n].m=(tree[arg[0]].m|(tree[arg[1]].m&~(1<<Mterm)))&MODHERIT;
    else
      tree[n].m=(tree[arg[0]].m|tree[arg[1]].m)&MODHERIT;
    return Gvoid;
  case GPreturn:
    tree[n].m=(1<<Mterm);
    if (y>=0)
    {
      gentype(y);
      tree[n].m|=tree[y].m&MODHERIT;
      lfunc[currfunc].gp.type=max(lfunc[currfunc].gp.type,tree[y].t);
    }
    else
      lfunc[currfunc].gp.type=Gvoid;
    return Gvoid;
  case GPlocal:
  case GPglobal:
    tree[n].m=0;
    return Gvoid;
  case GPmakevec:
  case GPmakemat:
    gentype(y);
    tree[n].m=(tree[y].m&MODHERIT)|(1<<Msidef);
    return Ggen;
  default:
    if (gp->spec>0) 
      die(n,"gentypefuncspec : func spec not implemented");
    else
      die(n,"Internal error : gentypefuncspec called with no spec");
  }
}
void genpercent(FILE *fout, int n)
{
  char *s=value[tree[n].x].val.str;
  while(*s)
  {
    if (*s=='%')
      fputc('%',fout);
    fputc(*s++,fout);
  }
}
void genformat(FILE *fout, int nb, int *arg)
{
  int i;
  for(i=0;i<nb;i++)
  {
    switch(ctype[tree[arg[i]].t])
    {
      case Vbptr:
      case Vsmall:
	fprintf(fout,"%%ld");
	break;
      case Vgen:
	fprintf(fout,"%%Z");
	break;
      case Vstr:
	if (tree[arg[i]].f!=Fstring)
	  fprintf(fout,"%%s");
	else
	  genpercent(fout,arg[i]);
	break;
      case Vvoid:
	break;
      case Vulong:
	fprintf(fout,"%%lu");
	break;
      case Vgptr:
	die(-1,"Printing gptr doesn't make sense");
    }
  }
}
void genentryspec(FILE *fout, int n, gpfunc *gp)
{
  int arg[STACKSZ];
  int nb;
  int y=tree[n].y;
  int i;
  int ncol,nlin;
  context *bl;
  switch(gp->spec)
  {
    case GPgrandO:
      nb=genlistargs(n,arg,2,2);
      gencallfunc(fout,"ggrandocp",arg,nb,"GL");
      break;
    case GPbreak:
      fprintf(fout,"break");
      break;
    case GPnext:
      fprintf(fout,"continue");
      break;
    case GPif:
      nb=genlistargs(n,arg,2,3);
#if 0    
      /*generate nice `? :' */
    if (t!=Gvoid && tree[arg[1]].f!=Fseq && (nb==2 || tree[arg[2]].f!=Fseq) )
    {
      fprintf(fout,"((");
      genbool(fout,arg[0],tree[arg[0]].t);
      fprintf(fout,")?");
      gencast(fout,arg[3],t);
      fprintf(fout,":");
      if (nb==5)
	gencast(fout,arg[4],t);
      else/*the type of left and right must be equal.*/
	gensmallval(fout,0,t);
      fprintf(fout,")");
    }
#endif
    genindent(fout);
    fprintf(fout,"if (");
    if(arg[1]!=-1)
      gencast(fout,arg[0],Gbool);
    else
      gencast(fout,arg[0],Gnegbool);
    fprintf(fout,")\n");
    if (nb==2)
      genbrace(fout,arg[1]);
    else
    {
      /*Be paranoid with dangling 'else' */
      int brace=arg[1]!=-1 && (tree[arg[1]].f==Fseq || tree[arg[1]].f==Fblock);
      if (brace)
      {
	genindent(fout);
	fprintf(fout,"{\n");
      }
      indent++;
      genindentseq(fout,arg[1]);
      gencode(fout,arg[1]);
      gensemicomma(fout,arg[1]);
      indent--;
      if (brace)
      {
	genindent(fout);
	fprintf(fout,"}\n");
      }
      if (arg[1]!=-1)
      {
	genindent(fout);
	fprintf(fout,"else\n");
      }
      genbrace(fout,arg[2]);
    }
    break;
  case GPwhile:
    nb=genlistargs(n,arg,2,2);
    genindent(fout);
    fprintf(fout,"while (");
    gencast(fout,arg[0],Gbool);
    fprintf(fout,")\n");
    genbrace(fout,arg[1]);
    break;
  case GPuntil:
    nb=genlistargs(n,arg,2,2);
    genindent(fout);
    fprintf(fout,"do\n");
    genindent(fout);
    fprintf(fout,"{\n");
    indent++;
    genindentseq(fout,arg[1]);
    gencode(fout,arg[1]);
    gensemicomma(fout,arg[1]);
    indent--;
    genindent(fout);
    fprintf(fout,"}while(");
    gencast(fout,arg[0],Gnegbool);
    fprintf(fout,");\n");
    break;
  case GPfor:
  case GPsum:
  case GPprod:
    nb=genlistargs(n,arg,4,4);
    genindent(fout);
    fprintf(fout,"for (");
    gencode(fout,arg[0]);
    fprintf(fout,"; ");
    gencode(fout,arg[1]);
    fprintf(fout,"; ");
    gencode(fout,arg[3]);
    fprintf(fout,")\n");
    genbrace(fout,arg[2]);
    break;
  case GPforstep:
    nb=genlistargs(n,arg,4,6);
    genindent(fout);
    fprintf(fout,"for (");
    gencode(fout,arg[0]);
    fprintf(fout,"; ");
    if ( nb==4 )
      gencode(fout,arg[3]);
    else
    {
      gencode(fout,arg[3]);
      fprintf(fout,"?");
      gencode(fout,arg[4]);
      fprintf(fout,":");
      gencode(fout,arg[5]);
    }
    fprintf(fout,"; ");
    gencode(fout,arg[2]);
    fprintf(fout,")\n");
    genbrace(fout,arg[1]);
    break;
  case GPforprime:
#if 0 
    if (bsup > maxprime()) err(primer1);
    for (p = 2, primepointer = diffptr; p<bsup; p += *primepointer)
    {
      if (p <= binf) continue;
      {SEQ}
    }
#endif
    nb=genlistargs(n,arg,6,6);
    genindent(fout);
    fprintf(fout,"if (");
    gencode(fout,arg[0]);
    fprintf(fout,") err(primer1);\n");
    genindent(fout);
    fprintf(fout,"for (");
    gencode(fout,arg[1]);
    fprintf(fout,", primepointer = diffptr; ");
    gencode(fout,arg[2]);
    fprintf(fout,"; ");
    gencode(fout,arg[3]);
    fprintf(fout,")\n");
    genindent(fout);
    fprintf(fout,"{\n");
    indent++;
    if (tree[tree[arg[4]].y].f!=Fsmall || tree[tree[arg[4]].y].x>2)
    {
      genindent(fout);
      fprintf(fout,"if (");
      gencast(fout,arg[4],Gbool);
      fprintf(fout,")\n");
      indent++;
      genindent(fout);
      fprintf(fout,"continue;\n");
      indent--;
    }
    genindentseq(fout,arg[5]);
    gencode(fout,arg[5]);
    gensemicomma(fout,arg[5]);
    indent--;
    genindent(fout);
    fprintf(fout,"}\n");
    break;
  case GPvector:
  case GPvectorv:
    nb=genlistargs(n,arg,6,6);
    genindent(fout);
    gencode(fout,arg[0]);
    fprintf(fout," = cgetg(");
    gencast(fout,arg[1],Gsmall);
    if (gp->spec==GPvector)
      fprintf(fout,", t_VEC);\n");
    else
      fprintf(fout,", t_COL);\n");
    genindent(fout);
    fprintf(fout,"for (");
    gencode(fout,arg[2]);
    fprintf(fout,"; ");
    gencode(fout,arg[3]);
    fprintf(fout,"; ");
    gencode(fout,arg[5]);
    fprintf(fout,")\n");
    genbrace(fout,arg[4]);
    break;
  case GPprint:
    nb=genlistargs(n,arg,0,STACKSZ);
    fprintf(fout,"fprintferr(\"");
    genformat(fout,nb,arg);
    if (gp->gpname[5]==0)
      /*if it is not print1*/
      fprintf(fout,"\\n");
    fprintf(fout,"\"");
    for(i=0;i<nb;i++)
      if (tree[arg[i]].f!=Fstring)
      {
	fprintf(fout,",");
	if (ctype[tree[arg[i]].t]==Vbptr)
	  fprintf(fout,"*");
	gencode(fout,arg[i]); 
      }
    fprintf(fout,")");
    break;
  case GPerror:
    nb=genlistargs(n,arg,0,STACKSZ);
    fprintf(fout,"err(talker, \"");
    genformat(fout,nb,arg);
    fprintf(fout,"\"");
    for(i=0;i<nb;i++)
      if (tree[arg[i]].f!=Fstring)
      {
	fprintf(fout,",");
	if (ctype[tree[arg[i]].t]==Vbptr)
	  fprintf(fout,"*");
	gencode(fout,arg[i]);
      }
    fprintf(fout,")");
    break;
  case GPmakevec:
    nb=genlistargs(n,arg,1,STACKSZ);
    genindent(fout);
    gencode(fout,arg[0]);
    fprintf(fout," = cgetg(%d, t_VEC);\n",nb);
    for(i=1;i<nb;i++)
    {
      genindentseq(fout,arg[i]);
      gencode(fout,arg[i]);
      gensemicomma(fout,arg[i]);
    }
    break;
  case GPmakemat:
    nb=genlistargs(n,arg,3,STACKSZ);
    nlin=tree[arg[1]].x;
    ncol=tree[arg[2]].x;
    genindent(fout);
    gencode(fout,arg[0]);
    fprintf(fout," = cgetg(%d, t_MAT);\n",ncol+1);
    for(i=1;i<=ncol;i++)
    {
      int j;
      genindent(fout);
      gencode(fout,arg[0]);
      fprintf(fout,"[%d] = lgetg(%d, t_COL);\n",i,nlin+1);
      indent++;
      for(j=1;j<=nlin;j++)
      {
	int k=(j-1)*ncol+i+2;
	genindentseq(fout,arg[k]);
	gencode(fout,arg[k]);
	gensemicomma(fout,arg[k]);
      }
      indent--;
    }
    break;
  case GPgplist:
    bl=block+tree[y].x;
    fprintf(fout,"{ ");
    for(i=0;i<bl->ngc;i++)
    {
      if (i) fprintf(fout,", ");
      fprintf(fout,"&%s",ctxstack[bl->gcvar[i]].var);
    }
    fprintf(fout," }");
    break;
  case GPgpmany:
    nb=genlistargs(n,arg,4,STACKSZ);
    bl=block+tree[arg[3]].x;
    if (!(bl->gc&(1<<GCneeded)))
      break;
    genindent(fout);
    if (!bl->ngc)
    {
      fprintf(fout,"avma = ");
      gencode(fout,arg[0]);
      fprintf(fout,";\n");
    }
    else if (bl->gc&(1<<GCupto))
    {
      char *varname=ctxstack[bl->gcvar[0]].var;
      fprintf(fout,"%s = gerepileupto(",varname);
      gencode(fout,arg[0]);
      fprintf(fout,", %s);\n",varname);
    }
    else
    {
      /*FIXME:Putting an if statement in the wilderness is not secure*/ 
      if (arg[1]!=-1)
      {
	fprintf(fout,"if (low_stack(");
	gencode(fout,arg[1]);
	fprintf(fout,", stack_lim(");
	gencode(fout,arg[0]);
	fprintf(fout,", 1)))\n");
	indent++;
	genindent(fout);
	indent--;
      }
      fprintf(fout,"gerepilemany(");
      gencode(fout,arg[0]);
      fprintf(fout,", ");
      gencode(fout,arg[2]);
      fprintf(fout,", %d);\n",bl->ngc);
    }
    break;
  case GPreturn:
    fprintf(fout,"return");
    if (lfunc[currfunc].gp.type!=Gvoid)
    {
      /*I don't like to see `return ;'*/
      fprintf(fout," ");
      gencast(fout,y,lfunc[currfunc].gp.type);
    }
    break;
  case GPlocal:
  case GPglobal:
    break;
  default:
    if (gp->spec>0) 
      die(n,"genentryspec: func spec not implemented");
    else
      die(n,"Internal error: genentryspec called with no spec");
  }
}
