/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

static int newprivvar=1;

int newdecl(int flag, Gtype t, int initval, int *v)
{
  char s[33];
  snprintf(s,32,"p%d",newprivvar++);
  *v=newnode(Fentry,newentry(s),-1);
  return pushvar(*v,flag,t,initval);
}
int newcall(char *s, int y)
{
  return newnode(Fentryfunc,newentry(s),y);
}
int addseqleft(int n, int seq)
{
  int i;
  int bseq;
  if(seq==-1)
    return n;
  if (tree[n].f!=Fseq)
    return newnode(Fseq,n,seq);
  for(i=seq;tree[tree[i].x].f==Fseq;i=tree[i].x);
  bseq=newnode(Fseq,n,tree[i].x);
  tree[i].x=bseq;
  return seq;
}
int addseqright(int seq, int n)
{ 
  if(seq==-1)
    return n;
  return newnode(Fseq,seq,n);
}
int geninsertvar(int seq, int ret, Ffunc func)
{
  int bseq;
  if (seq==-1)
    return -1;
  if (ret>=0)
  {
    if (tree[seq].f==Fseq)
    {  
      bseq=newnode(Ffacteuraff,ret,newnode(func,tree[seq].y,-1));
      bseq=newnode(Fseq,tree[seq].x,bseq);
    }
    else
      bseq=newnode(Ffacteuraff,ret,newnode(func,seq,-1));
  }
  else
    bseq=seq;
  return bseq;
}
int geninsertvarop(int seq, int ret, OPerator op)
{
  int bseq;
  if (seq==-1)
    return -1;
  if (ret>=0)
  {
    if (tree[seq].f==Fseq)
    {  
      bseq=newopcall(op,ret,tree[seq].y);
      bseq=newnode(Fseq,tree[seq].x,bseq);
    }
    else
      bseq=newopcall(op,ret, seq);
  }
  else
    bseq=seq;
  return bseq;
}

void makeblock(int bl, int n, int aseq, int ret, int savx)
{
  /*create a block*/
  tree[n].f=Fblock;
  tree[n].x=bl;
  block[bl].ret=ret;
  tree[n].y=aseq;
  copyctx(savx,block+bl);
  restorectx(savx);
}
void makeblocks(int bl1, int bl2, int n, int bseq, int aseq, int ret, int savx)
{
  tree[n].f=Fblock;
  tree[n].x=bl1;
  block[tree[n].x].ret=ret;
  tree[n].y=addseqright(bseq,newnode(Fblock,bl2,aseq));
  copyctx(savx,block+bl2);
  restorectx(savx);
}
void genblockdeclaration(int args, int n, int flag)
{
  int stack[STACKSZ];
  int nb;
  int i;
  int var,val;
  int mint;
  nb=listtostack(args,Flistarg,stack,STACKSZ,"function declaration",n);
  if (flag&(1<<Cuser))
    mint=Ggen;
  else
    mint=Gvoid;
  for(i=0;i<nb;i++)
  {
    switch(tree[stack[i]].f)
    {
    case Ftag:
      pushvar(tree[stack[i]].x,flag,tree[stack[i]].y,-1);
      break;
    case Fentry:
      pushvar(stack[i],flag,mint,-1);
      break;
    case Ffacteuraff:
      genequal(stack[i],"declaration",&var,&val);
      switch(tree[var].f)
      {
      case Fentry:
	pushvar(var,flag,mint,val);
	break;
      case Ftag:
	pushvar(tree[var].x,flag,tree[var].y,val);
	break;
      default:
	die(n,"Incorrect node %s in genblockdeclaration[aff]",
	    Ffuncname[tree[var].f]);
      }
      break;
    default:
      die(n,"Incorrect node %s in genblockdeclaration",
	  Ffuncname[tree[stack[i]].f]);
    }
  }
}
#if 0
/*The code for
global(globalvars)
f(args)=local(localvars);code;...
is */
{
  ulong ltop=avma;
  GEN p1;
  GEN *gptr[]={&p1,&globalsvar};
  {
    GEN args;
    GEN localvars;
    code;
    p1=...;
  }
  gerepilemany(ltop,gptr,N);
  return p1;
}
#endif
void genblockdeffunc(int n)
{
  int funcid=tree[n].x;
  int seq=tree[n].y;
  int entry=tree[funcid].x;
  int args=tree[funcid].y;
  int bl1,bl2,gpm,ret,gltop;
  int savcf,savnpv;
  int sav1,sav2,aseq,bseq=-1,nodebl2;
  int vret;
  /*save global var*/
  savcf=currfunc;
  savnpv=newprivvar;
  /*reset private var counter*/
  newprivvar=1;
  /*create function*/
  currfunc=newfunc(value[entry].val.str);
  /*create external block*/
  bl1=newblock();
  sav1=nctx;
  lfunc[currfunc].bctx=sav1;
  if (autogc)
  {
    /*declare ltop*/
    gltop=newnode(Fentry,newentry("ltop"),-1);
    pushvar(gltop,1<<Cuser,Gulong,newcall("_avma",-1));
  }
  /*declare return var*/
  vret=newdecl((1<<Cauto)|(1<<Creturn),Gvoid,-1,&ret);
  
  /*create external block*/
  if (autogc)
  {
    int arg[4];
    block[bl1].gc|=(1<<GCneeded)|(1<<GCglobal);
    block[bl1].egc=vret;
    arg[0]=gltop;
    arg[1]=-1;
    arg[2]=newnode(Fentry,newentry("gptr"),-1);
    arg[3]=newnode(Fsmall,bl1,-1);
    gpm=listtoseq(arg,4);
  }
  bl2=newblock();
  lfunc[currfunc].bl=bl2;
  block[bl2].ret=ret;
  sav2=nctx;
  /*declare var of prototype*/
  genblockdeclaration(args,n,(1<<Cuser)|(1<<Carg));
  /*generate affectation with return var*/
  aseq=geninsertvar(seq,ret,Faffect);
  /*generate block*/
  genblock(aseq,-1);
  {
    /*FIXME: For now, clear Cglobal flag to avoid initialization 
      problem with implicit fetch_user_var().*/
    int i;
    for (i=sav1;i<nctx;i++)
    {
      if (ctxstack[i].flag&(1<<Cglobal))
	ctxstack[i].flag&=~(1<<Cglobal);
    }
  }
  copyctx(sav2,block+bl2);
  restorectx(sav2);
  if (autogc)
  {
    int gptr=newnode(Fentry,newentry("gptr"),-1);
    int blo=newnode(Fsmall,bl1,-1);
    pushvar(gptr,1<<Cuser,Ggptr,newcall("_gerepilelist",blo));
    bseq=addseqright(bseq,newcall("_gerepilemany",gpm));
  }
  bseq=addseqright(bseq,newcall("return",newleaf(ret)));
  copyctx(sav1,block+bl1);
  restorectx(sav1);
  nodebl2=newnode(Fblock,bl2,aseq);
  tree[n].y=newnode(Fblock,bl1,newnode(Fseq,nodebl2,bseq));
  /*restore globalvar*/
  currfunc=savcf;
  savnpv=newprivvar;
}
int newvectoridx(int var, int ind)
{
  return newnode(Ffacteurmat,var,newnode(Fmatrix,newnode(Fsmall,ind,-1),-1));
}
int newmatidx(int var, int x, int y)
{
  return newnode(Ffacteurmat,var,newnode(Fmatrix,newnode(Fsmall,x,-1),
					 newnode(Fsmall,y,-1)));
}
void genblockvector(int n, int p)
{
  int arg[STACKSZ];
  int x=tree[n].x;
  int i,nb,ret;
  int aseq;
  nb=1+listtostack(x,Fmatrixelts,arg+1,STACKSZ-1,"Vector too long.",n);
  newdecl(0,Ggen,-1,&ret);
  arg[0]=ret;
  for(i=1;i<nb;i++)
    arg[i]=geninsertvar(arg[i],newvectoridx(newleaf(ret),i),Faffect);
  for(i=1;i<nb;i++)
    genblock(arg[i],-1);
  aseq=newcall("_makevec",listtoseq(arg,nb));
  makeblock(newblock(),n,aseq,ret,nctx);
}
void genblockmatrix(int n, int p)
{
  int line[STACKSZ];
  int arg[STACKSZ];
  int x=tree[n].x;
  int i,j,k,nb=3,nbline,nbcol,ret;
  int aseq;
  nbline=listtostack(x,Fmatrixlines,line,STACKSZ,"Matrix too long.",n);
  for(i=0;i<nbline;i++)
  {
    int k;
    k=listtostack(line[i],Fmatrixelts,arg+nb,STACKSZ-nb,"Matrix too long.",n);
    if (i && k!=nbcol)
      die(n,"Matrix must be rectangular");
    nbcol=k;
    nb+=k;
  }
  newdecl(0,Ggen,-1,&ret);
  arg[0]=ret;
  arg[1]=newnode(Fsmall,nbline,-1);
  arg[2]=newnode(Fsmall,nbcol,-1);
  for(j=1,k=1,i=3;i<nb;i++)
  {
    arg[i]=geninsertvar(arg[i],newmatidx(newleaf(ret),k,j),Faffect);
    if (j==nbcol)
    {
      j=1;
      k++;
    }
    else
      j++;
  }
  for(i=3;i<nb;i++)
    genblock(arg[i],-1);
  aseq=newcall("_makemat",listtoseq(arg,nb));
  makeblock(newblock(),n,aseq,ret,nctx);
}
/*
  n: node
  p:parent node
*/
void genblock(int n, int p)
{
  gpfunc *gp;
  if (n<0)
    return;
  if (tree[n].f<FneedENTRY && tree[n].f!=Fmat)
  {
    genblock(tree[n].x, n);
    genblock(tree[n].y, n);
  }
  switch(tree[n].f)
  {
  case Ffacteuraff:
#if I_WANT_BUG
    /*If someone want the return value, unnest to avoid side-effect
      problems.*/
    if (p>=0 && tree[p].f!=Fseq)
    {
      int ret,aseq;
      newdecl((1<<Cauto),Gvoid,-1,&ret);
      aseq=geninsertvar(newleaf(n),ret,Faffect);
      makeblock(n,-1,aseq,ret,nctx);
    }
#endif
    break;
  case Fmat:
    if (tree[tree[n].x].f==Fmatrixlines)
      /*if there is at least 2 lines it is a matrix*/
      genblockmatrix(n,p);
    else
      /*else it is a vector*/
      genblockvector(n,p);
    break;
  case Frefarg:
  case Fentry:/*may be an hidden function call*/
  case Fentryfunc:
    if (tree[n].x==OPn)
    {
      int y=tree[n].y;
      if (tree[y].f==Fsmall)
      {
	tree[n]=tree[y];
	tree[n].x=-tree[n].x;
      }
    }
    else
    {
      findfunction(tree[n].x,&gp);
      if (gp && gp->spec>0)
	genblockfuncspec(n,p,gp);
      else if (!gp && tree[n].f!=Fentryfunc && getvar(n)==-1)
      {
	pushvar(n,(1<<Cuser)|(1<<Cglobal),Gnotype,-1);
	/*May still catch some very hidden function call
	  They are discarded in gencode.
	 */
      }
      else
	genblock(tree[n].y,n);
    }
    break;
  case Fdeffunc:
    genblockdeffunc(n);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case FtrucQ:
  case Fgnil:
    break;
  case Ftag:
    genblock(tree[n].x,n);
    break;
  case Fblock:
    die(p,"Internal error : looping in genblock");
  default:
    if (tree[n].f>=FneedENTRY)
    {
      die(p,"Internal error : unknow func %s in genblock",Ffuncname[tree[n].f]);
    }
  }
}
