/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define TYPE
#include "header.h"
Gtype gentypefuncdesc(int n, gpfunc *gp);
void
inittrans(int n,int p)
{
  int i;
  for(i=0;i<Gnbtype;i++)
  {
    if (typemax[i][n]==n)
      typemax[p][i]=typemax[i][p]=p;
    if (typemax[p][i]==i)
      typemax[i][n]=typemax[n][i]=i;
  }
}
int
initmax(int n, int p)
{
  int i,m=Gnotype;
  for(i=0;i<Gnbtype;i++)
    if (typemax[n][i]==i && typemax[p][i]==i)
      if(m==Gnotype || typemax[i][m]==m)
	m=i;
  return m;
}
void outputtype(FILE *fout)
{
  int i,j;
  fprintf(fout,"        |");
  for(i=0;i<Gnbtype;i++)
    fprintf(fout,"%-8s",Gname[i]);
  fprintf(fout,"\n--------+");
  for(i=0;i<Gnbtype;i++)
    fprintf(fout,"--------");
  fprintf(fout,"\n");
  for(i=0;i<Gnbtype;i++)
  {
    /*No, this is not strange smileys*/
    fprintf(fout,"%-8s|",Gname[i]);
    for(j=0;j<Gnbtype;j++)
    {
      fprintf(fout,"%-8s",Gname[typemax[i][j]]);
    }
  fprintf(fout,"\n");
  }
}
void inittype(void)
{
  int n;
  int i,j;
  for(i=0;i<Gnbtype;i++)
    for(j=0;j<Gnbtype;j++)
      typemax[i][j]=(i==j)?i:Gnotype;
  for(n=0;typedesc[n]!=Gnotype;n++)
  {
    int i=n;
    for(n++;typedesc[n]!=Gnotype;i=n++)
    {
      int ti=typedesc[i];
      int tn=typedesc[n];
      inittrans(ti,tn);
    }
  }
  for(i=0;i<Gnbtype;i++)
    for(j=0;j<Gnbtype;j++)
      if (typemax[i][j]==Gnotype)
	typemax[i][j]=typemax[j][i]=initmax(i,j);
}
int gentypedeclaration(context *fc, int ind)
{
  int i;
  int val,t;
  int mode=0;
  for(i=0;i<fc->n;i++)
  {
    val=fc->c[i].initval;
    if (val!=-1)
    {
      t=gentype(val);
      if (fc->c[i].flag&(1<<Cauto) && ctxstack[ind+i].t<t)
      {
	ctxstack[ind+i].t=t;
	lastpass++;
      }
      mode|=tree[val].m;
    }
  }
  return mode;

}
void gentypedeffunc(int n)
{
  int funcid=tree[n].x;
  int seq=tree[n].y;
  int entry=tree[funcid].x;
  int savcf;
  ctxvar *ret;
  int tf;
  gpfunc *gp;
  context *fc;

  /*save current function*/
  savcf=currfunc;
  /*get function number and context*/
  currfunc=findnewentry(value[entry].val.str);
  gp=&lfunc[currfunc].gp;
  tf=gp->type;
  /*gentype for seq*/
  gentype(seq);
  fc=block+lfunc[currfunc].bl;
  /*get return var*/
  ret=getvarinblock(fc->ret,block+tree[seq].x);
  /*update prototype*/
  if (typemax[tf][ret->t]!=tf)
  {
    if(debug==2)
      fprintf(stderr,"%s returned %s now %s\n",gp->gpname,Gname[tf],Gname[ret->t]);
      tf=gp->type=typemax[tf][ret->t];
    lastpass++;
  }
  if ((gp->mode^tree[seq].m)&((1<<Mprec)|(1<<Msidef)))
  {
    lastpass++;
    if(debug==2)
      fprintf(stderr,"%s mode %d now %d\n",gp->gpname,gp->mode,tree[seq].m);//gp->mode|(tree[seq].m&((1<<Mprec)|(1<<Msidef))));
    gp->mode|=tree[seq].m&((1<<Mprec)|(1<<Msidef));
  }
  currfunc=savcf;
  /*create type*/
  tree[n].t=Gvoid;
  tree[n].m=(1<<Msidef);  
}
void gentypeblock(int n)
{
  int seq=tree[n].y;
  int savc;
  int mode;
  context *fc=block+tree[n].x;
  /*save new context address and gentype for seq*/
  savc=nctx;
  /*push context*/
  pushctx(fc);
  /*gentype for local var*/
  mode=gentypedeclaration(fc,savc);
  /*gentype for seq*/
  gentype(seq);
   /*save context*/
  copyctx(savc,fc);
  /*restore current context*/
  restorectx(savc);
  /*create type*/
  if (fc->ret==-1)
    tree[n].t=Gvoid;
  else
  {
    int v=getvarerr(fc->ret);
    tree[n].t=ctxstack[v].t;
  }
  tree[n].m=mode|(tree[seq].m&MODHERIT);
}
Gtype gentype(int n)
{
  int t,tx,ty;
  int mx,my;
  int x=tree[n].x;
  int y=tree[n].y;
  gpfunc *gp;
  if (n<0)
    return Gnotype;
  if (tree[n].f<FneedENTRY)
  {
    tx=gentype(x);
    mx=(x>=0)?tree[x].m:0;
    ty=gentype(y);
    my=(y>=0)?tree[y].m:0;
  }
  switch(tree[n].f)
  {
  case Fseq:
    if (mx&(1<<Mterm))
    {
      tree[n].t=Gvoid;/*the seq end here*/
      tree[n].m=mx&MODHERIT;
    }
    else
    {
      tree[n].t=ty;/*for `if(1,a;b)' and others construct */
      tree[n].m=(my|mx)&MODHERIT;
    }
    break;
  case Fmatrixelts:
    tree[n].t=Gnotype;
    tree[n].m=(mx|my)&MODHERIT;
    break;
  case Fmatrixlines:
    tree[n].t=Gnotype;
    tree[n].m=(mx|my)&MODHERIT;
    break;
  case Fmatrix:
  case FmatrixL:
  case FmatrixR:
    tree[n].t=Gnotype;
    tree[n].m=0;
    break;
  case Faffect:
    /*This data are carried along for Ffacteuraff*/
    tree[n].t=tx;
    tree[n].m=mx&MODHERIT;
    break;
  case Ffacteurmat:
    tree[n].t=Ggen;
    tree[n].m=(mx&MODHERIT)|(1<<Mparens);
    break;
  case Ffacteuraff:
    tree[n].t=tx;/*Probably it should be ty*/
    tree[n].m=(mx|my)&MODHERIT;
    if (ty!=Gnotype && typemax[tx][ty]!=tx && tree[x].f==Fentry)
    {
      int v=getvar(x);
      if (v!=-1)
      {
	if (!(ctxstack[v].flag&(1<<Cauto)))
	  warning(n,"Type clash :%s!>=%s",Gname[tx],Gname[ty]);
	else
	{
	  ctxstack[v].t=typemax[tx][ty];
	  lastpass++;	
	  if (debug) fprintf(stderr,"casting %s from %s to %s\n",ctxstack[v].var,Gname[tx],Gname[ty]);
	  if(debug>=2)
	  {
	    printnode(stderr,n);
	    fprintf(stderr,"\n");
	  }
	  tree[n].t=ty;
	  tx=ty;
	  tree[x].t=tx;
	}
      }
    }
    if (tx!=Gvoid)
      tree[n].m|=(1<<Msidef);
    break;
  case Fconst:
    if (value[x].type==Vsmall)
      tree[n].t=Gsmall;
    else
      tree[n].t=isanint(value[x].val.str)?Gint:Greal;
    tree[n].m=0;
    break;
  case Fstring:
    tree[n].t=Gstr;
    tree[n].m=0;
    break;
  case Fsmall:
    tree[n].t=Gsmall;
    tree[n].m=0;
    break;
  case FtrucQ:
    tree[n].t=Ggen;
    tree[n].m=0;
    break;
  case Femptyvec:
  case Femptymat:
    tree[n].t=Ggen;
    tree[n].m=0;
    break;
  case Fmat:
    tree[n].t=Ggen;
    tree[n].m=mx&MODHERIT;
    break;
  case Flistarg:
    tree[n].t=Gnotype;
    tree[n].m=(mx|my)&MODHERIT;
    break;
  case Ftag:
    tree[n].t=y;
    gentype(x);
    tree[n].m=tree[x].m&MODHERIT;
    break;
  case Frefarg:
  case Fentry:/*may be an hidden function call*/
  case Fentryfunc:
    findfunction(x,&gp);
    if (gp && gp->type==Gnotype && gp->spec>0)
      tree[n].t=gentypefuncspec(n,gp);
    else if (gp && gp->dsc && (t=gentypefuncdesc(n,gp))!=Gnotype)
      tree[n].t=t;
    else
    {
      ty=(y==-1)?Gnotype:gentype(y);
      my=(y==-1)?0:tree[y].m;
      if (gp)
      {
	tree[n].t=gp->type;
	tree[n].m=(gp->mode&(~(1<<Msemicomma)))|(my&MODHERIT);
      }
      else
      {
	if (tree[n].f==Fentry || tree[n].f==Frefarg)
	{
	  /*it was not a hidden function call*/
	  int c=getvar(n);
	  if (c>=0)
	  {	  
	    if (ctxstack[c].t!=Gnotype)
	    {
	      tree[n].t=ctxstack[c].t;
	      tree[n].m=(1<<Mvar);
	    }
	    else
	    {
	      tree[n].t=Ggen;
	      tree[n].m=0;
	    }
	  }
	  else
	    die(n,"extra variable `%s' in gentype",value[x].val.str);
	}
	else
	{
	  tree[n].t=Gnotype;
	  tree[n].m=my&MODHERIT;
	}
      }
    }
    break;
  case Fdeffunc:
    gentypedeffunc(n);
    break;
  case Fblock:
    gentypeblock(n);
    break;
  case Fgnil:
    tree[n].m=0;
    tree[n].t=Gvoid;
    break;
  default:
    die(n,"Incorrect node %s in gentype",Ffuncname[tree[n].f]);
  }
  return tree[n].t;
}
