/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

void gerepilelist(affnode *an, int nmod, context *bl, int savb)
{
  int *res;
  int nb=0;
  int i;
  if (!nmod)
  {
    bl->gcvar=NULL;
    bl->ngc=0;
    return;
  }
  res=calloc(nmod,sizeof(*res));
  for(i=0;i<nmod;i++)
  {
    int idx=an[i].idx;
    /*If i is affected or referenced*/
    if (an[i].f!=AFaccess)
    {
      int j;
      /*search the first occurence of i*/
      for(j=0;j<i;j++)
	if (an[j].idx==idx)
	  break;
      /*FIXME:if the variable is local and the first occurence
	is an affectation, do nothing */
      if (an[j].idx>=savb &&  an[j].f==AFaffect)
	continue;

      /*else check if it is not already in the list*/
      for(j=0;j<nb;j++)
	if (res[j]==idx)
	  break;
      /*if it is already, do nothing*/
      if (j<nb) continue;
      /*add to list*/
      res[nb++]=idx;
    }
  }
  if (debug)
  {
    int i;
    fprintf(stderr,"/*");
    for(i=0;i<nmod;i++)
      fprintf(stderr,"%s%s ",ctxstack[an[i].idx].var,an[i].f==AFaffect?"=":"");
    fprintf(stderr,"*/\n");
  }
  if (!nb)
  {
    bl->gcvar=NULL;
    bl->ngc=0;
    return;
  }
  bl->ngc=nb;
  bl->gcvar=realloc(res,nb*sizeof(*res));
  
  if (nb==1 && an[nmod-1].idx==res[0])
    bl->gc|=(1<<GCupto);
}
int listaff(int sava, int savc, int ret, affnode **ran)
{
  affnode *an;
  int nb;
  size_t size;
  int i,j;
  for (i=sava,nb=0;i<naff;i++)
  {
    if (affstack[i].idx<savc || affstack[i].idx==ret)
      nb++;
  }
  size=nb*sizeof(affnode);
  if (size)
  {
    an=malloc(size);
    for (i=sava,j=0;i<naff;i++)
      if (affstack[i].idx<savc || affstack[i].idx==ret)
      {
	an[j]=affstack[i];
	j++;
      }
    if (j!=nb) die(-1,"Internal error: listaff");
  }
  else an=NULL;
  *ran=an;
  return nb;
}
void pilelistblock(context *bl, int sava, int savb)
{
  affnode *an;
  int nb;
  nb=listaff(sava,savb,-1,&an);
  gerepilelist(an,nb,bl,savb);
  if (an)
    free(an);
}
void pilelistfunc(userfunc *uf, int sava, int savb)
{
  affnode *an;
  context bl;
  int nb;
  nb=listaff(sava,savb,-1,&an);
  gerepilelist(an,nb,&bl,savb);
  uf->ngc=bl.ngc;
  uf->gcvar=bl.gcvar;
  if (an)
    free(an);
}
void pilelistvar(int idx)
{
  ctxvar *v=ctxstack+idx;
  /* if ((v->flag&(1<<Cconst)) && v->val!=-1 && tree[v->val].f==Fsmall)
     return;*/
  if (v->flag&(1<<Carg))
    return;
  if (v->t==Gnotype)
  {
    if (findnewentry(v->var)==-1)
      newaff(AFaffect,idx); 
    /*else it was a very hidden function call*/
  }
  else if (ctype[v->t]!=Vgen)
    return;
  else
  {
     if (v->initval>=0)
    {
      pilelist(v->initval);
      newaff(AFaffect,idx); 
    }
  }
}
void pilelist(int n)
{
  int i,x,y;
  int v,savc,sava,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Ffacteuraff:
    if (tree[x].f!=Fentry)
      pilelist(x);
    pilelist(y);
    while(tree[x].f!=Fentry)
      /*FIXME: do some sanity checking*/
      x=tree[x].x;
    if (tree[x].f==Fentry && ctype[tree[x].t]==Vgen)
    {
      v=getvar(x);
      if (tree[tree[y].x].f==Ffacteurmat)
      {
	int z=newnode(Fentryfunc,-1,-1);
	tree[z]=tree[tree[y].x];
	tree[z].f=Fentryfunc;
	tree[z].x=newentry("_copy");
	tree[z].y=tree[y].x;
	tree[y].x=z;
	newaff(AFaffect,v);
      }
      else
	newaff(AFaffect,v);
    }
    break;
  case Ftag:
    pilelist(x);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
  case FtrucQ:
    break;
  case Frefarg:
    v=getvarerr(n);
    if (ctype[tree[n].t]==Vgen)
      newaff(AFrefarg,v);
    break;
  case Fentry:
    v=getvar(n);
    if (v>=0 && ctype[tree[n].t]==Vgen)
      newaff(AFaccess,v);
    /*else it is an hidden function call*/
    break;
  case Fentryfunc:
    pilelist(y);
    /*FIXME: add true parsing of description*/
    if (x>=OPss && x<=OPme)
    {
      	int arg[STACKSZ];
	int nb=genlistargs(n,arg,0,STACKSZ);
	if (nb && ctype[tree[arg[0]].t]==Vgen)
	  newaff(AFrefarg,getvaroflvalue(arg[0]));
    }
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      int entry=tree[funcid].x;
      int savcf=currfunc;
      /*get func number and context*/
      currfunc=findnewentry(value[entry].val.str);
      savc=nctx;
      sava=naff;
      pilelist(y);
      pilelistfunc(lfunc+currfunc,sava,savc);
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=nctx;
    sava=naff;
    bl=block+tree[n].x;
    pushctx(bl);
    savb=nctx;
    for(i=0;i<bl->n;i++)
      pilelistvar(savc+i);
    pilelist(y);
    if (bl->gc&(1<<GCneeded))
      pilelistblock(bl,sava,savb);
    copyctx(savc,bl);
    nctx=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in pilelist",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    pilelist(x);
    pilelist(y);
  }
}
void pileclean(int n)
{
  int x,y;
  int savc,sava,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Ffacteuraff:
    pileclean(x);
    pileclean(y);
    break;
  case Ftag:
    pileclean(x);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
  case FtrucQ:
  case Frefarg: 
  case Fentry:
    break;
  case Fentryfunc:
    pileclean(y);
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      int entry=tree[funcid].x;
      int savcf=currfunc;
      /*get func number and context*/
      currfunc=findnewentry(value[entry].val.str);
      //     fprintf(stderr,"#%d\n",lfunc[currfunc].ngc);
      pileclean(y);
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=nctx;
    sava=naff;
    bl=block+tree[n].x;
    pushctx(bl);
    savb=nctx;
    pileclean(y);
    if (bl->gc&(1<<GCglobal))
    {
      int nb=bl->ngc+lfunc[currfunc].ngc;
      int i,j,k;
      /*Malloc'ing 0 bytes is often a bug so we cheat*/
      int *var=malloc((nb+1)*sizeof(*bl->gcvar));
      for(i=0,j=0,k=0;i<bl->ngc || j<lfunc[currfunc].ngc;)
      {
	if (j==lfunc[currfunc].ngc 
	    || (i<bl->ngc && bl->gcvar[i]<lfunc[currfunc].gcvar[j]))
	  var[k++]=bl->gcvar[i++];
	else
	{
	  if (i<bl->ngc  && bl->gcvar[i]==lfunc[currfunc].gcvar[j])
	    i++;
	  var[k++]=lfunc[currfunc].gcvar[j++];
	}
      }
      if (bl->gcvar)
	free(bl->gcvar);
      if (k)
      {
	bl->gcvar=var;
	bl->ngc=k;
      } 
      else
      {
	bl->ngc=0;
	bl->gcvar=NULL;
	free(var);
      }
      if (bl->ngc!=1)
	bl->gc&=~(1<<GCupto);
    }
    if ((bl->gc&(1<<GCneeded)) && (!bl->ngc || (bl->gc&(1<<GCupto))))
    {
      if (bl->gc&(1<<GCglobal))
      {
	int v=getvarbyname("gptr");
	if (v>=savc && v<savb)
	  ctxstack[v].t=Gvoid;
      }
      else
      {
	int w=getvarbyname("st_lim"),v=getvarbyname("bptr");
	if (v>=savc && v<savb)
	{
	  ctxstack[v].t=Gvoid;
	  if (w<savc && w>=savb)
	    warning(-1,"Internal error: we loose `st_lim'!");
	  ctxstack[w].t=Gvoid;
	}
      }
    }
    copyctx(savc,bl);
    nctx=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in pileclean",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    pileclean(x);
    pileclean(y);
  }
}
