/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

void destroynode(int n)
{
  tree[n].f=Fgnil;
  tree[n].x=-1;
  tree[n].y=-1;
  tree[n].t=Gvoid;
}
int newgnil(void)
{
    int ret=newnode(Fgnil,-1,-1);
    tree[ret].t=Gvoid;
    return ret;
}
int newseq(int x, int y)
{
  int seq;
  if (tree[x].f==Fgnil || tree[y].f==Fgnil)
  {
    if (tree[x].f==Fgnil && tree[y].f==Fgnil)
      return newgnil();
    else if (tree[x].f==Fgnil)
      return y;
    else
      return x;
  }
  seq=newnode(Fseq,x,y);
  return seq;
}
/*
  n: node
  p: parent (-1 for first node)
  r: root of seq or -2-root if leftmost child.
 */
void movecode(int n, int p, int r, int ret)
{
  int rs=(r>=0)?r:-2-r;
  if (ret==-1)
    ret=newgnil();
  if (p!=rs)/*we are not at the root of seq*/
  {
    if ( tree[rs].f==Fseq )
    {
      /*the interesting case*/
      int seq=(r>=0)?newseq(tree[r].x,n):newseq(n,tree[rs].x);
      tree[rs].x=seq;
      if (tree[p].x==n)
	tree[p].x=ret;
      else
	tree[p].y=ret;
    }
    else /*we are at the start of a func, block or args entry*/
    {
      int seq=newseq(n,tree[rs].y);
      tree[rs].y=seq;
      if (tree[p].f==Fdeffunc || tree[p].f==Fblock)
	tree[p].y=ret;
      else if (tree[p].x==n)
	tree[p].x=ret;
      else
	tree[p].y=ret;
    }
  }
}
void moveblock(int n, int p, int r)
{
  int x;
  int y;
  gpfunc *gp;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Fseq:
    moveblock(x,n,-2-n);
    moveblock(y,n,n);
    break;
  case Ftag:
    moveblock(x,n,r);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
  case FtrucQ:
  case Frefarg:
  case Fentry:
    break;
  case Fentryfunc:
    /*If it is a func with "seq" arg we must change the root...
      Yes it's a real pain.
      Note: normally 'E' code does not contain Fseq after parsing,
      but may after this stage, e.g. if it call "vector".
    */
    findfunction(x,&gp);
    if (gp && gp->spec>0)
      tree[n].m|=gp->mode&(1<<Msemicomma);
    if (gp && gp->spec>0 && gp->code && y!=-1)
    {
      int stack[STACKSZ];
      int i;
      int nb=listtostackparent(y,Flistarg,stack,STACKSZ,gp->gpname,n);
      if (gp->code[0]==0)
	die(-1,"incorrect pseudoprototype for %s: %s\n",gp->gpname,gp->code);
      if (gp->code[0]=='I' || gp->code[0]=='E')
	moveblock(tree[stack[0]].x,stack[0],stack[0]);
      else
	moveblock(tree[stack[0]].x,stack[0],r);
      for(i=0;i<nb;i++)
      {
	if (gp->code[i+1]==0)
	  die(-1,"incorrect pseudoprototype for %s: %s\n",gp->gpname,gp->code);
	if (gp->code[i+1]=='I' || gp->code[i+1]=='E')
	  moveblock(tree[stack[i]].y,stack[i],stack[i]);
	else
	  moveblock(tree[stack[i]].y,stack[i],r);
      }
    }
    else
      moveblock(y,n,r);
    if (tree[n].t==Gvoid)
    {
      /*C doesn't allow making anything from void, so we need to
	move the call here. GP cast void to zero if necessary*/
      movecode(n,p,r,-1);
    }
    break;
  case Fdeffunc:
    moveblock(y,n,n);
    break;
  case Fblock:
    movecode(n,p,r,block[x].ret);
    moveblock(y,n,n);
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in moveblock",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    moveblock(x,n,r);
    moveblock(y,n,r);
  }
}
int blockisempty(int n)
{
  int i;
  context *fc=block+tree[n].x;
  for(i=0;i<fc->n;i++)
  {
    ctxvar *v=fc->c+i;
    if (!(v->flag&(1<<Cconst)) || v->val==-1)
      return 0;
  }
  return 1;
}
/*
  n: node
  p: parent (-1 for first node)
  d: 0 right child, 1 left child
*/
void cleanvar(int n)
{
  int x;
  int y;
  int v,savc;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Ffacteuraff:
    cleanvar(x);
    cleanvar(y);
    x=tree[n].x;
    y=tree[n].y;    
    if (tree[x].f==Fentry && tree[y].f==Faffect)
    {
      int z=tree[y].x;
      v=getvarerr(x);
      if (ctxstack[v].flag&(1<<Cconst))
      {
	int simple=0;
	if (ctxstack[v].val!=-1)
	  die(n,"Internal error: constant variable affected two times");
        if (tree[z].f==Fsmall)
	  simple=1;
	else  if (tree[z].f==Fentry)
	{
	  int w=getvar(z);
	  if(w>=0)
	    simple=!(ctxstack[w].flag&(1<<Cuser));
	}
	if (simple)
	{
	  ctxstack[v].val=z;
	  destroynode(n);
	}
      }
    }
    break;
  case Ftag:
    cleanvar(x);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
  case FtrucQ:
    break;
  case Frefarg:
  case Fentry:
    v=getvar(n);
    if (v>=0 && (ctxstack[v].flag&(1<<Cconst)) && ctxstack[v].val!=-1)
      tree[n]=tree[ctxstack[v].val];
    /*else it is an hidden function call*/
    break;
  case Fentryfunc:
    cleanvar(y);
    break;
  case Fdeffunc:
    /*Let be sure that the second block do not get curly backet*/
    tree[tree[tree[y].y].x].m|=(1<<Mbrace);
    cleanvar(y);
    /*but that the first block get them*/
    tree[y].m&=~(1<<Mbrace);
    break;
  case Fblock:
    savc=nctx;
    pushctx(block+tree[n].x);
    cleanvar(y);
    copyctx(savc,block+tree[n].x);
    if (blockisempty(n))
      tree[n].m|=(1<<Mbrace);
    nctx=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in cleanvar",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    cleanvar(x);
    cleanvar(y);
  }
}

/*
  n: node
  p: parent (-1 for first node)
  d: 0 right child, 1 left child
 */
void cleancode(int n, int p, int d)
{
  int x;
  int y;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Fseq:
    cleancode(x,n,0);
    cleancode(y,n,1);
    x=tree[n].x;
    y=tree[n].y;
    if (tree[x].f==Fgnil || tree[y].f==Fgnil)
    {
      if (tree[x].f==Fgnil && tree[y].f==Fgnil)
	destroynode(n);
      else
      {
	if (d==0)
	{
	  if (tree[x].f==Fgnil)
	    tree[p].x=y;
	  else
	    tree[p].x=x;
	}
	else
	{
	  if (tree[x].f==Fgnil)
	    tree[p].y=y;
	  else
	    tree[p].y=x;
	}
      }
    }
    else
      tree[n].m|=(1<<Msemicomma);
    break;
  case Ffacteuraff:
    cleancode(x,n,0);
    cleancode(y,n,1);
    x=tree[n].x;
    y=tree[n].y;
    if (tree[x].t==Gvoid)
    {
      tree[n]=tree[tree[y].x];
      if (tree[n].f==Fentry || tree[n].f==Fgnil)
	destroynode(n);
    }
    break;
  case Ftag:
    cleancode(x,n,0);
    break;
  case FtrucQ:
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
    break;
  case Frefarg:
  case Fentry:
  case Fentryfunc:
    cleancode(y,n,1);
    break;
  case Fdeffunc:
  case Fblock:
    tree[n].m|=(1<<Msemicomma); 
    cleancode(y,n,1);
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in cleancode",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    cleancode(x,n,0);
    cleancode(y,n,1);
  }
}
