%{
	  /*
	   *    * L'option -y permet de debuger le parser.
	   *       */
#define YYDEBUG 1
#define YYERROR_VERBOSE 1
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
int linecount,errs;
int yyerror(char *s);
int yylex(void);

%}
%expect 1
/*This should the only shift/reduce conflict :
    identifier  ->  funcid .
    definition  ->  funcid . '=' seq KEOC
*/
%union {
  int val;
  char str[1025];
}
%token <str> KCONST
%token <str> KENTRY
%token <str> KSTRING
%token KSTART
%left KEOC
%left ';' ','

%right '=' KPE KSE KME KDE KDRE KEUCE KMODE KSRE KSLE
%left '&' KAND '|' KOR 
%left KEQ KNE KGE '<' KLE '>' 
%left '+' '-'
%left KSR KSL 
%left '%' KDR '\\' '/' '*'
%left SIGN
%right '^'
%left '!' '~' '[' '\''
%left '.' ':'

%token KPP KSS 

%type <val> commands seq matrix matrix_index affect expr facteur truc
%type <val> identifier machin
%type <val> matrixelts matrixlines arg listarg constante funcid definition 

%start commands
%%
commands: KSTART {$$=-1;}
        | commands seq KEOC {$$=($1==-1)?$2:newnode(Fseq,$1,$2);}
	| commands KEOC     {$$=$1;}
;

seq: expr          {$$=$1;}
   | seq ';' expr {$$=newnode(Fseq,$1,$3);}
   | seq error     {$$=$1;errs++;}/*discard erroneous expr*/
   | seq ';'      {$$=$1;}
;


matrix_index: '[' expr ',' expr ']' {$$=newnode(Fmatrix,$2,$4);}
            | '[' expr ']' {$$=newnode(Fmatrix,$2,-1);}
            | '[' expr ',' ']' {$$=newnode(FmatrixL,$2,-1);}
            | '[' ',' expr ']' {$$=newnode(FmatrixR,$3,-1);}
;

affect: '=' expr {$$=newnode(Faffect,$2,-1);}
/*      | KPP      {$$=newnode(FaffectPP,-1,-1);}
      | KSS      {$$=newnode(FaffectSS,-1,-1);}
      | KME expr {$$=newnode(FaffectM,$2,-1);}
      | KDE expr {$$=newnode(FaffectD,$2,-1);}
      | KDRE expr {$$=newnode(FaffectDR,$2,-1);}
      | KEUCE expr {$$=newnode(FaffectEUC,$2,-1);}
      | KMODE expr {$$=newnode(FaffectMOD,$2,-1);}
      | KSLE expr {$$=newnode(FaffectSL,$2,-1);}
      | KSRE expr {$$=newnode(FaffectSR,$2,-1);}
      | KPE expr {$$=newnode(FaffectP,$2,-1);}
      | KSE expr {$$=newnode(FaffectS,$2,-1);}*/
;

expr: facteur {$$=$1;}
    | expr KOR  expr  {$$=newopcall(OPor,$1,$3);}
    | expr '|'  expr  {$$=newopcall(OPor,$1,$3);}
    | expr KAND expr  {$$=newopcall(OPand,$1,$3);}
    | expr '&'  expr  {$$=newopcall(OPand,$1,$3);}
    | expr KEQ  expr  {$$=newopcall(OPeq,$1,$3);}
    | expr KNE  expr  {$$=newopcall(OPne,$1,$3);}
    | expr KGE  expr  {$$=newopcall(OPge,$1,$3);}
    | expr '>'  expr  {$$=newopcall(OPg,$1,$3);}
    | expr KLE  expr  {$$=newopcall(OPle,$1,$3);}
    | expr '<'  expr  {$$=newopcall(OPl,$1,$3);}
    | expr '-'  expr  {$$=newopcall(OPs,$1,$3);}
    | expr '+'  expr  {$$=newopcall(OPp,$1,$3);}
    | expr KSL  expr  {$$=newopcall(OPsl,$1,$3);}
    | expr KSR  expr  {$$=newopcall(OPsr,$1,$3);}
    | expr '%'  expr  {$$=newopcall(OPmod,$1,$3);}
    | expr KDR  expr  {$$=newopcall(OPdr,$1,$3);}
    | expr '\\' expr  {$$=newopcall(OPeuc,$1,$3);}
    | expr '/'  expr  {$$=newopcall(OPd,$1,$3);}
    | expr '*'  expr  {$$=newopcall(OPm,$1,$3);}
    | facteur affect  {$$=newnode(Ffacteuraff,$1,$2);}/*see facteur*/

    | facteur KPP {$$=newopcall(OPpp,$1,-1);}
    | facteur KSS {$$=newopcall(OPss,$1,-1);}
    | facteur KME expr {$$=newopcall(OPme,$1,$3);}
    | facteur KDE expr {$$=newopcall(OPde,$1,$3);}
    | facteur KDRE expr {$$=newopcall(OPdre,$1,$3);}
    | facteur KEUCE expr {$$=newopcall(OPeuc,$1,$3);}
    | facteur KMODE expr {$$=newopcall(OPmod,$1,$3);}
    | facteur KSLE expr {$$=newopcall(OPsle,$1,$3);}
    | facteur KSRE expr {$$=newopcall(OPsre,$1,$3);}
    | facteur KPE expr {$$=newopcall(OPpe,$1,$3);}
    | facteur KSE expr {$$=newopcall(OPse,$1,$3);}
;
facteur: machin {$$=$1;}
       | '+' machin %prec SIGN{$$=newopcall(OPpl,$2,-1);}
       | '-' machin %prec SIGN{$$=newopcall(OPn,$2,-1);}
;
/*Note for the non french-speakers: truc and machin are the french
words for "things" "stuff", "foo", "bar" and the like. Commonly used 
words include "bidule" and "chose". Have fun !*/

machin: truc
       | machin '~' {$$=newopcall(OPtrans,$1,-1);}
       | machin '\'' {$$=newopcall(OPderiv,$1,-1);}
       | machin '!'  {$$=newopcall(OPfact,$1,-1);}
/*This is not necessary using right assoc save 27 shift reduce conflicts*/
       | machin '^' machin {$$=newopcall(OPpow,$1,$3);}
       /*     This save 17 shift reduce conflicts
       | machin affect {$$=newnode(Ffacteuraff,$1,$2);} */
       | machin matrix_index {$$=newnode(Ffacteurmat,$1,$2);}
       | machin '.' KENTRY   {$$=newnode(Fentryfunc,newmember($3),$1);}
       | machin ':' KENTRY   {$$=newnode(Ftag,$1,nodetype($3));}
;

truc: identifier {$$=$1;}
    | constante  {$$=$1;}
    | '!' truc {$$=newopcall(OPnb,$2,-1);}
    | '\'' KENTRY {$$=newnode(FtrucQ,newvalue(FtrucQ,$2),-1);}
    | matrix {$$=$1;}
    | '(' expr ')' {$$=$2;}
    | '(' error ')' {$$=-1;errs++;}/*try be be smart wth errors in parens*/
    | definition    {$$=$1;} /* Yes it's insane, but it's how POSIX gp is defined*/

/*  '%' thinggies skipped here*/
;

matrixelts: expr {$$=$1;}
          | matrixelts ',' expr {$$=newnode(Fmatrixelts,$1,$3);}
;

matrixlines: matrixelts {$$=$1;} 
           | matrixlines ';' matrixelts {$$=newnode(Fmatrixlines,$1,$3);}
;

matrix: '[' ']' {$$=newnode(Femptyvec,-1,-1);}
      | '[' ';' ']' {$$=newnode(Femptymat,-1,-1);}
      | '[' matrixlines ']' {$$=newnode(Fmat,$2,-1);}
;

arg: /*empty*/  {$$=-1;}
   |  seq       {$$=$1;}
   | '&' KENTRY {$$=newnode(Frefarg,newuserentry($2),-1);}
;
listarg: arg {$$=$1;}
       | listarg ',' arg {$$=newnode(Flistarg,$1,$3);}
;

funcid: KENTRY '(' listarg ')' {$$=newnode(Fentryfunc,newuserentry($1),$3);} 
;

identifier: funcid  {$$=$1;}
          | KENTRY              {$$=newnode(Fentry,newuserentry($1),-1);}
       /* ' derivate not implemented. no PARI func for it!*/
;

definition: funcid '=' seq KEOC {$$=newnode(Fdeffunc,$1,$3);}
;

constante: KCONST  {$$=newconstnode($1);}
         | KSTRING {$$=newnode(Fstring,newvalue(Fstring,$1),-1);}
;

%%
int yyerror(char * s)
{ 
  fprintf(stderr,"%s:%d: %s\n",nameparse,linecount,s);
  return 0;
}
