/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
extern int indent;
int currfunc;
int allocfctx(void);
void genentrydesc(FILE *fout, int n, gpfunc *gp);
extern gpfunc listfunc[];/*[] are mandatory for findfunction*/

int findnewentry(const char *s)
{
  int i;
  for(i=0; i<nfunc && strcmp(lfunc[i].gp.gpname,s);i++);
  return i<nfunc?i:-1;
}
int allocfunc(void)
{
  if (nfunc>=func_alloc)
  {
    func_alloc=nfunc+10;
    if (debug) fprintf(stderr,"alloc func: %d/%d\n",nfunc,func_alloc);
    lfunc=realloc(lfunc,func_alloc*sizeof(*lfunc));
    if (lfunc==NULL)
      fprintf(stderr,"Oups... alloc func: %d/%d\n",nfunc,func_alloc);
  }
  return nfunc++;
}
int newfunc(char *gpname)
{
  int r=allocfunc();
  lfunc[r].gp.gpname=strdup(gpname);
  lfunc[r].gp.cname=strdup(gpname);
  lfunc[r].gp.sec=0;
  lfunc[r].gp.code=NULL;
  lfunc[r].gp.type=Gvoid;
  lfunc[r].gp.mode=0;
  lfunc[r].gp.spec=0;/*Guser*/
  lfunc[r].gp.dsc=NULL;
  lfunc[r].var=NULL;
  lfunc[r].nvar=0;
  lfunc[r].gcvar=NULL;
  lfunc[r].ngc=0;
  return r;
}
int findfunction(int n, gpfunc **gp)
{
  char *s=value[n].val.str;
  int r;
  if ((r=findentry(s))!=-1)
  {
    *gp=listfunc+r;
    return -2;
  }
  if ((r=findnewentry(s))!=-1)
  {
    *gp=&lfunc[r].gp;
    return r;
  }
  *gp=NULL;
  return -1;
}
int genautoarg(FILE *fout, char c)
{
  switch(c)
  {
  case 'p':
    fprintf(fout,"prec");
    return 1;
  case 'P':
    fprintf(fout,"precdl");
    return 1;
  }
  return 0;
}
int genarg(FILE *fout, char c, int n)
{
  if (n==-1)
    die(-1,"missing mandatory argument in function call");
  switch(c)
  {
  case 'G':
    gencast(fout,n,Ggen);
    return 1;
  case 'L':
    gencast(fout,n,Gsmall);
    return 1;
  case '&':
    gencode(fout,n);
    return 1;
  case 's':
    gencast(fout,n,Gstr);
    return 1;
  case 'n':
    fprintf(fout,"varn(");
    gencode(fout,n);
    fprintf(fout,")");
    return 1;
  default:
    if(!genautoarg(fout,c))
      die(n,"Unhandled letter `%c' in prototype",c);
    return 0;
  }
}
char *gendefarg(FILE *fout, char *p, char *name)
{
  if (*p!='D')
  {
    if (!genautoarg(fout,*p))
      die(-1,"Too few args for function `%s'",name);
  }
  else
  {
    switch(*++p)
    {
    case 'G':
    case '&':
    case 'I':
      fprintf(fout,"NULL");
      break;
    case 'n':
      fprintf(fout,"-1");
      break;
    default:
      {
	char *q=p;
	for (q=p;*q && *q != ',';++q);
	if (!*q)
	  die(-1,"Unexpected end of prototype code `%s' for `%s'",p,name);
	if (*++q=='G')
	{
	  fprintf(fout,"gzero");
	  p=q+1;
	}
	else
	{
	  if (!q[1] || !q[2])
	    die(-1,"Unexpected end of prototype code `%s' for `%s'",p,name);
	  while (*p != ',') fputc(*p++,fout);
	  p+=2;
	}
      }
      break;
    }
  }
  return p;
}

void gencallfunc(FILE *fout, char *name, int *stack, int nb, char *proto)
{
  int i;
  /*If it is a Fentry with a proto, it is a hidden function call*/ 
  int firstarg=0;
  char *p=proto;
  fprintf(fout,"%s(",name);
  for(i=0;i<nb;p++)
  {
    if (firstarg) fprintf(fout,", ");
    else firstarg=1;
    if (*p)
    { 
      if (*p!='D')
	i+=genarg(fout,*p,stack[i]);
      else if (stack[i]!=-1)
      {
	switch(*++p)
	{
	case 'G':
	case 'n':
	  genarg(fout,*p,stack[i]);
	  break;
	case '&':
	  fprintf(fout,"&"); 
	  genarg(fout,*p,stack[i]);
	  break;
	default:
	  while (*p++ != ',');
	  genarg(fout,*p++,stack[i]);/* '++' eat last ',' */
	  break;
	}
	i++;
      }
      else
	p=gendefarg(fout,p,name);
    }
  }
  for(;*p;p++)
  {
    if (firstarg) fprintf(fout,", ");
    else firstarg=1;
      p=gendefarg(fout,p,name);
  }
  fprintf(fout,")");
}
void genentryuser(FILE *fout, int n, int nf)
{
  int arg[STACKSZ];
  int nb,nargs,firstarg=0;
  int i,j;
  gpfunc *gp=&lfunc[nf].gp;
  context *fc=block+lfunc[nf].bl;
  for (i=0,nargs=0;i<fc->n;i++)
    if ( fc->c[i].flag&(1<<Carg) )
      nargs++;
  nb=genlistargs(n,arg,0,nargs);
  fprintf(fout,"%s(",gp->cname);
  for(i=0,j=0;i<nb;j++)
  {
    if (!(fc->c[j].flag&(1<<Carg)))
      continue;
    if (firstarg)
      fprintf(fout,", ");
    firstarg=1;
    if (arg[i]>=0)
      gencast(fout,arg[i],fc->c[j].t);
    else if (fc->c[j].initval>=0)
      gencast(fout,fc->c[j].initval,fc->c[j].t);
    else
      gencast(fout,newnode(Fgnil,-1,-1),fc->c[j].t);
    i++;
  }
  for(   ;i<nargs;j++)
  {
    if (!(fc->c[j].flag&(1<<Carg)))
      continue;
    if (firstarg)
      fprintf(fout,", ");
    if (fc->c[j].initval>=0)
      gencast(fout,fc->c[j].initval,fc->c[j].t);
    else
      gencast(fout,GNIL,fc->c[j].t);
    i++;
  }
  if (gp->mode&(1<<Mprec))
  {
    if (firstarg) fprintf(fout,", ");
    else firstarg=1;
    fprintf(fout," prec");
  }
  fprintf(fout,")");
}
void genentry(FILE *fout, int n)
{
  int stack[STACKSZ];
  int x=tree[n].x;
  int i,l;
  char *proto=NULL;
  /*There are several hard cases:
    User can call unknown functions, and we have decided to honor it (why?)
    User can call a function without (), and it is customary for I or Pi
    User can forget to declare variable, or want to use indeterminate
  */
  gpfunc *gp;
  int nf=findfunction(x,&gp);
  if (gp)
  {
    if (gp->spec==0)
    {
      genentryuser(fout,n,nf);
      return;
    }
    else if (gp->spec>0)
    {
      genentryspec(fout,n,gp);
      return;
    }
    if (gp->dsc)
    {
      genentrydesc(fout,n,gp);
      return;
    }
    proto=gp->code;
  }
  /*If it is a Fentry with a proto, it is a hidden function call*/ 
  if (proto || tree[n].f==Fentryfunc)
  { 
    l=genlistargs(n,stack,0,STACKSZ);
    if (proto)
    {
      char *p=proto;
      int firstarg=0;
      fprintf(fout,"%s(",gp->cname);
      for(i=0;i<l;p++)
      {
	if (firstarg) fprintf(fout,", ");
	else firstarg=1;
	if (*p)
	{ 
	  if (*p!='D')
	    i+=genarg(fout,*p,stack[i]);
	  else
	  {
	    switch(*++p)
	    {
	    case 'G':
	    case 'n':
	      genarg(fout,*p,stack[i]);
	      break;
	    case '&':
	      fprintf(fout,"&");
	      genarg(fout,*p,stack[i]);
	      break;
	    default:
	      while (*p++ != ',');
	      genarg(fout,*p++,stack[i]);/* '++' eat last ',' */
	      break;
	    }
	    i++;
	  }
	}
      }
      for(;*p;p++)
      {
	if (firstarg) fprintf(fout,", ");
	else firstarg=1;
	if (*p!='D')
	{
	  if (!genautoarg(fout,*p)) 
	    die(n,"Too few args for function");
	}
	else
	{
	  switch(*++p)
	  {
	  case 'G':
	  case '&':
	  case 'I':
	    fprintf(fout,"NULL");
	    break;
	  case 'n':
	    fprintf(fout,"-1");
	    break;
	  default:
	    {
	      char *q=p;
	      while (*++q != ',');
	      if (*++q=='G')
	      {
		fprintf(fout,"gzero");
		p=q+1;
	      }
	      else
	      {
		while (*p != ',') fputc(*p++,fout);
		p+=2;
	      }
	    }
	    break;
	  }
	}
      }
    }
    else/*copy verbatim*/
    {
      if (gp && gp->cname)
	fprintf(fout,"%s(",gp->cname);
      else
	fprintf(fout,"%s(",value[x].val.str);
      for(i=0;i<l;i++)
      {
	if (i) fprintf(fout,", ");
	gencode(fout,stack[i]);
      }
    }
    fprintf(fout,")");
  }
  else
  {
    ctxvar *v=ctxstack+getvarerr(n);
    /*it is not an hidden function call*/
    if (ctype[v->t]==Vsmall && !(v->flag&(1<<Cuser)) && v->var[0]=='p')
      fprintf(fout,"l%s",v->var+1);
    else
      fprintf(fout,"%s",v->var);
  }
}
void gendecvar(FILE *fout, context *fc, int idx)
{
  ctxvar *v=fc->c+idx;
  if ((v->flag&(1<<Cconst)) && v->val!=-1)
    return;
  if (v->flag&(1<<Carg))
    return;
  if (v->t==Gnotype)
  {
    if (findnewentry(v->var)==-1)
    {
      genindent(fout);
      fprintf(fout,cname[Vgen],v->var);
      fprintf(fout," = polx[fetch_user_var(\"%s\")]",v->var);
    }
    /*else it was a very hidden function call*/
    else
      return;
  }
  else if (v->t==Gvoid)
  {
    return;
  } 
  else
  {
    genindent(fout);
    if (ctype[v->t]==Vsmall && !(v->flag&(1<<Cuser)) && v->var[0]=='p')
      v->var[0]='l';
    fprintf(fout,cname[ctype[v->t]],v->var);
    if (ctype[v->t]==Vsmall && !(v->flag&(1<<Cuser)) && v->var[0]=='l')
       v->var[0]='p';
    if (v->initval>=0)
    {
      fprintf(fout," = ");
      gencast(fout,v->initval,v->t);
    }
  }
  if (v->t!=Gnotype && v->t!=Ggen && ctype[v->t]==Vgen)
    fprintf(fout,";\t  /* %s */\n",Gname[v->t]);
  else
    fprintf(fout,";\n");
}
void genprototype(FILE *fout, int nf)
{
  int firstarg;
  gpfunc *gp=&lfunc[nf].gp;
  int t=gp->type;
  int m=gp->mode;
  int i;
  context *fc=block+lfunc[nf].bl;
  fprintf(fout,cname[ctype[t]],gp->cname);
  fprintf(fout,"(");
  firstarg=0;
  for (i=0;i<fc->n;i++)
    if( fc->c[i].flag&(1<<Carg) )
    {
      if (firstarg) fprintf(fout,", ");
      else firstarg=1;
      fprintf(fout,cname[ctype[fc->c[i].t]],fc->c[i].var);
      if (fc->c[i].initval>=0)
      {
	fprintf(fout,"/*=");
	printnode(fout,fc->c[i].initval);
	fprintf(fout,"*/");
      }

    }
  if (m&(1<<Mprec))
  {
    if (firstarg) fprintf(fout,", ");
    else firstarg=1;
    fprintf(fout,"long prec");
  }
  if (!firstarg) fprintf(fout,"void");
  fprintf(fout,")");
}
void gendeffunc(FILE *fout, int n)
{
  int funcid=tree[n].x;
  int seq=tree[n].y;
  int entry=tree[funcid].x;
  int savcf=currfunc;
  int t;
  /*get func number and context*/
  currfunc=findnewentry(value[entry].val.str);
  if (currfunc==-1) 
    die(n,"Internal error in gendeffunc : func %s not found",value[entry].val.str);
  genprototype(fout,currfunc);
  t=lfunc[currfunc].gp.type;
  if (t!=Gnotype && t!=Ggen && ctype[t]==Vgen)
    fprintf(fout,"\t  /* %s */",Gname[t]);
  fprintf(fout,"\n");
  gencode(fout,seq);
  fprintf(fout,"\n");
  currfunc=savcf;
}

void gendefblock(FILE *fout, int n)
{
  int b=tree[n].x;
  int seq=tree[n].y;
  int i;
  int t,m;
  int savc;
  context *fc=block+b;
  savc=nctx;
  pushctx(fc);
  /*some shortcut*/
  t=tree[n].t;
  m=tree[n].m;
  if(!(m&(1<<Mbrace)))
  {
    genindent(fout);
    fprintf(fout,"{\n");
    indent++;
  }
  for(i=0;i<fc->n;i++)
    gendecvar(fout,fc,i);
  genindentseq(fout,seq);
  gencode(fout,seq);
  gensemicomma(fout,seq);
  if(!(m&(1<<Mbrace)))
  {
    indent--;
    genindent(fout);
    fprintf(fout,"}\n");
  }
  nctx=savc;
}
