/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*List of gp functions. Must be include after header.h.*/
gpfunc listfunc[]={
{"Euler","mpeuler",3,"p",Ggen,(1<<Mprec),GPpari},
{"I","geni",3,"",Ggen,0,GPpari},
{"List","gtolist",2,"DG",Ggen,0,GPpari},
{"Mat","gtomat",2,"DG",Ggen,0,GPpari},
{"Mod","Mod0",2,"GGD0,L,",Ggen,0,GPpari},
{"O",NULL,7,NULL,Ggen,0,GPpari},
{"Pi","mppi",3,"p",Ggen,(1<<Mprec),GPpari},
{"Pol","gtopoly",2,"GDn",Ggen,0,GPpari},
{"Polrev","gtopolyrev",2,"GDn",Ggen,0,GPpari},
{"Qfb","Qfb0",2,"GGGDGp",Ggen,(1<<Mprec),GPpari},
{"Ser","gtoser",2,"GDn",Ggen,0,GPpari},
{"Set","gtoset",2,"DG",Ggen,0,GPpari},
{"Str","strtoGENstr",2,"D\"\",s,D0,L,",Ggen,0,GPpari},
{"Vec","gtovec",2,"DG",Ggen,0,GPpari},
{"abs","gabs",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"acos","gacos",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"acosh","gach",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"addprimes","addprimes",4,"DG",Ggen,0,GPpari},
{"agm","agm",3,"GGp",Ggen,(1<<Mprec),GPpari},
{"algdep","algdep0",8,"GLD0,L,p",Ggen,(1<<Mprec),GPpari},
{"alias","alias0",11,"rr",Gvoid,0,GPpari},
{"arg","garg",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"asin","gasin",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"asinh","gash",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"atan","gatan",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"atanh","gath",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"bernfrac","bernfrac",3,"L",Ggen,0,GPpari},
{"bernreal","bernreal",3,"Lp",Ggen,(1<<Mprec),GPpari},
{"bernvec","bernvec",3,"L",Ggen,0,GPpari},
{"besseljh","jbesselh",3,"GGp",Ggen,(1<<Mprec),GPpari},
{"besselk","kbessel0",3,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bestappr","bestappr",4,"GG",Ggen,0,GPpari},
{"bezout","vecbezout",4,"GG",Ggen,0,GPpari},
{"bezoutres","vecbezoutres",4,"GG",Ggen,0,GPpari},
{"bigomega","gbigomega",4,"G",Ggen,0,GPpari},
{"binary","binaire",2,"G",Ggen,0,GPpari},
{"binomial","binome",4,"GL",Ggen,0,GPpari},
{"bitand","gbitand",2,"GG",Ggen,0,GPpari},
{"bitneg","gbitneg",2,"GD-1,L,",Ggen,0,GPpari},
{"bitnegimply","gbitnegimply",2,"GG",Ggen,0,GPpari},
{"bitor","gbitor",2,"GG",Ggen,0,GPpari},
{"bittest","gbittest",2,"GG",Ggen,0,GPpari},
{"bitxor","gbitxor",2,"GG",Ggen,0,GPpari},
{"bnfcertify","certifybuchall",6,"G",Gsmall,0,GPpari},
{"bnfclassunit","bnfclassunit0",6,"GD0,L,DGp",Ggen,(1<<Mprec),GPpari},
{"bnfclgp","classgrouponly",6,"GDGp",Ggen,(1<<Mprec),GPpari},
{"bnfdecodemodule","decodemodule",6,"GG",Ggen,0,GPpari},
{"bnfinit","bnfinit0",6,"GD0,L,DGp",Ggen,(1<<Mprec),GPpari},
{"bnfisintnorm","bnfisintnorm",6,"GG",Ggen,0,GPpari},
{"bnfisnorm","bnfisnorm",6,"GGD1,L,p",Ggen,(1<<Mprec),GPpari},
{"bnfisprincipal","isprincipalall",6,"GGD1,L,",Ggen,0,GPpari},
{"bnfissunit","bnfissunit",6,"GGG",Ggen,0,GPpari},
{"bnfisunit","isunit",6,"GG",Ggen,0,GPpari},
{"bnfmake","bnfmake",6,"Gp",Ggen,(1<<Mprec),GPpari},
{"bnfnarrow","buchnarrow",6,"G",Ggen,0,GPpari},
{"bnfreg","regulator",6,"GDGp",Ggen,(1<<Mprec),GPpari},
{"bnfsignunit","signunits",6,"G",Ggen,0,GPpari},
{"bnfsunit","bnfsunit",6,"GGp",Ggen,(1<<Mprec),GPpari},
{"bnfunit","buchfu",6,"Gp",Ggen,(1<<Mprec),GPpari},
{"bnrL1","bnrL1",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bnrclass","bnrclass0",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bnrclassno","rayclassno",6,"GG",Ggen,0,GPpari},
{"bnrclassnolist","rayclassnolist",6,"GG",Ggen,0,GPpari},
{"bnrconductor","bnrconductor",6,"GDGDGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bnrconductorofchar","bnrconductorofchar",6,"GGp",Ggen,(1<<Mprec),GPpari},
{"bnrdisc","bnrdisc0",6,"GDGDGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bnrdisclist","bnrdisclist0",6,"GGDGD0,L,",Ggen,0,GPpari},
{"bnrinit","bnrinit0",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bnrisconductor","bnrisconductor",6,"GDGDGp",Gsmall,(1<<Mprec),GPpari},
{"bnrisprincipal","isprincipalrayall",6,"GGD1,L,",Ggen,0,GPpari},
{"bnrrootnumber","bnrrootnumber",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"bnrstark","bnrstark",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"break","break0",11,"D1,L,",Ggen,0,GPpari},
{"ceil","gceil",2,"G",Ggen,0,GPpari},
{"centerlift","centerlift0",2,"GDn",Ggen,0,GPpari},
{"changevar","changevar",2,"GG",Ggen,0,GPpari},
{"charpoly","charpoly0",8,"GDnD0,L,",Ggen,0,GPpari},
{"chinese","chinois",4,"GG",Ggen,0,GPpari},
{"component","compo",2,"GL",Ggen,0,GPpari},
{"concat","concat",8,"GDG",Ggen,0,GPpari},
{"conj","gconj",2,"G",Ggen,0,GPpari},
{"conjvec","conjvec",2,"Gp",Ggen,(1<<Mprec),GPpari},
{"content","content",4,"G",Ggen,0,GPpari},
{"contfrac","contfrac0",4,"GDGD0,L,",Ggen,0,GPpari},
{"contfracpnqn","pnqn",4,"G",Ggen,0,GPpari},
{"core","core0",4,"GD0,L,",Ggen,0,GPpari},
{"coredisc","coredisc0",4,"GD0,L,",Ggen,0,GPpari},
{"cos","gcos",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"cosh","gch",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"cotan","gcotan",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"denominator","denom",2,"G",Ggen,0,GPpari},
{"deriv","deriv",7,"GDn",Ggen,0,GPpari},
{"dilog","dilog",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"dirdiv","dirdiv",4,"GG",Ggen,0,GPpari},
{"direuler","direulerall",4,"V=GGEDG",Ggen,0,GPpari},
{"dirmul","dirmul",4,"GG",Ggen,0,GPpari},
{"dirzetak","dirzetak",6,"GG",Ggen,0,GPpari},
{"divisors","divisors",4,"G",Ggen,0,GPpari},
{"divrem","gdiventres",1,"GG",Ggen,0,GPpari},
{"eint1","veceint1",3,"GDGp",Ggen,(1<<Mprec),GPpari},
{"elladd","addell",5,"GGG",Ggen,0,GPpari},
{"ellak","akell",5,"GG",Ggen,0,GPpari},
{"ellan","anell",5,"GL",Ggen,0,GPpari},
{"ellap","ellap0",5,"GGD0,L,",Ggen,0,GPpari},
{"ellbil","bilhell",5,"GGGp",Ggen,(1<<Mprec),GPpari},
{"ellchangecurve","coordch",5,"GG",Ggen,0,GPpari},
{"ellchangepoint","pointch",5,"GG",Ggen,0,GPpari},
{"elleisnum","elleisnum",5,"GLD0,L,p",Ggen,(1<<Mprec),GPpari},
{"elleta","elleta",5,"Gp",Ggen,(1<<Mprec),GPpari},
{"ellglobalred","globalreduction",5,"G",Ggen,0,GPpari},
{"ellheight","ellheight0",5,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"ellheightmatrix","mathell",5,"GGp",Ggen,(1<<Mprec),GPpari},
{"ellinit","ellinit0",5,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"ellisoncurve","oncurve",5,"GG",Gsmall,0,GPpari},
{"ellj","jell",5,"Gp",Ggen,(1<<Mprec),GPpari},
{"elllocalred","localreduction",5,"GG",Ggen,0,GPpari},
{"elllseries","lseriesell",5,"GGDGp",Ggen,(1<<Mprec),GPpari},
{"ellorder","orderell",5,"GG",Ggen,0,GPpari},
{"ellordinate","ordell",5,"GGp",Ggen,(1<<Mprec),GPpari},
{"ellpointtoz","zell",5,"GGp",Ggen,(1<<Mprec),GPpari},
{"ellpow","powell",5,"GGGp",Ggen,(1<<Mprec),GPpari},
{"ellrootno","ellrootno",5,"GDG",Gsmall,0,GPpari},
{"ellsigma","ellsigma",5,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"ellsub","subell",5,"GGGp",Ggen,(1<<Mprec),GPpari},
{"elltaniyama","taniyama",5,"Gp",Ggen,(1<<Mprec),GPpari},
{"elltors","elltors0",5,"GD0,L,",Ggen,0,GPpari},
{"ellwp","ellwp0",5,"GDGD0,L,pP",Ggen,(1<<Mprec),GPpari},
{"ellzeta","ellzeta",5,"GGp",Ggen,(1<<Mprec),GPpari},
{"ellztopoint","pointell",5,"GGp",Ggen,(1<<Mprec),GPpari},
{"erfc","gerfc",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"eta","eta0",3,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"eulerphi","gphi",4,"G",Ggen,0,GPpari},
{"eval","geval",7,"G",Ggen,0,GPpari},
{"exp","gexp",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"factor","factor0",4,"GD-1,L,",Ggen,0,GPpari},
{"factorback","factorback",4,"GDG",Ggen,0,GPpari},
{"factorcantor","factcantor",4,"GG",Ggen,0,GPpari},
{"factorff","factmod9",4,"GGG",Ggen,0,GPpari},
{"factorial","mpfactr",4,"Lp",Ggen,(1<<Mprec),GPpari},
{"factorint","factorint",4,"GD0,L,",Ggen,0,GPpari},
{"factormod","factormod0",4,"GGD0,L,",Ggen,0,GPpari},
{"factornf","polfnf",6,"GG",Ggen,0,GPpari},
{"factorpadic","factorpadic0",7,"GGLD0,L,",Ggen,0,GPpari},
{"ffinit","ffinit",4,"GLDn",Ggen,0,GPpari},
{"fibonacci","fibo",4,"L",Ggen,0,GPpari},
{"floor","gfloor",2,"G",Ggen,0,GPpari},
{"for","forpari",11,"V=GGI",Gvoid,0,GPpari},
{"fordiv","fordiv",11,"GVI",Gvoid,0,GPpari},
{"forprime","forprime",11,"V=GGI",Gvoid,0,GPpari},
{"forstep","forstep",11,"V=GGGI",Gvoid,0,GPpari},
{"forsubgroup","forsubgroup",11,"V=GD0,L,I",Gvoid,0,GPpari},
{"forvec","forvec",11,"V=GID0,L,",Gvoid,0,GPpari},
{"frac","gfrac",2,"G",Ggen,0,GPpari},
{"galoisfixedfield","galoisfixedfield",6,"GGD0,L,Dn",Ggen,0,GPpari},
{"galoisinit","galoisinit",6,"GDG,",Ggen,0,GPpari},
{"galoispermtopol","galoispermtopol",6,"GG",Ggen,0,GPpari},
{"galoissubcyclo","galoissubcyclo",6,"LGDGDn",Ggen,0,GPpari},
{"gamma","ggamma",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"gammah","ggamd",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"gcd","gcd0",4,"GGD0,L,",Ggen,0,GPpari},
{"getheap","getheap",11,"",Ggen,0,GPpari},
{"getrand","getrand",11,"",Gsmall,0,GPpari},
{"getstack","getstack",11,"",Gsmall,0,GPpari},
{"gettime","gettime",11,"",Gsmall,0,GPpari},
{"hilbert","hil0",4,"GGDG",Gsmall,0,GPpari},
{"hyperu","hyperu",3,"GGGp",Ggen,(1<<Mprec),GPpari},
{"idealadd","idealadd",6,"GGG",Ggen,0,GPpari},
{"idealaddtoone","idealaddtoone0",6,"GGDG",Ggen,0,GPpari},
{"idealappr","idealappr0",6,"GGD0,L,",Ggen,0,GPpari},
{"idealchinese","idealchinese",6,"GGG",Ggen,0,GPpari},
{"idealcoprime","idealcoprime",6,"GGG",Ggen,0,GPpari},
{"idealdiv","idealdiv0",6,"GGGD0,L,",Ggen,0,GPpari},
{"idealfactor","idealfactor",6,"GG",Ggen,0,GPpari},
{"idealhnf","idealhnf0",6,"GGDG",Ggen,0,GPpari},
{"idealintersect","idealintersect",6,"GGG",Ggen,0,GPpari},
{"idealinv","idealinv",6,"GG",Ggen,0,GPpari},
{"ideallist","ideallist0",6,"GLD4,L,",Ggen,0,GPpari},
{"ideallistarch","ideallistarch0",6,"GGDGD0,L,",Ggen,0,GPpari},
{"ideallog","zideallog",6,"GGG",Ggen,0,GPpari},
{"idealmin","minideal",6,"GGDGp",Ggen,(1<<Mprec),GPpari},
{"idealmul","idealmul0",6,"GGGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"idealnorm","idealnorm",6,"GG",Ggen,0,GPpari},
{"idealpow","idealpow0",6,"GGGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"idealprimedec","primedec",6,"GG",Ggen,0,GPpari},
{"idealprincipal","principalideal",6,"GG",Ggen,0,GPpari},
{"idealred","ideallllred",6,"GGDGp",Ggen,(1<<Mprec),GPpari},
{"idealstar","idealstar0",6,"GGD1,L,",Ggen,0,GPpari},
{"idealtwoelt","ideal_two_elt0",6,"GGDG",Ggen,0,GPpari},
{"idealval","idealval",6,"GGG",Gsmall,0,GPpari},
{"ideleprincipal","principalidele",6,"GGp",Ggen,(1<<Mprec),GPpari},
{"if",NULL,11,NULL,Ggen,0,GPpari},
{"imag","gimag",2,"G",Ggen,0,GPpari},
{"incgam","incgam0",3,"GGDGp",Ggen,(1<<Mprec),GPpari},
{"incgamc","incgam3",3,"GGp",Ggen,(1<<Mprec),GPpari},
{"intformal","integ",7,"GDn",Ggen,0,GPpari},
{"intnum","intnum0",9,"V=GGED0,L,p",Ggen,(1<<Mprec),GPpari},
{"isfundamental","gisfundamental",4,"G",Ggen,0,GPpari},
{"isprime","gisprime",4,"GD0,L,",Ggen,0,GPpari},
{"ispseudoprime","gispsp",4,"G",Ggen,0,GPpari},
{"issquare","gcarrecomplet",4,"GD&",Ggen,0,GPpari},
{"issquarefree","gissquarefree",4,"G",Ggen,0,GPpari},
{"kronecker","gkronecker",4,"GG",Ggen,0,GPpari},
{"lcm","glcm",4,"GG",Ggen,0,GPpari},
{"length","glength",2,"G",Gsmall,0,GPpari},
{"lex","lexcmp",1,"GG",Gsmall,0,GPpari},
{"lift","lift0",2,"GDn",Ggen,0,GPpari},
{"lindep","lindep0",8,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"listcreate","listcreate",8,"L",Ggen,0,GPpari},
{"listinsert","listinsert",8,"GGL",Ggen,0,GPpari},
{"listkill","listkill",8,"G",Gvoid,0,GPpari},
{"listput","listput",8,"GGD0,L,",Ggen,0,GPpari},
{"listsort","listsort",8,"GD0,L,",Ggen,0,GPpari},
{"lngamma","glngamma",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"log","log0",3,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"matadjoint","adj",8,"G",Ggen,0,GPpari},
{"matalgtobasis","matalgtobasis",6,"GG",Ggen,0,GPpari},
{"matbasistoalg","matbasistoalg",6,"GG",Ggen,0,GPpari},
{"matcompanion","assmat",8,"G",Ggen,0,GPpari},
{"matdet","det0",8,"GD0,L,",Ggen,0,GPpari},
{"matdetint","detint",8,"G",Ggen,0,GPpari},
{"matdiagonal","diagonal",8,"G",Ggen,0,GPpari},
{"mateigen","eigen",8,"Gp",Ggen,(1<<Mprec),GPpari},
{"mathess","hess",8,"G",Ggen,0,GPpari},
{"mathilbert","mathilbert",8,"L",Ggen,0,GPpari},
{"mathnf","mathnf0",8,"GD0,L,",Ggen,0,GPpari},
{"mathnfmod","hnfmod",8,"GG",Ggen,0,GPpari},
{"mathnfmodid","hnfmodid",8,"GG",Ggen,0,GPpari},
{"matid","idmat",8,"L",Ggen,0,GPpari},
{"matimage","matimage0",8,"GD0,L,",Ggen,0,GPpari},
{"matimagecompl","imagecompl",8,"G",Ggen,0,GPpari},
{"matindexrank","indexrank",8,"G",Ggen,0,GPpari},
{"matintersect","intersect",8,"GG",Ggen,0,GPpari},
{"matinverseimage","inverseimage",8,"GG",Ggen,0,GPpari},
{"matisdiagonal","isdiagonal",8,"G",Gsmall,0,GPpari},
{"matker","matker0",8,"GD0,L,",Ggen,0,GPpari},
{"matkerint","matkerint0",8,"GD0,L,",Ggen,0,GPpari},
{"matmuldiagonal","matmuldiagonal",8,"GG",Ggen,0,GPpari},
{"matmultodiagonal","matmultodiagonal",8,"GG",Ggen,0,GPpari},
{"matpascal","matqpascal",8,"LDG",Ggen,0,GPpari},
{"matrank","rank",8,"G",Gsmall,0,GPpari},
{"matrix","matrice",8,"GGDVDVDI",Ggen,0,GPpari},
{"matrixqz","matrixqz0",8,"GG",Ggen,0,GPpari},
{"matsize","matsize",8,"G",Ggen,0,GPpari},
{"matsnf","matsnf0",8,"GD0,L,",Ggen,0,GPpari},
{"matsolve","gauss",8,"GG",Ggen,0,GPpari},
{"matsolvemod","matsolvemod0",8,"GGGD0,L,",Ggen,0,GPpari},
{"matsupplement","suppl",8,"Gp",Ggen,(1<<Mprec),GPpari},
{"mattranspose","gtrans",8,"G",Ggen,0,GPpari},
{"max","gmax",1,"GG",Ggen,0,GPpari},
{"min","gmin",1,"GG",Ggen,0,GPpari},
{"modreverse","polymodrecip",6,"G",Ggen,0,GPpari},
{"moebius","gmu",4,"G",Ggen,0,GPpari},
{"newtonpoly","newtonpoly",6,"GG",Ggen,0,GPpari},
{"next","next0",11,"D1,L,",Ggen,0,GPpari},
{"nextprime","gnextprime",4,"G",Ggen,0,GPpari},
{"nfalgtobasis","algtobasis",6,"GG",Ggen,0,GPpari},
{"nfbasis","nfbasis0",6,"GD0,L,DG",Ggen,0,GPpari},
{"nfbasistoalg","basistoalg",6,"GG",Ggen,0,GPpari},
{"nfdetint","nfdetint",6,"GG",Ggen,0,GPpari},
{"nfdisc","nfdiscf0",6,"GD0,L,DG",Ggen,0,GPpari},
{"nfeltdiv","element_div",6,"GGG",Ggen,0,GPpari},
{"nfeltdiveuc","nfdiveuc",6,"GGG",Ggen,0,GPpari},
{"nfeltdivmodpr","element_divmodpr",6,"GGGG",Ggen,0,GPpari},
{"nfeltdivrem","nfdivres",6,"GGG",Ggen,0,GPpari},
{"nfeltmod","nfmod",6,"GGG",Ggen,0,GPpari},
{"nfeltmul","element_mul",6,"GGG",Ggen,0,GPpari},
{"nfeltmulmodpr","element_mulmodpr2",6,"GGGG",Ggen,0,GPpari},
{"nfeltpow","element_pow",6,"GGG",Ggen,0,GPpari},
{"nfeltpowmodpr","element_powmodpr",6,"GGGG",Ggen,0,GPpari},
{"nfeltreduce","element_reduce",6,"GGG",Ggen,0,GPpari},
{"nfeltreducemodpr","nfreducemodpr2",6,"GGG",Ggen,0,GPpari},
{"nfeltval","element_val",6,"GGG",Gsmall,0,GPpari},
{"nffactor","nffactor",6,"GG",Ggen,0,GPpari},
{"nffactormod","nffactormod",6,"GGG",Ggen,0,GPpari},
{"nfgaloisapply","galoisapply",6,"GGG",Ggen,0,GPpari},
{"nfgaloisconj","galoisconj0",6,"GD0,L,DGp",Ggen,(1<<Mprec),GPpari},
{"nfhilbert","nfhilbert0",6,"GGGDG",Gsmall,0,GPpari},
{"nfhnf","nfhermite",6,"GG",Ggen,0,GPpari},
{"nfhnfmod","nfhermitemod",6,"GGG",Ggen,0,GPpari},
{"nfinit","nfinit0",6,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"nfisideal","isideal",6,"GG",Gsmall,0,GPpari},
{"nfisincl","nfisincl",6,"GG",Ggen,0,GPpari},
{"nfisisom","nfisisom",6,"GG",Ggen,0,GPpari},
{"nfkermodpr","nfkermodpr",6,"GGG",Ggen,0,GPpari},
{"nfmodprinit","nfmodprinit",6,"GG",Ggen,0,GPpari},
{"nfnewprec","nfnewprec",6,"Gp",Ggen,(1<<Mprec),GPpari},
{"nfroots","nfroots",6,"GG",Ggen,0,GPpari},
{"nfrootsof1","rootsof1",6,"G",Ggen,0,GPpari},
{"nfsnf","nfsmith",6,"GG",Ggen,0,GPpari},
{"nfsolvemodpr","nfsolvemodpr",6,"GGGG",Ggen,0,GPpari},
{"nfsubfields","subfields0",6,"GDG",Ggen,0,GPpari},
{"norm","gnorm",2,"G",Ggen,0,GPpari},
{"norml2","gnorml2",2,"G",Ggen,0,GPpari},
{"numdiv","gnumbdiv",4,"G",Ggen,0,GPpari},
{"numerator","numer",2,"G",Ggen,0,GPpari},
{"numtoperm","permute",2,"LG",Ggen,0,GPpari},
{"omega","gomega",4,"G",Ggen,0,GPpari},
{"padicappr","apprgen9",7,"GG",Ggen,0,GPpari},
{"padicprec","padicprec",2,"GG",Gsmall,0,GPpari},
{"permtonum","permuteInv",2,"G",Ggen,0,GPpari},
{"polcoeff","polcoeff0",7,"GLDn",Ggen,0,GPpari},
{"polcompositum","polcompositum0",6,"GGD0,L,",Ggen,0,GPpari},
{"polcyclo","cyclo",7,"LDn",Ggen,0,GPpari},
{"poldegree","poldegree",7,"GDn",Gsmall,0,GPpari},
{"poldisc","poldisc0",7,"GDn",Ggen,0,GPpari},
{"poldiscreduced","reduceddiscsmith",7,"G",Ggen,0,GPpari},
{"polgalois","galois",6,"Gp",Ggen,(1<<Mprec),GPpari},
{"polhensellift","polhensellift",7,"GGGL",Ggen,0,GPpari},
{"polinterpolate","polint",7,"GDGDGD&",Ggen,0,GPpari},
{"polisirreducible","gisirreducible",7,"G",Ggen,0,GPpari},
{"pollead","pollead",7,"GDn",Ggen,0,GPpari},
{"pollegendre","legendre",7,"LDn",Ggen,0,GPpari},
{"polrecip","polrecip",7,"G",Ggen,0,GPpari},
{"polred","polred0",6,"GD0,L,DGp",Ggen,(1<<Mprec),GPpari},
{"polredabs","polredabs0",6,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"polredord","ordred",6,"Gp",Ggen,(1<<Mprec),GPpari},
{"polresultant","polresultant0",7,"GGDnD0,L,",Ggen,0,GPpari},
{"polroots","roots0",7,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"polrootsmod","rootmod0",7,"GGD0,L,",Ggen,0,GPpari},
{"polrootspadic","rootpadic",7,"GGL",Ggen,0,GPpari},
{"polsturm","sturmpart",7,"GDGDG",Gsmall,0,GPpari},
{"polsubcyclo","subcyclo",7,"GGDn",Ggen,0,GPpari},
{"polsylvestermatrix","sylvestermatrix",7,"GGp",Ggen,(1<<Mprec),GPpari},
{"polsym","polsym",7,"GL",Ggen,0,GPpari},
{"poltchebi","tchebi",7,"LDn",Ggen,0,GPpari},
{"poltschirnhaus","tschirnhaus",6,"G",Ggen,0,GPpari},
{"polylog","polylog0",3,"LGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"polzagier","polzag",7,"LL",Ggen,0,GPpari},
{"precision","precision0",2,"GD0,L,",Ggen,0,GPpari},
{"precprime","gprecprime",4,"G",Ggen,0,GPpari},
{"prime","prime",4,"L",Ggen,0,GPpari},
{"primes","primes",4,"L",Ggen,0,GPpari},
{"prod","produit",9,"V=GGEDG",Ggen,0,GPpari},
{"prodeuler","prodeuler",9,"V=GGEp",Ggen,(1<<Mprec),GPpari},
{"prodinf","prodinf0",9,"V=GED0,L,p",Ggen,(1<<Mprec),GPpari},
{"psi","gpsi",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"qfbclassno","qfbclassno0",4,"GD0,L,",Ggen,0,GPpari},
{"qfbcompraw","compraw",4,"GG",Ggen,0,GPpari},
{"qfbhclassno","hclassno",4,"G",Ggen,0,GPpari},
{"qfbnucomp","nucomp",4,"GGG",Ggen,0,GPpari},
{"qfbnupow","nupow",4,"GG",Ggen,0,GPpari},
{"qfbpowraw","powraw",4,"GL",Ggen,0,GPpari},
{"qfbprimeform","primeform",4,"GGp",Ggen,(1<<Mprec),GPpari},
{"qfbred","qfbred0",4,"GD0,L,DGDGDG",Ggen,0,GPpari},
{"qfgaussred","sqred",8,"G",Ggen,0,GPpari},
{"qfjacobi","jacobi",8,"Gp",Ggen,(1<<Mprec),GPpari},
{"qflll","qflll0",8,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"qflllgram","qflllgram0",8,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"qfminim","qfminim0",8,"GGGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"qfperfection","perf",8,"G",Ggen,0,GPpari},
{"qfsign","signat",8,"G",Ggen,0,GPpari},
{"quadclassunit","quadclassunit0",4,"GD0,L,DGp",Ggen,(1<<Mprec),GPpari},
{"quaddisc","quaddisc",4,"G",Ggen,0,GPpari},
{"quadgen","quadgen",4,"G",Ggen,0,GPpari},
{"quadhilbert","quadhilbert",4,"GDGp",Ggen,(1<<Mprec),GPpari},
{"quadpoly","quadpoly0",4,"GDn",Ggen,0,GPpari},
{"quadray","quadray",4,"GGDGp",Ggen,(1<<Mprec),GPpari},
{"quadregulator","gregula",4,"Gp",Ggen,(1<<Mprec),GPpari},
{"quadunit","gfundunit",4,"Gp",Ggen,(1<<Mprec),GPpari},
{"random","genrand",2,"DG",Ggen,0,GPpari},
{"real","greal",2,"G",Ggen,0,GPpari},
{"removeprimes","removeprimes",4,"DG",Ggen,0,GPpari},
{"reorder","reorder",11,"DG",Ggen,0,GPpari},
{"return","return0",11,"DG",Ggen,0,GPpari},
{"rnfalgtobasis","rnfalgtobasis",6,"GG",Ggen,0,GPpari},
{"rnfbasis","rnfbasis",6,"GG",Ggen,0,GPpari},
{"rnfbasistoalg","rnfbasistoalg",6,"GG",Ggen,0,GPpari},
{"rnfcharpoly","rnfcharpoly",6,"GGGDn",Ggen,0,GPpari},
{"rnfconductor","rnfconductor",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"rnfdedekind","rnfdedekind",6,"GGG",Ggen,0,GPpari},
{"rnfdet","rnfdet0",6,"GGDG",Ggen,0,GPpari},
{"rnfdisc","rnfdiscf",6,"GG",Ggen,0,GPpari},
{"rnfeltabstorel","rnfelementabstorel",6,"GG",Ggen,0,GPpari},
{"rnfeltdown","rnfelementdown",6,"GG",Ggen,0,GPpari},
{"rnfeltreltoabs","rnfelementreltoabs",6,"GG",Ggen,0,GPpari},
{"rnfeltup","rnfelementup",6,"GG",Ggen,0,GPpari},
{"rnfequation","rnfequation0",6,"GGD0,L,",Ggen,0,GPpari},
{"rnfhnfbasis","rnfhermitebasis",6,"GG",Ggen,0,GPpari},
{"rnfidealabstorel","rnfidealabstorel",6,"GG",Ggen,0,GPpari},
{"rnfidealdown","rnfidealdown",6,"GG",Ggen,0,GPpari},
{"rnfidealhnf","rnfidealhermite",6,"GG",Ggen,0,GPpari},
{"rnfidealmul","rnfidealmul",6,"GG",Ggen,0,GPpari},
{"rnfidealnormabs","rnfidealnormabs",6,"GG",Ggen,0,GPpari},
{"rnfidealnormrel","rnfidealnormrel",6,"GG",Ggen,0,GPpari},
{"rnfidealreltoabs","rnfidealreltoabs",6,"GG",Ggen,0,GPpari},
{"rnfidealtwoelt","rnfidealtwoelement",6,"GG",Ggen,0,GPpari},
{"rnfidealup","rnfidealup",6,"GG",Ggen,0,GPpari},
{"rnfinit","rnfinitalg",6,"GGp",Ggen,(1<<Mprec),GPpari},
{"rnfisfree","rnfisfree",6,"GG",Gsmall,0,GPpari},
{"rnfisnorm","rnfisnorm",6,"GGGD1,L,p",Ggen,(1<<Mprec),GPpari},
{"rnfkummer","rnfkummer",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"rnflllgram","rnflllgram",6,"GGGp",Ggen,(1<<Mprec),GPpari},
{"rnfnormgroup","rnfnormgroup",6,"GG",Ggen,0,GPpari},
{"rnfpolred","rnfpolred",6,"GGp",Ggen,(1<<Mprec),GPpari},
{"rnfpolredabs","rnfpolredabs",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"rnfpseudobasis","rnfpseudobasis",6,"GG",Ggen,0,GPpari},
{"rnfsteinitz","rnfsteinitz",6,"GG",Ggen,0,GPpari},
{"round","round0",2,"GD&",Ggen,0,GPpari},
{"serconvol","convol",7,"GG",Ggen,0,GPpari},
{"serlaplace","laplace",7,"G",Ggen,0,GPpari},
{"serreverse","recip",7,"G",Ggen,0,GPpari},
{"setintersect","setintersect",8,"GG",Ggen,0,GPpari},
{"setisset","setisset",8,"G",Gsmall,0,GPpari},
{"setminus","setminus",8,"GG",Ggen,0,GPpari},
{"setrand","setrand",11,"L",Gsmall,0,GPpari},
{"setsearch","setsearch",8,"GGD0,L,",Gsmall,0,GPpari},
{"setunion","setunion",8,"GG",Ggen,0,GPpari},
{"shift","gshift",1,"GL",Ggen,0,GPpari},
{"shiftmul","gmul2n",1,"GL",Ggen,0,GPpari},
{"sigma","gsumdivk",4,"GD1,L,",Ggen,0,GPpari},
{"sign","gsigne",1,"G",Gsmall,0,GPpari},
{"simplify","simplify",2,"G",Ggen,0,GPpari},
{"sin","gsin",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"sinh","gsh",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"sizebyte","taille2",2,"G",Gsmall,0,GPpari},
{"sizedigit","sizedigit",2,"G",Gsmall,0,GPpari},
{"solve","zbrent",9,"V=GGEp",Ggen,(1<<Mprec),GPpari},
{"sqr","gsqr",3,"G",Ggen,0,GPpari},
{"sqrt","gsqrt",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"sqrtint","racine",4,"G",Ggen,0,GPpari},
{"sqrtn","gsqrtn",3,"GGD&p",Ggen,(1<<Mprec),GPpari},
{"subgrouplist","subgrouplist0",6,"GD0,L,D0,L,p",Ggen,(1<<Mprec),GPpari},
{"subst","gsubst",7,"GnG",Ggen,0,GPpari},
{"sum","somme",9,"V=GGEDG",Ggen,0,GPpari},
{"sumalt","sumalt0",9,"V=GED0,L,p",Ggen,(1<<Mprec),GPpari},
{"sumdiv","divsum",9,"GVE",Ggen,0,GPpari},
{"suminf","suminf",9,"V=GEp",Ggen,(1<<Mprec),GPpari},
{"sumpos","sumpos0",9,"V=GED0,L,p",Ggen,(1<<Mprec),GPpari},
{"tan","gtan",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"tanh","gth",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"taylor","tayl",7,"GnP",Ggen,0,GPpari},
{"teichmuller","teich",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"theta","theta",3,"GGp",Ggen,(1<<Mprec),GPpari},
{"thetanullk","thetanullk",3,"GLp",Ggen,(1<<Mprec),GPpari},
{"thue","thue",7,"GGDG",Ggen,0,GPpari},
{"thueinit","thueinit",7,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"trace","gtrace",8,"G",Ggen,0,GPpari},
{"truncate","trunc0",2,"GD&",Ggen,0,GPpari},
{"until",NULL,11,NULL,Ggen,0,GPpari},
{"valuation","ggval",2,"GG",Gsmall,0,GPpari},
{"variable","gpolvar",2,"G",Ggen,0,GPpari},
{"vecextract","extract0",8,"GGDG",Ggen,0,GPpari},
{"vecmax","vecmax",1,"G",Ggen,0,GPpari},
{"vecmin","vecmin",1,"G",Ggen,0,GPpari},
{"vecsort","vecsort0",8,"GDGD0,L,",Ggen,0,GPpari},
{"vector","vecteur",8,"GDVDI",Ggen,0,GPpari},
{"vectorv","vvecteur",8,"GDVDI",Ggen,0,GPpari},
{"weber","weber0",3,"GD0,L,p",Ggen,(1<<Mprec),GPpari},
{"while",NULL,11,NULL,Ggen,0,GPpari},
{"zeta","gzeta",3,"Gp",Ggen,(1<<Mprec),GPpari},
{"zetak","gzetakall",6,"GGD0,L,p",Ggen,(1<<Mprec),GPpari},
{"zetakinit","initzeta",6,"Gp",Ggen,(1<<Mprec),GPpari},
{"znlog","znlog",4,"GG",Ggen,0,GPpari},
{"znorder","order",4,"G",Ggen,0,GPpari},
{"znprimroot","ggener",4,"G",Ggen,0,GPpari},
{"znstar","znstar",4,"G",Ggen,0,GPpari},

#include "supfunc.h"

{NULL,NULL,0,NULL,Gnotype,0,-1} /* sentinel */
};
