/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

int varlistaff(int sava, int savc, affnode **ran)
{
  affnode *an;
  int nb;
  size_t size;
  int i,j;
  for (i=sava,nb=0;i<naff;i++)
  {
    if (affstack[i].idx<savc)
      nb++;
  }
  size=nb*sizeof(affnode);
  if (size)
  {
    an=malloc(size);
    for (i=sava,j=0;i<naff;i++)
      if (affstack[i].idx<savc)
      {
	an[j]=affstack[i];
	j++;
      }
    if (j!=nb) die(-1,"Internal error: varlistaff");
  }
  else an=NULL;
  *ran=an;
  return nb;
}
void varlistvar(int idx)
{
  ctxvar *v=ctxstack+idx;
  if (v->flag&(1<<Carg))
    return;
  if (v->t==Gnotype)
  {
    /*    if (findnewentry(v->var)==-1)
	  newaff(AFaffect,idx); */
    /*else it was a very hidden function call*/
  }
  else 
  {
    if (v->initval>=0)
    {
      varlist(v->initval);
      newaff(AFaffect,idx); 
    }
  }
}
void varlist(int n)
{
  int i,x,y,nv;
  int v,savc,sava,savb;
  gpfunc *gp;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Faffect:
    if (tree[x].f!=Fentry)
      varlist(x);
    varlist(y);
    v=getvarerr(getlvaluerr(x));
    if (isfunc(y,"clone"))
      newaff(AFclone,v);
    else
      newaff(AFaffect,v);
    break;
  case Ftag:
    varlist(x);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case Fgnil:
  case FtrucQ:
    break;
  case Frefarg:
    v=getvarerr(n);
    newaff(AFrefarg,v);
    break;
  case Fentry:
    v=getvar(n);
    if (v>=0)
      newaff(AFaccess,v);
    /*else it is an hidden function call*/
    break;
  case Fentryfunc:
    varlist(y);
    /*FIXME: add true parsing of description*/
    if (x>=OPss && x<=OPme)
    {
      int arg[STACKSZ];
      int nb=genlistargs(n,arg,0,STACKSZ);
      if (nb)
	newaff(AFrefarg,getvarerr(getlvaluerr(arg[0])));
    }
    else
    {
      int fc=findfunction(x,&gp);
      if (fc>=0)
      {
	userfunc *uf=lfunc+fc;
	int base=lfunc[currfunc].savb;
	int i;
	char *c;
	c=malloc(base);
	memset(c,0,base);
	for(i=0;i<uf->nvar;i++)
	{
	  affnode *an=uf->var+i;
	  if (an->idx<base && ctxstack[an->idx].flag&(1<<Cglobal)
	      && an->f!=AFaccess && c[an->idx]==0)
	  {
	    c[an->idx]=1;
	    newaff(AFaffect,an->idx);
	  }
	}
	free(c);
      }
    }
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      int entry=tree[funcid].x;
      int savcf=currfunc;
      userfunc *uf;
      /*get func number and context*/
      currfunc=findnewentry(value[entry].val.str);
      uf=lfunc+currfunc;
      savc=nctx;
      uf->savb=savc;
      sava=naff;
      varlist(y);
      if (uf->var)
	free(uf->var);
      nv=varlistaff(sava,savc,&uf->var);
      if (nv!=uf->nvar)
	lastpass=1;
      uf->nvar=nv;
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=nctx;
    sava=naff;
    bl=block+tree[n].x;
    for (i=0;i<bl->n;i++)
    {
      ctxvar *v=bl->c+i;
      int nv=getvarbyname(v->var);
      if (nv!=-1)
	newaff(AFhide,nv);
    } 
    pushctx(bl);
    savb=nctx;
    for(i=0;i<bl->n;i++)
      varlistvar(savc+i);
    varlist(y);
    if (bl->var)
      free(bl->var);
    nv=varlistaff(sava,savb,&bl->var);
    if (nv!=bl->nvar)
      lastpass=1;
    bl->nvar=nv;
    bl->savb=savb;
    copyctx(savc,bl);
    nctx=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in varlist",
	  (tree[n].f>=0?Ffuncname[tree[n].f]:"<0"));
    varlist(x);
    varlist(y);
  }
}
