/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
int indent=0;
extern int indentlevel;
void genindent(FILE *fout)
{
  int i;
  for (i=0;i<indent*indentlevel;i++)
    fputc(' ',fout);
}
void genindentseq(FILE *fout, int n)
{
  if (n==-1 || (tree[n].m&(1<<Msemicomma)))
    return;
  genindent(fout);
}
void gensemicomma(FILE *fout, int x)
{
  if (x!=-1 && !(tree[x].m&(1<<Msemicomma)))
    fprintf(fout,";\n");
}
void genparens(FILE *fout, int x)
{
  if (x!=-1 && (tree[x].m&(1<<Mparens)))
    fprintf(fout,"(");
  gencode(fout,x);
  if (x!=-1 && (tree[x].m&(1<<Mparens)))
    fprintf(fout,")");
}
extern int optcleanvar;
void genbrace(FILE *fout, int x)
{
  if (x==-1) return;
  /*If it is an empty block, cross it*/
  if (tree[x].f==Fblock && (tree[x].m&(1<<Mbrace)) && !optcleanvar )
    genbrace(fout,tree[x].y);
  else
  {
    int brace=(tree[x].f==Fseq || (tree[x].m&(1<<Melse)));
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"{\n");
    }
    indent++;
    genindentseq(fout,x);
    gencode(fout,x);
    gensemicomma(fout,x);
    indent--;
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"}\n");
    }
  }
}

void gensmallval(FILE *fout, int val, Gtype t)
{
  switch(val)
  {
    case 0:
      fprintf(fout,(ctype[t]==Vsmall)?"0":"gzero");
      break;
    case 1:
      fprintf(fout,(ctype[t]==Vsmall)?"1":"gun");
      break;
    case 2:
      fprintf(fout,(ctype[t]==Vsmall)?"2":"gdeux");
      break;
    default:
      die(-1,"Internal error:val %d unhandled in gensmallval",val);
  }
}
void genfacteuraff(FILE *fout, int x, int z)
{
  int tx=tree[x].t;
  int tz;
  tz=tree[z].t;
  gencode(fout,x);
  fprintf(fout," = ");
  if (tree[x].f==Ffacteurmat && tree[z].f==Fentry && ctype[tree[z].t]==Vgen) 
    fprintf(fout,"gcopy(");
  gencast(fout,z,tx);
  if (tree[x].f==Ffacteurmat && tree[z].f==Fentry && ctype[tree[z].t]==Vgen)
    fprintf(fout,")");
}
  void 
genfacteurmat(FILE *fout, int x, int y)
{ 
  /*
     int stack[STACKSZ];
     listtostackparent(n,Ffacteurmat,stack,0,STACKSZ,"indices",n);
   */
  int yx=tree[y].x;
  int yy=tree[y].y;
  switch(tree[y].f)
  { 
    case FmatrixR:
    case Fmatrix:
      if(yy==-1)
      {
	fprintf(fout,"(GEN)");      
	genparens(fout,x);
	fprintf(fout,"[");
	gencast(fout,yx,Gsmall);
	fprintf(fout,"]");
      }
      else
      {
	fprintf(fout,"gcoeff(");
	gencode(fout,x);
	fprintf(fout,", ");
	gencast(fout,yx,Gsmall);
	fprintf(fout,", ");
	gencast(fout,yy,Gsmall);
	fprintf(fout,")");
      }
      break; 
    case FmatrixL:
      die(y,"[n,] not implemented, sorry");
      break;
    default:
      die(y,"Internal error:genfacteurmat: unhandled func %d",tree[y].f);
  }
}

/*If there is no suitable GP prototype, just print nothing*/
void geninstall(FILE *fout, int nf)
{
  int i;
  int nargs=0;
  gpfunc *gp=&lfunc[nf].gp;
  context *fc=block+lfunc[nf].bl;
  char *c;
  switch(ctype[gp->type])
  {
    case Vgen:
      c="";
      break;
    case Vsmall:
      c="l";
      break;
    case Vvoid:
      c="v";
      break;
    default:
      return;
  }
  for (i=0;i<fc->n;i++)
    if ( fc->c[i].flag&(1<<Carg) )
      switch(ctype[fc->c[i].t])
      {
	case Vsmall:
	case Vgen:
	case Vstr:
	  nargs++;
	  break;
	default:
	  return;
      }
  fprintf(fout,"install(\"%s\",\"%s",gp->cname,c);
  for (i=0;i<fc->n;i++)
    if ( fc->c[i].flag&(1<<Carg) )
    {
      if (ctype[fc->c[i].t]==Vsmall || ctype[fc->c[i].t]==Vgen)
      {
	fprintf(fout,"D");
	if (fc->c[i].initval>=0)
	  printnode(fout,fc->c[i].initval);
	else
	  fprintf(fout,"0");
      }
      switch(ctype[fc->c[i].t])
      {
	case Vsmall:
	  fprintf(fout,",L,");
	  break;
	case Vgen:
	  fprintf(fout,",G,");
	  break;
	case Vstr:
	  fprintf(fout,"s");
	  break;
	default:
	  die(-1,"Argument type not supported by GP.");
      }
    }
  if (gp->mode&(1<<Mprec))
    fputc('p',fout);
  fprintf(fout,"\",\"%s_c\",\"./%s.so\")\n",gp->gpname,nameparse);
}
void genheader(FILE *fout)
{
  int i;
  fprintf(fout,"/*-*- compile-command: \"");
  fprintf(fout,PARI_MODULE_BUILD,nameparse,nameparse,nameparse);
  fprintf(fout,"\"; -*-*/\n");
  printf("#include <pari/pari.h>\n");
  printf("/*\n");
  for(i=0;i<nfunc;i++)
    geninstall(fout,i);
  printf("*/\n");
  for(i=0;i<nfunc;i++)
  {
    genprototype(fout,i);
    fprintf(fout,";\n");
  }
  fprintf(fout,"/*End of prototype*/\n\n");
  if (nctx)
  {
    for(i=0;i<nctx;i++)
    {
      ctxvar *v=ctxstack+i;
      fprintf(fout,"static ");
      fprintf(fout,cname[ctype[v->t]],v->var);
      fprintf(fout,";\n");
    }
    fprintf(fout,"/*End of global vars*/\n\n");
  }
}

void gencode(FILE *fout, int n)
{
  int x=tree[n].x;
  int y=tree[n].y;
  if (n<0)
    return; 
  if (debug>=3) fprintf(fout,"/*%s:%d*/",Gname[tree[n].t],tree[n].m);
  switch(tree[n].f)
  {
  case Fseq:
    genindentseq(fout,x);
    gencode(fout,x);
    gensemicomma(fout,x);
    genindentseq(fout,y);
    gencode(fout,y);
    gensemicomma(fout,y);
    break;
  case Fmatrix:
  case FmatrixL:
  case FmatrixR:
    die(-1,"Internal error: Fmatrix* in gencode");
    /*all this stuff is handled by Ffacteurmat*/
    break;
  case Ffacteurmat:
    genfacteurmat(fout,x,y);
    break;
  case Faffect:
    genfacteuraff(fout,x,y);
    break;
  case Fconst:
    if (value[x].type==Vsmall)
      fprintf(fout,"%ld",value[x].val.small);
    else
      fprintf(fout,"flisexpr(\"%s\")",value[x].val.str);
    break;
  case Fstring:
    fprintf(fout,"\"%s\"",value[x].val.str);
    break;
  case Fsmall:
    fprintf(fout,"%d",tree[n].x);
    break;
  case FtrucQ:
    fprintf(fout,"polx[fetch_user_var(\"%s\")]",value[x].val.str);
    break;
  case Femptyvec:
    fprintf(fout,"cgetg(1,t_VEC)");
    break;
  case Femptymat:
    fprintf(fout,"cgetg(1,t_MAT)");
    break;
  case Fmatrixelts:
  case Fmatrixlines:
  case Fmat:
    /*handled by genblockmatrix*/
  case Flistarg:
    /*handle by Fentry*/
    die(-1,"Internal error: %s in gencode",Ffuncname[tree[n].f]);
    break;
  case Frefarg:
  case Fentry:
    genentry(fout,n);
    break;
  case Fentryfunc:
    genentryfunc(fout,n);
    break;
  case Fdeffunc:
    gendeffunc(fout,n);
    break;
  case Fblock:
    gendefblock(fout,n);
    break;
  case Fgnil:
    fprintf(fout,"0");
    break;
  case Ftag:
    gencast(fout,x,y);
    break;
  default:
    die(n,"Internal error : unknow func %s in gencode",Ffuncname[tree[n].f]);
    break;
  }
}
