/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
extern gpfunc listfunc[];
gpdesc *newdesc(int nb)
{
  gpdesc *gd;
  gd=malloc(sizeof(*gd));
  gd->nb=nb;
  gd->a=calloc(nb,sizeof(*(gd->a)));
  return gd;
}
descargatom strtoargs(char *s)
{
  descargatom aa;
  int t;
  switch(*s)
  {
    case '&':
      aa.t=AAreftype;
      break;
    case '#':
      aa.t=AAherevalue;
      break;
    case '*':
      aa.t=AAlvalue;
      break;
    case '@':
      aa.t=AAmulti;
      break;
    default:
      t=strtotype(s);
      if (t==-1)
      {
	aa.t=AAsmall;
	aa.v=atol(s);
      }
      else
      {
	aa.t=AAtype;
	aa.v=t;
      }
      return aa;
  }
  t=strtotype(s+1);
  if (t==-1)
    die(-1,"bad reference in description file");
  aa.v=t;
  return aa;
}
void readentry(FILE *f, char *buf, int len)
{
  if (!fgets(buf,len,f))
    perror("gp2c");
  if (!*buf)
    die(-1,"Bad description file <entry>");
  buf[strlen(buf)-1]=0;
}

int readnumber(FILE *f, char *buf, int len)
{
  readentry(f,buf,len);
  return atol(buf);
}
void initdesc(char *descfile)
{
  char buf[1024];
  FILE *dfile;
  if (!(dfile=fopen(descfile,"r")))
  {
    fprintf(stderr,"Cannot find description file %s\n",descfile);
    exit(1);
  }
  while(!feof(dfile))
  {
    int i;
    int nf,nb;
    gpdesc *gd;
    if (!fgets(buf,1024,dfile))
      break;
    if (!*buf)
      die(-1,"Bad description file <desc>");
    buf[strlen(buf)-1]=0;
    nf=findentry(buf);
    if (nf==-1)
      die(-1,"Incorrect description file %s: function %s not found",descfile,buf);
    nb=readnumber(dfile,buf,1024);
    gd=newdesc(nb);
    for(i=0;i<nb;i++)
    { 
      int j,nb;
      readentry(dfile,buf,1024);
      gd->a[i].cname=strdup(buf);
      gd->a[i].nargs=readnumber(dfile,buf,1024);
      if (gd->a[i].nargs)
      	gd->a[i].args=calloc(gd->a[i].nargs,sizeof(*gd->a[i].args));
      else
	gd->a[i].args=NULL;
      for(j=0;j<gd->a[i].nargs;j++)
      {
	readentry(dfile,buf,1024);
	gd->a[i].args[j]=strtoargs(buf);
      }
      nb=readnumber(dfile,buf,1024);
      gd->a[i].mode=0;
      if (nb)
      {
	readentry(dfile,buf,1024);
	gd->a[i].type=nodetype(buf);
	for(j=1;j<nb;j++)
	{
	  readentry(dfile,buf,1024);
	  gd->a[i].mode|=(1<<nodemode(buf));
	}
      }
      else
	gd->a[i].type=Ggen;
    }
    listfunc[nf].dsc=gd;    
  }
  fclose(dfile);
}

gpdescarg *descfindrules(int nb, int *arg, gpdesc *dsc)
{
  int i;
  int best=-1,score;
  gpdescarg *ga=dsc->a;
  for(i=0;i<dsc->nb;i++)
  {
    int sc=0;
    int haslvalue=0;
    int j;
    descargatom *da=ga[i].args;
    if (nb!=ga[i].nargs)
      continue;
    for(j=0;j<nb;j++)
    {
      int t=tree[arg[j]].t;
      switch(da[j].t)
      {
      case AAtype:
	if (arg[j]>=0 && typemax[t][da[j].v]==da[j].v)
	  continue;
	if (arg[j]>=0 && typemax[t][da[j].v]==t)
	{
	  sc++;
	  continue;
	}
	break;
      case AAsmall:
	if (arg[j]>=0 && tree[arg[j]].f==Fsmall && tree[arg[j]].x==da[j].v)
	  continue;
	break;
      case AAreftype:
	if (arg[j]>=0 && tree[arg[j]].f==Frefarg && typemax[t][da[j].v]==t && ctype[t]==ctype[da[j].v])
	  continue;
	break;
      case AAherevalue:
	if (arg[j]>=0 && typemax[t][da[j].v]==da[j].v
	    && (tree[arg[j]].f==Fsmall  || tree[arg[j]].f==Fconst))
	  continue;
	break;
      case AAlvalue:
	if (arg[j]>=0 && t==da[j].v && getlvalue(arg[j])>=0)
	{
	  haslvalue=1;  
	  continue;
	}
	break;
      case AAmulti:
        if (arg[j]>=0 && (tree[arg[j]].f==Fentry || tree[arg[j]].f==Fsmall))
          continue;
	if (arg[j]>=0 && t==da[j].v)
	  warning(arg[j],"Only variable are allowed for this function, sorry");
	break;
      default:
	die(-1,"Internal error unknown AAvalue in gpdescarg");
      }
      break;
    }
    if (j<nb)
      continue;
    if (sc==0)
    {
      best=i;
      break;
    }
    if (best==-1 || sc<score || (haslvalue && sc==score))
    {
      score=sc;
      best=i;
    }
  }
  return (best==-1)?NULL:ga+best;
}
Gtype gentypefuncdesc(int n, gpfunc *gp)
{
  int arg[STACKSZ];
  int nb;
  int y=tree[n].y;
  gpdescarg *rule;
  if ( y!=-1 )
  {
    gentype(y);
    tree[n].m|=tree[y].m&MODHERIT;
  }
  nb=genlistargs(n,arg,0,STACKSZ);
  rule=descfindrules(nb,arg,gp->dsc);
  if (!rule)
  {
    if(default_type==Gnotype)
      warning(n,"no rules matching %s()",gp->gpname);
    return Gnotype;
  }
  tree[n].m|=rule->mode;
  return rule->type;
}
enum {FBparens} flagbit;
void genentrydesc(FILE *fout, int n, gpfunc *gp)
{
  int arg[STACKSZ];
  char buf[STACKSZ];
  int nb;
  char *p,*q;
  int mode,flag;
  gpdescarg *rule;
  nb=genlistargs(n,arg,0,STACKSZ);
  rule=descfindrules(nb,arg,gp->dsc);
  if (!rule)
  {
    die(n,"no rules matching %s()",gp->gpname);
    return ;
  }
  p=rule->cname;
  mode=0;flag=0;
  do
  {
    switch(mode)
    {
    case 0:
      if (*p=='$')
	mode=1;
      else if (*p)
	fputc(*p,fout);
      break;
    case 1:
      switch(*p)
      {
      case '(':
 	flag|=(1<<FBparens);
	break;
      case '"':
	q=memccpy(buf,p+1,'"',STACKSZ-1);
	if (!q)
	  die(n,"Unfinished \" in description");
	*(q-1)=0;
	die(n,buf);
      case 0:
	die(n,"Unfinished $ in description");
      default:
	if(isdigit(*p))
	{
	  mode=2;
	  q=p;
	}
      }
      break;
    case 2:
      if (!isalnum(*p))
      {
	if (q!=p)
	{
	  int x=0;
	  while(q<p)
	    x=x*10+(*q++)-'0';
	  if (--x>nb)
	    die(n,"Too few args for function description %s",rule->cname); 
	  if (flag&(1<<FBparens))
	  {
	    if (*p!=')')
	      die(n,"Missing parens in function description %s",rule->cname);
	    gencastf(fout,arg[x],rule->args[x].v,1);
	  }
	  else
	  {
	    gencast(fout,arg[x],rule->args[x].v);
	    if (*p) fputc(*p,fout);
	  }
	}
	else if (*p)
	  fputc(*p,fout);
	mode=0;
	flag=0;
      }
      break;
    }
  }while(*p++);
}
