%{
#define YYDEBUG 1
#define YYERROR_VERBOSE 1
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
int linecount,errs;
int yyerror(char *s);
int yylex(void);

%}
%expect 2
%union {
  int val;
  char str[1025];
}
%token <str> KCONST
%token <str> KENTRY
%token <str> KSTRING
%token KSTART 
%left KEOC
%left ';' ','
%left CAT
%right CATR
%right '=' KPE KSE KME KDE KDRE KEUCE KMODE KSRE KSLE
%left '&' KAND '|' KOR 
%left KEQ KNE KGE '<' KLE '>' 
%left '+' '-'
%left KSR KSL 
%left '%' KDR '\\' '/' '*'
%left SIGN
%right '^'
%left '!' '~' '[' '\''
%left '.' MAT
%left MAT2
%token KPP KSS 
%left ':'
%left TAG2

%type <val> commands seq matrix matrix_index expr truc
%type <val> string lvalue 
%type <val> matrixelts matrixlines arg listarg constante definition 
%type <val> funcid memberid
%start commands
%%
commands: KSTART {$$=-1;}
        | commands seq KEOC {$$=($1==-1)?$2:newnode(Fseq,$1,$2);}
	| commands KEOC     {$$=$1;}
;

semicommas: /*empty*/
          | semicommas ';'
;

seq: semicommas expr     {$$=$2;}
   | seq ';' expr {$$=newnode(Fseq,$1,$3);}
   | seq error    {$$=$1;errs++;}/*discard erroneous expr*/
   | seq ';'      {$$=$1;}
;


matrix_index: '[' expr ',' expr ']' {$$=newnode(Fmatrix,$2,$4);}
            | '[' expr ']' {$$=newnode(Fmatrix,$2,-1);}
            | '[' expr ',' ']' {$$=newnode(FmatrixL,$2,-1);}
            | '[' ',' expr ']' {$$=newnode(FmatrixR,$3,-1);}
;

expr: truc {$$=$1;}
    | string {$$=$1;}
    | lvalue '=' expr {$$=newnode(Faffect,$1,$3);}
    | lvalue KPP {$$=newopcall(OPpp,$1,-1);}
    | lvalue KSS {$$=newopcall(OPss,$1,-1);}
    | lvalue KME expr {$$=newopcall(OPme,$1,$3);}
    | lvalue KDE expr {$$=newopcall(OPde,$1,$3);}
    | lvalue KDRE expr {$$=newopcall(OPdre,$1,$3);}
    | lvalue KEUCE expr {$$=newopcall(OPeuce,$1,$3);}
    | lvalue KMODE expr {$$=newopcall(OPmode,$1,$3);}
    | lvalue KSLE expr {$$=newopcall(OPsle,$1,$3);}
    | lvalue KSRE expr {$$=newopcall(OPsre,$1,$3);}
    | lvalue KPE expr {$$=newopcall(OPpe,$1,$3);}
    | lvalue KSE expr {$$=newopcall(OPse,$1,$3);}
    | '!' expr 	      {$$=newopcall(OPnb,$2,-1);}
    | expr KOR  expr  {$$=newopcall(OPor,$1,$3);}
    | expr '|'  expr  {$$=newopcall(OPor,$1,$3);}
    | expr KAND expr  {$$=newopcall(OPand,$1,$3);}
    | expr '&'  expr  {$$=newopcall(OPand,$1,$3);}
    | expr KEQ  expr  {$$=newopcall(OPeq,$1,$3);}
    | expr KNE  expr  {$$=newopcall(OPne,$1,$3);}
    | expr KGE  expr  {$$=newopcall(OPge,$1,$3);}
    | expr '>'  expr  {$$=newopcall(OPg,$1,$3);}
    | expr KLE  expr  {$$=newopcall(OPle,$1,$3);}
    | expr '<'  expr  {$$=newopcall(OPl,$1,$3);}
    | expr '-'  expr  {$$=newopcall(OPs,$1,$3);}
    | expr '+'  expr  {$$=newopcall(OPp,$1,$3);}
    | expr KSL  expr  {$$=newopcall(OPsl,$1,$3);}
    | expr KSR  expr  {$$=newopcall(OPsr,$1,$3);}
    | expr '%'  expr  {$$=newopcall(OPmod,$1,$3);}
    | expr KDR  expr  {$$=newopcall(OPdr,$1,$3);}
    | expr '\\' expr  {$$=newopcall(OPeuc,$1,$3);}
    | expr '/'  expr  {$$=newopcall(OPd,$1,$3);}
    | expr '*'  expr  {$$=newopcall(OPm,$1,$3);}
    | '+' expr %prec SIGN {$$=newopcall(OPpl,$2,-1);}
    | '-' expr %prec SIGN {$$=newopcall(OPn,$2,-1);}
    | expr '^' expr {$$=newopcall(OPpow,$1,$3);}
    | expr '~' {$$=newopcall(OPtrans,$1,-1);}
    | expr '\'' {$$=newopcall(OPderiv,$1,-1);}
    | expr '!'  {$$=newopcall(OPfact,$1,-1);}
    | expr matrix_index %prec MAT {$$=newnode(Ffacteurmat,$1,$2);}
    | memberid {$$=$1;}
    | expr ':' KENTRY   {$$=newnode(Ftag,$1,nodetype($3));}
    | lvalue	{$$=$1;}
    | '(' expr ')' {$$=$2;}
;
/*Note for the non french-speakers: truc and machin are the french
words for "things" "stuff", "foo", "bar" and the like. Commonly used 
words include "bidule" and "chose". Have fun !*/

lvalue: KENTRY              {$$=newnode(Fentry,newuserentry($1),-1);}
      | lvalue matrix_index %prec MAT2 {$$=newnode(Ffacteurmat,$1,$2);}
      | lvalue ':' KENTRY   %prec TAG2 {$$=newnode(Ftag,$1,nodetype($3));}
;

truc: funcid {$$=$1;}
    | constante  {$$=$1;}
    | '\'' KENTRY {$$=newnode(FtrucQ,newvalue(FtrucQ,$2),-1);}
    | matrix {$$=$1;}
    | definition    {$$=$1;} /* Yes it's insane, but it's how POSIX gp is defined*/

/*  '%' thinggies skipped here*/
;

matrixelts: expr {$$=$1;}
          | matrixelts ',' expr {$$=newnode(Fmatrixelts,$1,$3);}
;

matrixlines: matrixelts {$$=$1;} 
           | matrixlines ';' matrixelts {$$=newnode(Fmatrixlines,$1,$3);}
;

matrix: '[' ']' {$$=newnode(Femptyvec,-1,-1);}
      | '[' ';' ']' {$$=newnode(Femptymat,-1,-1);}
      | '[' matrixlines ']' {$$=newnode(Fmat,$2,-1);}
;

arg: /*empty*/  {$$=GNOARG;}
   |  seq       {$$=$1;}
   | '&' KENTRY {$$=newnode(Frefarg,newuserentry($2),-1);}
;
listarg: arg {$$=$1;}
       | listarg ',' arg {$$=newnode(Flistarg,$1,$3);}
;

funcid: KENTRY '(' listarg ')' {$$=newnode(Fentryfunc,newuserentry($1),$3);} 
;

memberid: expr '.' KENTRY  {$$=newnode(Fentryfunc,newmember($3),$1);}
;

definition: funcid '=' seq KEOC {$$=newnode(Fdeffunc,$1,$3);}
          | memberid '=' seq KEOC {$$=newnode(Fdeffunc,$1,$3);}
;

string: KSTRING {$$=newnode(Fstring,newvalue(Fstring,$1),-1);}
;

constante: KCONST  {$$=newconstnode($1);}
/*	 | string {$$=$1;}*/
;

%%
int yyerror(char * s)
{ 
  fprintf(stderr,"%s:%d: %s\n",nameparse,linecount,s);
  return 0;
}
