/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"

static int toplevel=0;
int initnode=0;
extern char *optprefix;  
char *nameinitfunc(void)
{
  const char *initname="init_";
  char *p,*q,*name,*pref="";
  if (optprefix)
    pref=optprefix;
  name=calloc(strlen(pref)+strlen(initname)+strlen(nameparse)+1,sizeof(*name));
  sprintf(name,"%s%s",pref,initname);
  q=name+strlen(name);
  for(p=nameparse;*p && *p!='.';p++,q++)
    if (isalnum(*p))
      *q=*p;
    else
      *q='_';
  *q=0;
  return name;
}
int addinitfunc(int n)
{
  int code;
  int i;
  int ret;
  char *name;
  /*if (!nctx && toplevel==0) return n; */
  name=nameinitfunc();
  code=toplevel?toplevel:-1;
  for(i=0;i<nctx;i++)
  {
    ctxvar *v=ctxstack+i;
    if (v->initval>=0)
      code=addseqleft(newnode(Faffect,newnode(Fentry,newentry(v->var),-1),v->initval),code);
    else
      code=addseqleft(newnode(Faffect,newnode(Fentry,newentry(v->var),-1),GNIL),code);
  }
  code=addseqright(code,GNIL);
  initnode=newnode(Fdeffunc,newnode(Fentryfunc,newentry(name),-1),code);
  newfunc(tree[initnode].x);
  ret=addseqright(initnode,n);
  return ret;
}
/*
  n: node
  p:parent node
*/
void gentoplevel(int n)
{
  int x,y;
  gpfunc *gp;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Fseq:
    if (x>=0 && tree[x].f!=Fdeffunc && tree[x].f!=Fseq)
    {
      if (isfunc(x,"local"))
	warning(x,"`local' at top level discarded");
      else if(isfunc(x,"global"))
      {
        int args[STACKSZ];
        int nb=genlistargs(x,args,0,STACKSZ-1);
        int i;
      	toplevel=addseqright(toplevel,x);
        for(i=0;i<nb;i++)
	  if (tree[args[i]].f==Faffect)
            toplevel=addseqright(toplevel,args[i]);
      }
      else
      	toplevel=addseqright(toplevel,x);
      tree[n].x=GNIL;
    }
    else
      gentoplevel(x);
    if (y>=0 && tree[y].f!=Fdeffunc)
    {
      if (isfunc(y,"local"))
	warning(y,"`local' at top level discarded");
      else
        toplevel=addseqright(toplevel,y);
      tree[n].y=GNIL;
    }
    else
      gentoplevel(y);
    break;
  case Fentryfunc:
    die(n,"Fentryfunc in toplevel");
    gentoplevel(y);
/*    if (isfunc(n,"global"))
      tree[n]=tree[GNIL];*/
    break;
  case Fdeffunc:
    if (findfunction(tree[x].x,&gp)!=-1)
      die(n,"Function %s already defined",gp->gpname);
    newfunc(x);
    break;
  case Frefarg:
  case Fentry:
  case Fconst:
  case Fstring:
  case Fsmall:
  case FtrucQ:
  case Fgnil:
    break;
  case Ftag:
    die(n,"Ftag in toplevel");
    gentoplevel(x);
    break;
  default:
    if (tree[n].f>=FneedENTRY)
    {
      die(n,"Internal error : unknown func %s in gentoplevel",funcname(tree[n].f));
    }
    else
    {
      gentoplevel(x);
      gentoplevel(y);
    }
  }
}

