/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*Patch for list of gp functions. Must be include after header.h.*/
typedef enum {GPuser_private,
	      GPgpmany,GPgplist,GPinstall,
	      GPgrandO,
	      GPbreak,GPnext,GPfor,GPforstep,GPforstepvec,GPforprime,GPforvec,GPglobal,GPif,GPlocal,GPprod,GPreturn,GPsum,GPuntil,GPwhile,GPprint,GPerror,
	      GPmakevec,GPmakemat,GPvector,GPvectorsmall,GPvectorv,GPmatrix,GPinitfunc
} GPspec_private;

struct patchfunc_s
{
  char *gpname;
  char *code;
  Gtype type;
  GPspec_private mode;
  int spec;
} patchfunc[]={
/*Override previous definition in pari/src/init.c*/
{"O",NULL,Ggen,0,GPgrandO},
{"break",NULL,Gvoid,0,GPbreak},
{"next",NULL,Gvoid,0,GPnext},
{"for","GGIG",Gnotype,(1<<Msemicomma),GPfor},
{"forstep","GIGGGG",Gnotype,(1<<Msemicomma),GPforstep},
{"forvec","GIGGGG",Gnotype,(1<<Msemicomma),GPforvec},
{"forprime","GGGGGI",Gnotype,(1<<Msemicomma),GPforprime},
{"if","GII",Gnotype,(1<<Msemicomma),GPif},
{"prod","GGIG",Gnotype,(1<<Msemicomma),GPprod},
{"return",NULL,Gnotype,(1<<Mterm),GPreturn},
{"sum","GGIG",Gnotype,(1<<Msemicomma),GPsum},
{"until","EI",Gnotype,(1<<Msemicomma),GPuntil},
{"vector","GGGGIG",Gnotype,(1<<Msemicomma),GPvector},
{"vectorsmall","GGGGIG",Gnotype,(1<<Msemicomma),GPvectorsmall},
{"vectorv","GGGGIG",Gnotype,(1<<Msemicomma),GPvectorv},
{"matrix","GGGGGGGGGGI",Gnotype,(1<<Msemicomma),GPmatrix},
{"while","EI",Gnotype,(1<<Msemicomma),GPwhile},
/* New definition*/
{"local",NULL,Gnotype,(1<<Msemicomma),GPlocal},
{"global",NULL,Gnotype,(1<<Msemicomma),GPglobal},
{"print",NULL,Gvoid,(1<<Msidef),GPprint},
{"print1",NULL,Gvoid,(1<<Msidef),GPprint},
{"printp",NULL,Gvoid,(1<<Msidef),GPprint},
{"printp1",NULL,Gvoid,(1<<Msidef),GPprint},
{"error",NULL,Gvoid,(1<<Msidef)|(1<<Mterm),GPerror},
{"_makevec",NULL,Gnotype,(1<<Msemicomma),GPmakevec},
{"_makemat",NULL,Gnotype,(1<<Msemicomma),GPmakemat},
{"_gerepilelist",NULL,Ggptr,0,GPgplist},
{"_gerepilemany",NULL,Gvoid,(1<<Msemicomma),GPgpmany},
{"_initfunc","",Gvoid,(1<<Msemicomma),GPinitfunc},
{"forstepvec","GIGGGG",Gnotype,(1<<Msemicomma),GPforstepvec},
{"install",NULL,Gnotype,(1<<Msemicomma),GPinstall},
{NULL,NULL,0,0,0}};
