/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include "header.h"
char *nameparse;
void die(int n, char *format, ...)
{
  va_list ap;
  va_start(ap, format);
  if (n>0)
    fprintf(stderr,"%s:%d:",nameparse,tree[n].lineno);
  else
    fprintf(stderr,"%s:%s:",nameparse,currfunc==-1?"toplevel":lfunc[currfunc].gpname); 
  vfprintf(stderr,format,ap);
  fprintf(stderr,"\n"); 
  printnode(stderr,n);
  fprintf(stderr,"\n"); 
  exit(1);
}
void warning(int n, char *format, ...)
{
  va_list ap;
  va_start(ap, format);
  if (n>0)
    fprintf(stderr,"Warning:%s:%d:",nameparse,tree[n].lineno);
  else
    fprintf(stderr,"Warning:%s:%s:",nameparse,currfunc==-1?"toplevel":lfunc[currfunc].gpname); 
  vfprintf(stderr,format,ap);
  fprintf(stderr,"\n"); 
  printnode(stderr,n);
  fprintf(stderr,"\n");
  va_end(ap);
}

int listtostack(int n, int f, int *stack, int nbmax, char *error,int nerr)
{
  int x,i,nb;
  if (n==-1) return 0;
  for(x=n,i=0;tree[x].f==f && i<nbmax;x=tree[x].x,i++);
  if (i==nbmax)
    die(nerr,"Too many args for `%s'",error);
  nb=i+1;
  for(x=n;i>0;stack[i]=tree[x].y,x=tree[x].x,i--);
  stack[0]=x;
  return nb;
}
int listtostackparent(int n, int f, int *stack, int nbmax, char *error,int nerr)
{
  int x,i,nb;
  if (n==-1) return 0;
  nbmax--;
  for(x=n,i=0;tree[x].f==f && i<nbmax;x=tree[x].x,i++);
  if (i==nbmax)
    die(nerr,"Too many args for `%s'",error);
  nb=i--;
  for(x=n;i>=0;stack[i]=x,x=tree[x].x,i--);
  return nb;
}
int genlistargs(int n,int *stack,int min,int max)
{
  char *name=value[tree[n].x].val.str;
  int y=tree[n].y;
  int nb=(y==GNOARG)?0:listtostack(y,Flistarg,stack,max,name,n);
  if(nb<min)
    die(n,"Too few args for `%s'",name);
  return nb;
}

PPproto parseproto(char const **q, char *c)
{
  char  const *p=*q;
  long i;
  switch(*p)
  {
  case 0:
    return PPend;
  case 'D':
    switch(p[1])
    {
    case 0:
      die(-1,"incomplete prototype");
    case 'G':
    case '&':
    case 'V':
    case 'I':
    case 'n':
      *c=p[1];
      *q=p+2;
      return PPdefault;
    default:
      for(i=0;*p && i<2;p++) i+=*p==',';
      if (i<2)
        die(-1,"incomplete prototype");
      *c=p[-2];
      *q=p;
      return PPdefaultmulti;
    }
    break;
  case '=':
    *c=*p;
    *q=p+1;
    return PPsep;
  case 's':
    if (p[1]=='*')
      p++;
  default:/*fall through*/
    *c=*p;
    *q=p+1;
    return PPstd;
    break;
  }
}
