/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"

static int newprivvar=1;
extern int initnode;
int newdecl(int flag, Gtype t, int initval, int *v)
{
  char s[33];
  sprintf(s,"p%d",newprivvar++);
  *v=newnode(Fentry,newentry(s),-1);
  return pushvar(*v,flag,t,initval);
}
int newcall(char *s, int y)
{
  return newnode(Fentryfunc,newentry(s),y);
}
int addseqleft(int n, int seq)
{
  int i;
  int bseq;
  if(seq==-1)
    return n;
  if (tree[n].f!=Fseq)
    return newnode(Fseq,n,seq);
  for(i=seq;tree[tree[i].x].f==Fseq;i=tree[i].x);
  bseq=newnode(Fseq,n,tree[i].x);
  tree[i].x=bseq;
  return seq;
}
int addseqright(int seq, int n)
{ 
  if(seq==-1)
    return n;
  return newnode(Fseq,seq,n);
}
int geninsertvar(int seq, int ret)
{
  int bseq;
  if (seq==-1)
    return -1;
  if (ret>=0)
  {
    if (tree[seq].f==Fseq)
    {  
      bseq=newnode(Faffect,ret,tree[seq].y);
      bseq=newnode(Fseq,tree[seq].x,bseq);
    }
    else
      bseq=newnode(Faffect,ret,seq);
  }
  else
    bseq=seq;
  return bseq;
}
int geninsertvarop(int seq, int ret, OPerator op)
{
  int bseq;
  if (seq==-1)
    return -1;
  if (ret>=0)
  {
    if (tree[seq].f==Fseq)
    {  
      bseq=newopcall(op,ret,tree[seq].y);
      bseq=newnode(Fseq,tree[seq].x,bseq);
    }
    else
      bseq=newopcall(op,ret, seq);
  }
  else
    bseq=seq;
  return bseq;
}

void makeblock(int bl, int n, int aseq, int ret, int savx)
{
  /*create a block*/
  tree[n].f=Fblock;
  tree[n].x=bl;
  block[bl].ret=ret;
  tree[n].y=aseq;
  copyctx(savx,block+bl);
  restorectx(savx);
}
void makeblocks(int bl1, int bl2, int n, int bseq, int aseq, int ret, int savx)
{
  int y;
  tree[n].f=Fblock;
  tree[n].x=bl1;
  block[tree[n].x].ret=ret;
  y=addseqright(bseq,newnode(Fblock,bl2,aseq));
  tree[n].y=y;
  copyctx(savx,block+bl2);
  restorectx(savx);
}
void genblockdeclaration(int args, int n, int flag)
{
  int stack[STACKSZ];
  int nb;
  int i;
  int var,val;
  Gtype tv;
  int mint;
  nb=listtostack(args,Flistarg,stack,STACKSZ,"function declaration",n);
  if (nb==1 && stack[0]==GNOARG)
    nb--;
  if (flag&(1<<Cuser))
    mint=Ggen;
  else
    mint=Gvoid;
  for(i=0;i<nb;i++)
  {
    switch(tree[stack[i]].f)
    {
    case Ftag:
      pushvar(tree[stack[i]].x,flag,tree[stack[i]].y,-1);
      break;
    case Fentry:
      pushvar(stack[i],flag,mint,-1);
      break;
    case Faffect:
      genequal(stack[i],"declaration",&var,&val,&tv);
      if ( tv==Gnotype )
	tv=mint;
      pushvar(var,flag,tv,val);
      genblock(val,-1);
      break;
    default:
      die(n,"Incorrect node %s in genblockdeclaration",
	  funcname(tree[stack[i]].f));
    }
  }
}
#if 0
/*The code for
  global(globalvars)
  f(args)=local(localvars);code;...
is */
{
  ulong ltop=avma;
  GEN p1;
  GEN *gptr[]={&p1,&globalsvar};
  {
    GEN args;
    GEN localvars;
    code;
    p1=...;
  }
  gerepilemany(ltop,gptr,N);
  return p1;
}
#endif
void genblockdeffunc(int n)
{
  int funcid=tree[n].x;
  int seq=tree[n].y;
  char *name=entryname(funcid);
  int args=tree[funcid].y;
  int bl1,bl2,gpm,ret,gltop;
  int savcf,savnpv;
  int sav1,sav2,aseq,bseq=-1,nodebl1,nodebl2;
  int vret;
  userfunc *ufunc;
  /*save global var*/
  savcf=currfunc;
  savnpv=newprivvar;
  /*reset private var counter*/
  newprivvar=1;
  /*create function*/
  currfunc=findfunction(entryname(funcid));
  if (currfunc<0)
    die(n,"internal error: unknow function %s in genblockdeffunc",name);
  if (lfunc[currfunc].spec!=GPuser)
    die(n,"internal error: not a user function %s in genblockdeffunc",name);
  ufunc=lfunc[currfunc].user;
  ufunc->node=n;
  /*create external block*/
  bl1=newblock();
  sav1=s_ctx.n;
  ufunc->bctx=sav1;
  if (autogc)
  {
    /*declare ltop*/
    gltop=newnode(Fentry,newentry("ltop"),-1);
    pushvar(gltop,1<<Cuser,Gulong,newcall("_avma",-1));
  }
  /*declare return var*/
  vret=newdecl((1<<Cauto)|(1<<Creturn),Gvoid,-1,&ret);
  
  /*create external block*/
  if (autogc)
  {
    int arg[4];
    block[bl1].gc|=(1<<GCneeded)|(1<<GCglobal);
    block[bl1].egc=vret;
    arg[0]=gltop;
    arg[1]=GNOARG;
    arg[2]=newnode(Fentry,newentry("gptr"),-1);
    arg[3]=newnode(Fsmall,bl1,-1);
    gpm=listtoseq(arg,4);
  }
  bl2=newblock();
  ufunc->bl=bl2;
  block[bl2].ret=ret;
  sav2=s_ctx.n;
  /*declare var of prototype*/
  genblockdeclaration(args,n,(1<<Cuser)|(1<<Carg));
  /*generate affectation with return var*/
  aseq=geninsertvar(seq,ret);
  /*generate block*/
  genblock(aseq,-1);
  if (n!=initnode)
  {
    /*FIXME: For now, clear Cglobal flag to avoid initialization 
      problem with implicit fetch_user_var().*/
    int i;
    for (i=sav1;i<s_ctx.n;i++)
    {
      if (ctxstack[i].flag&(1<<Cglobal))
	ctxstack[i].flag&=~(1<<Cglobal);
    }
  }
  aseq=addseqleft(newcall("_checkargs",-1),aseq);
  copyctx(sav2,block+bl2);
  restorectx(sav2);
  if (autogc)
  {
    int gptr=newnode(Fentry,newentry("gptr"),-1);
    int blo=newnode(Fsmall,bl1,-1);
    pushvar(gptr,1<<Cuser,Ggptr,newcall("_gerepilelist",blo));
    bseq=addseqright(bseq,newcall("_gerepilemany",gpm));
  }
  bseq=addseqright(bseq,newcall("return",newleaf(ret)));
  copyctx(sav1,block+bl1);
  restorectx(sav1);
  nodebl2=newnode(Fblock,bl2,aseq);
  nodebl1=newnode(Fblock,bl1,newnode(Fseq,nodebl2,bseq));
  tree[n].y=nodebl1;
  /*restore globalvar*/
  currfunc=savcf;
  savnpv=newprivvar;
}
int newvectoridx(int var, int ind)
{
  return newnode(Ffacteurmat,var,newnode(Fmatrix,newnode(Fsmall,ind,-1),-1));
}
int newmatidx(int var, int x, int y)
{
  return newnode(Ffacteurmat,var,newnode(Fmatrix,newnode(Fsmall,x,-1),
					 newnode(Fsmall,y,-1)));
}
void genblockmatrixl(int n, int x, int y)
{
  int arg[6];
  int var,bsup,seq,ret;
  int vx,vy,vsup;
  int savx,bl1,bl2;
  int aseq,bseq=-1;
  /*we have x[y,] x is a matrix, y a small*/
  newdecl((1<<Cauto)|(1<<Cconst),Gvoid,-1,&vx);
  newdecl((1<<Cconst),Gsmall,-1,&vy);
  newdecl((1<<Cconst),Glg,-1,&vsup);
  bsup=newcall("length",newnode(Ftag,newleaf(vx),Gvec));
  bseq=addseqright(bseq,geninsertvar(x,vx));
  bseq=addseqright(bseq,geninsertvar(y,vy));
  bseq=addseqright(bseq,geninsertvar(bsup,vsup));
  genblock(bseq,-1);
  newdecl(0,Gvec,-1,&ret);
  savx=s_ctx.n;
  bl1=newblock();
  bl2=newblock();
  newdecl(0,Gsmall,-1,&var);
  seq=newnode(Ffacteurmat,newleaf(vx),
      newnode(Fmatrix,newleaf(vy),newleaf(var)));
  arg[0]=ret;
  arg[1]=newleaf(vsup);
  arg[2]=newnode(Faffect,var,newnode(Fsmall,1,-1));
  arg[3]=newopcall(OPle,newleaf(var),vsup);
  arg[4]=newnode(Ffacteurmat,newleaf(ret),newnode(Fmatrix,newleaf(var),-1));
  arg[4]=geninsertvar(seq,arg[4]);
  genblock(arg[4],-1);
  arg[5]=newopcall(OPpp,newleaf(var),-1);
  aseq=newcall("vector",listtoseq(arg,6));
  makeblocks(bl1,bl2,n,bseq,aseq,ret,savx);
}
void genblockvector(int n)
{
  int arg[STACKSZ];
  int x=tree[n].x;
  int i,nb,ret;
  int aseq;
  nb=1+listtostack(x,Fmatrixelts,arg+1,STACKSZ-1,"Vector too long.",n);
  newdecl(0,Gvec,-1,&ret);
  arg[0]=ret;
  for(i=1;i<nb;i++)
    arg[i]=geninsertvar(arg[i],newvectoridx(newleaf(ret),i));
  for(i=1;i<nb;i++)
    genblock(arg[i],-1);
  aseq=newcall("_makevec",listtoseq(arg,nb));
  makeblock(newblock(),n,aseq,ret,s_ctx.n);
}
void genblockindex(int n)
{
  int ret,z;
  int aseq;
  newdecl((1<<Cconst),Gsmall,-1,&ret);
  z=newleaf(n);
  tree[z]=tree[n];
  aseq=geninsertvar(z,ret);
  makeblock(newblock(),n,aseq,ret,s_ctx.n);
}
void genblockmatrix(int n)
{
  int line[STACKSZ];
  int arg[STACKSZ];
  int x=tree[n].x;
  int i,j,k,nb=3,nbline,nbcol,ret;
  int aseq;
  nbline=listtostack(x,Fmatrixlines,line,STACKSZ,"Matrix too long.",n);
  for(i=0;i<nbline;i++)
  {
    int k;
    k=listtostack(line[i],Fmatrixelts,arg+nb,STACKSZ-nb,"Matrix too long.",n);
    if (i && k!=nbcol)
      die(n,"Matrix must be rectangular");
    nbcol=k;
    nb+=k;
  }
  newdecl(0,Gvec,-1,&ret);
  arg[0]=ret;
  arg[1]=newnode(Fsmall,nbline,-1);
  arg[2]=newnode(Fsmall,nbcol,-1);
  for(j=1,k=1,i=3;i<nb;i++)
  {
    arg[i]=geninsertvar(arg[i],newmatidx(newleaf(ret),k,j));
    if (j==nbcol)
    {
      j=1;
      k++;
    }
    else
      j++;
  }
  for(i=3;i<nb;i++)
    genblock(arg[i],-1);
  aseq=newcall("_makemat",listtoseq(arg,nb));
  makeblock(newblock(),n,aseq,ret,s_ctx.n);
}
/*
  n: node
  p:parent node
  
  Rule of the game:
  genblock may change the parent's node, so you need to do
  n=tree[p].x to recover the new n.

  genblock must never be used twice on the same node.
  Using p=-1 is allowed but discard the value of x.
  If p>0 genblock may change the parent's node, so you need to do
  n=tree[p].x to recover the new n, if needed.
*/
static long multi=0;
extern int linecount;
void genblock(int n, int p)
{
  int x,y;
  if (n<0)
    return;
  linecount=tree[n].lineno;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Fseq:
      genblock(x, n);
      genblock(y, n);
    break;
  case Fmat:
    if (tree[x].f==Fmatrixlines)
      /*if there is at least 2 lines it is a matrix*/
      genblockmatrix(n);
    else
      /*else it is a vector*/
      genblockvector(n);
    break;
  case Fmatrix:
  case FmatrixR:
    genblock(x,n);
    genblock(y,n);
    x=tree[n].x;
    y=tree[n].y;
    if (multi && x!=-1 && tree[x].f!=Fsmall)
      genblockindex(x);
    if (multi && y!=-1 && tree[y].f!=Fsmall)
      genblockindex(y);
    break;
  case Ffacteurmat:
    if ( tree[y].f==FmatrixL )
    {
      y=tree[n].y=tree[y].x;
      genblockmatrixl(n,x,y);
    }
    else
    {
      genblock(x,n);
      genblock(y,n);
    /*  x=tree[n].x; y=tree[n].y;*/
    }
    break;	
  case Frefarg:
  case Fentry:/*may be an hidden function call*/
    if (findfunction(entryname(n))==-1) /*it is not a function call*/
    {
      if (getvar(n)==-1)
      {/*The variable has not been declared*/
	pushvar(n,(1<<Cuser)|(1<<Cglobal),Gnotype,-1);
	if(warn) warning(n,"variable undeclared");
      }
      break;
    }/*else it is a function call*/
    tree[n].f=Fentryfunc;
  case Fentryfunc:/*fall through*/
    if (x==OPn && tree[y].f==Fsmall)
    {
      tree[n]=tree[y];
      tree[n].x=-tree[n].x;
    }
    /*FIXME: add true parsing of description*/
    if (x>=OPss && x<=OPme)
    {
      multi++;
      genblock(y,n);
      multi--;
    }
    else
    {
      int nf=findfunction(value[x].val.str);
      if (lfunc[nf].spec>0)
	genblockfuncspec(n,p,lfunc+nf);
      else
	genblock(y,n);
    }
    break;
  case Fdeffunc:
    if (currfunc!=-1)
      die(n,"nested function definition not implemented");
    genblockdeffunc(n);
    break;
  case Fconst:
  case Fstring:
  case Fsmall:
  case FtrucQ:
  case Fgnil:
    break;
  case Ftag:
    genblock(x,n);
    break;
  case Fblock:
    die(p,"Internal error : looping in genblock");
  default:
    if (tree[n].f>=FneedENTRY)
    {
      die(p,"Internal error : unknown func %s in genblock",funcname(tree[n].f));
    }
    else
    {
      genblock(x, n);
      genblock(y, n);
    }
  }
}

