%{      
#include "config.h"
#include <unistd.h>
#include "header.h"
#include "parse.h"
int linecount=1;
int yydebug;
static enum {Mread_lines,Min_braces} mode=Mread_lines;
static int terminate=-1,start=0;
static int lastcom=-1;
static void countline(char *text,int len)
{
  int i; 
  for (i=0; i<len; i++) 
    linecount+=(text[i]=='\n');
}
/* There are two start conditions:
-- toplevel 
-- INITIAL

We start at toplevel. As soon as we see a non toplevel command, we go to
INITIAL. When the command is completed, we revert to toplevel and emit a KEOC
(End Of Command) token to the parser. It is better to stay at toplevel when we
encounter non-command tokens (comments, white spaces).  

The mode can be
Mread_lines: line by line mode
Min_braces : inside braces
*/
%}
NUMBER [0-9]+
EXPO ("e"|"E")("+"|"-")?{NUMBER}
CONST ({NUMBER}("."[0-9]*)?|"."{NUMBER}){EXPO}?
STRING \"([^"\\]|(\\.))*\"
ENTRY [A-Za-z][A-Za-z0-9_]*
%x toplevel
%%
        if (!start) {start=1; BEGIN(toplevel); return KSTART;}
{ENTRY}	{ 	
		char *p2=yylval.str.s, *p1=yytext;
		int i,l=min(sizeof(yylval.str)/sizeof(char),yyleng);
		for (i=0; i<l; i++) p2[i]=p1[i];
		p2[l]=0;
		if (yydebug) fprintf(stderr,"[%s]",p2);
                yylval.str.c=lastcom; lastcom=-1;
		return KENTRY;
	}
{CONST}	{ 
		char *p2=yylval.str.s, *p1=yytext;
	  	int i,l=min(sizeof(yylval.str)/sizeof(char),yyleng);
		for (i=0; i<l; i++) p2[i]=p1[i];
		p2[l]=0;
		if (yydebug) fprintf(stderr,"[%s]",p2);
                yylval.str.c=lastcom; lastcom=-1;
		return KCONST;
	}
{STRING} { 
              char *p2=yylval.str.s, *p1=yytext;
              int i,l=min(sizeof(yylval.str)/sizeof(char), yyleng);
              for (i=1; i<l-1; i++) p2[i-1]=p1[i];
	      p2[i-1]=0;
	      if (yydebug) fprintf(stderr,"[%s]",p2);
	      countline(yytext,yyleng);
              yylval.str.c=lastcom; lastcom=-1;
	      return KSTRING; 
         }
<<EOF>>         {if (terminate++) return KEOC; else yyterminate();}

<toplevel>(##?[ \t\r]*|\\[a-z][^\n]*)$ {fprintf(stderr,"Warning:%s:%d: meta commands not implemented\n%s\n",
		  nameparse,linecount,yytext);}


"\\/"           return KDR;
">>"            return KSR;
"<<"            return KSL;
"<="            return KLE;
">="            return KGE;
"!="|"<>"       return KNE;
"=="            return KEQ;
"&&"            return KAND;
"||"            return KOR;

"++"            return KPP;
"--"            return KSS;
"+="            return KPE;
"-="            return KSE;
"*="            return KME;
"/="            return KDE;
"\\="           return KEUCE;
"\\/="          return KDRE;
"%="            return KMODE;
">>="           return KSRE;
"<<="           return KSLE;

<INITIAL,toplevel>"\\"[ \t\r]*"\n"		{linecount++;}
"\n"            {linecount++;if (mode==Mread_lines) {BEGIN(toplevel);return KEOC;}}
<toplevel>"\n"  {linecount++;}
"{"             {mode=Min_braces;BEGIN(INITIAL);}
"}"             {mode=Mread_lines;BEGIN(toplevel);return KEOC;}

"="[ \t\r\n]*      {countline(yytext,yyleng);return yytext[0];}


<INITIAL,toplevel>[ \t\r]+
<INITIAL,toplevel>"/*"|"\\\\" {
        int star=0;
        int n;
        int nl=0;
        if (lastcom==-1)
          lastcom=newcomment();
        n=lastcom;
        pushcomment(n,'/');
        pushcomment(n,'*');
        if (yytext[0]=='/')
        {
          for ( ; ; )
          {
            int c = input();
            if ( c == EOF )
              die(-1,"Unfinished comment");
            pushcomment(n,c);
            if ( c == '/' && star) break;
            if ( c == '*' ) star=1;
            else star=0;
            if ( c == '\n' ) linecount++;
          }
        }
        else
        {
          nl=1;
          for ( ; ; )
          {
            int c = input();
            if ( c == EOF )
              die(-1,"Unfinished comment");
            if ( c == '\n' )
            {
              linecount++;
              break; 
            }
            pushcomment(n,c);
          }
          pushcomment(n,' ');
          pushcomment(n,'*');
          pushcomment(n,'/');
          pushcomment(n,'\n');
        }
        /*We hack: we put white spaces after comments in the comments
          This makes output looking better in most cases.
          Sadly we can't add white spaces that are before comments.
        */
        for( ; ; )
        {
          int c = input();
          if ( c == '\n' ) 
          {
            linecount++;
            pushcomment(n,c);
            nl=1;
          }
          else if ( c == ' ' || c == '\t')
          {
             if (nl==0)
               pushcomment(n,c);
               /*We only add spaces on the same line*/
          }
          else 
          {
            unput(c); 
            break;
          }
        }
     }
<toplevel>. {BEGIN(INITIAL); unput(yytext[0]);return KEOC;}
. return yytext[0];
%%
