/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
extern gpfunc listfunc[];
gpdesc *newdesc(int nb)
{
  gpdesc *gd;
  gd=malloc(sizeof(*gd));
  gd->nb=nb;
  gd->a=calloc(nb,sizeof(*(gd->a)));
  return gd;
}
descargatom strtoargs(char *s)
{
  descargatom aa;
  int t;
  switch(*s)
  {
    case 0:
      aa.t=AAnoarg;
      aa.v=Gnotype;
      return aa;
    case '&':
      aa.t=AAreftype;
      break;
    case '#':
      aa.t=AAherevalue;
      break;
    case '*':
      aa.t=AAlvalue;
      break;
    case '@':
      aa.t=AAmulti;
      break;
    default:
      t=strtotype(s);
      if (t==-1)
      {
	aa.t=AAsmall;
	aa.v=atol(s);
      }
      else
      {
	aa.t=AAtype;
	aa.v=t;
      }
      return aa;
  }
  t=strtotype(s+1);
  if (t==-1)
    die(-1,"bad reference in description file");
  aa.v=t;
  return aa;
}
void readentry(FILE *f, char *buf, int len)
{
  if (!fgets(buf,len,f))
    perror("gp2c");
  if (!*buf)
    die(-1,"Bad description file <entry>");
  buf[strlen(buf)-1]=0;
}

int readnumber(FILE *f, char *buf, int len)
{
  readentry(f,buf,len);
  return atol(buf);
}

int readtypemode(FILE *f,char *buf, int len, int *mode)
{
  int nb=readnumber(f,buf,len);
  int type;
  *mode=0;
  if (nb)
  {
    int j;
    readentry(f,buf,len);
    type=nodetype(buf);
    for(j=1;j<nb;j++)
    {
      readentry(f,buf,len);
      *mode|=(1<<nodemode(buf));
    }
  }
  else
    type=Ggen;
  return type;
}

#define BUFFER_SIZE 1024

void initdesc(char *descfile)
{
  char buf[BUFFER_SIZE];
  FILE *dfile;
  if (!(dfile=fopen(descfile,"r")))
  {
    fprintf(stderr,"Cannot find description file %s\n",descfile);
    exit(1);
  }
  while(!feof(dfile))
  {
    int i;
    int nb,ndesc,nf;
    gpfunc *func;
    gpdesc *gd;
    if (!fgets(buf,BUFFER_SIZE,dfile))
      break;
    if (!*buf)
      die(-1,"Bad description file %s",descfile);
    buf[strlen(buf)-1]=0;
    nf=getfunc(buf); func=lfunc+nf;
    nb=readnumber(dfile,buf,BUFFER_SIZE);/*number of description*/
    gd=newdesc(nb); ndesc=0;
    for(i=0;i<nb;i++)
    { 
      int j,nargs;
      char *data;
      readentry(dfile,buf,BUFFER_SIZE);
      data=strdup(buf);
      nargs=readnumber(dfile,buf,BUFFER_SIZE);
      if (nargs>=0)
      {  /* This is a description*/
        gpdescarg *da=gd->a+(ndesc++);
	da->cname=data;
	da->nargs=nargs;
	if (nargs)
	  da->args=calloc(nargs,sizeof(*da->args));
	else
	  da->args=NULL;
	for(j=0;j<nargs;j++)
	{
	  readentry(dfile,buf,BUFFER_SIZE);
	  da->args[j]=strtoargs(buf);
	}
	da->type=readtypemode(dfile,buf,BUFFER_SIZE,&da->mode);
      }
      else
      {
	switch(-nargs)
	{
	case 1: /*This is a prototype*/
	  func->proto.cname=data;
	  readentry(dfile,buf,BUFFER_SIZE);
	  func->proto.code=strdup(buf);
	  func->type=readtypemode(dfile,buf,BUFFER_SIZE,&func->mode);
	  break;
	default:
	  die(-1,"unknown description type %d in %s",nargs,descfile);
	}
      }
    }
    gd->nb=ndesc;
    func->dsc=ndesc?gd:NULL; 
  }
  fclose(dfile);
}

gpdescarg *descfindrules(int nb, int *arg, gpfunc *gp)
{
  int i;
  int best=-1,score=-1,escore=-1;
  gpdesc *dsc=gp->dsc;
  gpdescarg *ga=dsc->a;
  for(i=0;i<dsc->nb;i++)
  {
    int sc=0, esc=0;
    int j;
    descargatom *da=ga[i].args;
    if (nb!=ga[i].nargs)
      continue;
    for(j=0;j<nb;j++)
    {
      int t;
      if ( arg[j]==GNOARG )
      {
        esc++;
        continue;
      }
      if (arg[j]<0)
        die(-1,"Internal error: Bad argment in descfindrules");
      t=tree[arg[j]].t;
      switch(da[j].t)
      {
      case AAtype:
        if (t==da[j].v)
          esc++;
	if (typemax[t][da[j].v]==da[j].v)
	  continue;
	if (typemax[t][da[j].v]==t)
	{
	  sc++;
	  continue;
	}
	break;
      case AAsmall:
	if (tree[arg[j]].f==Fsmall && tree[arg[j]].x==da[j].v)
        {
          esc++;
	  continue;
        }
	break;
      case AAreftype:
        if (t==da[j].v)
          esc++;
	if (tree[arg[j]].f==Frefarg && typemax[t][da[j].v]==t && ctype[t]==ctype[da[j].v])
	  continue;
	break;
      case AAherevalue:
        if (t==da[j].v)
          esc++;
	if (typemax[t][da[j].v]==da[j].v && (tree[arg[j]].f==Fsmall  || tree[arg[j]].f==Fconst))
	  continue;
	break;
      case AAlvalue:
 	if (t==da[j].v && getlvalue(arg[j])>=0)
	{
	  esc++;
	  continue;
	}
	break;
      case AAmulti:
        if (tree[arg[j]].f==Fentry || tree[arg[j]].f==Fsmall)
          continue;
	if (t==da[j].v)
	  warning(arg[j],"Only variable are allowed for function %s",gp->gpname);
	break;
      default:
	die(-1,"Internal error unknown AAvalue in gpdescarg");
      }
      break;
    }
    if (j<nb)
      continue;
    if (best==-1 || sc<score || (sc==score &&  esc>escore ))
    {
      score=sc;
      escore=esc;
      best=i;
    }
  }
  return (best==-1)?NULL:ga+best;
}
Gtype gentypefuncdesc(int n, gpfunc *gp)
{
  int arg[STACKSZ];
  int nb;
  int y=tree[n].y;
  gpdescarg *rule;
  if ( y!=-1 )
  {
    gentype(y);
    tree[n].m|=tree[y].m&MODHERIT;
  }
  nb=genlistargs(n,arg,0,STACKSZ);
  rule=descfindrules(nb,arg,gp);
  if (!rule)
    return Gnotype;
  tree[n].m|=rule->mode;
  return rule->type;
}
enum {FBparens} flagbit;
void gencodedesc(FILE *fout, int nb, int *arg, gpdescarg *rule, int nerr)
{
  char buf[STACKSZ];
  char *p,*q=NULL;
  int mode,flag,cast=-1;
  p=rule->cname;
  mode=0;flag=0;
  do
  {
    switch(mode)
    {
    case 0:
      if (*p=='$')
	mode=1;
      else if (*p)
	fputc(*p,fout);
      break;
    case 1:
      switch(*p)
      {
      case '(':
 	flag|=(1<<FBparens);
	break;
      case '"':
	q=memccpy(buf,p+1,'"',STACKSZ-1);
	if (!q)
	  die(nerr,"Unfinished \" in description");
	*(q-1)=0;
	die(nerr,buf);
      case 0:
	die(nerr,"Unfinished $ in description");
      default:
	if (isalpha(*p))
	{
	  q=memccpy(buf,p,':',STACKSZ-1);
	  if (!q)
	    die(nerr,"Unfinished cast in description");
	  *(q-1)=0;
	  cast=nodetype(buf);
	  p+=q-buf-1;
	}
	else if(isdigit(*p))
	{
	  mode=2;
	  q=p;
	}
      }
      break;
    case 2:
      if (!isalnum(*p))
      {
	if (q!=p)
	{
	  int x=0,t;
          while(q<p)
	    x=x*10+(*q++)-'0';
	  if (--x>nb)
	    die(nerr,"Too few args for function description %s",rule->cname); 
	  t=(cast==-1)?rule->args[x].v:cast;
	  cast=-1;
	  if (flag&(1<<FBparens))
	  {
	    if (*p!=')')
	      die(nerr,"Missing parens in function description %s",rule->cname);
	    gencastf(fout,arg[x],t,1);
	  }
	  else
	  {
	    gencast(fout,arg[x],t);
	    if (*p) fputc(*p,fout);
	  }
	}
	else if (*p)
	  fputc(*p,fout);
	mode=0;
	flag=0;
      }
      break;
    }
  } while(*p++);
}
int genentrydesc(FILE *fout, int n, gpfunc *gp)
{
  int arg[STACKSZ];
  int nb;
  gpdescarg *rule;
  nb=genlistargs(n,arg,0,STACKSZ);
  rule=descfindrules(nb,arg,gp);
  if (!rule)
    return 0;
  gencodedesc(fout,nb,arg,rule,n);
  return 1;
}

