/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>   
#include "header.h"

/* return hashing value for variable s*/
long
varkey(const char *s)
{
  long  n = 0;
  while (*s) { n = (n<<1) ^ *s; s++; }
  return n;
}

int newctx(int flag)
{
  int n;
  n=stack_new(&s_ctx);
  ctxstack[n].flag=flag;
  return n;
}

int newaff(int func, int idx)
{
  int n=stack_new(&s_aff);
  if (idx<0)
    die(-1,"Internal error: unknown var");
  affstack[n].f=func;
  affstack[n].idx=idx;
  return n;
}

int newblock(void)
{
  int n=stack_new(&s_bloc);
  stack_init(&block[n].s,sizeof(*block[n].c),(void **)&block[n].c);
  block[n].ret=-1;
  stack_init(&block[n].v,sizeof(*block[n].var),(void **)&block[n].var);
  block[n].gc=0;
  stack_init(&block[n].g,sizeof(*block[n].gcvar),(void **)&block[n].gcvar);
  return n;
}

int pushvar(int n, int flag, Gtype t, int initval)
{
  int c=newctx(flag);
  int v=tree[n].x;
  const char *s=value[v].val.str;
  ctxstack[c].var=s;
  if (flag&(1<<Cuser))
    ctxstack[c].cvar=usercname(s);
  else
    ctxstack[c].cvar=s;
  ctxstack[c].key=varkey(s);
  ctxstack[c].t=t;
  ctxstack[c].initval=initval;
  ctxstack[c].val=-1;
  return c;
}
int getvarinstack(const char *s, int n, const ctxvar *ctx)
{
  int i,key;
  key=varkey(s);
  for(i=n-1;i>=0 && (ctx[i].key!=key || strcmp(ctx[i].var,s));i--);
  return i;
}
int getvarbyname(const char *s)
{
  return getvarinstack(s,s_ctx.n,ctxstack);
}
int getvar(int n)
{
  if(tree[n].f!=Fentry && tree[n].f!=Frefarg)
    die(n,"Internal error : Not a Fentry in getvar");
  return getvarbyname(value[tree[n].x].val.str);
}
ctxvar *getvarinblock(int n, context *fc)
{  
  int v;
  if (tree[n].f!=Fentry && tree[n].f!=Frefarg)
    die(n,"Internal error : %s(%d) in getvarinblock",funcname(tree[n].f),tree[n].f);
  v=getvarinstack(value[tree[n].x].val.str,fc->s.n,fc->c);
  if ( v<0 )
    die(n,"Internal error : var not found in getvarinblock");
  return fc->c+v;
}
int getvarerr(int n)
{
  int v=getvar(n);
  if (v==-1)
    die(n,"Internal error: variable %s appears from nowhere",
	value[tree[n].x].val.str);
  return v;
}
void restorectx(int c)
{
  int i,j;
  for(i=c,j=c;i<s_ctx.n;i++)
    if (ctxstack[i].flag&(1<<Cglobal))
    {
      if (i!=j)
	ctxstack[j]=ctxstack[i];
      /*      ctxstack[j].flag=ctxstack[i].flag&~(1<<Cparent);*/
      j++;
    }
  if(j>s_ctx.n) die(-1,"Internal error: restorectx");
  s_ctx.n=j;
}

void pushctx(context *fc)
{
  stack_push(&s_ctx,&fc->s);
}

void copyctx(int c, context *fc)
{
  int i;
  fc->s.n=0;
  for (i=c; i<s_ctx.n ;i++)
    if (!(ctxstack[i].flag&(1<<Cglobal)))
    {
      int n=stack_new(&fc->s);
      fc->c[n]=ctxstack[i];
    }
}
