%{      
#include "config.h"
#include <unistd.h>
#include <string.h>
#include "header.h"
#include "parse.h"
int linecount=1;
int yydebug;
static enum {Mread_lines,Min_braces} mode=Mread_lines;
static int terminate=2,start=0;
static int lastcom=-1;
static void countline(char *text,int len)
{
  int i; 
  for (i=0; i<len; i++) 
    linecount+=(text[i]=='\n');
}

static void copytoken(void)
{
  yylval.str.s=strdup(yytext);
  if (yydebug) fprintf(stderr,"[%s]",yytext);
  yylval.str.c=lastcom; lastcom=-1;
}

static void copystring(void)
{
  yylval.str.s=strdup(yytext+1);
  yylval.str.s[yyleng-2]=0;
  if (yydebug) fprintf(stderr,"[%s]",yytext);
  countline(yytext,yyleng);
  yylval.str.c=lastcom; lastcom=-1;
}

/* There are two start conditions:
   -- toplevel 
   -- INITIAL

We start at toplevel. As soon as we see a non toplevel command, we go to
INITIAL. When the command is completed, we revert to toplevel and emit a KEOC
(End Of Command) token to the parser. It is better to stay at toplevel when we
encounter non-command tokens (comments, white spaces).  

The mode can be
Mread_lines: line by line mode
Min_braces : inside braces
*/
/* REAL_NOTAIL can be confused with member function to integer
 * so we let parse.y handle them
 */
%}
INTEGER [0-9]+
EXPO ("e"|"E")("+"|"-")?{INTEGER}
REAL_DEC [0-9]*"."{INTEGER}{EXPO}?
REAL_INT   {INTEGER}{EXPO}
REAL_NODEC {INTEGER}"."{EXPO}
REAL_NOTAIL {INTEGER}"."
REAL {REAL_DEC}|{REAL_INT}|{REAL_NODEC}
STRING \"([^"\\]|(\\.))*\"
ENTRY [A-Za-z][A-Za-z0-9_]*
%x toplevel
%%
        if (!start) {start=1; BEGIN(toplevel);}
{ENTRY}		copytoken(); return KENTRY; 
{INTEGER}	copytoken(); return KINTEGER;
{REAL}	        copytoken(); return KREAL;
{STRING}        copystring(); return KSTRING;

<<EOF>>         {if (terminate--) return KEOC; else yyterminate();}

<toplevel>\\[a-z][^\n]*|\?[^\n]* {
        fprintf(stderr,"Warning:%s:%d: meta commands not implemented\n%s\n",
	        nameparse,linecount,yytext);
                        }

<toplevel>##?[ \t\r]*$ { /*We cannot recognize #<EOF> */
        fprintf(stderr,"Warning:%s:%d: meta commands not implemented\n%s\n",
	        nameparse,linecount,yytext);
                        }


"\\/"           return KDR;
">>"            return KSR;
"<<"            return KSL;
"<="            return KLE;
">="            return KGE;
"!="|"<>"       return KNE;
"=="            return KEQ;
"&&"            return KAND;
"||"            return KOR;

"++"            return KPP;
"--"            return KSS;
"+="            return KPE;
"-="            return KSE;
"*="            return KME;
"/="            return KDE;
"\\="           return KEUCE;
"\\/="          return KDRE;
"%="            return KMODE;
">>="           return KSRE;
"<<="           return KSLE;

<INITIAL,toplevel>"\\"[ \t\r]*"\n"		{linecount++;}
"\n"            {linecount++;if (mode==Mread_lines) {BEGIN(toplevel);return KEOC;}}
<toplevel>"\n"  {linecount++;}
"{"             {mode=Min_braces;BEGIN(INITIAL);}
"}"             {mode=Mread_lines;BEGIN(toplevel);return KEOC;}

"="[ \t\r\n]*      {countline(yytext,yyleng);return yytext[0];}


<INITIAL,toplevel>[ \t\r]+
<INITIAL,toplevel>"/*"|"\\\\" {
        int star=0;
        int n;
        int nl=0;
        int lc=linecount;
        if (lastcom==-1)
          lastcom=newcomment();
        n=lastcom;
        pushcomment(n,'/');
        pushcomment(n,'*');
        if (yytext[0]=='/')
        {
          for ( ; ; )
          {
            int c = input();
            if ( c == EOF )
              die(-1,"Unfinished comment");
            pushcomment(n,c);
            if ( c == '/' && star) break;
            if ( c == '*' ) star=1;
            else star=0;
            if ( c == '\n' ) linecount++;
          }
        }
        else
        {
          nl=1;
          for ( ; ; )
          {
            int c = input();
            if ( c == EOF )
              die(-1,"Unfinished comment");
            if ( c == '/' && star) c='\\';
            if ( c == '*' ) star=1;
            else star=0;
            if ( c == '\n' )
            {
              linecount++;
              break; 
            }
            if ( c == '\r' )
              continue;
            pushcomment(n,c);
          }
          pushcomment(n,' ');
          pushcomment(n,'*');
          pushcomment(n,'/');
          pushcomment(n,'\n');
        }
        /*We hack: we put white spaces after comments in the comments
          This makes output looking better in most cases.
          Sadly we can't add white spaces that are before comments.
        */
        for( ; ; )
        {
          int c = input();
          if ( c == EOF  )
            return KEOC;
          if ( c == '\n' ) 
          {
            linecount++;
            pushcomment(n,c);
            nl=1;
          }
          else if ( c == ' ' || c == '\t')
          {
            if (nl==0)
              pushcomment(n,c);
              /*We only add spaces on the same line*/
          }
          else if ( c != '\r' )
          {
            unput(c); 
            break;
          }
        }
        if (YYSTATE==INITIAL && lc<linecount && mode==Mread_lines) 
        {
          BEGIN(toplevel);
          return KEOC;
        }
      }
<toplevel>. {BEGIN(INITIAL); unput(yytext[0]);return KEOC;}
. return yytext[0];
%%
