/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
extern int indent;
int currfunc;
static int newcvar=1;

/*Use getfunc or newuserfunc instead*/
static int newfunc(const char *gpname)
{
  int r=stack_new(&s_func);
  gpfunc *f=lfunc+r;
  f->gpname=gpname;
  f->proto.cname=gpname;
  f->proto.code=NULL;
  f->proto.origin=NULL;
  f->type=Gvoid;
  f->mode=0;
  f->spec=GPpari;
  f->dsc=NULL;
  f->user=NULL;
  return r;
}

int newuserfunc(const char *gpname)
{
  int r=newfunc(gpname);
  gpfunc *f=lfunc+r;
  userfunc *uf;
  if (gpname[0]=='_' && gpname[1]=='.') 
  {
    char *s=strdup(gpname);
    s[0]='m'; s[1]='_';
    f->proto.cname=usercname(s);
    if (s!= f->proto.cname) free(s);
  }
  else
    f->proto.cname=usercname(gpname);
  f->spec=GPuser;
  f->proto.origin=namelib;
  uf=f->user=malloc(sizeof(*f->user));
  stack_init(&uf->v,sizeof(*uf->var),(void *)&uf->var);
  stack_init(&uf->g,sizeof(*uf->gcvar),(void *)&uf->gcvar);
  return r;
}

int findfunction(const char *s)
{
  int i;
  for(i=0; i<s_func.n && strcmp(lfunc[i].gpname,s);i++);
  return i<s_func.n?i:-1;
}

int getfunc(const char *gpname)
{
  int r=findfunction(gpname);
  if (r>=0)
    return r;
  return newfunc(strdup(gpname));
}

int genautoarg(FILE *fout, char c)
{
  switch(c)
  {
  case 'p':
    fprintf(fout,"prec");
    return 1;
  case 'P':
    fprintf(fout,"precdl");
    return 1;
  }
  return 0;
}
int genarg(int nerr, FILE *fout, char c, int n)
{
  if (n==-1)
    die(n,"missing mandatory argument in function call");
  switch(c)
  {
  case 'G':
    gencast(fout,n,Ggen);
    return 1;
  case 'L':
    gencast(fout,n,Gsmall);
    return 1;
  case '&':
    fprintf(fout,"&");
    if (tree[n].f!=Frefarg)
      die(nerr,"Missing & for reference");
    gencode(fout,n);
    return 1;
  case 'r':
  case 's':
    gencast(fout,n,Gstr);
    return 1;
  case 'n':
    gencast(fout,n,Gvar);
    return 1;
  default:
    die(nerr,"Unsupported letter `%c' in prototype.\n"
        "This function is not supported by the compiler."
        ,c);
    return 0;
  }
}
void gendefarg(int n, FILE *fout, char c, const char *name)
{
  switch(c)
  {
  case 'G':
  case '&':
  case 'I':
  case 'V':
    fprintf(fout,"NULL");
    break;
  case 'n':
    fprintf(fout,"-1");
    break;
  default:
    die(n,"Unknown default in prototype code `%c' for `%s'",c,name);
  }
}
void gendefargmulti(FILE *fout, char const *q, char const *p)
{
  for(p++;p<q-3;p++)
    if (p[0]!='\\' || p[1]!='"')
      fputc(*p,fout);
}

void gencallfunc(int n, FILE *fout, const char *name, int *stack, int nb, const char *proto)
{
  int i=0;
  int firstarg=0;
  char const *p=proto,*q=proto;
  char c;
  PPproto mod;
  fprintf(fout,"%s(",name);
  while((mod=parseproto(&p,&c)))
  {
    if (mod==PPsep) continue;
    if (firstarg) fprintf(fout,", ");
    firstarg=1;
    switch(mod)
    {
    case PPstd:
      if (genautoarg(fout,c))
        break;
      if (i<nb && stack[i]!=GNOARG)
        genarg(n,fout,c,stack[i]);
      else
        die(n,"Mandatory argument needed for %s",name);
      i++;
      break;
    case PPdefault:
      if (i<nb && stack[i]!=GNOARG)
        genarg(n,fout,c,stack[i]);
      else
        gendefarg(n,fout,c,name);
      i++;
      break;
    case PPdefaultmulti:
      if (i<nb && stack[i]!=GNOARG)
        genarg(n,fout,c,stack[i]);
      else
        gendefargmulti(fout,p,q);
      i++;
      break;
    default:
      die(n,"internal error: PPproto %d in gencallfunc",mod);
    }
    q=p;
  }
  fprintf(fout,")");
}
void genentryuser(FILE *fout, int n, int nf)
{
  int arg[STACKSZ];
  int nb,nargs,firstarg=0;
  int i,j;
  gpfunc *gp=lfunc+nf;
  userfunc *ufunc=gp->user;
  context *fc=block+ufunc->bl;
  for (i=0,nargs=0;i<fc->s.n;i++)
    if ( fc->c[i].flag&(1<<Carg) )
      nargs++;
  nb=genlistargs(n,arg,0,nargs);
  fprintf(fout,"%s(",gp->proto.cname);
  for(i=0,j=0;i<nb;j++)
  {
    if (!(fc->c[j].flag&(1<<Carg)))
      continue;
    if (firstarg)
      fprintf(fout,", ");
    firstarg=1;
    if (arg[i]>=0)
      gencast(fout,arg[i],fc->c[j].t);
    else if (fc->c[j].initval>=0)
      gencast(fout,fc->c[j].initval,fc->c[j].t);
    else
      gencast(fout,GNIL,fc->c[j].t);
    i++;
  }
  for(   ;i<nargs;j++)
  {
    if (!(fc->c[j].flag&(1<<Carg)))
      continue;
    if (firstarg)
      fprintf(fout,", ");
    firstarg=1;
    if (fc->c[j].initval>=0)
      gencast(fout,fc->c[j].initval,fc->c[j].t);
    else
      gencast(fout,GNIL,fc->c[j].t);
    i++;
  }
  if (gp->mode&(1<<Mprec))
  {
    if (firstarg) fprintf(fout,", ");
    else firstarg=1;
    fprintf(fout,"prec");
  }
  fprintf(fout,")");
}

void genentryfunc(FILE *fout, int n)
{
  int stack[STACKSZ];
  const char *name=entryname(n);
  int i,l;
  const char *proto=NULL;
  int nf=findfunction(name);
  gpfunc *gp=lfunc+nf;
  if (nf >= 0)
  {
    if (gp->spec==0)
    {
      genentryuser(fout,n,nf);
      return;
    }
    else if (gp->spec>0)
    {
      genentryspec(fout,n,gp);
      return;
    }
    if (gp->dsc && genentrydesc(fout,n,gp))
      return;
    proto=gp->proto.code;
  }
  l=genlistargs(n,stack,0,STACKSZ);
  if (proto)
    gencallfunc(n,fout,gp->proto.cname,stack,l,proto);
  else/*copy verbatim*/
  {
    if (nf >= 0 && gp->proto.cname)
      fprintf(fout,"%s(",gp->proto.cname);
    else
      fprintf(fout,"%s(",name);
    for(i=0;i<l;i++)
    {
      if (i) fprintf(fout,", ");
      gencode(fout,stack[i]);
    }
    fprintf(fout,")");
  }
}
void genentry(FILE *fout, int n)
{
  ctxvar *v=ctxstack+getvarerr(n);
  fprintf(fout,"%s",v->cvar);
}

void gendecvar(FILE *fout, context *fc, int idx)
{
  ctxvar *v=fc->c+idx;
  if ((v->flag&(1<<Cconst)) && v->val!=-1)
    return;
  if (v->flag&(1<<Carg))
    return;
  if (v->t==Gvoid)
    return;
  genindent(fout);
  fprintf(fout,cname[ctype[v->t]],v->cvar);
  if (v->initval>=0)
  {
    fprintf(fout," = ");
    gencast(fout,v->initval,v->t);
  }
  else if (ctype[v->t]==Vgen && autogc)
    /* We want to protect gerepile from uninitialized values*/
    fprintf(fout," = gzero");
  if ((v->t!=Ggen && ctype[v->t]==Vgen) || (v->t!=Gsmall && ctype[v->t]==Vsmall))
    fprintf(fout,";\t  /* %s */\n",Gname[v->t]);
  else
    fprintf(fout,";\n");
}

void genprotocode(FILE *fout, int nf)
{
  gpfunc *gp=lfunc+nf;
  char const *p=gp->proto.code;
  char c;
  PPproto mod;
  int firstarg=0;
  fprintf(fout,"extern ");
  fprintf(fout,cname[ctype[gp->type]],gp->proto.cname);
  fprintf(fout,"(");
  while((mod=parseproto(&p,&c)))
  {
    if (mod==PPsep) continue;
    if (firstarg) fprintf(fout,", ");
    firstarg=1;
    switch(c)
    {
    case 'p': 
    case 'P':
    case 'L':
    case 'n':
      fprintf(fout,"long");
      break;
    case 'f':
      fprintf(fout,"long *");
      break;
    case 'G':
      fprintf(fout,"GEN");
      break;
    case 'F':
    case '*':
    case '&':
      fprintf(fout,"GEN *");
      break;
    case 'r':
    case 's':
    case 'E':
    case 'I':
      fprintf(fout,"char *");
      break;
    case 'V':
    case 'S':
      fprintf(fout,"entree *");
      break;
    default:
      die(-1,"unknow prototype `%c'",c);
    }
  }
  fprintf(fout,")");
}

void genprototype(FILE *fout, int nf, int kb)
{
  int firstarg;
  gpfunc *gp=lfunc+nf;
  int t=gp->type;
  int m=gp->mode;
  int i;
  context *fc=block+gp->user->bl;
  if (!kb)
    fprintf(fout,cname[ctype[t]],gp->proto.cname);
  else
  {
    char *name=calloc(strlen(gp->proto.cname)+2,sizeof(char));
    sprintf(name,"\n%s",gp->proto.cname);
    fprintf(fout,cname[ctype[t]],name);
    free(name);
  }
  fprintf(fout,"(");
  firstarg=0;
  for (i=0;i<fc->s.n;i++)
  {
    ctxvar *v=fc->c+i;
    if( v->flag&(1<<Carg) )
    {
      if (firstarg) fprintf(fout,", ");
      else firstarg=1;
      fprintf(fout,cname[ctype[v->t]],v->cvar);
      if (ctype[v->t]!=Vgen && v->initval>=0)
      {
        fprintf(fout,"/*=");
        printnode(fout,v->initval);
        fprintf(fout,"*/");
      }

    }
  }
  if (m&(1<<Mprec))
  {
    if (firstarg) fprintf(fout,", ");
    else firstarg=1;
    fprintf(fout,"long prec");
  }
  if (!firstarg) fprintf(fout,"void");
  fprintf(fout,")");
}

void gencopyarg(FILE *fout, int n)
{
  gpfunc *gp=lfunc+currfunc;
  context *fc=block+gp->user->bl;
  long i;
  if (tree[n].x!=gp->user->bl || !fc->var) return;
  for (i=0;i<fc->s.n;i++)
    if (fc->c[i].flag&(1<<Carg))
    {
      long j;
      for(j=0;j<fc->v.n;j++)
	if (fc->var[j].f==AFaffectcompo && fc->var[j].idx==i+fc->savb-fc->s.n )
	{
	  genindent(fout);
	  fprintf(fout,"%s = gcopy(%s);\n",fc->c[i].var,fc->c[i].var);
	  break;
	}
    }
}

void gendeffunc(FILE *fout, int n)
{
  int funcid=tree[n].x;
  int seq=tree[n].y;
  const char *name=entryname(funcid);
  int savcf=currfunc;
  gpfunc *gp;
  int t;
  /*get func number and context*/
  currfunc=findfunction(name);
  newcvar=1;
  if (currfunc==-1) 
    die(n,"Internal error in gendeffunc : func %s not found",name);
  gp=lfunc+currfunc;
  gencomment(fout,funcid,0);
  genprototype(fout,currfunc,1);
  t=gp->type;
  if (t!=Ggen && ctype[t]==Vgen)
    fprintf(fout,"\t  /* %s */",Gname[t]);
  fprintf(fout,"\n");
  gencode(fout,seq);
  fprintf(fout,"\n");
  currfunc=savcf;
}

void gendefblock(FILE *fout, int n)
{
  int b=tree[n].x;
  int seq=tree[n].y;
  int i;
  int t,m;
  int savc;
  context *fc=block+b;
  savc=s_ctx.n;
  for(i=0;i<fc->s.n;i++)
  {
    ctxvar *v=fc->c+i;
    if ((v->flag&(1<<Cconst)) && v->val!=-1) continue;
    if (v->t!=Gvoid && isdigit(*v->var))
    {
      char s[33];
      sprintf(s,"%c%d",(ctype[v->t]==Vsmall?'l':'p'),newcvar++);
      v->cvar=strdup(s);
    }
  }
  pushctx(fc);
  /*some shortcut*/
  t=tree[n].t;
  m=tree[n].m;
  if(!(m&(1<<Mbrace)))
  {
    genindent(fout);
    fprintf(fout,"{\n");
    indent++;
  }
  for(i=0;i<fc->s.n;i++)
    gendecvar(fout,fc,i);
  gencopyarg(fout,n);
  genindentseq(fout,seq);
  gencode(fout,seq);
  gensemicomma(fout,seq);
  if(!(m&(1<<Mbrace)))
  {
    indent--;
    genindent(fout);
    fprintf(fout,"}\n");
  }
  s_ctx.n=savc;
}
