/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

void varlistaff(int sava, int savc, stack *v)
{
  affnode **an=(affnode **) stack_base(v);
  int i;
  v->n=0;
  for (i=sava;i<s_aff.n;i++)
    if (affstack[i].idx<savc)
    {
      int n=stack_new(v);
      (*an)[n]=affstack[i];
    }
}

void varlistvar(int idx)
{
  ctxvar *v=ctxstack+idx;
  if (v->flag&(1<<Carg))
    return;
  if (v->initval>=0)
  {
    varlist(v->initval);
    newaff(AFaffect,idx); 
  }
}

void varlist(int n)
{
  int i,x,y,nv;
  int v,savc,sava,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;  
  switch(tree[n].f)
  {
  case Faffect:
    /*    if (tree[x].f!=Fentry)
          varlist(x);*/
    varlist(y);
    v=getvarerr(getlvaluerr(x));
    if (isfunc(y,"clone"))
      newaff(AFclone,v);
    else
    {
      if (tree[detag(x)].f==Fentry)
        newaff(AFaffect,v);
      else
        newaff(AFaffectcompo,v);
    }
    break;
  case Ftag:
    varlist(x);
    break;
  case Fconst:
  case Fsmall:
  case Fgnil:
    break;
  case Frefarg:
    v=getvarerr(n);
    newaff(AFrefarg,v);
    break;
  case Fentry:
    v=getvarerr(n);
    newaff(AFaccess,v);
    break;
  case Fentryfunc:
    varlist(y);
    /*FIXME: add true parsing of description*/
    if (x>=OPss && x<=OPme)
    {
      int arg[STACKSZ];
      int nb=genlistargs(n,arg,0,STACKSZ);
      if (nb)
      {
        int a=detag(arg[0]);
        int v=getvarerr(getlvaluerr(a));
        newaff(AFrefarg,v);
        if (tree[a].f!=Fentry)
          newaff(AFaffectcompo,v);
      }
    }
    else
    {
      int fc=findfunction(entryname(n));
      gpfunc *gp=lfunc+fc;
      if (fc>=0 && gp->spec==GPuser)
      {
        userfunc *uf=gp->user;
        int base=lfunc[currfunc].user->savb;/*currfunc!=fc*/
        int i;
        char *c;
        c=calloc(base,sizeof(*c));
        for(i=0;i<uf->v.n;i++)
        {
          affnode *an=uf->var+i;
          if (an->idx<base && ctxstack[an->idx].flag&(1<<Cglobal)
              && an->f!=AFaccess && c[an->idx]==0)
          {
            c[an->idx]=1;
            newaff(AFaffect,an->idx);
          }
        }
        free(c);
      }
    }
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      const char *name=entryname(funcid);
      int savcf=currfunc;
      userfunc *uf;
      /*get func number and context*/
      currfunc=findfunction(name);
      uf=lfunc[currfunc].user;
      savc=s_ctx.n;
      uf->savb=savc;
      sava=s_aff.n;
      varlist(y);
      nv=uf->v.n;
      varlistaff(sava,savc,&uf->v);
      if (nv!=uf->v.n)
        lastpass=1;
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=s_ctx.n;
    sava=s_aff.n;
    bl=block+tree[n].x;
    for (i=0;i<bl->s.n;i++)
    {
      ctxvar *v=bl->c+i;
      int nv=getvarbyname(v->var);
      if (nv!=-1)
        newaff(AFhide,nv);
    } 
    pushctx(bl);
    savb=s_ctx.n;
    for(i=0;i<bl->s.n;i++)
      varlistvar(savc+i);
    varlist(y);
    nv=bl->v.n;
    varlistaff(sava,savb,&bl->v);
    if (nv!=bl->v.n)
      lastpass=1;
    bl->savb=savb;
    copyctx(savc,bl);
    s_ctx.n=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in varlist",funcname(tree[n].f));
    varlist(x);
    varlist(y);
  }
}
