/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
int indent=0;
extern int indentlevel;

void genindent(FILE *fout)
{
  int i;
  for (i=0;i<indent*indentlevel;i++)
    fputc(' ',fout);
}

void genindentseq(FILE *fout, int n)
{
  if (n==-1 || (tree[n].m&(1<<Msemicomma)))
    return;
  genindent(fout);
}

void gencomment(FILE *fout, int n, int flag)
{
  comment *c;
  int i;
  if (tree[n].comment<0)
    return;
  c=com+tree[n].comment;
  for(i=0;i<c->s.n-1;i++)
  {
    if (c->txt[i]=='\n')
    {
      if (!flag) fputc('\n',fout); 
      genindent(fout);
      while(c->txt[i+1]==' ' || c->txt[i+1]=='\t')
        i++;
    }
    else
      fputc(c->txt[i],fout);
  }
  if (c->txt[i]=='\n')
  {
    if (!flag) fputc('\n',fout); 
    if (!(tree[n].m&(1<<Msemicomma)))
      genindent(fout);
  }
  else
    fputc(c->txt[i],fout);
}
void gensemicomma(FILE *fout, int x)
{
  if (x!=-1 && !(tree[x].m&(1<<Msemicomma)))
    fprintf(fout,";\n");
}
extern int optcleanvar;
void genbrace(FILE *fout, int x)
{
  if (x==-1) return;
  if (tree[x].f==Fblock)
  {
  /*If it is an empty block, cross it*/
    if ((tree[x].m&(1<<Mbrace)) && !optcleanvar )
      genbrace(fout,tree[x].y);
    else
      gencodeg(fout,x);
  }
  else
  {
    int brace=(tree[x].f==Fseq || (tree[x].m&(1<<Melse)));
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"{\n");
    }
    indent++;
    genindentseq(fout,x);
    gencodeg(fout,x);
    gensemicomma(fout,x);
    indent--;
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"}\n");
    }
  }
}

void gensmallval(FILE *fout, int val, Gtype t)
{
  switch(val)
  {
    case 0:
      fprintf(fout,(ctype[t]==Vsmall)?"0":"gzero");
      break;
    case 1:
      fprintf(fout,(ctype[t]==Vsmall)?"1":"gun");
      break;
    case 2:
      fprintf(fout,(ctype[t]==Vsmall)?"2":"gdeux");
      break;
    default:
      die(-1,"Internal error:val %d unhandled in gensmallval",val);
  }
}

void genpercent(FILE *fout, int n)
{
  const char *s=value[tree[n].x].val.str;
  while(*s)
  {
    if (*s=='%')
      fputc('%',fout);
    fputc(*s++,fout);
  }
}

void 
genfacteurmat(FILE *fout, int n)
{ 
  /*
     int stack[STACKSZ];
     listtostackparent(n,Ffacteurmat,stack,0,STACKSZ,"indices",n);
   */
  int x=tree[n].x;
  int y=tree[n].y;
  int yx=tree[y].x;
  int yy=tree[y].y;
  int t=tree[x].t;
  int f=tree[y].f;
  if (f!=Fmatrix && f!=FmatrixR)
    die(y,"Internal error:genfacteurmat: unhandled func %s",funcname(f));
  /* For now, we treat gen as vec, which will cause a bug if a gen 
   * contain a vecsmall*/
  if (t!=Ggen && !is_subtype(t,Gvec) && !is_subtype(t,Gvecsmall))
    die(n,"Type %s has no components.",Gname[t]);
  /*For vecsmall, we only allow [x], not [,x] nor [x,y]*/
  if (is_subtype(t,Gvecsmall) && (f!=Fmatrix || yy!=-1))
    die(n,"Type %s is not a matrix.",Gname[t]);
  if (yy==-1)
  {
    genparens(fout,x);
    fprintf(fout,"[");
    gencast(fout,yx,Gsmall);
    fprintf(fout,"]");
  }
  else
  {
    fprintf(fout,"coeff(");
    gencast(fout,x,Ggen);
    fprintf(fout,", ");
    gencast(fout,yx,Gsmall);
    fprintf(fout,", ");
    gencast(fout,yy,Gsmall);
    fprintf(fout,")");
  }
}

void genfacteuraff(FILE *fout, int x, int z)
{
  int tx=tree[x].t;
  int tz=tree[z].t;
  gencodeg(fout,x);
  fprintf(fout," = ");
  if ((tree[x].m&(1<<Mlong)) && ctype[tx]==Vgen)
  {
    if (tree[z].f==Fentry && ctype[tz]==Vgen) 
    {
      fprintf(fout,"lcopy(");
      gencast(fout,z,tx);
      fprintf(fout,")");
      return;
    }
    else
      gencastl(fout,z,tx,0);
  }
  else
    gencast(fout,z,tx);
}

/*If there is no suitable GP prototype, just print nothing*/
extern char *optsuffix;
extern int optstrict;
void geninstall(FILE *fout, int nf)
{
  int i;
  int nargs=0;
  gpfunc *gp=lfunc+nf;
  int rt=ctype[gp->type];
  if (!creturn[rt])
    return;
  if(gp->spec==GPuser)
  {
    context *fc=block+gp->user->bl;
    for (i=0;i<fc->s.n;i++)
    {
      ctxvar *v=fc->c+i;
      if ( v->flag&(1<<Carg) )
      {
        int t=ctype[v->t];
        if (cproto[t])
          nargs++;
        else
          /*There are no suitable prototype*/
	  return;
      }
    }
    /*GP (<=2.2.3) cannot handle functions with more than 8 args*/
    if (nargs>8 && optstrict)
      return; 
    fprintf(fout,"install(\"%s\",\"%s",gp->proto.cname,creturn[rt]);
    for (i=0;i<fc->s.n;i++)
    {
      ctxvar *v=fc->c+i;
      if ( v->flag&(1<<Carg) )
      {
        int t=ctype[v->t];
        if (v->initval>=0 || !optstrict)
        {
          fprintf(fout,"D");
          if (t!=Vgen || !optstrict)
          {
            if (v->initval<0)
              fprintf(fout,"%s",cdefault[t]);
            else
              printnode(fout,v->initval);
            fprintf(fout,",%s,",cproto[t]);
          }
          else
            fprintf(fout,"%s",cproto[t]);
        }
        else
          fprintf(fout,"%s",cproto[t]);
      }
    }
    if (gp->mode&(1<<Mprec))
      fputc('p',fout);
  }
  else
    fprintf(fout,"install(\"%s\",\"%s%s",gp->proto.cname,creturn[rt],gp->proto.code);
  /* Member function has a gpname of "_.func" which is not a valid
   * GP func name.
   * we use "m_" instead.
   */
  if( gp->gpname[0]=='_' && gp->gpname[1]=='.' ) 
    fprintf(fout,"\",\"m_%s%s\"",gp->gpname+2,(optsuffix?optsuffix:""));
  else
    fprintf(fout,"\",\"%s%s\"",gp->gpname,(optsuffix?optsuffix:""));
  if (gp->proto.origin)
    fprintf(fout,",\"%s\"",gp->proto.origin);
  fprintf(fout,");\n");
}
void genheader(FILE *fout)
{
  int i;
  fprintf(fout,"/*-*- compile-command: \"");
  fprintf(fout,PARI_MODULE_BUILD,nameparse,nameparse,nameparse,nameparse);
  fprintf(fout,"\"; -*-*/\n");
  printf("#include <pari/pari.h>\n");
  printf("/*\n");
  for(i=0;i<s_func.n;i++)
    if (lfunc[i].spec==GPinstalled)
      geninstall(fout,i);
  for(i=0;i<s_func.n;i++)
    if (lfunc[i].spec==GPuser)
      geninstall(fout,i);
  printf("*/\n");
  for(i=0;i<s_func.n;i++)
  {
    if (lfunc[i].spec==GPuser)
      genprototype(fout,i,0);
    else if (lfunc[i].spec==GPinstalled)
      genprotocode(fout,i);
    else continue;
    fprintf(fout,";\n");
  }
  fprintf(fout,"/*End of prototype*/\n\n");
  if (s_ctx.n)
  {
    for(i=0;i<s_ctx.n;i++)
    {
      ctxvar *v=ctxstack+i;
      fprintf(fout,"static ");
      fprintf(fout,cname[ctype[v->t]],v->cvar);
      fprintf(fout,";\n");
    }
    fprintf(fout,"/*End of global vars*/\n\n");
  }
}

void gencodeg(FILE *fout, int n)
{
  int x=tree[n].x;
  int y=tree[n].y;
  if (n<0)
    return; 
  if (tree[n].comment>=0)
  {
    if (tree[n].m&(1<<Msemicomma))
      genindent(fout);
    gencomment(fout,n,0);
  }
  if (debug>=3) fprintf(fout,"/*%s:%d*/",Gname[tree[n].t],tree[n].m);
  switch(tree[n].f)
  {
  case Fseq:
    genindentseq(fout,x);
    gencodeg(fout,x);
    gensemicomma(fout,x);
    genindentseq(fout,y);
    gencodeg(fout,y);
    gensemicomma(fout,y);
    break;
  case Fmatrix:
  case FmatrixL:
  case FmatrixR:
    die(-1,"Internal error: Fmatrix* in gencode");
    /*all this stuff is handled by Ffacteurmat*/
    break;
  case Ffacteurmat:
    genfacteurmat(fout,n);
    break;
  case Faffect:
    genfacteuraff(fout,x,y);
    break;
  case Fconst:
    {
      long val=value[x].val.small;
      const char *str=value[x].val.str;
      switch (value[x].type)
      {
      case CSTsmall:
        fprintf(fout,"%ld",val);
        break;
      case CSTsmallreal:
        switch(val)
        {
        case 0:
          fprintf(fout,"realzero(prec)");
          break;
        case 1:
          fprintf(fout,"realun(prec)");
          break;
        default:
          fprintf(fout,"mulsr(%ld, realun(prec))",val);
          break;
        }
        break;
      case CSTexpr:
        fprintf(fout,"flisexpr(\"%s\")",str);
        break;
      case CSTstr:
        fprintf(fout,"\"%s\"",str);
        break;
      case CSTquote:
        fprintf(fout,"fetch_user_var(\"%s\")",str);
        break;
      }
      break;
    }
  case Fsmall:
    fprintf(fout,"%d",tree[n].x);
    break;
  case Femptyvec:
    fprintf(fout,"cgetg(1,t_VEC)");
    break;
  case Femptymat:
    fprintf(fout,"cgetg(1,t_MAT)");
    break;
  case Fmatrixelts:
  case Fmatrixlines:
  case Fmat:
    /*handled by genblockmatrix*/
  case Flistarg:
    /*handle by Fentry*/
    die(-1,"Internal error: %s in gencode",funcname(tree[n].f));
    break;
  case Frefarg:
  case Fentry:
    genentry(fout,n);
    break;
  case Fentryfunc:
    genentryfunc(fout,n);
    break;
  case Fdeffunc:
    gendeffunc(fout,n);
    break;
  case Fblock:
    gendefblock(fout,n);
    break;
  case Fgnil:
    fprintf(fout,"0");
    break;
  case Ftag:
    gencast(fout,x,y);
    break;
  default:
    die(n,"Internal error : unknow func %s in gencode",funcname(tree[n].f));
    break;
  }
}
void genparensg(FILE *fout, int n)
{
  if (n!=-1 && (tree[n].m&(1<<Mparens)))
    fprintf(fout,"(");
  gencodeg(fout, n);
  if (n!=-1 && (tree[n].m&(1<<Mparens)))
    fprintf(fout,")");
}
void gencode(FILE *fout, int n)
{
  if ((tree[n].m&(1<<Mlong)) && ctype[tree[n].t]==Vgen)
  {
    fprintf(fout,"(GEN) ");
    genparensg(fout, n);
  }
  else
    gencodeg(fout, n);
}
void genparens(FILE *fout, int n)
{
  long x=n;
  if(n<0) return;
  x=detag(x);
  if (tree[x].m&(1<<Mlong|1<<Mparens))
  {
    fprintf(fout,"(");
    gencode(fout, n);
    fprintf(fout,")");
  }
  else
    gencode(fout, n);
}

