/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
extern int indent;
extern int indentlevel;
void gencaststoi(FILE *fout, int n, Gtype t)
{
  if (tree[n].f==Fconst && value[tree[n].x].type==CSTsmall)
    if(value[tree[n].x].val.small>=0 && value[tree[n].x].val.small<=2)
    {
      gensmallval(fout,value[tree[n].x].val.small,Gint);
      return;
    }
  if (tree[n].f==Fsmall && tree[n].x>=0 &&  tree[n].x<=2)
  {
    gensmallval(fout,tree[n].x,Gint);
    return;
  }
  if (tree[n].f==Fgnil)
  {
    gensmallval(fout,0,Gint);
    return;
  }
  fprintf(fout,"stoi(");
  gencast(fout,n,t);
  fprintf(fout,")");
}
int gencastcode(FILE *fout, int n, Gtype t, Gtype nt, int f)
{
#ifdef DEBUG_CAST
  fprintf(fout,"/*%s:%s:%s*/",Gname[tree[n].t],Gname[t],Gname[nt]);
#endif
  switch(nt)
  {
  case Gbool:
    switch(t)
    {
    case Gvoid:
      fprintf(fout,"0");
      break;
    case Gnegbool:
      fprintf(fout,"!");
      gencastf(fout,n,t,1);
      break;
    case Glg:
      if (f) fprintf(fout,"(");
      gencastf(fout,n,t,f);
      fprintf(fout," != 1");
      if (f) fprintf(fout,")");
      break;
    case Gsmall:
      gencastf(fout,n,t,f);
      break;
    case Gbptr:
      fprintf(fout,"*");
      gencastf(fout,n,t,1);
      break;
    case Ggen:
    case Gmp:
    case Gint:
      fprintf(fout,"!gcmp0(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gnegbool:
    switch(t)
    {
    case Gvoid:
      fprintf(fout,"1");
      break;
    case Glg:
      if (f) fprintf(fout,"(");
      gencastf(fout,n,t,f);
      fprintf(fout," == 1");
      if (f) fprintf(fout,")");
      break;
    case Gbool:
    case Gsmall:
      fprintf(fout,"!");
      gencastf(fout,n,t,1);
      break;
    case Gbptr:
      fprintf(fout,"!*");
      gencastf(fout,n,t,1);
      break;
    case Gint:
    case Gmp:
    case Ggen:
      fprintf(fout,"gcmp0(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gsmall:
    switch(t)
    {
    case Gbool:
    case Gtyp:
      gencastf(fout,n,t,f);
      break;
    case Gbptr:
      fprintf(fout,"*");
      gencastf(fout,n,t,1);
      break;
    case Gint:
      fprintf(fout,"itos(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    case Glg:
      if (tree[n].f==Fsmall)
        fprintf(fout,"%d",tree[n].x-1);
      else
      {
	if (f) fprintf(fout,"(");
	gencastf(fout,n,t,1);
	fprintf(fout,"-1");
	if (f) fprintf(fout,")");
      }
      break;
    default:
      return 0;
    }
    break;
  case Gint:
    switch(t)
    {
    case Gvoid:
      fprintf(fout,"gzero");
      break;
    case Gsmall:
    case Gbool:
      gencaststoi(fout,n,t);
      break;
    case Gmp:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Greal:
    switch(t)
    {
    case Gmp:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gmp:
    switch(t)
    {
    case Gint:
    case Greal:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Glg:
    switch(t)
    {
    case Gbool:
    case Gsmall:
      if (tree[n].f==Fsmall)
	fprintf(fout,"%d",tree[n].x+1);
      else
      {
	if (f) fprintf(fout,"(");
	gencastf(fout,n,t,1);
	fprintf(fout,"+1");
	if (f) fprintf(fout,")");
      }
      break;
    default:
      return 0;
    }
    break;
  case Gvecsmall:
    switch(t)
    {
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gvec:
    switch(t)
    {
    case Gnf:
    case Gbnf:
    case Gbnr:
    case Gell:
    case Gbell:
    case Gclgp:
    case Gprid:
    case Ggal:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gvar:
    switch(t)
    {
    case Gpol:
      fprintf(fout,"varn(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    case Ggen:
      fprintf(fout,"gvar(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gpol:
    switch(t)
    {
    case Gvar:
      fprintf(fout,"polx[");
      gencastf(fout,n,t,0);
      fprintf(fout,"]");
      break;
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Ggen:
    switch(t)
    {
    case Gint:
    case Gmp:
    case Gvecsmall:
    case Gvec:
    case Gpol:
    case Ggenstr:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Ggenstr:
    switch(t)
    {
    case Ggen:
      fprintf(fout,"concat(strtoGENstr(\"\", 0), ");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    case Gstr:
      fprintf(fout,"strtoGENstr(");
      gencastf(fout,n,t,0);
      fprintf(fout,", 0)");
      break;
    default:
      return 0;
    }
    break;
  case Gstr:
    switch(t)
    { 
    case Ggenstr:  
      /* Since str are always constant, we do not need to strdup() the result.
       */
      fprintf(fout,"GSTR(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    case Gtyp:
      fprintf(fout,"type_name(");
      gencastf(fout,n,t,0);
      fprintf(fout,")");
      break;
    default:
      return 0;
    }
    break;
  case Gtyp:
    switch(t)
    {
    case Gstr:
      if (is_const(n,CSTstr))
      {
	/*A little hack to make Karim impressed.*/
	const char *s=value[tree[n].x].val.str;
	if ( s[0]=='t' && s[1]=='_' )
	  fprintf(fout,"%s",s);
	else
          return 0;
      }
      else
        return 0;
      break;
    default:
      return 0;
    }
    break;
  case Gnf:
    switch(t)
    {
    case Gbnf:
      if (f) fprintf(fout,"(");
      fprintf(fout,"(GEN)");
      gencastf(fout,n,t,1);
      fprintf(fout,"[7]");
      if (f) fprintf(fout,")");
      break;
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gbnf:
    switch(t)
    {
    case Gbnr:
      if (f) fprintf(fout,"(");
      fprintf(fout,"(GEN)");
      gencastf(fout,n,t,1);
      fprintf(fout,"[1]");
      if (f) fprintf(fout,")");
      break;
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gbnr:
    switch(t)
    {
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gclgp:
    switch(t)
    {
    case Gbnf:
      if (f) fprintf(fout,"(");
      fprintf(fout,"gmael(");
      gencastf(fout,n,t,0);
      fprintf(fout,",8,1)");
      if (f) fprintf(fout,")");
      break;
    case Gbnr:
      if (f) fprintf(fout,"(");
      fprintf(fout,"(GEN)");
      gencastf(fout,n,t,1);
      fprintf(fout,"[5]");
      if (f) fprintf(fout,")");
      break;
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gell:
    switch(t)
    {
    case Gbell:
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gbell:
    switch(t)
    {
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Ggal:
    switch(t)
    {
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  case Gprid:
    switch(t)
    {
    case Ggen:
      gencastf(fout,n,t,f);
      break;
    default:
      return 0;
    }
    break;
  default:
    return 0;
  }
  return 1;
}
void gencastf(FILE *fout, int n, Gtype nt, int f)
{
  int t=tree[n].t;
  int tnt=typemax[t][nt];
  int i;
  if (t==nt)
  {
    /*bottom of the recursion*/
    if (f)
      genparens(fout,n);
    else
      gencode(fout,n);
    return;
  }
  if (gencastcode(fout,n,t,nt,f))
    return;
  /*the interesting case */
  if (is_subtype(t,nt))
    for (i=0;i<Gnbtype;i++)
      if (is_subtype(t,i) && is_subtype(i,nt))
	if (gencastcode(fout,n,i,nt,f))
	  return;
  if (is_subtype(nt,t))
    for (i=0;i<Gnbtype;i++)
      if (is_subtype(i,t) && is_subtype(nt,i))
	if (gencastcode(fout,n,i,nt,f))
	  return;
  if (gencastcode(fout,n,tnt,nt,f))
    return;
  if (debug)
    warning(-1,"No conversion method defined for %s->%s",Gname[t],Gname[nt]);
  for(i=0;i<Gnbtype;i++)
    if ( is_subtype(i,tnt) && is_subtype(nt,i))
      if (gencastcode(fout,n,i,nt,f))
	  return;
  die(-1,"No conversion method defined for %s->%s",Gname[t],Gname[nt]);
}

void gencastl(FILE *fout, int n, Gtype nt, int f)
{
  int m=tree[n].m;
  if ((m&(1<<Mlong)) && ctype[nt]==Vgen && ctype[tree[n].t]==Vgen)
  {
    if (f)
      genparensg(fout,n);
    else
      gencodeg(fout,n);
  }
  else
  {
    fprintf(fout,"(long) ");
    gencastf(fout,n,nt,f);
  }
}

void gencast(FILE *fout, int n, Gtype nt)
{
  if (nt<Gnbtype)
    gencastf(fout,n,nt,0);
  else
    gencode(fout,n);
}

void gencastnoarg(FILE *fout, int n, Gtype nt, int f) 
{
  if (n!=GNOARG) gencastf(fout,n,nt,f);
  else
    switch(nt)
    {
      case Gint:
      case Greal:
      case Gmp:
      case Gpol:
      case Gvec:
      case Ggen:
        fprintf(fout,"NULL");    
        break;
      case Gsmall:
        fprintf(fout,"0");    
        break;
      case Gvar:
        fprintf(fout,"-1");    
        break;
      case Gstr:
        fprintf(fout,"\"\"");    
        break;
      default:
        die(n,"Unknow default for type %s",Gname[nt]);
    }
}
