/*
Copyright (C) 2000-2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define TYPE
#include "header.h"
Gtype gentypefuncdesc(int n, gpfunc *gp);
void
inittrans(int n,int p)
{
  int i;
  for(i=0;i<Gnbtype;i++)
  {
    if (is_subtype(i,n))
      typemax[p][i]=typemax[i][p]=p;
    if (is_subtype(p,i))
      typemax[i][n]=typemax[n][i]=i;
  }
}
int
initmax(int n, int p)
{
  int i,m=Gnotype;
  for(i=0;i<Gnbtype;i++)
    if (is_subtype(n,i) && is_subtype(p,i))
      if(m==Gnotype || is_subtype(i,m))
	m=i;
  return m;
}
void outputtype(FILE *fout)
{
  int i,j;
  fprintf(fout,"        |");
  for(i=0;i<Gnbtype;i++)
    fprintf(fout,"%-8s",Gname[i]);
  fprintf(fout,"\n--------+");
  for(i=0;i<Gnbtype;i++)
    fprintf(fout,"--------");
  fprintf(fout,"\n");
  for(i=0;i<Gnbtype;i++)
  {
    /*No, this is not strange smileys*/
    fprintf(fout,"%-8s|",Gname[i]);
    for(j=0;j<Gnbtype;j++)
    {
      fprintf(fout,"%-8s",Gname[typemax[i][j]]);
    }
  fprintf(fout,"\n");
  }
}
void inittype(void)
{
  int n;
  int i,j;
  for(i=0;i<Gnbtype;i++)
    for(j=0;j<Gnbtype;j++)
      typemax[i][j]=(i==j)?i:Gnotype;
  for(n=0;typedesc[n]!=Gnotype;n++)
  {
    int i=n;
    for(n++;typedesc[n]!=Gnotype;i=n++)
    {
      int ti=typedesc[i];
      int tn=typedesc[n];
      typemax[ti][tn]=typemax[tn][ti]=tn;
    }
  }
  for(i=0;i<Gnbtype;i++)
    for(j=0;j<Gnbtype;j++)
      if (typemax[i][j]==j)
        inittrans(i,j);
  for(i=0;i<Gnbtype;i++)
    for(j=0;j<Gnbtype;j++)
      if (typemax[i][j]==Gnotype)
	typemax[i][j]=typemax[j][i]=initmax(i,j);
}
int gentypedeclaration(context *fc, int ind)
{
  int i;
  int val,t;
  int mode=0;
  for(i=0;i<fc->s.n;i++)
  {
    val=fc->c[i].initval;
    if (val!=-1)
    {
      t=gentype(val);
      if (fc->c[i].flag&(1<<Cauto) && ctxstack[ind+i].t<t)
      {
	ctxstack[ind+i].t=t;
	lastpass++;
      }
      mode|=tree[val].m;
    }
  }
  return mode;

}
void gentypedeffunc(int n)
{
  int funcid=tree[n].x;
  int seq=tree[n].y;
  const char *name=entryname(funcid);
  int savcf;
  ctxvar *ret;
  int tf;
  gpfunc *gp;
  context *fc;

  /*save current function*/
  savcf=currfunc;
  /*get function number and context*/
  currfunc=findfunction(name);
  gp=lfunc+currfunc;
  /*gentype for seq*/
  gentype(seq);
  /*gentype may change gp->type*/
  tf=gp->type;
  fc=block+gp->user->bl;
  /*get return var*/
  ret=getvarinblock(fc->ret,block+tree[seq].x);
  /*update prototype*/
  if (!is_subtype(ret->t,tf))
  {
    if(debug==2)
      fprintf(stderr,"%s returned %s now %s:",gp->gpname,Gname[tf],Gname[ret->t]);
    tf=gp->type=typemax[tf][ret->t];
    if (tf==Gnegbool) tf=gp->type=Gbool;
    if (tf==Glg) tf=gp->type=Gsmall;
    if (tf==Gstr) tf=gp->type=Ggenstr;
    if(debug==2)
      fprintf(stderr,"casted to %s\n",Gname[tf]);
     lastpass++;
  }
  if ((gp->mode^tree[seq].m)&((1<<Mprec)|(1<<Msidef)))
  {
    lastpass++;
    if(debug==2)
      fprintf(stderr,"%s mode %d now %d\n",gp->gpname,gp->mode,tree[seq].m);
    /*gp->mode|(tree[seq].m&((1<<Mprec)|(1<<Msidef))));*/
    gp->mode|=tree[seq].m&((1<<Mprec)|(1<<Msidef));
  }
  currfunc=savcf;
  /*create type*/
  tree[n].t=Gvoid;
  tree[n].m=(1<<Msidef);  
}
void gentypeblock(int n)
{
  int seq=tree[n].y;
  int savc;
  int mode;
  context *fc=block+tree[n].x;
  /*save new context address and gentype for seq*/
  savc=s_ctx.n;
  /*push context*/
  pushctx(fc);
  /*gentype for local var*/
  mode=gentypedeclaration(fc,savc);
  /*gentype for seq*/
  gentype(seq);
   /*save context*/
  copyctx(savc,fc);
  /*restore current context*/
  restorectx(savc);
  /*create type*/
  if (fc->ret==-1)
    tree[n].t=Gvoid;
  else
  {
    int v=getvarerr(fc->ret);
    tree[n].t=ctxstack[v].t;
  }
  tree[n].m=mode|(tree[seq].m&MODHERIT);
}
Gtype gentype(int n)
{
  int t,tx,ty;
  int mx,my;
  int x,y,c;
  gpfunc *gp;
  int nf;
  if (n<0)
    return Gnotype;
  x=tree[n].x;
  y=tree[n].y;
   if (tree[n].f<FneedENTRY)
  {
    tx=gentype(x);
    mx=(x>=0)?tree[x].m:0;
    ty=gentype(y);
    my=(y>=0)?tree[y].m:0;
  }
  switch(tree[n].f)
  {
  case Fseq:
    if (mx&(1<<Mterm))
    {
      tree[n].t=Gvoid;/*the seq end here*/
      tree[n].m=mx&MODHERIT;
    }
    else
    {
      tree[n].t=ty;/*for `if(1,a;b)' and others construct */
      tree[n].m=(my|mx)&MODHERIT;
    }
    break;
  case Fmatrixelts:
    tree[n].t=Gnotype;
    tree[n].m=(mx|my)&MODHERIT;
    break;
  case Fmatrixlines:
    tree[n].t=Gnotype;
    tree[n].m=(mx|my)&MODHERIT;
    break;
  case Fmatrix:
  case FmatrixR:
  case FmatrixL:
    tree[n].t=Gnotype;
    tree[n].m=0;
    break;
  case Ffacteurmat:
    tree[n].t=is_subtype(tx,Gvecsmall)?Gsmall:Ggen;
    tree[n].m=(mx&MODHERIT)|(1<<Mcopy);
    if (tree[y].f!=FmatrixL && tree[n].t==Ggen)
      tree[n].m|=1<<Mlong;
    break;
  case Faffect:
    {
      int z;
      tree[n].t=tx;/*Probably it should be ty*/
      tree[n].m=(mx|my)&MODHERIT;
      z=detag(tree[n].x);
      if (!is_subtype(ty,tx) && tree[z].f==Fentry)
      {
	int v=getvar(z);
	if (v!=-1)
	{
	  if (!(ctxstack[v].flag&(1<<Cauto)))
	  {
	    if ((ctxstack[v].flag&(1<<Cuser))) 
	      warning(n,"Type clash :%s!>=%s",Gname[tx],Gname[ty]);
	  }
	  else
	  {
	    ctxstack[v].t=typemax[tx][ty];
	    lastpass++;	
	    if (debug) fprintf(stderr,"casting %s from %s to %s now %s.\n",ctxstack[v].var,Gname[tx],Gname[ty],Gname[ctxstack[v].t]);
	    if(debug>=2)
	    {
	      printnode(stderr,n);
	      fprintf(stderr,"\n");
	    }
	    tree[n].t=ty;
	    tx=ty;
	    tree[x].t=tx;
	  }
	}
      }
      if (tx!=Gvoid)
	tree[n].m|=(1<<Msidef);
      tree[n].m|=(tree[z].m&(1<<Mlong))|(1<<Mparens);
    }
    break;
  case Fconst:
    tree[n].m=0;
    switch(value[x].type)
    {
    case CSTsmall:      
      tree[n].t=Gsmall;
      break;
    case CSTsmallreal:
      tree[n].t=Greal;
      tree[n].m=(1<<Mprec);
      break;
    case CSTexpr:
      tree[n].t=isanint(value[x].val.str)?Gint:Greal;
      break;
    case CSTstr:
      tree[n].t=Gstr;
      break;
    case CSTquote:
      tree[n].t=Gvar;
      break;
    }
    break;
  case Fsmall:
    tree[n].t=Gsmall;
    tree[n].m=0;
    break;
  case Femptyvec:
    tree[n].t=Gvec;
    tree[n].m=0;
    break;
  case Femptymat:
    tree[n].t=Ggen;
    tree[n].m=0;
    break;
  case Fmat:
    tree[n].t=Ggen;
    tree[n].m=mx&MODHERIT;
    break;
  case Flistarg:
    tree[n].t=Gnotype;
    tree[n].m=(mx|my)&MODHERIT;
    break;
  case Ftag:
    tree[n].t=y;
    gentype(x);
    tree[n].m=tree[x].m&MODHERIT;
    break;
  case Frefarg:
  case Fentry:
    c=getvar(n);
    if (c>=0)
    {	  
      tree[n].t=ctxstack[c].t;
      tree[n].m=(1<<Mvar);
      if (ctxstack[c].flag&(1<<Carg))
        tree[n].m|=(1<<Mcopy);
    }
    else
      die(n,"Internal error: extra variable `%s' in gentype",value[x].val.str);
    break;
  case Fentryfunc:
    nf=findfunction(entryname(n));
    gp=lfunc+nf;
    if (nf>=0) 
    {
      if (gp->type==Gnotype && gp->spec>0)
        /* is a special function ? */
        tree[n].t=gentypefuncspec(n,gp);
      else if (gp->dsc && (t=gentypefuncdesc(n,gp))!=Gnotype) 
        /* else has the function a description ?*/ 
        tree[n].t=t;
      else
        /* else use the function a type */ 
      {
        gentype(y);
        tree[n].t=gp->type;
        my=(y==-1)?0:tree[y].m;
        tree[n].m=(gp->mode&(~(1<<Msemicomma)))|(my&MODHERIT);
      }
    }
    else
    {
      gentype(y);
      my=(y==-1)?0:tree[y].m;
      tree[n].t=Ggen;
      tree[n].m=my&MODHERIT;
      warning(n,"function prototype is unknown");
    }
    break;
  case Fdeffunc:
    gentypedeffunc(n);
    break;
  case Fblock:
    gentypeblock(n);
    break;
  case Fgnil:
    if (n!=GNOARG && n!=GNIL)
    {
      tree[n].m=0;
      tree[n].t=Gvoid;
      warning(n,"Internal warning: new gnil.");
    }
    break;
  default:
    die(n,"Internal error: Incorrect node %s in gentype",funcname(tree[n].f));
  }
  return tree[n].t;
}
