/*
Copyright (C) 2000  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

typedef enum {Mvar, Msidef, Mterm, Mprec, Msemicomma, Mparens, Mbrace, Melse, Mcopy, Mlong, Mnbmode} Mmode;
/*gentype:
  Mvar :  value cannot be determined at compile time
  Msidef: Statement has (probably) a side effect
  Mterm:  Statement never return.
  Mprec:  function need the prec arg.
  Melse     :  This is an if else block, (try to) be clever...
  If there is doubt, set Mvar, Msidef and Mprec but not Mterm.
  moveblock:
  Msemicomma:  This is a full statement, no need of ';'
  Mparens   :  May need to be braced by parens.
  Mbrace    :  This is a false block, no need of '{}'
  Mcopy	    :  May need to be gcopyed.
  Mlong	    :  long that need to be casted to GEN
*/ 
#define MODHERIT ((1<<Mvar)|(1<<Msidef)|(1<<Mterm)|(1<<Mprec))

typedef enum {Vvoid, Vsmall, Vgen, Vstr, Vbptr, Vgptr, Vulong} Vtype;

typedef enum {Gempty,Gvoid, Gnegbool, Gbool, Gsmall, Gint, Greal, Gmp, Glg, Gvecsmall, Gvec, Gvar, Gpol, Ggen, Ggenstr, Gstr, Gbptr, Ggptr, Gulong, Gtyp, Gnf, Gbnf, Gbnr, Gell, Gbell, Gclgp, Gprid, Ggal, Gnbtype, Gnotype, Ggc} Gtype;

Gtype typemax[Gnbtype][Gnbtype];
static inline int is_subtype(Gtype a, Gtype b) {return typemax[a][b]==b;}
#ifndef TYPE
extern const char *Mname[];
extern const char *Gname[];
extern const char *cname[];
extern const char *cproto[];
extern const char *creturn[];
extern const char *cdefault[];
extern const char *opname[];
extern const Vtype ctype[];
#else
const char *Mname[]={"var","sidef","term","prec","semicomma","parens","brace","else","copy","long","nbmode",""};
const char *cname[]={"void %s","long %s","GEN %s","char *%s","byteptr %s","GEN *%s[]","ulong %s"};
const char *cproto[]={NULL,"L","G","s",NULL,NULL,NULL};
const char *creturn[]={"v","l","",NULL,NULL,NULL,NULL};
const char *cdefault[]={NULL,"0","0","\\\"\\\"",NULL,NULL,NULL};
const char *Gname[]={"empty","void","negbool","bool","small","int","real","mp","lg","vecsmall","vec","var","pol","gen","genstr","str","bptr","gptr","ulong","typ","nf","bnf","bnr","ell","bell","clgp","prid","gal","nbtype","notype","gc",""};

const Vtype ctype[]={Vvoid,Vvoid,Vsmall,Vsmall,Vsmall,Vgen,Vgen,Vgen,Vsmall,Vgen,Vgen,Vsmall,Vgen,Vgen,Vgen,Vstr,Vbptr,Vgptr,Vulong,Vsmall,Vgen,Vgen,Vgen,Vgen,Vgen,Vgen,Vgen,Vgen};
const Gtype typedesc[]={Gempty,Gvoid, Gbool, Gsmall, Gint, Gmp, Ggen, Gnotype,
                        Gempty,Greal,Gmp,Gnotype,
                        Gempty,Gbptr,Gsmall,Gnotype,
                        Gempty,Gbool,Glg,Gsmall,Gnotype,
                        Gempty,Gvoid,Gnegbool,Gbool,Gnotype,
                        Gempty,Gtyp,Gstr,Ggenstr,Ggen,Gnotype,
                        Gempty,Gvecsmall,Ggen,Gnotype,
                        Gempty,Gvec,Ggen,Gnotype,
                        Gempty,Gbnr,Gbnf,Gnf,Gvec,Gnotype,
                        Gempty,Gbnr,Gbnf,Gclgp,Gvec,Gnotype,
                        Gempty,Gbell,Gell,Gvec,Gnotype,
                        Gempty,Gprid,Gvec,Gnotype,
                        Gempty,Ggal,Gvec,Gnotype,
                        Gempty,Gvar,Gpol,Ggen,Gnotype,
                        Gnotype};
#endif
