#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "pari/pari.h"

#if defined (USG) || defined (__SVR4) || defined (_UNICOS) || defined(HPUX)
#include <time.h>

int
cputime ()
{
  if (CLOCKS_PER_SEC < 100000)
    return clock () * 1000 / CLOCKS_PER_SEC;
  return clock () / (CLOCKS_PER_SEC / 1000);
}
#else
#include <sys/types.h>
#include <sys/resource.h>

int
cputime ()
{
  struct rusage rus;

  getrusage (0, &rus);
  return rus.ru_utime.tv_sec * 1000 + rus.ru_utime.tv_usec / 1000;
}
#endif

int
main(int argc, char *argv[])
{
  int n, prec, st, st2, N, i;
  GEN x, y, z, r, s, X;
  unsigned long ltop;

  if (argc != 2 && argc != 3) {
    fprintf(stderr, "Usage: timing digits [N]\n"); exit(1);
  }
  n = atoi(argv[1]);
  if (argc==3)  N = atoi(argv[2]);
  prec = (int) ( n * log(10.0) / log(2.0) + 1.0 );
  printf("prec=%u\n", n);

  init(10000000, 2); 

  x = randomi(int2n(prec));
  y = randomi(int2n(prec));
  X = randomi(int2n(2 * prec));

  ltop = avma; 
//  printf("starts computing...\n");

  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = addii (x, y), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("addii      took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = mulii (x, y), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("mulii      took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = diviiexact (X, y), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("diviiexact took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = divii (X, y), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("divii      took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = dvmdii (X, y, &r), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("dvmdii     took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = gcdii (x, y), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("gcdii      took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
  N=1;  st = cputime();
  do {
    for (i=0;i<N;i++) z = bezout (x, y, &r,&s), avma = ltop;
    N=2*N;
    st2=cputime();
  } while (st2-st<1000);
  printf("bezout     took %f ms (%d eval in %d ms)\n",
         (double)(st2-st)/(N-1),N-1,st2-st);
}
