/* $Id: compat.c,v 1.17 2001/12/05 19:37:14 karim Exp $

Copyright (C) 2000  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "pari.h"
extern GEN geni(void);

static GEN
prod0(GEN x, entree *ep, GEN a, GEN b, char *ch) {return produit(ep,a,b,ch,x);}

static GEN
sum0(GEN x, entree *ep, GEN a, GEN b, char *ch) {return somme(ep,a,b,ch,x);}

static long
sturm0(GEN x) {return sturm(x);}

static GEN
sigmak0(long k, GEN x) {return gsumdivk(x,k);}

static GEN
lseriesell0(GEN a, GEN b, GEN c, GEN d, long prec)
  {(void)c; return lseriesell(a,b,d,prec);}

static GEN
subres0(GEN x, GEN y) { return subres(x,y); }

static long
rounderror(GEN x)
{
  long e, av=avma;
  grndtoi(x,&e); avma=av; return (long)(e*L2SL10);
}

static GEN
_factpol(GEN x, long unused, long hint) { return factpol(x,hint); }

static void
suppressed(void) {err(talker,"this function has been suppressed");}

entree oldfonctions[]={
{"O",50,NULL,7,NULL},
{"abs",1,(void *)gabs,3,"Gp"},
{"acos",1,(void *)gacos,3,"Gp"},
{"acosh",1,(void *)gach,3,"Gp"},
{"addell",3,(void *)addell,5,"GGG"},
{"addprimes",1,(void *)addprimes,4,"G"},
{"adj",1,(void *)adj,8,"G"},
{"agm",2,(void *)agm,3,"GGp"},
{"akell",2,(void *)akell,5,"GG"},
{"algdep",23,(void *)algdep,8,"GLp"},
{"algdep2",33,(void *)algdep2,8,"GLLp"},
{"algtobasis",2,(void*)algtobasis,6,"GG"},
{"anell",23,(void *)anell,5,"GL"},
{"apell",2,(void *)apell,5,"GG"},
{"apell2",2,(void *)apell2,5,"GG"},
{"apprpadic",2,(void *)apprgen9,7,"GG"},
{"arg",1,(void *)garg,3,"Gp"},
{"asin",1,(void *)gasin,3,"Gp"},
{"asinh",1,(void *)gash,3,"Gp"},
{"assmat",1,(void *)assmat,8,"G"},
{"atan",1,(void *)gatan,3,"Gp"},
{"atanh",1,(void *)gath,3,"Gp"},
{"basis",13,(void *)base,6,"Gf"},
{"basis2",13,(void *)base2,6,"Gf"},
{"basistoalg",2,(void*)basistoalg,6,"GG"},
{"bernreal",11,(void *)bernreal,3,"Lp"},
{"bernvec",11,(void *)bernvec,3,"L"},
{"bestappr",2,(void *)bestappr,4,"GGp"},
{"bezout",2,(void *)vecbezout,4,"GG"},
{"bezoutres",2,(void *)vecbezoutres,4,"GG"},
{"bigomega",1,(void *)gbigomega,4,"G"},
{"bilhell",3,(void *)bilhell,5,"GGGp"},
{"bin",21,(void *)binome,4,"GL"},
{"binary",1,(void *)binaire,2,"G"},
{"bittest",2,(void *)gbittest,2,"GG"},
{"boundcf",21,(void *)gboundcf,4,"GL"},
{"boundfact",21,(void *)boundfact,4,"GL"},
{"buchcertify",10,(void *)certifybuchall,6,"lG"},
{"buchfu",1,(void *)buchfu,6,"Gp"},
{"buchgen",92,(void *)buchall,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,D0,L,p"},
{"buchgenforcefu",95,(void *)buchall,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,D3,L,p"},
{"buchgenfu",94,(void *)buchall,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,D2,L,p"},
{"buchimag",96,(void *)buchimag,4,"GD0.1,G,D0.1,G,D5,G,"},
{"buchinit",91,(void *)buchall,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,D-1,L,p"},
{"buchinitforcefu",89,(void *)buchall,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,D-3,L,p"},
{"buchinitfu",90,(void *)buchall,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,D-2,L,p"},
{"buchnarrow",1,(void *)buchnarrow,6,"Gp"},
{"buchray",2,(void *)buchray,6,"GGp"},
{"buchrayinit",2,(void *)buchrayinit,6,"GGp"},
{"buchrayinitgen",2,(void *)buchrayinitgen,6,"GGp"},
{"buchreal",97,(void *)buchreal,4,"GD0,G,D0.1,G,D0.1,G,D5,G,p"},
{"bytesize",10,(void *)taille2,2,"lG"},
{"ceil",1,(void *)gceil,2,"G"},
{"centerlift",1,(void *)centerlift,2,"G"},
{"cf",1,(void *)gcf,4,"Gp"},
{"cf2",2,(void *)gcf2,4,"GGp"},
{"changevar",2,(void *)changevar,2,"GG"},
{"char",14,(void *)caradj0,8,"Gn"},
{"char1",14,(void *)caract,8,"Gn"},
{"char2",14,(void *)carhess,8,"Gn"},
{"chell",2,(void *)coordch,5,"GG"},
{"chinese",2,(void *)chinois,4,"GG"},
{"chptell",2,(void *)pointch,5,"GG"},
{"classno",1,(void *)classno,4,"G"},
{"classno2",1,(void *)classno2,4,"G"},
{"coeff",21,(void *)truecoeff,2,"GL"},
{"compimag",2,(void *)compimag,4,"GG"},
{"compo",21,(void *)compo,2,"GL"},
{"compositum",2,(void *)compositum,6,"GG"},
{"compositum2",2,(void *)compositum2,6,"GG"},
{"comprealraw",2,(void *)comprealraw,4,"GG"},
{"concat",2,(void *)concat,8,"GG"},
{"conductor",62,(void *)bnrconductor,6,"GD0,G,D0,G,D1,L,"},
{"conductorofchar",2,(void *)bnrconductorofchar,6,"GG"},
{"conj",1,(void *)gconj,2,"G"},
{"conjvec",1,(void *)conjvec,2,"Gp"},
{"content",1,(void *)content,4,"G"},
{"convol",2,(void *)convol,7,"GG"},
{"core",1,(void *)core,4,"G"},
{"core2",1,(void *)core2,4,"G"},
{"coredisc",1,(void *)coredisc,4,"G"},
{"coredisc2",1,(void *)coredisc2,4,"G"},
{"cos",1,(void *)gcos,3,"Gp"},
{"cosh",1,(void *)gch,3,"Gp"},
{"cvtoi",13,(void *)gcvtoi,2,"Gf"},
{"cyclo",11,(void *)cyclo,7,"LDn"},
{"decodefactor",1,(void *)factorback,4,"G"},
{"decodemodule",2,(void *)decodemodule,6,"GG"},
{"degree",10,(void *)degree,2,"lG"},
{"denom",1,(void *)denom,2,"G"},
{"deplin",1,(void *)deplin,8,"Gp"},
{"deriv",14,(void *)deriv,7,"Gn"},
{"det",1,(void *)det,8,"G"},
{"det2",1,(void *)det2,8,"G"},
{"detint",1,(void *)detint,8,"G"},
{"diagonal",1,(void *)diagonal,8,"G"},
{"dilog",1,(void *)dilog,3,"Gp"},
{"dirdiv",2,(void *)dirdiv,7,"GG"},
{"direuler",83,(void *)direuler,7,"V=GGI"},
{"dirmul",2,(void *)dirmul,7,"GG"},
{"dirzetak",2,(void *)dirzetak,6,"GG"},
{"disc",1,(void *)discsr,7,"G"},
{"discf",1,(void *)discf,6,"G"},
{"discf2",1,(void *)discf2,6,"G"},
{"discrayabs",62,(void *)bnrdisc0,6,"GD0,G,D0,G,D0,L,"},
{"discrayabscond",62,(void *)bnrdisc0,6,"GD0,G,D0,G,D2,L,"},
{"discrayabslist",2,(void *)discrayabslist,6,"GG"},
{"discrayabslistarch",32,(void *)discrayabslistarch,6,"GGL"},
{"discrayabslistarchall",32,(void *)discrayabslistarch,6,"GL"},
{"discrayabslistlong",21,(void *)discrayabslistlong,6,"GL"},
{"discrayrel",62,(void *)bnrdisc0,6,"GD0,G,D0,G,D1,L,"},
{"discrayrelcond",62,(void *)bnrdisc0,6,"GD0,G,D0,G,D3,L,"},
{"divisors",1,(void *)divisors,4,"G"},
{"divres",2,(void *)gdiventres,1,"GG"},
{"divsum",22,(void *)divsum,9,"GVI"},
{"eigen",1,(void *)eigen,8,"Gp"},
{"eint1",1,(void *)eint1,3,"Gp"},
{"erfc",1,(void *)gerfc,3,"Gp"},
{"eta",1,(void *)eta,3,"Gp"},
{"euler",0,(void *)mpeuler,3,"p"},
{"eval",1,(void *)geval,7,"G"},
{"exp",1,(void *)gexp,3,"Gp"},
{"extract",2,(void *)extract,8,"GG"},
{"fact",11,(void *)mpfactr,4,"Lp"},
{"factcantor",2,(void *)factcantor,4,"GG"},
{"factfq",3,(void *)factmod9,4,"GGG"},
{"factmod",2,(void *)factmod,4,"GG"},
{"factor",1,(void *)factor,4,"G"},
{"factoredbasis",28,(void *)factoredbase,6,"GGf"},
{"factoreddiscf",2,(void *)factoreddiscf,6,"GG"},
{"factoredpolred",2,(void *)factoredpolred,6,"GGp"},
{"factoredpolred2",2,(void *)factoredpolred2,6,"GGp"},
{"factornf",2,(void *)polfnf,6,"GG"},
{"factorpadic",32,(void *)factorpadic4,7,"GGL"},
{"factorpadic2",32,(void *)factorpadic2,7,"GGL"},
{"factpol",33,(void *)_factpol,7,"GLL"},
{"factpol2",0,(void *)suppressed,6,"GL"},
{"fibo",11,(void *)fibo,4,"L"},
{"floor",1,(void *)gfloor,2,"G"},
{"for",83,(void *)forpari,11,"vV=GGI"},
{"fordiv",84,(void *)fordiv,11,"vGVI"},
{"forprime",83,(void *)forprime,11,"vV=GGI"},
{"forstep",86,(void *)forstep,11,"vV=GGGI"},
{"forvec",87,(void*)forvec,11,"vV=GID0,L,"},
{"fpn",21,(void *)ffinit,2,"GLDn"},
{"frac",1,(void *)gfrac,2,"G"},
{"galois",1,(void *)galois,6,"Gp"},
{"galoisapply",3,(void *)galoisapply,6,"GGG"},
{"galoisconj",1,(void *)galoisconj,6,"G"},
{"galoisconj1",0,(void *)suppressed,6,"G"},
{"galoisconjforce",0,(void *)suppressed,6,"G"},
{"gamh",1,(void *)ggamd,3,"Gp"},
{"gamma",1,(void *)ggamma,3,"Gp"},
{"gauss",2,(void *)gauss,8,"GG"},
{"gaussmodulo",3,(void *)gaussmodulo,8,"GGG"},
{"gaussmodulo2",3,(void *)gaussmodulo2,8,"GGG"},
{"gcd",2,(void *)ggcd,4,"GG"},
{"getheap",0,(void *)getheap,2,""},
{"getrand",0,(void *)getrand,2,"l"},
{"getstack",0,(void *)getstack,2,"l"},
{"gettime",0,(void *)gettime,2,"l"},
{"globalred",1,(void *)globalreduction,5,"G"},
{"goto",0,(void*)suppressed,11,"s*"},
{"hclassno",1,(void *)hclassno,4,"G"},
{"hell",2,(void *)ghell,5,"GGp"},
{"hell2",2,(void *)ghell2,5,"GGp"},
{"hermite",1,(void *)hnf,8,"G"},
{"hermite2",1,(void *)hnfall,8,"G"},
{"hermitehavas",0,(void *)suppressed,8,"G"},
{"hermitemod",2,(void *)hnfmod,8,"GG"},
{"hermitemodid",2,(void *)hnfmodid,8,"GG"},
{"hermiteperm",1,(void *)hnfperm,8,"G"},
{"hess",1,(void *)hess,8,"G"},
{"hilb",30,(void *) hil,4,"lGGG"},
{"hilbert",11,(void *)mathilbert,8,"L"},
{"hilbp",20,(void *) hil,4,"lGG"},
{"hvector",22,(void *)vecteur,9,"GVI"},
{"hyperu",3,(void *)hyperu,3,"GGGp"},
{"i",0,(void *)geni,2,""},
{"idealadd",3,(void *)idealadd,6,"GGG"},
{"idealaddmultone",2,(void *)idealaddmultoone,6,"GG"},
{"idealaddone",3,(void *)idealaddtoone,6,"GGG"},
{"idealappr",2,(void *)idealappr,6,"GGp"},
{"idealapprfact",2,(void *)idealapprfact,6,"GG"},
{"idealchinese",3,(void *)idealchinese,6,"GGG"},
{"idealcoprime",3,(void *)idealcoprime,6,"GGG"},
{"idealdiv",3,(void *)idealdiv,6,"GGG"},
{"idealdivexact",3,(void *)idealdivexact,6,"GGG"},
{"idealfactor",2,(void *)idealfactor,6,"GG"},
{"idealhermite",2,(void *)idealhermite,6,"GG"},
{"idealhermite2",3,(void *)idealhermite2,6,"GGG"},
{"idealintersect",3,(void *)idealintersect,6,"GGG"},
{"idealinv",2,(void *)idealinv,6,"GG"},
{"idealinv2",2,(void *)idealinv,6,"GG"},
{"ideallist",21,(void *)ideallist,6,"GL"},
{"ideallistarch",3,(void *)ideallistarch,6,"GGG"},
{"ideallistarchgen",3,(void *)ideallistarchgen,6,"GGG"},
{"ideallistunit",21,(void *)ideallistunit,6,"GL"},
{"ideallistunitarch",3,(void *)ideallistunitarch,6,"GGG"},
{"ideallistunitarchgen",3,(void *)ideallistunitarchgen,6,"GGG"},
{"ideallistunitgen",21,(void *)ideallistunitgen,6,"GL"},
{"ideallistzstar",21,(void *)ideallistzstar,6,"GL"},
{"ideallistzstargen",21,(void *)ideallistzstargen,6,"GL"},
{"ideallllred",3,(void *)ideallllred,6,"GGGp"},
{"idealmul",3,(void *)idealmul,6,"GGG"},
{"idealmulred",3,(void *)idealmulred,6,"GGGp"},
{"idealnorm",2,(void *)idealnorm,6,"GG"},
{"idealpow",3,(void *)idealpow,6,"GGG"},
{"idealpowred",3,(void *)idealpowred,6,"GGGp"},
{"idealtwoelt",2,(void *)ideal_two_elt,6,"GG"},
{"idealtwoelt2",3,(void *)ideal_two_elt2,6,"GGG"},
{"idealval",30,(void *)idealval,6,"lGGG"},
{"idmat",11,(void *)idmat,8,"L"},
{"if",80,NULL,11,NULL},
{"imag",1,(void *)gimag,2,"G"},
{"image",1,(void *)image,8,"G"},
{"image2",1,(void *)image2,8,"G"},
{"imagecompl",1,(void *)imagecompl,8,"G"},
{"incgam",2,(void *)incgam,3,"GGp"},
{"incgam1",2,(void *)incgam1,3,"GGp"},
{"incgam2",2,(void *)incgam2,3,"GGp"},
{"incgam3",2,(void *)incgam3,3,"GGp"},
{"incgam4",3,(void *)incgam4,3,"GGGp"},
{"indexrank",1,(void *)indexrank,8,"G"},
{"indsort",1,(void *)indexsort,8,"G"},
{"initalg",1,(void *)initalg,6,"Gp"},
{"initalgred",1,(void *)initalgred,6,"Gp"},
{"initalgred2",1,(void *)initalgred2,6,"Gp"},
{"initell",1,(void *)initell,5,"Gp"},
{"initzeta",1,(void *)initzeta,6,"Gp"},
{"integ",14,(void *)integ,7,"Gn"},
{"intersect",2,(void *)intersect,8,"GG"},
{"intgen",37,(void *)rombint,9,"V=GGIp"},
{"intinf",37,(void *)qromi,9,"V=GGIp"},
{"intnum",37,(void *)qromb,9,"V=GGIp"},
{"intopen",37,(void *)qromo,9,"V=GGIp"},
{"inverseimage",2,(void *)inverseimage,8,"GG"},
{"isdiagonal",10,(void *)isdiagonal,8,"lG"},
{"isfund",1,(void *)gisfundamental,4,"G"},
{"isideal",20,(void *)isideal,6,"lGG"},
{"isincl",2,(void *)nfisincl,6,"GG"},
{"isinclfast",2,(void *)nfisincl,6,"GG"},
{"isirreducible",1,(void *)gisirreducible,7,"G"},
{"isisom",2,(void *)nfisisom,6,"GG"},
{"isisomfast",2,(void *)nfisisom,6,"GG"},
{"isoncurve",20,(void *)oncurve,5,"lGG"},
{"isprime",1,(void *)gisprime,4,"GD0,L,"},
{"isprincipal",2,(void *)isprincipal,6,"GG"},
{"isprincipalforce",2,(void *)isprincipalforce,6,"GG"},
{"isprincipalgen",2,(void *)isprincipalgen,6,"GG"},
{"isprincipalgenforce",2,(void *)isprincipalgenforce,6,"GG"},
{"isprincipalray",2,(void *)isprincipalray,6,"GG"},
{"isprincipalraygen",2,(void *)isprincipalraygen,6,"GG"},
{"ispsp",1,(void *)gispsp,4,"G"},
{"isqrt",1,(void *)racine,4,"G"},
{"isset",10,(void *)setisset,8,"lG"},
{"issqfree",1,(void *)gissquarefree,4,"G"},
{"issquare",1,(void *)gcarreparfait,4,"G"},
{"isunit",2,(void *)isunit,6,"GG"},
{"jacobi",1,(void *)jacobi,8,"Gp"},
{"jbesselh",2,(void *)jbesselh,3,"GGp"},
{"jell",1,(void *)jell,3,"Gp"},
{"karamul",0,(void *)suppressed,7,"GGL"},
{"kbessel",2,(void *)kbessel,3,"GGp"},
{"kbessel2",2,(void *)kbessel2,3,"GGp"},
{"ker",1,(void *)ker,8,"G"},
{"keri",1,(void *)keri,8,"G"},
{"kerint",1,(void *)kerint,8,"G"},
{"kerint1",1,(void *)kerint1,8,"G"},
{"kerint2",1,(void *)kerint2,8,"G"},
{"kro",2,(void *)gkronecker,4,"GG"},
{"label",0,(void*)suppressed,11,"s*"},
{"lambdak",2,(void *)glambdak,6,"GGp"},
{"laplace",1,(void *)laplace,7,"G"},
{"lcm",2,(void *)glcm,4,"GG"},
{"legendre",11,(void *)legendre,7,"LDn"},
{"length",1,(void *)glength,2,"lG"},
{"lex",20,(void *)lexcmp,2,"lGG"},
{"lexsort",1,(void *)lexsort,8,"G"},
{"lift",1,(void *)lift,2,"G"},
{"lindep",1,(void *)lindep,8,"Gp"},
{"lindep2",23,(void *)lindep2,8,"GLp"},
{"lll",1,(void *)lll,8,"Gp"},
{"lll1",1,(void *)lll1,8,"Gp"},
{"lllgen",1,(void *)lllgen,8,"Gp"},
{"lllgram",1,(void *)lllgram,8,"Gp"},
{"lllgram1",1,(void *)lllgram1,8,"Gp"},
{"lllgramgen",1,(void *)lllgramgen,8,"G"},
{"lllgramint",1,(void *)lllgramint,8,"G"},
{"lllgramkerim",1,(void *)lllgramkerim,8,"G"},
{"lllgramkerimgen",1,(void *)lllgramkerimgen,8,"G"},
{"lllint",1,(void *)lllint,8,"G"},
{"lllintpartial",1,(void *)lllintpartial,8,"G"},
{"lllkerim",1,(void *)lllkerim,8,"G"},
{"lllkerimgen",1,(void *)lllkerimgen,8,"G"},
{"lllrat",1,(void *)lllrat,8,"G"},
{"ln",1,(void *)glog,3,"Gp"},
{"lngamma",1,(void *)glngamma,3,"Gp"},
{"localred",2,(void *)localreduction,5,"GG"},
{"log",1,(void *)glog,3,"Gp"},
{"logagm",1,(void *)glogagm,3,"Gp"},
{"lseriesell",4,(void *)lseriesell0,5,"GGGGp"},
{"makebigbnf",1,(void *)bnfmake,6,"Gp"},
{"mat",1,(void *)gtomat,8,"G"},
{"matextract",3,(void *)matextract,8,"GGG"},
{"mathell",2,(void *)mathell,5,"GGp"},
{"matrix",49,(void *)matrice,9,"GGVVI"},
{"matrixqz",2,(void *)matrixqz,8,"GG"},
{"matrixqz2",1,(void *)matrixqz2,8,"G"},
{"matrixqz3",1,(void *)matrixqz3,8,"G"},
{"matsize",1,(void *)matsize,2,"G"},
{"max",2,(void *)gmax,1,"GG"},
{"min",2,(void *)gmin,1,"GG"},
{"minideal",3,(void *)minideal,6,"GGGp"},
{"minim",33,(void *)minim,8,"GGG"},
{"minim2",23,(void *)minim2,8,"GG"},
{"mod",25,(void *)gmodulcp,2,"GG"},
{"modp",25,(void *)gmodulo,2,"GG"},
{"modreverse",1,(void *)polymodrecip,6,"G"},
{"modulargcd",2,(void *)modulargcd,2,"GG"},
{"mu",1,(void *)gmu,4,"G"},
{"newtonpoly",2,(void *)newtonpoly,6,"GG"},
{"nextprime",1,(void *)nextprime,4,"G"},
{"nfdetint",2,(void *)nfdetint,6,"GG"},
{"nfdiv",3,(void *)element_div,6,"GGG"},
{"nfdiveuc",3,(void *)nfdiveuc,6,"GGG"},
{"nfdivres",3,(void *)nfdivres,6,"GGG"},
{"nfhermite",2,(void *)nfhermite,6,"GG"},
{"nfhermitemod",3,(void *)nfhermitemod,6,"GGG"},
{"nfmod",3,(void *)nfmod,6,"GGG"},
{"nfmul",3,(void *)element_mul,6,"GGG"},
{"nfpow",3,(void *)element_pow,6,"GGG"},
{"nfreduce",3,(void *)element_reduce,6,"GGG"},
{"nfsmith",2,(void *)nfsmith,6,"GG"},
{"nfval",30,(void *)element_val,6,"lGGG"},
{"norm",1,(void *)gnorm,2,"G"},
{"norml2",1,(void *)gnorml2,2,"G"},
{"nucomp",3,(void *)nucomp,4,"GGG"},
{"numdiv",1,(void *)numbdiv,4,"G"},
{"numer",1,(void *)numer,2,"G"},
{"nupow",2,(void *)nupow,4,"GG"},
{"o",50,NULL,7,NULL},
{"omega",1,(void *)gomega,4,"G"},
{"ordell",2,(void *)ordell,5,"GGp"},
{"order",1,(void *)order,4,"G"},
{"orderell",2,(void *)orderell,5,"GG"},
{"ordred",1,(void *)ordred,6,"Gp"},
{"padicprec",20,(void *)padicprec,2,"lGG"},
{"pascal",99,(void *)matqpascal,8,"LDG"},
{"perf",10,(void *)perf,8,"G"},
{"permutation",24,(void *)numtoperm,2,"LG"},
{"permutation2num",1,(void *)permtonum,2,"G"},
{"pf",2,(void *)primeform,4,"GGp"},
{"phi",1,(void *)phi,4,"G"},
{"pi",0,(void *)mppi,3,"p"},
{"pnqn",1,(void *)pnqn,4,"G"},
{"pointell",2,(void *)pointell,5,"GGp"},
{"polint",31,(void *)polint,7,"GGGD&"},
{"polred",1,(void *)polred,6,"Gp"},
{"polred2",1,(void *)polred2,6,"Gp"},
{"polredabs",1,(void *)polredabs,6,"Gp"},
{"polredabs2",1,(void *)polredabs2,6,"Gp"},
{"polredabsall",1,(void *)polredabsall,6,"Gp"},
{"polredabsfast",0,(void *)suppressed,6,""},
{"polredabsnored",1,(void *)polredabsnored,6,"Gp"},
{"polsym",21,(void *)polsym,7,"GL"},
{"polvar",1,(void *)gpolvar,2,"G"},
{"poly",14,(void *)gtopoly,2,"Gn"},
{"polylog",24,(void *)gpolylog,3,"LGp"},
{"polylogd",24,(void *)polylogd,3,"LGp"},
{"polylogdold",24,(void *)polylogdold,3,"LGp"},
{"polylogp",24,(void *)polylogp,3,"LGp"},
{"polyrev",14,(void *)gtopolyrev,2,"Gn"},
{"polzag",21,(void *)polzag,9,"LL"},
{"powell",3,(void *)powell,5,"GGGp"},
{"powrealraw",23,(void *)powrealraw,4,"GL"},
{"prec",21,(void *)gprec,2,"GL"},
{"precision",1,(void *)ggprecision,2,"G"},
{"prime",11,(void *)prime,4,"L"},
{"primedec",2,(void *)primedec,6,"GG"},
{"primes",11,(void *)primes,4,"L"},
{"primroot",1,(void *)gener,4,"G"},
{"principalideal",2,(void *)principalideal,6,"GG"},
{"principalidele",2,(void *)principalidele,6,"GGp"},
{"prod",48,(void *)prod0,9,"GV=GGI"},
{"prodeuler",37,(void *)prodeuler,9,"V=GGIp"},
{"prodinf",27,(void *)prodinf,9,"V=GIp"},
{"prodinf1",27,(void *)prodinf1,9,"V=GIp"},
{"psi",1,(void *)gpsi,3,"Gp"},
{"qfi",3,(void *)qfi,4,"GGG"},
{"qfr",4,(void *)qfr,4,"GGGG"},
{"quaddisc",1,(void *)quaddisc,4,"G"},
{"quadgen",1,(void *)quadgen,2,"G"},
{"quadpoly",1,(void *)quadpoly,2,"G"},
{"random",0,(void *)genrand,2,"DG"},
{"rank",10,(void *)rank,8,"lG"},
{"rayclassno",2,(void *)rayclassno,6,"GG"},
{"rayclassnolist",2,(void *)rayclassnolist,6,"GG"},
{"real",1,(void *)greal,2,"G"},
{"recip",1,(void *)polrecip,7,"G"},
{"redimag",1,(void *)redimag,4,"G"},
{"redreal",1,(void *)redreal,4,"G"},
{"redrealnod",2,(void *)redrealnod,4,"GG"},
{"reduceddisc",1,(void *)reduceddiscsmith,7,"G"},
{"regula",1,(void *)regula,4,"Gp"},
{"reorder",1,(void *)reorder,11,"G"},
{"resultant",2,(void *)subres0,7,"GG"},
{"resultant2",2,(void *)resultant2,7,"GG"},
{"reverse",1,(void *)recip,7,"G"},
{"rhoreal",1,(void *)rhoreal,4,"G"},
{"rhorealnod",2,(void *)rhorealnod,4,"GG"},
{"rndtoi",13,(void *)grndtoi,2,"Gf"},
{"rnfbasis",2,(void *)rnfbasis,6,"GG"},
{"rnfdiscf",2,(void *)rnfdiscf,6,"GG"},
{"rnfequation",2,(void *)rnfequation,6,"GG"},
{"rnfequation2",2,(void *)rnfequation2,6,"GG"},
{"rnfhermitebasis",2,(void *)rnfhermitebasis,6,"GG"},
{"rnfisfree",20,(void *)rnfisfree,6,"lGG"},
{"rnflllgram",3,(void *)rnflllgram,6,"GGG"},
{"rnfpolred",2,(void *)rnfpolred,6,"GG"},
{"rnfpseudobasis",2,(void *)rnfpseudobasis,6,"GG"},
{"rnfsteinitz",2,(void *)rnfsteinitz,6,"GG"},
{"rootmod",2,(void *)rootmod,7,"GG"},
{"rootmod2",2,(void *)rootmod2,7,"GG"},
{"rootpadic",32,(void *)rootpadic,7,"GGL"},
{"roots",1,(void *)roots,7,"Gp"},
{"rootsof1",1,(void *)rootsof1,6,"G"},
{"rootsold",1,(void *)rootsold,7,"Gp"},
{"round",1,(void *)ground,2,"G"},
{"rounderror",10,(void *)rounderror,2,"lG"},
{"series",14,(void *)gtoser,2,"Gn"},
{"set",1,(void *)gtoset,8,"G"},
{"setintersect",2,(void *)setintersect,8,"GG"},
{"setminus",2,(void *)setminus,8,"GG"},
{"setrand",11,(void *)setrand,2,"lL"},
{"setsearch",20,(void *)setsearch,8,"lGGD0,L,"},
{"setunion",2,(void *)setunion,8,"GG"},
{"shift",21,(void *)gshift,1,"GL"},
{"shiftmul",21,(void *)gmul2n,1,"GL"},
{"sigma",1,(void *)sumdiv,4,"G"},
{"sigmak",24,(void *)sigmak0,4,"LG"},
{"sign",10,(void *)gsigne,1,"lG"},
{"signat",1,(void *)signat,8,"G"},
{"signunit",1,(void *)signunits,6,"G"},
{"simplefactmod",2,(void *)simplefactmod,4,"GG"},
{"simplify",1,(void *)simplify,2,"G"},
{"sin",1,(void *)gsin,3,"Gp"},
{"sinh",1,(void *)gsh,3,"Gp"},
{"size",10,(void *)sizedigit,2,"lG"},
{"smallbasis",13,(void *)smallbase,6,"Gf"},
{"smallbuchinit",93,(void *)smallbuchinit,6,"GD0.3,G,D0.3,G,D5,G,D1,G,D4,L,D3,L,p"},
{"smalldiscf",1,(void *)smalldiscf,6,"G"},
{"smallfact",1,(void *)smallfact,4,"G"},
{"smallinitell",1,(void *)smallinitell,5,"Gp"},
{"smallpolred",1,(void *)smallpolred,6,"Gp"},
{"smallpolred2",1,(void *)smallpolred2,6,"Gp"},
{"smith",1,(void *)smith,8,"G"},
{"smith2",1,(void *)smith2,8,"G"},
{"smithclean",1,(void *)smithclean,8,"G"},
{"smithpol",1,(void *)gsmith,8,"G"},
{"solve",37,(void *)zbrent,9,"V=GGIp"},
{"sort",1,(void *)sort,8,"G"},
{"sqr",1,(void *)gsqr,3,"G"},
{"sqred",1,(void *)sqred,8,"G"},
{"sqrt",1,(void *)gsqrt,3,"Gp"},
{"srgcd",2,(void *)srgcd,7,"GG"},
{"sturm",10,(void *)sturm0,7,"lG"},
{"sturmpart",30,(void *)sturmpart,7,"lGGG"},
{"subcyclo",2,(void *)subcyclo,6,"GGDn"},
{"subell",3,(void *)subell,5,"GGGp"},
{"subst",26,(void *)gsubst,7,"GnG"},
{"sum",48,(void *)sum0,9,"GV=GGI"},
{"sumalt",27,(void *)sumalt,9,"V=GIp"},
{"sumalt2",27,(void *)sumalt2,9,"V=GIp"},
{"suminf",27,(void *)suminf,9,"V=GIp"},
{"sumpos",27,(void *)sumpos,9,"V=GIp"},
{"sumpos2",27,(void *)sumpos2,9,"V=GIp"},
{"supplement",1,(void *)suppl,8,"G"},
{"sylvestermatrix",2,(void *)sylvestermatrix,7,"GG"},
{"tan",1,(void *)gtan,3,"Gp"},
{"tanh",1,(void *)gth,3,"Gp"},
{"taniyama",1,(void *)taniyama,5,"G"},
{"taylor",12,(void *)tayl,7,"GnP"},
{"tchebi",11,(void *)tchebi,7,"LDn"},
{"teich",1,(void *)teich,3,"Gp"},
{"theta",2,(void *)theta,3,"GGp"},
{"thetanullk",21,(void *)thetanullk,3,"GL"},
{"threetotwo",0,(void *)suppressed,6,"GGGG"},
{"threetotwo2",0,(void *)suppressed,6,"GGGG"},
{"torsell",1,(void *)torsell,5,"Gp"},
{"trace",1,(void *)gtrace,8,"G"},
{"trans",1,(void *)gtrans,8,"G"},
{"trunc",1,(void *)gtrunc,2,"G"},
{"tschirnhaus",1,(void *)tschirnhaus,6,"G"},
{"twototwo",0,(void *)suppressed,6,"GGG"},
{"unit",1,(void *)fundunit,4,"G"},
{"until",82,NULL,11,NULL},
{"valuation",20,(void *)ggval,2,"lGG"},
{"vec",1,(void *)gtovec,2,"G"},
{"vecindexsort",2,(void *)indexsort,8,"G"},
{"veclexsort",2,(void *)lexsort,8,"G"},
{"vecmax",1,(void *)vecmax,2,"G"},
{"vecmin",1,(void *)vecmin,2,"G"},
{"vecsort",2,(void *)vecsort,8,"GG"},
{"vector",22,(void *)vecteur,9,"GVI"},
{"vvector",22,(void *)vvecteur,9,"GVI"},
{"weipell",1,(void *)weipell,5,"GP"},
{"wf",1,(void *)wf,3,"Gp"},
{"wf2",1,(void *)wf2,3,"Gp"},
{"while",81,NULL,11,NULL},
{"zell",2,(void *)zell,5,"GGp"},
{"zeta",1,(void *)gzeta,3,"Gp"},
{"zetak",2,(void *)gzetak,6,"GGp"},
{"zideallog",3,(void *)zideallog,6,"GGG"},
{"zidealstar",2,(void *)zidealstar,6,"GG"},
{"zidealstarinit",2,(void *)zidealstarinit,6,"GG"},
{"zidealstarinitgen",2,(void *)zidealstarinitgen,6,"GG"},
{"znstar",1,(void *)znstar,4,"G"},

{NULL,0,NULL,0,NULL} /* sentinel */
};

char *oldhelpmessage[] =
{
  "O(a^b)=o(a^b)=p-adic or power series zero with precision given by b",
  "abs(x)=absolute value (or modulus) of x",
  "acos(x)=inverse cosine of x",
  "acosh(x)=inverse hyperbolic cosine of x",
  "addell(e,z1,z2)=sum of the points z1 and z2 on elliptic curve e",
  "addprimes(x)=add primes in the vector x (with at most 20 components) to the prime table",
  "adj(x)=adjoint matrix of x",
  "agm(x,y)=arithmetic-geometric mean of x and y",
  "akell(e,n)=computes the n-th Fourier coefficient of the L-function of the elliptic curve e",
  "algdep(x,n)=algebraic relations up to degree n of x",
  "algdep2(x,n,dec)=algebraic relations up to degree n of x where dec is as in  lindep2",
  "algtobasis(nf,x)=transforms the algebraic number x into a column vector on the integral basis nf[7]",
  "anell(e,n)=computes the first n Fourier coefficients of the L-function of the elliptic curve e (n<32768)",
  "apell(e,p)=computes a_p for the elliptic curve e using Shanks-Mestre's method",
  "apell2(e,p)=computes a_p for the elliptic curve e using Jacobi symbols",
  "apprpadic(x,a)=p-adic roots of the polynomial x congruent to a mod p",
  "arg(x)=argument of x,such that -pi<arg(x)<=pi",
  "asin(x)=inverse sine of x",
  "asinh(x)=inverse hyperbolic sine of x",
  "assmat(x)=associated matrix to polynomial x",
  "atan(x)=inverse tangent of x",
  "atanh(x)=inverse hyperbolic tangent of x",
  "basis(x)=integral basis of the field Q[a], where a is a root of the polynomial x, using the round 4 algorithm",
  "basis2(x)=integral basis of the field Q[a], where a is a root of the polynomial x, using the round 2 algorithm",
  "basistoalg(nf,x)=transforms the vertical vector x on the integral basis into an algebraic number",
  "bernreal(x)=Bernoulli number B_x, as a real number with the current precision",
  "bernvec(x)=Vector of rational Bernoulli numbers B_0, B_2,... up to B_(2x)",
  "bestappr(x,k)=gives the best approximation to the real x with denominator less or equal to k",
  "bezout(x,y)= gives a 3-dimensional row vector [u,v,d] such that d=gcd(x,y) and u*x+v*y=d",
  "bezoutres(x,y)= gives a 3-dimensional row vector [u,v,d] such that d=resultant(x,y) and u*x+v*y=d, where x and y are polynomials",
  "bigomega(x)=number of repeated prime divisors of x",
  "bilhell(e,z1,z2)=canonical bilinear form for the points z1,z2 on the elliptic curve e. Either z1 or z2 can also be a vector/matrix of points",
  "bin(x,y)=binomial coefficient x*(x-1)...*(x-y+1)/y! defined for y in Z and any x",
  "binary(x)=gives the vector formed by the binary digits of x (x C-integer)",
  "bittest(x,n)=gives bit number n (coefficient of 2^n) of the integer x",
  "boundcf(x,lmax)=continued fraction expansion of x with at most lmax terms",
  "boundfact(x,lim)=partial factorization of the integer x (using primes up to lim)",
  "buchcertify(bnf)=certify the correctness (i.e. remove the GRH) of the bnf data output by buchinit or buchinitfu",
  "buchfu(bnf)=compute the fundamental units of the number field bnf output by buchinit",
  "buchgen(P,...)=compute the structure of the class group and the regulator for the number field defined by the polynomial P. See manual for the other parameters (which can be omitted)",
  "buchgenforcefu(P,...)=compute the structure of the class group, the regulator a primitive root of unity and a system of fundamental units for the number field defined by the polynomial P, and insist until the units are obtained. See manual for the other parameters (which can be omitted)",
  "buchgenfu(P,...)=compute the structure of the class group, the regulator a primitive root of unity and a system of fundamental units (if they are not too large) for the number field defined by the polynomial P. See manual for the other parameters (which can be omitted)",
  "buchimag(D,...)=compute the structure of the class group of the complex quadratic field of discriminant D<0. See manual for the other parameters (which can be omitted)",
  "buchinit(P,...)=compute the necessary data for future use in ideal and unit group computations. See manual for details",
  "buchinitforcefu(P,...)=compute the necessary data for future use in ideal and unit group computations, and insist on having fundamental units. See manual for details",
  "buchinitfu(P,...)=compute the necessary data for future use in ideal and unit group computations, including fundamental units if they are not too large. See manual for details",
  "buchnarrow(bnf)=given a big number field as output by buchinitxx, gives as a 3-component vector the structure of the narrow class group",
  "buchray(bnf,ideal)=given a big number field as output by buchinitfu (only) and  an ideal or a 2-component row vector formed by an ideal and a list of R1 zeros or ones representing a module, finds the ray class group structure corresponding to this module",
  "buchrayinit(bnf,ideal)=same as buchrayinitgen, except that the generators are not explicitly computed",
  "buchrayinitgen(bnf,ideal)=given a big number field as output by buchinitfu (only) and  an ideal or a 2-component row vector formed by an ideal and a list of R1 zeros or ones representing a module, initializes data for computing in the ray class group  corresponding to this module. In particular, the fifth component is the ray class group structure",
  "buchreal(D,...)=compute the structure of the class group and the regulator of the real quadratic field of discriminant D>0 in the wide sense. See manual for the other parameters (which can be omitted)",
  "bytesize(x)=number of bytes occupied by the complete tree of the object x",
  "ceil(x)=ceiling of x=smallest integer>=x",
  "centerlift(x)=centered lift of x. Same as lift except for integermods",
  "cf(x)=continued fraction expansion of x (x rational,real or rational function)",
  "cf2(b,x)=continued fraction expansion of x (x rational,real or rational function), where b is the vector of numerators of the continued fraction",
  "changevar(x,y)=change variables of x according to the vector y",
  "char(x,y)=det(y*I-x)=characteristic polynomial of the matrix x using the comatrix",
  "char1(x,y)=det(y*I-x)=characteristic polynomial of the matrix x using Lagrange interpolation",
  "char2(x,y)=characteristic polynomial of the matrix x expressed with variable y, using the Hessenberg form. Can be much faster or much slower than char, depending on the base ring",
  "chell(x,y)=change data on elliptic curve according to y=[u,r,s,t]",
  "chinese(x,y)=x,y being integers modulo mx and my,finds z such that z is congruent to x mod mx and y mod my",
  "chptell(x,y)=change data on point or vector of points x on an elliptic curve according to y=[u,r,s,t]",
  "classno(x)=class number of discriminant x",
  "classno2(x)=class number of discriminant x",
  "coeff(x,s)=coefficient of degree s of x, or the s-th component for vectors or matrices (for which it is simpler to use x[])",
  "compimag(x,y)=Gaussian composition of the binary quadratic forms x and y of negative discriminant",
  "compo(x,s)=the s'th component of the internal representation of x. For vectors or matrices, it is simpler to use x[]",
  "compositum(pol1,pol2)=vector of all possible compositums of the number fields defined by the polynomials pol1 and pol2",
  "compositum2(pol1,pol2)=vector of all possible compositums of the number fields defined by the polynomials pol1 and pol2, with roots of pol1 and pol2 expressed on the compositum polynomials",
  "comprealraw(x,y)=Gaussian composition without reduction of the binary quadratic forms x and y of positive discriminant",
  "concat(x,y)=concatenation of x and y",
  "conductor(bnr,subgroup)=conductor of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup",
  "conductorofchar(bnr,chi)=conductor of the character chi on the ray class group bnr",
  "conj(x)=the algebraic conjugate of x",
  "conjvec(x)=conjugate vector of the algebraic number x",
  "content(x)=gcd of all the components of x, when this makes sense",
  "convol(x,y)=convolution (or Hadamard product) of two power series",
  "core(n)=unique (positive of negative) squarefree integer d dividing n such that n/d is a square",
  "core2(n)=two-component row vector [d,f], where d is the unique squarefree integer dividing n such that n/d=f^2 is a square",
  "coredisc(n)=discriminant of the quadratic field Q(sqrt(n))",
  "coredisc2(n)=two-component row vector [d,f], where d is the discriminant of the quadratic field Q(sqrt(n)) and n=df^2. f may be a half integer",
  "cos(x)=cosine of x",
  "cosh(x)=hyperbolic cosine of x",
  "cvtoi(x)=truncation of x, without taking into account loss of integer part precision",
  "cyclo(n)=n-th cyclotomic polynomial",
  "decodefactor(fa)=given a factorisation fa, gives the factored object back",
  "decodemodule(nf,fa)=given a coded module fa as in discrayabslist, gives the true module",
  "degree(x)=degree of the polynomial or rational function x. -1 if equal 0, 0 if non-zero scalar",
  "denom(x)=denominator of x (or lowest common denominator in case of an array)",
  "deplin(x)=finds a linear dependence between the columns of the matrix x",
  "deriv(x,y)=derivative of x with respect to the main variable of y",
  "det(x)=determinant of the matrix x",
  "det2(x)=determinant of the matrix x (better for integer entries)",
  "detint(x)=some multiple of the determinant of the lattice generated by the columns of x (0 if not of maximal rank). Useful with hermitemod",
  "diagonal(x)=creates the diagonal matrix whose diagonal entries are the entries of the vector x",
  "dilog(x)=dilogarithm of x",
  "dirdiv(x,y)=division of the Dirichlet series x by the Dir. series y",
  "direuler(p=a,b,expr)=Dirichlet Euler product of expression expr from p=a to p=b, limited to b terms. Expr should be a polynomial or rational function in p and X, and X is understood to mean p^(-s)",
  "dirmul(x,y)=multiplication of the Dirichlet series x by the Dir. series y",
  "dirzetak(nf,b)=Dirichlet series of the Dedekind zeta function of the number field nf up to the bound b-1",
  "disc(x)=discriminant of the polynomial x",
  "discf(x)=discriminant of the number field defined by the polynomial x using round 4",
  "discf2(x)=discriminant of the number field defined by the polynomial x using round 2",
  "discrayabs(bnr,subgroup)=absolute [N,R1,discf] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup",
  "discrayabscond(bnr,subgroup)=absolute [N,R1,discf] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup. Result is zero if fmodule is not the conductor",
  "discrayabslist(bnf,listes)=if listes is a 2-component vector as output by ideallistunit or similar, gives list of corresponding discrayabscond",
  "discrayabslistarch(bnf,arch,bound)=gives list of discrayabscond of all modules up to norm bound with archimedean places arch, in a longvector format",
  "discrayabslistarchall(bnf,bound)=gives list of discrayabscond of all modules up to norm bound with all possible archimedean places arch in reverse lexicographic order, in a longvector format",
  "discrayabslistlong(bnf,bound)=gives list of discrayabscond of all modules up to norm bound without archimedean places, in a longvector format",
  "discrayrel(bnr,subgroup)=relative [N,R1,rnfdiscf] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup",
  "discrayrelcond(bnr,subgroup)=relative [N,R1,rnfdiscf] of the subfield of the ray class field bnr given by buchrayinit, defined by the HNF matrix subgroup. Result is zero if module is not the conductor",
  "divisors(x)=gives a vector formed by the divisors of x in increasing order",
  "divres(x,y)=euclidean division of x by y giving as a 2-dimensional column vector the quotient and the remainder",
  "divsum(n,X,expr)=sum of expression expr, X running over the divisors of n",
  "eigen(x)=eigenvectors of the matrix x given as columns of a matrix",
  "eint1(x)=exponential integral E1(x)",
  "erfc(x)=complementary error function",
  "eta(x)=eta function without the q^(1/24)",
  "euler=euler()=euler's constant with current precision",
  "eval(x)=evaluation of x, replacing variables by their value",
  "exp(x)=exponential of x",
  "extract(x,y)=extraction of the components of the vector x according to the vector or mask y, from left to right (1, 2, 4, 8, ...for the first, second, third, fourth,...component)",
  "fact(x)=factorial of x (x C-integer), the result being given as a real number",
  "factcantor(x,p)=factorization mod p of the polynomial x using Cantor-Zassenhaus",
  "factfq(x,p,a)=factorization of the polynomial x in the finite field F_p[X]/a(X)F_p[X]",
  "factmod(x,p)=factorization mod p of the polynomial x using Berlekamp",
  "factor(x)=factorization of x",
  "factoredbasis(x,p)=integral basis of the maximal order defined by the polynomial x, where p is the matrix of the factorization of the discriminant of x",
  "factoreddiscf(x,p)=discriminant of the maximal order defined by the polynomial x, where p is the matrix of the factorization of the discriminant of x",
  "factoredpolred(x,p)=reduction of the polynomial x, where p is the matrix of the factorization of the discriminant of x (gives minimal polynomials only)",
  "factoredpolred2(x,p)=reduction of the polynomial x, where p is the matrix of the factorization of the discriminant of x (gives elements and minimal polynomials)",
  "factornf(x,t)=factorization of the polynomial x over the number field defined by the polynomial t",
  "factorpadic(x,p,r)=p-adic factorization of the polynomial x to precision r, using the round 4 algorithm",
  "factorpadic2(x,p,r)=p-adic factorization of the polynomial x to precision r, using Buchmann-Lenstra",
  "factpol(x,l,hint)=factorization over Z of the polynomial x up to degree l (complete if l=0) using Hensel lift, knowing that the degree of each factor is a multiple of hint",
  "factpol2(x,l)=factorization over Z of the polynomial x up to degree l (complete if l=0) using root finding",
  "fibo(x)=fibonacci number of index x (x C-integer)",
  "floor(x)=floor of x=largest integer<=x",
  "for(X=a,b,seq)=the sequence is evaluated, X going from a up to b",
  "fordiv(n,X,seq)=the sequence is evaluated, X running over the divisors of n",
  "forprime(X=a,b,seq)=the sequence is evaluated, X running over the primes between a and b",
  "forstep(X=a,b,s,seq)=the sequence is evaluated, X going from a to b in steps of s",
  "forvec(x=v,seq)=v being a vector of two-component vectors of length n, the sequence is evaluated with x[i] going from v[i][1] to v[i][2] for i=n,..,1",
  "fpn(p,n)=monic irreducible polynomial of degree n over F_p[x]",
  "frac(x)=fractional part of x=x-floor(x)",
  "galois(x)=Galois group of the polynomial x (see manual for group coding)",
  "galoisapply(nf,aut,x)=Apply the Galois automorphism sigma (polynomial or polymod) to the object x (element or ideal) in the number field nf",
  "galoisconj(nf)=list of conjugates of a root of the polynomial x=nf[1] in the same number field, using p-adics, LLL on integral basis (not always complete)",
  "galoisconj1(nf)=list of conjugates of a root of the polynomial x=nf[1] in the same number field nf, using complex numbers, LLL on integral basis (not always complete)",
  "galoisconjforce(nf)=list of conjugates of a root of the polynomial x=nf[1] in the Galois number field nf, using p-adics, LLL on integral basis. Guaranteed to be complete if the field is Galois, otherwise there is an infinite loop",
  "gamh(x)=gamma of x+1/2 (x integer)",
  "gamma(x)=gamma function at x",
  "gauss(a,b)=gaussian solution of ax=b (a matrix,b vector)",
  "gaussmodulo(M,D,Y)=one solution of system of congruences MX=Y mod D",
  "gaussmodulo2(M,D,Y)=all solutions of system of congruences MX=Y mod D",
  "gcd(x,y)=greatest common divisor of x and y",
  "getheap()=2-component vector giving the current number of objects in the heap and the space they occupy",
  "getrand()=current value of random number seed",
  "getstack()=current value of stack pointer avma",
  "gettime()=time (in milliseconds) since last call to gettime",
  "globalred(e)=e being an elliptic curve, returns [N,[u,r,s,t],c], where N is the conductor of e, [u,r,s,t] leads to the standard model for e, and c is the product of the local Tamagawa numbers c_p",
  "goto(n)=THIS FUNCTION HAS BEEN SUPPRESSED",
  "hclassno(x)=Hurwitz-Kronecker class number of x>0",
  "hell(e,x)=canonical height of point x on elliptic curve E defined by the vector e computed using theta-functions",
  "hell2(e,x)=canonical height of point x on elliptic curve E defined by the vector e computed using Tate's method",
  "hermite(x)=(upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, using a naive algorithm",
  "hermite2(x)=2-component vector [H,U] such that H is an (upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, and U is a unimodular matrix such that xU=H, using Batut's algorithm",
  "hermitehavas(x)=3-component vector [H,U,P] such that H is an (upper triangular) Hermite normal form of x with extra zero columns, U is a unimodular matrix and P is a permutation of the rows such that P applied to xU gives H, using Havas's algorithm",
  "hermitemod(x,d)=(upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, where d is the non-zero determinant of this lattice",
  "hermitemodid(x,d)=(upper triangular) Hermite normal form of x concatenated with d times the identity matrix",
  "hermiteperm(x)=3-component vector [H,U,P] such that H is an (upper triangular) Hermite normal form of x with extra zero columns, U is a unimodular matrix and P is a permutation of the rows such that P applied to xU gives H, using Batut's algorithm",
  "hess(x)=Hessenberg form of x",
  "hilb(x,y,p)=Hilbert symbol at p of x,y (integers or fractions)",
  "hilbert(n)=Hilbert matrix of order n (n C-integer)",
  "hilbp(x,y)=Hilbert symbol of x,y (where x or y is integermod or p-adic)",
  "hvector(n,X,expr)=row vector with n components of expression expr, the variable X ranging from 1 to n",
  "hyperu(a,b,x)=U-confluent hypergeometric function",
  "i=i()=square root of -1",
  "idealadd(nf,x,y)=sum of two ideals x and y in the number field defined by nf",
  "idealaddone(nf,x,y)=when the sum of two ideals x and y in the number field K defined by nf is equal to Z_K, gives a two-component vector [a,b] such that a is in x, b is in y and a+b=1",
  "idealaddmultone(nf,list)=when the sum of the ideals in the number field K defined by nf and given in the vector list is equal to Z_K, gives a vector of elements of the corresponding ideals who sum to 1",
  "idealappr(nf,x)=x being a fractional ideal, gives an element b such that v_p(b)=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealapprfact(nf,x)=x being a prime ideal factorization with possibly zero or negative exponents, gives an element b such that v_p(b)=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealchinese(nf,x,y)=x being a prime ideal factorization and y a vector of elements, gives an element b such that v_p(b-y_p)>=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealcoprime(nf,x,y)=gives an element b in nf such that b.x is an integral ideal coprime to the integral ideal y",
  "idealdiv(nf,x,y)=quotient x/y of two ideals x and y in HNF in the number field nf",
  "idealdivexact(nf,x,y)=quotient x/y of two ideals x and y in HNF in the number field nf when the quotient is known to be an integral ideal",
  "idealfactor(nf,x)=factorization of the ideal x given in HNF into prime ideals in the number field nf",
  "idealhermite(nf,x)=hermite normal form of the ideal x in the number field nf, whatever form x may have",
  "idealhermite2(nf,a,b)=hermite normal form of the ideal aZ_K+bZ_K in the number field K defined by nf, where a and b are elements",
  "idealintersect(nf,x,y)=intersection of two ideals x and y in HNF in the number field defined by nf",
  "idealinv(nf,x)=inverse of the ideal x in the number field nf not using the different",
  "idealinv2(nf,x)=inverse of the ideal x in the number field nf using the different",
  "ideallist(nf,bound)=vector of vectors of all ideals of norm<=bound in nf",
  "ideallistarch(nf,list,arch)=vector of vectors of all zidealstarinits of all modules in list with archimedean arch added, without generators",
  "ideallistarchgen(nf,list,arch)=vector of vectors of all zidealstarinits of all modules in list with archimedean arch added, with generators",
  "ideallistunit(bnf,bound)=2-component vector [L,U] where L is as ideallistzstar, and U is a vector of vector of zinternallogs of the units, without generators",
  "ideallistunitarch(bnf,lists,arch)=adds the archimedean arch to the lists output by ideallistunit",
  "ideallistunitarchgen(bnf,lists,arch)=adds the archimedean arch to the lists output by ideallistunitgen",
  "ideallistunitgen(bnf,bound)=2-component vector [L,U] where L is as ideallistzstar, and U is a vector of vector of zinternallogs of the units, with generators",
  "ideallistzstar(nf,bound)=vector of vectors of all zidealstarinits of all ideals of norm<=bound, without generators",
  "ideallistzstargen(nf,bound)=vector of vectors of all zidealstarinits of all ideals of norm<=bound, with generators",
  "ideallllred(nf,x,vdir)=LLL reduction of the ideal x in the number field nf along direction vdir, in HNF",
  "idealmul(nf,x,y)=product of the two ideals x and y in the number field nf",
  "idealmulred(nf,x,y)=reduced product of the two ideals x and y in the number field nf",
  "idealnorm(nf,x)=norm of the ideal x in the number field nf",
  "idealpow(nf,x,n)=n-th power of the ideal x in HNF in the number field nf",
  "idealpowred(nf,x,n)=reduced n-th power of the ideal x in HNF in the number field nf",
  "idealtwoelt(nf,x)=two-element representation of an ideal x in the number field nf",
  "idealtwoelt2(nf,x,a)=two-element representation of an ideal x in the number field nf, with the first element equal to a",
  "idealval(nf,x,p)=valuation at p given in primedec format of the ideal x in the number field nf",
  "idmat(n)=identity matrix of order n (n C-integer)",
  "if(a,seq1,seq2)= if a is nonzero, seq1 is evaluated, otherwise seq2",
  "imag(x)=imaginary part of x",
  "image(x)=basis of the image of the matrix x",
  "image2(x)=basis of the image of the matrix x",
  "imagecompl(x)=vector of column indices not corresponding to the indices given by the function image",
  "incgam(s,x)=incomplete gamma function",
  "incgam1(s,x)=incomplete gamma function (for debugging only)",
  "incgam2(s,x)=incomplete gamma function (for debugging only)",
  "incgam3(s,x)=complementary incomplete gamma function",
  "incgam4(s,x,y)=incomplete gamma function where y=gamma(s) is precomputed",
  "indexrank(x)=gives two extraction vectors (rows and columns) for the matrix x such that the exracted matrix is square of maximal rank",
  "indsort(x)=indirect sorting of the vector x",
  "initalg(x)=x being a nonconstant irreducible polynomial, gives the vector: [x,[r1,r2],discf,index,[M,MC,T2,T,different] (see manual),r1+r2 first roots, integral basis, matrix of power basis in terms of integral basis, multiplication table of basis]",
  "initalgred(x)=x being a nonconstant irreducible polynomial, finds (using polred) a simpler polynomial pol defining the same number field, and gives the vector: [pol,[r1,r2],discf,index,[M,MC,T2,T,different] (see manual), r1+r2 first roots, integral basis, matrix of power basis in terms of integral basis, multiplication table of basis]",
  "initalgred2(P)=P being a nonconstant irreducible polynomial, gives a two-element vector [nf,mod(a,pol)], where nf is as output by initalgred and mod(a,pol) is a polymod equal to mod(x,P) and pol=nf[1]",
  "initell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector: [a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j,[e1,e2,e3],w1,w2,eta1,eta2,q,area]",
  "initzeta(x)=compute number field information necessary to use zetak, where x is an irreducible polynomial",
  "integ(x,y)=formal integration of x with respect to the main variable of y",
  "intersect(x,y)=intersection of the vector spaces whose bases are the columns of x and y",
  "intgen(X=a,b,s)=general numerical integration of s from a to b with respect to X, to be used after removing singularities",
  "intinf(X=a,b,s)=numerical integration of s from a to b with respect to X, where a or b can be plus or minus infinity (1.0e4000), but of same sign",
  "intnum(X=a,b,s)=numerical integration of s from a to b with respect to X",
  "intopen(X=a,b,s)=numerical integration of s from a to b with respect to X, where s has only limits at a or b",
  "inverseimage(x,y)=an element of the inverse image of the vector y by the matrix x if one exists, the empty vector otherwise",
  "isdiagonal(x)=true(1) if x is a diagonal matrix, false(0) otherwise",
  "isfund(x)=true(1) if x is a fundamental discriminant (including 1), false(0) if not",
  "isideal(nf,x)=true(1) if x is an ideal in the number field nf, false(0) if not",
  "isincl(x,y)=tests whether the number field defined by the polynomial x is isomorphic to a subfield of the one defined by y; 0 if not, otherwise all the isomorphisms",
  "isinclfast(nf1,nf2)=tests whether the number nf1 is isomorphic to a subfield of nf2 or not. If it gives a non-zero result, this proves that this is the case. However if it gives zero, nf1 may still be isomorphic to a subfield of nf2 so you have to use the much slower isincl to be sure",
  "isirreducible(x)=true(1) if x is an irreducible non-constant polynomial, false(0) if x is reducible or constant",
  "isisom(x,y)=tests whether the number field defined by the polynomial x is isomorphic to the one defined by y; 0 if not, otherwise all the isomorphisms",
  "isisomfast(nf1,nf2)=tests whether the number fields nf1 and nf2 are isomorphic or not. If it gives a non-zero result, this proves that they are isomorphic. However if it gives zero, nf1 and nf2 may still be isomorphic so you have to use the much slower isisom to be sure",
  "isoncurve(e,x)=true(1) if x is on elliptic curve e, false(0) if not",
  "isprime(x)=true(1) if x is a strong pseudoprime for 10 random bases, false(0) if not",
  "isprincipal(bnf,x)=bnf being output by buchinit, gives the vector of exponents on the class group generators of x. In particular x is principal if and only if the result is the zero vector",
  "isprincipalforce(bnf,x)=same as isprincipal, except that the precision is doubled until the result is obtained",
  "isprincipalgen(bnf,x)=bnf being output by buchinit, gives [v,alpha,bitaccuracy], where v is the vector of exponents on the class group generators and alpha is the generator of the resulting principal ideal. In particular x is principal if and only if v is the zero vector",
  "isprincipalgenforce(bnf,x)=same as isprincipalgen, except that the precision is doubled until the result is obtained",
  "isprincipalray(bnf,x)=bnf being output by buchrayinit, gives the vector of exponents on the ray class group generators of x. In particular x is principal if and only if the result is the zero vector",
  "isprincipalraygen(bnf,x)=bnf being output by buchrayinit, gives [v,alpha,bitaccuracy], where v is the vector of exponents on the class group generators and alpha is the generator of the resulting principal ideal. In particular x is principal if and only if v is the zero vector",
  "ispsp(x)=true(1) if x is a strong pseudoprime, false(0) if not",
  "isqrt(x)=integer square root of x (x integer)",
  "isset(x)=true(1) if x is a set (row vector with strictly increasing entries), false(0) if not",
  "issqfree(x)=true(1) if x is squarefree, false(0) if not",
  "issquare(x)=true(1) if x is a square, false(0) if not",
  "isunit(bnf,x)=bnf being output by buchinit, gives the vector of exponents of x on the fundamental units and the roots of unity if x is a unit, the empty vector otherwise",
  "jacobi(x)=eigenvalues and orthogonal matrix of eigenvectors of the real symmetric matrix x",
  "jbesselh(n,x)=J-bessel function of index n+1/2 and argument x, where n is a non-negative integer",
  "jell(x)=elliptic j invariant of x",
  "karamul(x,y,k)=THIS FUNCTION HAS BEEN SUPPRESSED",
  "kbessel(nu,x)=K-bessel function of index nu and argument x (x positive real of type real, nu of any scalar type)",
  "kbessel2(nu,x)=K-bessel function of index nu and argument x (x positive real of type real, nu of any scalar type)",
  "ker(x)=basis of the kernel of the matrix x",
  "keri(x)=basis of the kernel of the matrix x with integer entries",
  "kerint(x)=LLL-reduced Z-basis of the kernel of the matrix x with integral entries using a modified LLL",
  "kerint1(x)=LLL-reduced Z-basis of the kernel of the matrix x with rational entries using matrixqz3 and the HNF",
  "kerint2(x)=LLL-reduced Z-basis of the kernel of the matrix x with integral entries using a modified LLL",
  "kro(x,y)=kronecker symbol (x/y)",
  "label(n)=THIS FUNCTION HAS BEEN SUPPRESSED",
  "lambdak(nfz,s)=Dedekind lambda function of the number field nfz at s, where nfz is the vector computed by initzeta (NOT by initalg)",
  "laplace(x)=replaces the power series sum of a_n*x^n/n! by sum of a_n*x^n",
  "lcm(x,y)=least common multiple of x and y=x*y/gcd(x,y)",
  "legendre(n)=legendre polynomial of degree n (n C-integer)",
  "length(x)=number of non code words in x",
  "lex(x,y)=compare x and y lexicographically (1 if x>y, 0 if x=y, -1 if x<y)",
  "lexsort(x)=sort the elements of the vector x in ascending lexicographic order",
  "lift(x)=lifts every element of Z/nZ to Z or Z[x]/PZ[x] to Z[x]",
  "lindep(x)=Z-linear dependencies between components of x (Hastad et al)",
  "lindep2(x,dec)=Z-linear dependencies between components of x using LLL, where dec should be about one half the number of decimal digits of precision",
  "lll(x)=lll reduction of the vectors forming the matrix x (gives the unimodular transformation matrix)",
  "lll1(x)=old version of lll reduction of the vectors forming the matrix x (gives the unimodular transformation matrix)",
  "lllgen(x)=lll reduction of the vectors forming the matrix x with polynomial coefficients (gives the unimodular transformation matrix)",
  "lllgram(x)=lll reduction of the lattice whose gram matrix is x (gives the unimodular transformation matrix)",
  "lllgram1(x)=old version of lll reduction of the lattice whose gram matrix is x (gives the unimodular transformation matrix)",
  "lllgramgen(x)=lll reduction of the lattice whose gram matrix is x with polynomial coefficients (gives the unimodular transformation matrix)",
  "lllgramint(x)=lll reduction of the lattice whose gram matrix is the integral matrix x (gives the unimodular transformation matrix)",
  "lllgramkerim(x)=kernel and lll reduction of the lattice whose gram matrix is the integral matrix x",
  "lllgramkerimgen(x)=kernel and lll reduction of the lattice whose gram matrix is the matrix x with polynomial coefficients",
  "lllint(x)=lll reduction of the vectors forming the matrix x when the gram matrix is integral (gives the unimodular transformation matrix)",
  "lllintpartial(x)=partial (hence faster) lll reduction of the vectors forming the matrix x when the gram matrix is integral (gives the unimodular transformation matrix)",
  "lllkerim(x)=kernel and lll reduction of the vectors forming the integral matrix x",
  "lllkerimgen(x)=kernel and lll reduction of the vectors forming the matrix x with polynomial coefficients",
  "lllrat(x)=lll reduction of the vectors forming the matrix x, computations done with rational numbers (gives the unimodular transformation matrix)",
  "ln(x)=log(x)=natural logarithm of x",
  "lngamma(x)=logarithm of the gamma function of x",
  "localred(e,p)= e being an ellliptic curve, returns [f,kod,[u,r,s,t],c], where f is the conductor's exponent, kod is the kodaira type for e at p, [u,r,s,t] is the change of variable needed to make e minimal at p, and c is the local Tamagawa number c_p",
  "log(x)=ln(x)=natural logarithm of x",
  "logagm(x)=natural logarithm of x, computed using agm (faster than log for more than a few hundred decimal digits)",
  "lseriesell(e,s,N,A)=L-series at s of the elliptic curve e, where |N| is the conductor, sign(N) the sign of the functional equation, and A a cut-off point close to 1",
  "makebigbnf(sbnf)=transforms small sbnf as output by smallbuchinit into a true big bnf",
  "mat(x)=transforms any GEN x into a matrix",
  "matextract(x,y,z)=extraction of the components of the matrix x according to the vector or masks y (for the rows) and z (for the columns) from left to right (1,2,4,8,...for the first, second, third, fourth, ...rows or columns)",
  "mathell(e,x)=gives the height matrix for vector of points x on elliptic curve e using theta functions",
  "matrix(m,n,X,Y,expr)=mXn matrix of expression expr, the row variable X going  from 1 to m and the column variable Y going from 1 to n",
  "matrixqz(x,p)=transforms the rational or integral mxn (m>=n) matrix x into an integral matrix with gcd of maximal determinants equal to 1 if p is equal to 0, not divisible by p otherwise",
  "matrixqz2(x)=finds a basis of the intersection with Z^n of the lattice spanned by the columns of x",
  "matrixqz3(x)=finds a basis of the intersection with Z^n of the Q-vector space spanned by the columns of x",
  "matsize(x)=number of rows and columns of the vector/matrix x as a 2-vector",
  "max(x,y)=maximum of x and y",
  "min(x,y)=minimum of x and y",
  "minideal(nf,ix,vdir)=minimum of the ideal ix in the direction vdir in the number field nf",
  "minim(x,bound,maxnum)=number of vectors of square norm <= bound, maximum norm and list of vectors for the integral and definite quadratic form x; minimal non-zero vectors if bound=0",
  "minim2(x,bound)=looks for vectors of square norm <= bound, return the first one and its norm",
  "mod(x,y)=creates the integer x modulo y on the PARI stack",
  "modp(x,y)=creates the integer x modulo y as a permanent object (on the heap)",
  "modreverse(x)=reverse polymod of the polymod x, if it exists",
  "modulargcd(x,y)=gcd of the polynomials x and y using the modular method",
  "mu(x)=Moebius function of x",
  "newtonpoly(x,p)=Newton polygon of polynomial x with respect to the prime p",
  "nextprime(x)=smallest prime number>=x",
  "nfdetint(nf,x)=multiple of the ideal determinant of the pseudo generating set x",
  "nfdiv(nf,a,b)=element a/b in nf",
  "nfdiveuc(nf,a,b)=gives algebraic integer q such that a-bq is small",
  "nfdivres(nf,a,b)=gives [q,r] such that r=a-bq is small",
  "nfhermite(nf,x)=if x=[A,I], gives a pseudo-basis of the module sum A_jI_j",
  "nfhermitemod(nf,x,detx)=if x=[A,I], and detx is a multiple of the ideal determinant of x, gives a pseudo-basis of the module sum A_jI_j",
  "nfmod(nf,a,b)=gives r such that r=a-bq is small with q algebraic integer",
  "nfmul(nf,a,b)=element a.b in nf",
  "nfpow(nf,a,k)=element a^k in nf",
  "nfreduce(nf,a,id)=gives r such that a-r is the ideal id and r is small",
  "nfsmith(nf,x)=if x=[A,I,J], outputs [c_1,...c_n] Smith normal form of x",
  "nfval(nf,a,pr)=valuation of element a at the prime pr",
  "norm(x)=norm of x",
  "norml2(x)=square of the L2-norm of the vector x",
  "nucomp(x,y,l)=composite of primitive positive definite quadratic forms x and y using nucomp and nudupl, where l=[|D/4|^(1/4)] is precomputed",
  "numdiv(x)=number of divisors of x",
  "numer(x)=numerator of x",
  "nupow(x,n)=n-th power of primitive positive definite quadratic form x using nucomp and nudupl",
  "o(a^b)=O(a^b)=p-adic or power series zero with precision given by b",
  "omega(x)=number of unrepeated prime divisors of x",
  "ordell(e,x)=y-coordinates corresponding to x-ordinate x on elliptic curve e",
  "order(x)=order of the integermod x in (Z/nZ)*",
  "orderell(e,p)=order of the point p on the elliptic curve e over Q, 0 if non-torsion",
  "ordred(x)=reduction of the polynomial x, staying in the same order",
  "padicprec(x,p)=absolute p-adic precision of object x",
  "pascal(n)=pascal triangle of order n (n C-integer)",
  "perf(a)=rank of matrix of xx~ for x minimal vectors of a gram matrix a",
  "permutation(n,k)=permutation number k (mod n!) of n letters (n C-integer)",
  "permutation2num(vect)=ordinal (between 1 and n!) of permutation vect",
  "pf(x,p)=returns the prime form whose first coefficient is p, of discriminant x",
  "phi(x)=Euler's totient function of x",
  "pi=pi()=the constant pi, with current precision",
  "pnqn(x)=[p_n,p_{n-1};q_n,q_{n-1}] corresponding to the continued fraction x",
  "pointell(e,z)=coordinates of point on the curve e corresponding to the complex number z",
  "polint(xa,ya,x)=polynomial interpolation at x according to data vectors xa, ya",
  "polred(x)=reduction of the polynomial x (gives minimal polynomials only)",
  "polred2(x)=reduction of the polynomial x (gives elements and minimal polynomials)",
  "polredabs(x)=a smallest generating polynomial of the number field for the T2 norm on the roots, with smallest index for the minimal T2 norm",
  "polredabs2(x)=gives [pol,a] where pol is as in polredabs, and alpha is the element whose characteristic polynomial is pol",
  "polredabsall(x)=complete list of the smallest generating polynomials of the number field for the T2 norm on the roots",
  "polredabsfast(x)=a smallest generating polynomial of the number field for the T2 norm on the roots",
  "polredabsnored(x)=a smallest generating polynomial of the number field for the T2 norm on the roots without initial polred",
  "polsym(x,n)=vector of symmetric powers of the roots of x up to n",
  "polvar(x)=main variable of object x. Gives p for p-adic x, error for scalars",
  "poly(x,v)=convert x (usually a vector or a power series) into a polynomial with variable v, starting with the leading coefficient",
  "polylog(m,x)=m-th polylogarithm of x",
  "polylogd(m,x)=D_m~-modified m-th polylog of x",
  "polylogdold(m,x)=D_m-modified m-th polylog of x",
  "polylogp(m,x)=P_m-modified m-th polylog of x",
  "polyrev(x,v)=convert x (usually a vector or a power series) into a polynomial with variable v, starting with the constant term",
  "polzag(n,m)=Zagier's polynomials of index n,m",
  "powell(e,x,n)=n times the point x on elliptic curve e (n in Z)",
  "powrealraw(x,n)=n-th power without reduction of the binary quadratic form x of positive discriminant",
  "prec(x,n)=change the precision of x to be n (n C-integer)",
  "precision(x)=real precision of object x",
  "prime(n)=returns the n-th prime (n C-integer)",
  "primedec(nf,p)=prime ideal decomposition of the prime number p in the number field nf as a vector of 5 component vectors [p,a,e,f,b] representing the prime ideals pZ_K+a.Z_K, e,f as usual, a as vector of components on the  integral basis, b Lenstra's constant",
  "primes(n)=returns the vector of the first n primes (n C-integer)",
  "primroot(n)=returns a primitive root of n when it exists",
  "principalideal(nf,x)=returns the principal ideal generated by the algebraic number x in the number field nf",
  "principalidele(nf,x)=returns the principal idele generated by the algebraic number x in the number field nf",
  "prod(x,X=a,b,expr)=x times the product (X runs from a to b) of expression",
  "prodeuler(X=a,b,expr)=Euler product (X runs over the primes between a and b) of real or complex expression",
  "prodinf(X=a,expr)=infinite product (X goes from a to infinity) of real or complex expression",
  "prodinf1(X=a,expr)=infinite product (X goes from a to infinity) of real or complex 1+expression",
  "psi(x)=psi-function at x",
  "qfi(a,b,c)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c<0",
  "qfr(a,b,c,d)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c>0 and distance d",
  "quaddisc(x)=discriminant of the quadratic field Q(sqrt(x))",
  "quadgen(x)=standard generator of quadratic order of discriminant x",
  "quadpoly(x)=quadratic polynomial corresponding to the discriminant x",
  "random()=random integer between 0 and 2^31-1",
  "rank(x)=rank of the matrix x",
  "rayclassno(bnf,x)=ray class number of the module x for the big number field bnf. Faster than buchray if only the ray class number is wanted",
  "rayclassnolist(bnf,liste)=if listes is as output by idealisunit or similar, gives list of corresponding ray class numbers",
  "real(x)=real part of x",
  "recip(x)=reciprocal polynomial of x",
  "redimag(x)=reduction of the binary quadratic form x with D<0",
  "redreal(x)=reduction of the binary quadratic form x with D>0",
  "redrealnod(x,sq)=reduction of the binary quadratic form x with D>0 without distance function where sq=[sqrt D]",
  "reduceddisc(f)=vector of elementary divisors of Z[a]/f'(a)Z[a], where a is a root of the polynomial f",
  "regula(x)=regulator of the real quadratic field of discriminant x",
  "reorder(x)=reorder the variables for output according to the vector x",
  "resultant(x,y)=resultant of the polynomials x and y with exact entries",
  "resultant2(x,y)=resultant of the polynomials x and y",
  "reverse(x)=reversion of the power series x",
  "rhoreal(x)=single reduction step of the binary quadratic form x of positive discriminant",
  "rhorealnod(x,sq)=single reduction step of the binary quadratic form x with D>0 without distance function where sq=[sqrt D]",
  "rndtoi(x)=take the nearest integer to all the coefficients of x, without taking into account loss of integer part precision",
  "rnfbasis(bnf,order)=given an order as output by rnfpseudobasis or rnfsteinitz, gives either a basis of the order if it is free, or an n+1-element generating set",
  "rnfdiscf(nf,pol)=given a pol with coefficients in nf, gives a 2-component vector [D,d], where D is the relative ideal discriminant, and d is the relative discriminant in nf^*/nf*^2",
  "rnfequation(nf,pol)=given a pol with coefficients in nf, gives the absolute equation of the number field defined by pol",
  "rnfequation2(nf,pol)=given a pol with coefficients in nf, gives [apol,th], where apol is the absolute equation of the number field defined by pol and th expresses the root of nf[1] in terms of the root of apol",
  "rnfhermitebasis(bnf,order)=given an order as output by rnfpseudobasis, gives either a true HNF basis of the order if it exists, zero otherwise",
  "rnfisfree(bnf,order)=given an order as output by rnfpseudobasis or rnfsteinitz, outputs true (1) or false (0) according to whether the order is free or not",
  "rnflllgram(nf,pol,order)=given a pol with coefficients in nf and an order as output by rnfpseudobasis or similar, gives [[neworder],U], where neworder is a reduced order and U is the unimodular transformation matrix",
  "rnfpolred(nf,pol)=given a pol with coefficients in nf, finds a list of polynomials defining some subfields, hopefully simpler",
  "rnfpseudobasis(nf,pol)=given a pol with coefficients in nf, gives a 4-component vector [A,I,D,d] where [A,I] is a pseudo basis of the maximal order in HNF on the power basis, D is the relative ideal discriminant, and d is the relative discriminant in nf^*/nf*^2",
  "rnfsteinitz(nf,order)=given an order as output by rnfpseudobasis, gives [A,I,..] where (A,I) is a pseudo basis where all the ideals except perhaps the last are trivial",
  "rootmod(x,p)=roots mod p of the polynomial x",
  "rootmod2(x,p)=roots mod p of the polynomial x, when p is small",
  "rootpadic(x,p,r)=p-adic roots of the polynomial x to precision r",
  "roots(x)=roots of the polynomial x using Schonhage's method modified by Gourdon",
  "rootsof1(nf)=number of roots of unity and primitive root of unity in the number field nf",
  "rootsold(x)=roots of the polynomial x using a modified Newton's method",
  "round(x)=take the nearest integer to all the coefficients of x",
  "rounderror(x)=maximum error found in rounding x",
  "series(x,v)=convert x (usually a vector) into a power series with variable v, starting with the constant coefficient",
  "set(x)=convert x into a set, i.e. a row vector with strictly increasing coefficients",
  "setintersect(x,y)=intersection of the sets x and y",
  "setminus(x,y)=set of elements of x not belonging to y",
  "setrand(n)=reset the seed of the random number generator to n",
  "setsearch(x,y)=looks if y belongs to the set x. Returns 0 if it is not, otherwise returns the index j such that y==x[j]",
  "setunion(x,y)=union of the sets x and y",
  "shift(x,n)=shift x left n bits if n>=0, right -n bits if n<0",
  "shiftmul(x,n)=multiply x by 2^n (n>=0 or n<0)",
  "sigma(x)=sum of the divisors of x",
  "sigmak(k,x)=sum of the k-th powers of the divisors of x (k C-integer)",
  "sign(x)=sign of x, of type integer, real or fraction",
  "signat(x)=signature of the symmetric matrix x",
  "signunit(bnf)=matrix of signs of the real embeddings of the system of fundamental units found by buchinit",
  "simplefactmod(x,p)=same as factmod except that only the degrees of the irreducible factors are given",
  "simplify(x)=simplify the object x as much as possible",
  "sin(x)=sine of x",
  "sinh(x)=hyperbolic sine of x",
  "size(x)=maximum number of decimal digits minus one of (the coefficients of) x",
  "smallbasis(x)=integral basis of the field Q[a], where a is a root of the polynomial x where one assumes that no square of a prime>primelimit divides the discriminant of x",
  "smallbuchinit(pol)=small buchinit, which can be converted to a big one using makebigbnf",
  "smalldiscf(x)=discriminant of the number field defined by the polynomial x where one assumes that no square of a prime>primelimit divides the discriminant of x",
  "smallfact(x)=partial factorization of the integer x (using only the stored primes)",
  "smallinitell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector: [a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j]",
  "smallpolred(x)=partial reduction of the polynomial x (gives minimal polynomials only)",
  "smallpolred2(x)=partial reduction of the polynomial x (gives elements and minimal polynomials)",
  "smith(x)=Smith normal form (i.e. elementary divisors) of the matrix x, expressed as a vector",
  "smith2(x)=gives a three element vector [u,v,d] where u and v are square unimodular matrices such that d=u*x*v=diagonal(smith(x))",
  "smithclean(z)=if z=[u,v,d] as output by smith2, removes from u,v,d the rows and columns corresponding to entries equal to 1 in d",
  "smithpol(x)=Smith normal form (i.e. elementary divisors) of the matrix x with polynomial coefficients, expressed as a vector",
  "solve(X=a,b,expr)=real root of expression expr (X between a and b), where expr(a)*expr(b)<=0",
  "sort(x)=sort in ascending order of the vector x",
  "sqr(x)=square of x. NOT identical to x*x",
  "sqred(x)=square reduction of the (symmetric) matrix x ( returns a square matrix whose i-th diagonal term is the coefficient of the i-th square in which the coefficient of the i-th variable is 1)",
  "sqrt(x)=square root of x",
  "srgcd(x,y)=polynomial gcd of x and y using the subresultant algorithm",
  "sturm(x)=number of real roots of the polynomial x",
  "sturmpart(x,a,b)=number of real roots of the polynomial x in the interval (a,b]",
  "subcyclo(p,d)=finds an equation for the d-th degree subfield of Q(zeta_p), where p must be a prime power",
  "subell(e,z1,z2)=difference of the points z1 and z2 on elliptic curve e",
  "subst(x,y,z)=in expression x, replace the variable y by the expression z",
  "sum(x,X=a,b,expr)=x plus the sum (X goes from a to b) of expression expr",
  "sumalt(X=a,expr)=Villegas-Zagier's acceleration of alternating series expr, X starting at a",
  "sumalt2(X=a,expr)=Cohen-Villegas-Zagier's acceleration of alternating series expr, X starting at a",
  "suminf(X=a,expr)=infinite sum (X goes from a to infinity) of real or complex expression expr",
  "sumpos(X=a,expr)=sum of positive series expr, the formal variable X starting at a",
  "sumpos2(X=a,expr)=sum of positive series expr, the formal variable X starting at a, using Zagier's polynomials",
  "supplement(x)=supplement the columns of the matrix x to an invertible matrix",
  "sylvestermatrix(x,y)=forms the sylvester matrix associated to the two polynomials x and y. Warning: the polynomial coefficients are in columns, not in rows",
  "tan(x)=tangent of x",
  "tanh(x)=hyperbolic tangent of x",
  "taniyama(e)=modular parametrization of elliptic curve e",
  "taylor(x,y)=taylor expansion of x with respect to the main variable of y",
  "tchebi(n)=Tchebitcheff polynomial of degree n (n C-integer)",
  "teich(x)=teichmuller character of p-adic number x",
  "theta(q,z)=Jacobi sine theta-function",
  "thetanullk(q,k)=k'th derivative at z=0 of theta(q,z)",
  "threetotwo(nf,a,b,c)=returns a 3-component vector [d,e,U] such that U is a unimodular 3x3 matrix with algebraic integer coefficients such that [a,b,c]*U=[0,d,e]",
  "threetotwo2(nf,a,b,c)=returns a 3-component vector [d,e,U] such that U is a unimodular 3x3 matrix with algebraic integer coefficients such that [a,b,c]*U=[0,d,e]",
  "torsell(e)=torsion subgroup of elliptic curve e: order, structure, generators",
  "trace(x)=trace of x",
  "trans(x)=x~=transpose of x",
  "trunc(x)=truncation of x;when x is a power series,take away the O(X^)",
  "tschirnhaus(x)=random Tschirnhausen transformation of the polynomial x",
  "twototwo(nf,a,b)=returns a 3-component vector [d,e,U] such that U is a unimodular 2x2 matrix with algebraic integer coefficients such that [a,b]*U=[d,e] and d,e are hopefully smaller",
  "unit(x)=fundamental unit of the quadratic field of discriminant x where x must be positive",
  "until(a,seq)=evaluate the expression sequence seq until a is nonzero",
  "valuation(x,p)=valuation of x with respect to p",
  "vec(x)=transforms the object x into a vector. Used mainly if x is a polynomial or a power series",
  "vecindexsort(x): indirect sorting of the vector x",
  "veclexsort(x): sort the elements of the vector x in ascending lexicographic order",
  "vecmax(x)=maximum of the elements of the vector/matrix x",
  "vecmin(x)=minimum of the elements of the vector/matrix x",
  "vecsort(x,k)=sorts the vector of vector (or matrix) x according to the value of its k-th component",
  "vector(n,X,expr)=row vector with n components of expression expr (X ranges from 1 to n)",
  "vvector(n,X,expr)=column vector with n components of expression expr (X ranges from 1 to n)",
  "weipell(e)=formal expansion in x=z of Weierstrass P function",
  "wf(x)=Weber's f function of x (j=(f^24-16)^3/f^24)",
  "wf2(x)=Weber's f2 function of x (j=(f2^24+16)^3/f2^24)",
  "while(a,seq)= while a is nonzero evaluate the expression sequence seq. Otherwise 0",
  "zell(e,z)=In the complex case, lattice point corresponding to the point z on the elliptic curve e",
  "zeta(s)=Riemann zeta function at s",
  "zetak(nfz,s)=Dedekind zeta function of the number field nfz at s, where nfz is the vector computed by initzeta (NOT by initalg)",
  "zideallog(nf,x,bid)=if bid is a big ideal as given by zidealstarinit or zidealstarinitgen , gives the vector of exponents on the generators bid[2][3] (even if these generators have not been computed)",
  "zidealstar(nf,I)=3-component vector v, giving the structure of (Z_K/I)^*. v[1] is  the order (i.e. phi(I)), v[2] is a vector of cyclic components, and v[3]  is a vector giving the corresponding generators",
  "zidealstarinit(nf,I)=6-component vector [I,v,fa,f2,U,V] where v is as in zidealstar without the generators, fa is the prime ideal factorisation of I and f2, U and V are technical but essential to work in (Z_K/I)^*",
  "zidealstarinitgen(nf,I)=6-component vector [I,v,fa,f2,U,V] where v is as in zidealstar fa is the prime ideal factorisation of I and f2, U and V are technical but essential to work in (Z_K/I)^*",
  "znstar(n)=3-component vector v, giving the structure of (Z/nZ)^*. v[1] is  the order (i.e. phi(n)), v[2] is a vector of cyclic components, and v[3]  is a vector giving the corresponding generators",
};
