/* $Id: paridecl.h,v 1.203 2002/06/09 00:22:41 karim Exp $

Copyright (C) 2000  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*******************************************************************/
/*                                                                 */
/*                DECLARATIONS of PUBLIC FUNCTIONS                 */
/*                                                                 */
/*******************************************************************/
BEGINEXTERN
/* alglin1.c */
GEN     _col(GEN x);
GEN     _vec(GEN x);
GEN     _veccopy(GEN x);
GEN     FpM_FpV_mul(GEN x, GEN y, GEN p);
GEN     FpM_deplin(GEN x, GEN p);
GEN     FpM_image(GEN x, GEN p);
GEN     FpM_intersect(GEN x, GEN y, GEN p);
GEN     FpM_invimage(GEN m, GEN v, GEN p);
GEN     FpM_inv(GEN x, GEN p);
GEN     FpM_ker(GEN x, GEN p);
GEN     FpM_mul(GEN x, GEN y, GEN p);
GEN     FpM_sindexrank(GEN x, GEN p);
GEN     FpM_suppl(GEN x, GEN p);
GEN     Fq_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FqM_gauss(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_ker(GEN x, GEN T, GEN p);
GEN     FqM_suppl(GEN x, GEN T, GEN p);
GEN     QM_inv(GEN M, GEN dM);
GEN     ZM_inv(GEN M, GEN dM);
GEN     concat(GEN x, GEN y);
GEN     concatsp(GEN x, GEN y);
GEN     concatsp3(GEN x, GEN y, GEN z);
GEN     deplin(GEN x);
GEN     det(GEN a);
GEN     det0(GEN a,long flag);
GEN     det2(GEN a);
GEN     dethnf(GEN x);
GEN     dethnf_i(GEN mat);
GEN     detint(GEN x);
GEN     diagonal(GEN x);
GEN     eigen(GEN x, long prec);
GEN     extract(GEN x, GEN l);
GEN     extract0(GEN x, GEN l1, GEN l2);
GEN     gaddmat(GEN x, GEN y);
GEN     gaddmat_i(GEN x, GEN y);
GEN     gauss(GEN a, GEN b);
GEN     gaussmodulo(GEN M, GEN D, GEN Y);
GEN     gaussmodulo2(GEN M, GEN D, GEN Y);
GEN     gscalcol(GEN x, long n);
GEN     gscalcol_i(GEN x, long n);
GEN     gscalcol_proto(GEN z, GEN myzero, long n);
GEN     gscalmat(GEN x, long n);
GEN     gscalsmat(long x, long n);
GEN     gtomat(GEN x);
GEN     gtrans_i(GEN x);
GEN     gtrans(GEN x);
GEN     hnfadd(GEN mit,GEN perm,GEN* ptdep,GEN* ptA,GEN* ptC,GEN extramat,GEN extraC);
GEN     hnfspec(long** mat,GEN perm,GEN* ptdep,GEN* ptA,GEN* ptC,long k0);
GEN     idmat(long n);
GEN     idmat_intern(long n,GEN myun,GEN myzero);
GEN     image(GEN x);
GEN     image2(GEN x);
GEN     imagecompl(GEN x);
GEN     imagereel(GEN x, long prec);
GEN     indexrank(GEN x);
GEN     inverseimage(GEN mat, GEN y);
long    isdiagonal(GEN x);
long    isscalarmat(GEN x, GEN s);
GEN     ker(GEN x);
GEN     keri(GEN x);
GEN     matextract(GEN x, GEN l1, GEN l2);
GEN     matimage0(GEN x,long flag);
GEN     matker0(GEN x, long flag);
GEN     matmuldiagonal(GEN x, GEN d);
GEN     matmultodiagonal(GEN x, GEN y);
GEN     matsolvemod0(GEN M, GEN D, GEN Y,long flag);
GEN     mattodiagonal(GEN m);
GEN     mattodiagonal_i(GEN m);
long    rank(GEN x);
GEN     rowextract_i(GEN A, long x1, long x2);
GEN     rowextract_p(GEN A, GEN p);
GEN     sindexrank(GEN x);
GEN     suppl(GEN x);
GEN     vecextract_i(GEN A, long y1, long y2);
GEN     vecextract_p(GEN A, GEN p);
GEN     zerocol(long n);
GEN     zeromat(long m, long n);
GEN     zerovec(long n);

/* alglin2.c */

GEN     QuickNormL1(GEN x,long prec);
GEN     QuickNormL2(GEN x,long prec);
GEN     adj(GEN x);
GEN     assmat(GEN x);
GEN     caract(GEN x, int v);
GEN     caract2(GEN p, GEN x, int v);
GEN     caradj(GEN x, long v, GEN *py);
GEN     caradj0(GEN x, long v);
GEN     carhess(GEN x, long v);
GEN     charpoly0(GEN x, int v,long flag);
GEN     conjvec(GEN x,long prec);
GEN     gconj(GEN x);
GEN     gnorm(GEN x);
GEN     gnorml1(GEN x,long prec);
GEN     gnorml2(GEN x);
GEN     gtrace(GEN x);
GEN     hess(GEN x);
GEN     hnf(GEN x);
GEN     hnfall(GEN x);
GEN     hnfhavas(GEN x);
GEN     hnflll(GEN x);
GEN     hnflll_i(GEN A, GEN *ptB, int remove);
GEN     hnfmod(GEN x, GEN detmat);
GEN     hnfmodid(GEN x,GEN p);
GEN     hnfperm(GEN x);
GEN     intersect(GEN x, GEN y);
GEN     jacobi(GEN a, long prec);
GEN     matrixqz(GEN x, GEN pp);
GEN     matrixqz0(GEN x, GEN pp);
GEN     matrixqz2(GEN x);
GEN     matrixqz3(GEN x);
GEN     signat(GEN a);
GEN     smith(GEN x);
GEN     smith2(GEN x);
GEN     smithall(GEN x, GEN *ptU, GEN *ptV);
GEN     smithclean(GEN z);
GEN     sqred(GEN a);
GEN     sqred1(GEN a);
GEN     sqred1intern(GEN a, long flag);
GEN     sqred3(GEN a);

/* anal.c */

entree  *fetch_named_var(char *s, int doerr);
entree  *gp_variable(char *s);
entree  *is_entry(char *s);
void    delete_named_var(entree *ep);
long    delete_var(void);
long    fetch_user_var(char *s);
long    fetch_var(void);
GEN     flisexpr(char *t);
GEN     flisseq(char *t);
void    freeep(entree *ep);
long    hashvalue(char *s);
entree* install(void *f, char *name, char *code);
GEN     lisexpr(char *t);
GEN     lisseq(char *t);
long    manage_var(long n, entree *ep);
void    name_var(long n, char *s);
GEN     readseq(char *c, int strict);
GEN     strtoGENstr(char *s, long flag);

/* arith1.c */

GEN     bestappr(GEN x, GEN k);
GEN     bestappr0(GEN x, GEN a, GEN b);
long    carrecomplet(GEN x, GEN *pt);
long    cgcd(long a,long b);
GEN     chinese(GEN x, GEN y);
GEN     chinois(GEN x, GEN y);
GEN     classno(GEN x);
GEN     classno2(GEN x);
long    clcm(long a,long b);
GEN     contfrac0(GEN x, GEN b, long flag);
GEN     fibo(long n);
GEN     fundunit(GEN x);
GEN     gboundcf(GEN x, long k);
GEN     gcarrecomplet(GEN x, GEN *pt);
GEN     gcarreparfait(GEN x);
GEN     gcf(GEN x);
GEN     gcf2(GEN b, GEN x);
GEN     gener(GEN m);
GEN     gfundunit(GEN x);
GEN     ggener(GEN m);
GEN     gisfundamental(GEN x);
GEN     gisprime(GEN x, long flag);
GEN     gispseudoprime(GEN x, long flag);
GEN     gispsp(GEN x);
GEN     gkrogs(GEN x, long y);
GEN     gkronecker(GEN x, GEN y);
GEN     gmillerrabin(GEN n, long k);
GEN     gnextprime(GEN n);
GEN     gprecprime(GEN n);
GEN     gracine(GEN a);
GEN     gregula(GEN x, long prec);
GEN     hclassno(GEN x);
long    hil(GEN x, GEN y, GEN p);
long    hil0(GEN x, GEN y, GEN p);
long    isfundamental(GEN x);
long    isprime(GEN x);
long    isprimeAPRCL(GEN N);
long    isprimeSelfridge(GEN x);
long    ispseudoprime(GEN x, long flag);
long    ispsp(GEN x);
long    krogs(GEN x, long y);
long    kronecker(GEN x, GEN y);
long    krosg(long s, GEN x);
long    kross(long x, long y);
void    lucas(long n, GEN *ln, GEN *ln1);
GEN     mpfact(long n);
GEN     mpfactr(long n, long prec);
GEN     mpinvmod(GEN a, GEN m);
GEN     mppgcd(GEN a, GEN b);
GEN     mpppcm(GEN a, GEN b);
GEN     mpsqrtmod(GEN a, GEN p);
GEN     mpsqrtnmod(GEN a, GEN n, GEN p, GEN *zetan);
GEN     order(GEN x);
GEN     pnqn(GEN x);
GEN     powmodulo(GEN a, GEN n, GEN m);
GEN     qfbclassno0(GEN x,long flag);
GEN     quaddisc(GEN x);
GEN     racine(GEN a);
GEN     regula(GEN x, long prec);
GEN     znstar(GEN x);

/* arith2.c */

GEN     Qfb0(GEN x, GEN y, GEN z, GEN d, long prec);
GEN     addprimes(GEN primes);
GEN     auxdecomp(GEN n, long all);
long    bigomega(GEN n);
GEN     binaire(GEN x);
long    bittest(GEN x, long n);
GEN     boundfact(GEN n, long lim);
GEN     compimag(GEN x, GEN y);
GEN     compimagraw(GEN x, GEN y);
GEN     compraw(GEN x, GEN y);
GEN     compreal(GEN x, GEN y);
GEN     comprealraw(GEN x, GEN y);
GEN     core(GEN n);
GEN     corepartial(GEN n);
GEN     core0(GEN n,long flag);
GEN     core2(GEN n);
GEN     core2partial(GEN n);
GEN     coredisc(GEN n);
GEN     coredisc0(GEN n,long flag);
GEN     coredisc2(GEN n);
GEN     decomp(GEN n);
GEN     decomp_primary_small(long n);
GEN     decomp_small(long n);
GEN     divisors(GEN n);
GEN     factorint(GEN n, long flag);
GEN     gbigomega(GEN n);
GEN     gbitand(GEN x, GEN y);
GEN     gbitneg(GEN x, long n);
GEN     gbitnegimply(GEN x, GEN y);
GEN     gbitor(GEN x, GEN y);
GEN     gbittest(GEN x, GEN n);
GEN	gbittest3(GEN x, GEN n, long c);
GEN     gbitxor(GEN x, GEN y);
GEN     gboundfact(GEN n, long lim);
GEN     gissquarefree(GEN x);
GEN     gmu(GEN n);
GEN     gnumbdiv(GEN n);
GEN     gomega(GEN n);
GEN     gphi(GEN n);
GEN     gsumdiv(GEN n);
GEN     gsumdivk(GEN n,long k);
byteptr initprimes(long maxnum);
long    issquarefree(GEN x);
ulong   maxprime(void);
long    mu(GEN n);
GEN     nucomp(GEN x, GEN y, GEN l);
GEN     nudupl(GEN x, GEN l);
GEN     numbdiv(GEN n);
GEN     nupow(GEN x, GEN n);
long    omega(GEN n);
GEN     phi(GEN n);
GEN     powraw(GEN x, long n);
GEN     powrealraw(GEN x, long n);
GEN     prime(long n);
GEN     primeform(GEN x, GEN p, long prec);
GEN     primes(long n);
GEN     qfbred0(GEN x, long flag, GEN D, GEN isqrtD, GEN sqrtD);
GEN     qfi(GEN x, GEN y, GEN z);
GEN     qfr(GEN x, GEN y, GEN z, GEN d);
GEN     redimag(GEN x);
GEN     redreal(GEN x);
GEN     redrealnod(GEN x, GEN isqrtD);
GEN     removeprimes(GEN primes);
GEN     rhoreal(GEN x);
GEN     rhorealnod(GEN x, GEN isqrtD);
GEN     smallfact(GEN n);
GEN     sqcompimag(GEN x);
GEN     sqcompreal(GEN x);
GEN     sumdiv(GEN n);
GEN     sumdivk(GEN n,long k);

/* base1.c */

GEN     bnfnewprec(GEN nf, long prec);
GEN     bnrnewprec(GEN bnr, long prec);
void    check_pol_int(GEN x, char *s);
GEN     check_units(GEN x, char *f);
void    checkbid(GEN bid);
GEN     checkbnf(GEN bnf);
GEN     checkbnf_discard(GEN bnf);
void    checkbnr(GEN bnr);
void    checkbnrgen(GEN bnr);
void    checkid(GEN x, long N);
GEN     checknf(GEN nf);
GEN     checknfelt_mod(GEN nf, GEN x, char *s);
void    checkprimeid(GEN bid);
void    checkrnf(GEN rnf);
GEN     galois(GEN x, long prec);
GEN     galoisapply(GEN nf, GEN aut, GEN x);
GEN     get_bnf(GEN x,int *t);
GEN     get_nf(GEN x,int *t);
GEN     get_nfpol(GEN x, GEN *nf);
GEN     get_primeid(GEN x);
GEN     glambdak(GEN nfz, GEN s, long prec);
int     gpolcomp(GEN p1, GEN p2);
GEN     gsmith(GEN x);
GEN     gsmith2(GEN x);
GEN     gzetak(GEN nfz, GEN s, long prec);
GEN     gzetakall(GEN nfz, GEN s, long flag, long prec);
GEN     initalg(GEN x, long prec);
GEN     initalgred(GEN x, long prec);
GEN     initalgred2(GEN x, long prec);
GEN     initzeta(GEN pol, long prec);
GEN     mathnf0(GEN x,long flag);
GEN     matsnf0(GEN x,long flag);
long    nf_get_r1(GEN nf);
long    nf_get_r2(GEN nf);
void    nf_get_sign(GEN nf, long *r1, long *r2);
long    nfgetprec(GEN x);
GEN     nfinit0(GEN x,long flag, long prec);
GEN     nfnewprec(GEN nf, long prec);
GEN     rootsof1(GEN x);
GEN     tschirnhaus(GEN x);

/* base2.c */

GEN     allbase(GEN f, int flag, GEN *dx, GEN *dK, GEN *index, GEN *ptw);
GEN     base(GEN x, GEN *y);
GEN     base2(GEN x, GEN *y);
void    checkmodpr(GEN modpr);
GEN     compositum(GEN pol1, GEN pol2);
GEN     compositum2(GEN pol1, GEN pol2);
GEN     discf(GEN x);
GEN     discf2(GEN x);
GEN     factoredbase(GEN x, GEN p, GEN *y);
GEN     factoreddiscf(GEN x, GEN p);
GEN     ff_to_nf(GEN x, GEN modpr);
GEN     fix_relative_pol(GEN nf, GEN x, int chk_lead);
GEN     gcdpm(GEN f1,GEN f2,GEN pm);
long    idealval(GEN nf,GEN ix,GEN vp);
GEN     idealprodprime(GEN nf, GEN L);
GEN     modprX(GEN x, GEN nf,GEN modpr);
GEN     modprX_lift(GEN x, GEN modpr);
GEN     modprM(GEN z, GEN nf,GEN modpr);
GEN     modprM_lift(GEN z, GEN modpr);
GEN     nf_to_ff_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     nf_to_ff(GEN nf, GEN x, GEN modpr);
GEN     nfbasis(GEN x, GEN *y,long flag,GEN p);
GEN     nfbasis0(GEN x,long flag,GEN p);
GEN     nfdiscf0(GEN x,long flag, GEN p);
GEN     nfreducemodideal(GEN nf,GEN x,GEN ideal);
GEN     nfreducemodpr(GEN nf, GEN x, GEN modpr);
GEN     polcompositum0(GEN pol1, GEN pol2,long flag);
GEN     primedec(GEN nf,GEN p);
GEN     rnfbasis(GEN bnf, GEN order);
GEN     rnfdet(GEN nf, GEN order);
GEN     rnfdet0(GEN nf, GEN x, GEN y);
GEN     rnfdet2(GEN nf, GEN A, GEN I);
GEN     rnfdiscf(GEN nf, GEN pol);
GEN     rnfequation(GEN nf, GEN pol2);
GEN     rnfequation0(GEN nf, GEN pol2, long flall);
GEN     rnfequation2(GEN nf, GEN pol);
GEN     rnfhermitebasis(GEN bnf, GEN order);
long    rnfisfree(GEN bnf, GEN order);
GEN     rnflllgram(GEN nf, GEN pol, GEN order,long prec);
GEN     rnfpolred(GEN nf, GEN pol, long prec);
GEN     rnfpolredabs(GEN nf, GEN pol, long flag);
GEN     rnfpseudobasis(GEN nf, GEN pol);
GEN     rnfsimplifybasis(GEN bnf, GEN order);
GEN     rnfsteinitz(GEN nf, GEN order);
GEN     smallbase(GEN x, GEN *y);
GEN     smalldiscf(GEN x);
GEN     zk_to_ff_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     zkmodprinit(GEN nf, GEN pr);

/* base3.c */

GEN     algtobasis(GEN nf, GEN x);
GEN     algtobasis_i(GEN nf,GEN x);
GEN     basistoalg(GEN nf, GEN x);
GEN     element_div(GEN nf, GEN x, GEN y);
GEN     element_inv(GEN nf, GEN x);
GEN     element_invmodideal(GEN nf, GEN x, GEN ideal);
GEN     element_mul(GEN nf,GEN x,GEN y);
GEN     element_muli(GEN nf,GEN x,GEN y);
GEN     element_mulid(GEN nf, GEN x, long i);
GEN     element_mulvec(GEN nf, GEN x, GEN v);
GEN     element_pow(GEN nf,GEN x,GEN k);
GEN     element_pow_mod_p(GEN nf, GEN x, GEN n, GEN p);
GEN     element_powmodideal(GEN nf,GEN x,GEN k,GEN ideal);
GEN     element_powmodidele(GEN nf,GEN x,GEN k,GEN idele,GEN structarch);
GEN     element_sqr(GEN nf,GEN x);
GEN     element_sqri(GEN nf, GEN x);
long    element_val(GEN nf, GEN x, GEN vp);
long    element_val2(GEN nf, GEN x, GEN d, GEN vp);
GEN     eltmul_get_table(GEN nf, GEN x);
GEN     ideallist(GEN nf,long bound);
GEN     ideallist0(GEN nf,long bound, long flag);
GEN     ideallistarch(GEN nf, GEN list, GEN arch);
GEN     ideallistarch0(GEN nf, GEN list, GEN arch,long flag);
GEN     ideallistarchgen(GEN nf, GEN list, GEN arch);
GEN     ideallistunit(GEN nf,long bound);
GEN     ideallistunitarch(GEN bnf,GEN list,GEN arch);
GEN     ideallistunitarchgen(GEN bnf,GEN list,GEN arch);
GEN     ideallistunitgen(GEN nf,long bound);
GEN     ideallistzstar(GEN nf,long bound);
GEN     ideallistzstargen(GEN nf,long bound);
GEN     idealstar0(GEN nf, GEN x,long flag);
int     isnfscalar(GEN x);
GEN     lllreducemodmatrix(GEN x,GEN y);
GEN     nfdiveuc(GEN nf, GEN a, GEN b);
GEN     nfdivres(GEN nf, GEN a, GEN b);
GEN     nfmod(GEN nf, GEN a, GEN b);
GEN     nfreducemodidele(GEN nf,GEN g,GEN idele,GEN structarch);
GEN     reducemodinvertible(GEN x, GEN y);
GEN     reducemodmatrix(GEN x, GEN y);
GEN     reducemodHNF(GEN x, GEN y, GEN *Q);
GEN     set_sign_mod_idele(GEN nf, GEN x, GEN y, GEN idele, GEN sarch);
GEN     smithrel(GEN H, GEN *newU, GEN *newUi);
GEN     zarchstar(GEN nf,GEN x,GEN arch,long nba);
GEN     zideallog(GEN nf,GEN x,GEN bigideal);
GEN     zidealstar(GEN nf, GEN x);
GEN     zidealstarinit(GEN nf, GEN x);
GEN     zidealstarinitall(GEN nf, GEN x,long flun);
GEN     zidealstarinitgen(GEN nf, GEN x);
GEN     zidealstarinitjoin(GEN nf, GEN bid1, GEN bid2, long flag);
GEN     zidealstarinitjoinarch(GEN nf, GEN bid1, GEN arch, long nba, long flag);
GEN     znlog(GEN x, GEN g);
GEN     zsigne(GEN nf,GEN alpha,GEN arch);

/* base4.c */

GEN     element_divmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     element_invmodpr(GEN nf, GEN y, GEN modpr);
GEN     element_mulmodpr2(GEN nf, GEN x, GEN y, GEN modpr);
GEN     element_powmodpr(GEN nf, GEN x, GEN k, GEN modpr);
GEN     element_reduce(GEN nf, GEN x, GEN ideal);
GEN     ideal_two_elt(GEN nf, GEN ix);
GEN     ideal_two_elt0(GEN nf, GEN ix, GEN a);
GEN     ideal_two_elt2(GEN nf, GEN x, GEN a);
GEN     idealadd(GEN nf, GEN x, GEN y);
GEN     idealaddmultoone(GEN nf, GEN list);
GEN     idealaddtoone(GEN nf, GEN x, GEN y);
GEN     idealaddtoone0(GEN nf, GEN x, GEN y);
GEN     idealappr(GEN nf, GEN x);
GEN     idealappr0(GEN nf, GEN x, long fl);
GEN     idealapprfact(GEN nf, GEN x);
GEN     idealchinese(GEN nf, GEN x, GEN y);
GEN     idealcoprime(GEN nf, GEN x, GEN y);
GEN     idealdiv(GEN nf, GEN x, GEN y);
GEN     idealdiv0(GEN nf, GEN x, GEN y,long flag);
GEN     idealdivexact(GEN nf, GEN x, GEN y);
GEN     idealdivpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealmulpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealfactor(GEN nf, GEN x);
GEN     idealhermite(GEN nf, GEN x);
GEN     idealhermite2(GEN nf, GEN a, GEN b);
GEN     idealhnf0(GEN nf, GEN a, GEN b);
GEN     idealintersect(GEN nf, GEN x, GEN y);
GEN     idealinv(GEN nf, GEN ix);
GEN     ideallllred(GEN nf,GEN ix,GEN vdir,long prec);
GEN     ideallllred_elt(GEN nf, GEN I);
GEN     idealmul(GEN nf, GEN ix, GEN iy);
GEN     idealmul0(GEN nf, GEN ix, GEN iy, long flag, long prec);
GEN     idealmulh(GEN nf, GEN ix, GEN iy);
GEN     idealmulprime(GEN nf,GEN ix,GEN vp);
GEN     idealmulred(GEN nf, GEN ix, GEN iy, long prec);
GEN     idealnorm(GEN nf, GEN x);
GEN     idealoplll(GEN op(GEN,GEN,GEN), GEN nf, GEN x, GEN y);
GEN     idealpow(GEN nf, GEN ix, GEN n);
GEN     idealpow0(GEN nf, GEN ix, GEN n, long flag, long prec);
GEN     idealpowred(GEN nf, GEN ix, GEN n,long prec);
GEN     idealpows(GEN nf, GEN ideal, long iexp);
GEN     ideleaddone(GEN nf, GEN x, GEN idele);
int     ishnfall(GEN x);
GEN     hnfall_i(GEN A, GEN *ptB, long remove);
long    isideal(GEN nf,GEN x);
long    isinvector(GEN v, GEN x, long n);
GEN     minideal(GEN nf,GEN ix,GEN vdir,long prec);
GEN     nfdetint(GEN nf,GEN pseudo);
GEN     nfhermite(GEN nf, GEN x);
GEN     nfhermitemod(GEN nf, GEN x, GEN detmat);
GEN     nfkermodpr(GEN nf, GEN x, GEN modpr);
GEN     nfmodprinit(GEN nf, GEN pr);
GEN     nfsmith(GEN nf, GEN x);
GEN     nfsolvemodpr(GEN nf, GEN a, GEN b, GEN modpr);
GEN     oldidealinv(GEN nf, GEN ix);
GEN     prime_to_ideal(GEN nf, GEN vp);
GEN     principalideal(GEN nf, GEN a);
GEN     principalidele(GEN nf, GEN a, long prec);

/* base5.c */

GEN     lift_to_pol(GEN x);
GEN     matalgtobasis(GEN nf, GEN x);
GEN     matbasistoalg(GEN nf, GEN x);
GEN     rnfalgtobasis(GEN rnf, GEN x);
GEN     rnfbasistoalg(GEN rnf, GEN x);
GEN     rnfelementabstorel(GEN rnf, GEN x);
GEN     rnfelementdown(GEN rnf, GEN x);
GEN     rnfelementreltoabs(GEN rnf, GEN x);
GEN     rnfelementup(GEN rnf, GEN x);
GEN     rnfidealabstorel(GEN rnf, GEN x);
GEN     rnfidealdown(GEN rnf, GEN x);
GEN     rnfidealhermite(GEN rnf, GEN x);
GEN     rnfidealmul(GEN rnf,GEN x,GEN y);
GEN     rnfidealnormabs(GEN rnf, GEN x);
GEN     rnfidealnormrel(GEN rnf, GEN x);
GEN     rnfidealreltoabs(GEN rnf, GEN x);
GEN     rnfidealtwoelement(GEN rnf,GEN x);
GEN     rnfidealup(GEN rnf, GEN x);
GEN     rnfinitalg(GEN nf,GEN pol,long prec);

/* bibli1.c */

GEN     T2_from_embed(GEN x, long r1);
GEN     algdep(GEN x, long n, long prec);
GEN     algdep0(GEN x, long n, long bit,long prec);
GEN     algdep2(GEN x, long n, long bit);
GEN     factoredpolred(GEN x, GEN p);
GEN     factoredpolred2(GEN x, GEN p);
GEN     kerint(GEN x);
GEN     kerint1(GEN x);
GEN     lindep(GEN x, long prec);
GEN     lindep0(GEN x, long flag,long prec);
GEN     lindep2(GEN x, long bit);
GEN     lll(GEN x, long prec);
GEN     lllgen(GEN x);
GEN     lllgram(GEN x, long prec);
GEN     lllgramall(GEN x, long alpha, long flag);
GEN     lllgramgen(GEN x);
GEN     lllgramint(GEN x);
GEN     lllgramintern(GEN x, long alpha, long flag, long prec);
GEN     lllgramkerim(GEN x);
GEN     lllgramkerimgen(GEN x);
GEN     lllint(GEN x);
GEN     lllint_i(GEN x, long alpha, int gram, GEN *h, GEN *ptfl, GEN *ptB);
GEN     lllint_ip(GEN x, long alpha);
GEN     lllintern(GEN x, long D, long flag, long prec);
GEN     lllintpartial(GEN mat);
GEN     lllkerim(GEN x);
GEN     lllkerimgen(GEN x);
GEN     matkerint0(GEN x,long flag);
GEN     minim(GEN a, GEN borne, GEN stockmax);
GEN     nf_get_LLL(GEN nf);
GEN     qfminim0(GEN a, GEN borne, GEN stockmax,long flag, long prec);
GEN     minim2(GEN a, GEN borne, GEN stockmax);
GEN     ordred(GEN x);
GEN     perf(GEN a);
GEN     polred(GEN x);
GEN     polred0(GEN x, long flag, GEN p);
GEN     polred2(GEN x);
GEN     polredabs(GEN x);
GEN     polredabs0(GEN x, long flag);
GEN     polredabs2(GEN x);
GEN     polredabsall(GEN x, long flun);
GEN     qflll0(GEN x, long flag, long prec);
GEN     qflllgram0(GEN x, long flag, long prec);
GEN     smallpolred(GEN x);
GEN     smallpolred2(GEN x);

/* bibli2.c */

GEN     RXQ_powers(GEN a, GEN T, long l);
GEN     RX_RXQ_compo(GEN f, GEN x, GEN T);
GEN     binome(GEN x, long k);
int     cmp_pol(GEN x, GEN y);
int     cmp_prime_ideal(GEN x, GEN y);
int     cmp_prime_over_p(GEN x, GEN y);
int     cmp_vecint(GEN x, GEN y);
GEN     convol(GEN x, GEN y);
GEN     cyclo(long n, long v);
GEN     dirdiv(GEN x, GEN y);
GEN     dirmul(GEN x, GEN y);
GEN     dirzetak(GEN nf, GEN b);
long    gen_search(GEN x, GEN y, int flag, int (*cmp)(GEN,GEN));
GEN     gen_setminus(GEN set1, GEN set2, int (*cmp)(GEN,GEN));
GEN     gen_sort(GEN x, int flag, int (*cmp)(GEN,GEN));
GEN     genrand(GEN N);
GEN     getheap(void);
long    getrand(void);
long    getstack(void);
long    gettime(void);
GEN     gprec(GEN x, long l);
GEN     gprec_w(GEN x, long pr);
GEN     grando0(GEN x, long n, long do_clone);
GEN     gtoset(GEN x);
GEN     indexlexsort(GEN x);
GEN     indexsort(GEN x);
GEN     laplace(GEN x);
GEN     legendre(long n, long v);
GEN     lexsort(GEN x);
GEN     mathilbert(long n);
GEN     matqpascal(long n, GEN q);
GEN     modreverse_i(GEN a, GEN T);
long    mymyrand(void);
GEN     numtoperm(long n, GEN x);
int     pari_compare_int(int *a,int *b);
int     pari_compare_long(long *a,long *b);
GEN     permtonum(GEN x);
GEN     polint(GEN xa, GEN ya, GEN x, GEN *dy);
GEN     polrecip(GEN x);
GEN     polymodrecip(GEN x);
GEN     roots_to_pol(GEN a, long v);
GEN     setintersect(GEN x, GEN y);
long    setisset(GEN x);
GEN     setminus(GEN x, GEN y);
long    setrand(long seed);
long    setsearch(GEN x, GEN y, long flag);
GEN     setunion(GEN x, GEN y);
GEN     sindexlexsort(GEN x);
GEN     sindexsort(GEN x);
GEN     sort(GEN x);
long    tablesearch(GEN T, GEN x, int (*cmp)(GEN,GEN));
GEN     tayl(GEN x, long v, long precdl);
GEN     tchebi(long n, long v);
GEN     vecsort(GEN x, GEN k);
GEN     vecsort0(GEN x, GEN k, long flag);

/* buch1.c */

GEN     buchimag(GEN D, GEN gcbach, GEN gcbach2, GEN gCO);
GEN     buchreal(GEN D, GEN gsens, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec);
GEN     quadclassunit0(GEN x, long flag,GEN data, long prec);
GEN     quadhilbert(GEN D, GEN flag, long prec);
GEN     quadray(GEN bnf, GEN f, GEN flag, long prec);


/* buch2.c */

GEN     bnfclassunit0(GEN P,long flag,GEN data,long prec);
GEN     bnfinit0(GEN P,long flag,GEN data,long prec);
GEN     buchall(GEN P, GEN gcbach, GEN gcbach2, GEN gRELSUP, GEN gborne, long nbrelpid, long minsfb, long flun, long prec);
GEN     buchfu(GEN bignf);
GEN     classgrouponly(GEN P,GEN data,long prec);
GEN     isprincipal(GEN bignf, GEN x);
GEN     isprincipalall(GEN bignf, GEN x,long flall);
GEN     isprincipalforce(GEN bignf,GEN x);
GEN     isprincipalgen(GEN bignf, GEN x);
GEN     isprincipalgenforce(GEN bignf,GEN x);
GEN     isunit(GEN bignf, GEN x);
GEN     bnfmake(GEN sbnf,long prec);
GEN     regulator(GEN P,GEN data,long prec);
GEN     signunits(GEN bignf);
GEN     smallbuchinit(GEN pol,GEN gcbach,GEN gcbach2,GEN gRELSUP,GEN gborne,long nbrelpid,long minsfb,long prec);

/* buch3.c */

GEN     bnrclass0(GEN bignf, GEN ideal, long flag);
GEN     bnrconductor(GEN arg0,GEN arg1,GEN arg2,long all);
GEN     bnrconductorofchar(GEN bnr,GEN chi);
GEN     bnrdisc0(GEN arg0, GEN arg1, GEN arg2, long flag);
GEN     bnrdisclist0(GEN bnf,GEN borne, GEN arch, long all);
GEN     bnrinit0(GEN bignf,GEN ideal,long flag);
long    bnrisconductor(GEN arg0,GEN arg1,GEN arg2);
GEN     buchnarrow(GEN bignf);
GEN     buchray(GEN bignf,GEN ideal);
GEN     buchrayinit(GEN bignf,GEN ideal);
GEN     buchrayinitgen(GEN bignf,GEN ideal);
long    certifybuchall(GEN bnf);
GEN     conductor(GEN bnr,GEN subgroup,long all);
GEN     decodemodule(GEN nf, GEN fa);
GEN     discrayabs(GEN bnr,GEN subgroup);
GEN     discrayabscond(GEN bnr,GEN subgroup);
GEN     discrayabslist(GEN bnf,GEN listes);
GEN     discrayabslistarch(GEN bnf, GEN arch, long bound);
GEN     discrayabslistlong(GEN bnf, long bound);
GEN     discrayrel(GEN bnr,GEN subgroup);
GEN     discrayrelcond(GEN bnr,GEN subgroup);
GEN     isprincipalray(GEN bignf, GEN x);
GEN     isprincipalrayall(GEN bignf, GEN x,long flall);
GEN     isprincipalraygen(GEN bignf, GEN x);
GEN     rayclassno(GEN bignf,GEN ideal);
GEN     rayclassnolist(GEN bnf,GEN listes);
GEN     rnfconductor(GEN bnf, GEN polrel, long flag);
GEN     rnfkummer(GEN bnr, GEN subgroup, long all, long prec);
GEN     rnfnormgroup(GEN bnr, GEN polrel);
GEN     subgrouplist0(GEN bnr, GEN indexbound, long all);

/* buch4.c */

GEN     bnfisnorm(GEN bnf,GEN x,long flag,long PREC);
GEN     rnfisnorm(GEN bnf,GEN ext,GEN x,long flag,long PREC);
GEN     bnfissunit(GEN bnf,GEN suni,GEN x);
GEN     bnfsunit(GEN bnf,GEN s,long PREC);
long    nfhilbert(GEN bnf,GEN a,GEN b);
long    nfhilbert0(GEN bnf,GEN a,GEN b,GEN p);
long    nfhilbertp(GEN bnf,GEN a,GEN b,GEN p);
long    qpsoluble(GEN pol,GEN p);
long    qpsolublenf(GEN bnf,GEN pol,GEN p);
long    zpsoluble(GEN pol,GEN p);
long    zpsolublenf(GEN bnf,GEN pol,GEN p);

/* elliptic.c */

GEN     addell(GEN e, GEN z1, GEN z2);
GEN     akell(GEN e, GEN n);
GEN     anell(GEN e, long n);
GEN     apell(GEN e, GEN p);
GEN     apell2(GEN e, GEN p);
GEN     bilhell(GEN e, GEN z1, GEN z2, long prec);
GEN     coordch(GEN e, GEN ch);
GEN     ellap0(GEN e, GEN p, long flag);
GEN     elleisnum(GEN om, long k, long flag, long prec);
GEN     elleta(GEN om, long prec);
GEN     ellheight0(GEN e, GEN a, long flag,long prec);
GEN     ellinit0(GEN x,long flag,long prec);
GEN     ellminimalmodel(GEN E, GEN *ptv);
long    ellrootno(GEN e, GEN p);
GEN     ellsigma(GEN om, GEN z, long flag, long prec);
GEN     elltors0(GEN e, long flag);
GEN     ellwp0(GEN e, GEN z, long flag, long prec, long PREC);
GEN     ellzeta(GEN om, GEN z, long prec);
GEN     ghell(GEN e, GEN a, long prec);
GEN     ghell2(GEN e, GEN a, long prec);
GEN     globalreduction(GEN e1);
GEN     initell(GEN x, long prec);
GEN     localreduction(GEN e, GEN p1);
GEN     lseriesell(GEN e, GEN s, GEN A, long prec);
GEN     mathell(GEN e, GEN x, long prec);
int     oncurve(GEN e, GEN z);
GEN     ordell(GEN e, GEN x, long prec);
GEN     orderell(GEN e, GEN p);
GEN     pointch(GEN x, GEN ch);
GEN     pointell(GEN e, GEN z, long prec);
GEN     powell(GEN e, GEN z, GEN n);
GEN     smallinitell(GEN x);
GEN     subell(GEN e, GEN z1, GEN z2);
GEN     taniyama(GEN e);
GEN     torsell(GEN e);
GEN     weipell(GEN e, long precdl);
GEN     zell(GEN e, GEN z, long prec);

/* es.c */

char*   GENtostr(GEN x);
void    brute(GEN g, char format, long dec);
void    bruteall(GEN g, char format, long dec, long flbl);
void    bruterr(GEN x,char format,long dec);
const char* eng_ord(long i);
void    etatpile(unsigned int n);
char*   expand_tilde(char *s);
int     file_is_binary(FILE *f);
void    flusherr(void);
void    fprintferr(char* pat, ...);
void    killallfiles(int check);
int     killfile(pariFILE *f);
GEN     lisGEN(FILE *f);
void    matbrute(GEN g, char format, long dec);
pariFILE* newfile(FILE *f, char *name, int type);
void    os_close(long fd);
char*   os_getenv(char *s);
long    os_open(char *s, int mode);
void    os_read(long fd, char ch[], long s);
void    (*os_signal(int sig, void (*f)(int)))(int);
void    outbeaut(GEN x);
void    outbeauterr(GEN x);
void    outbrute(GEN x);
void    outerr(GEN x);
void    outmat(GEN x);
void    output(GEN x);
void    outsor(GEN x);
void    outtex(GEN x);
void    pari_fclose(pariFILE *f);
pariFILE*   pari_fopen(char *s, char *mode);
pariFILE*   pari_safefopen(char *s, char *mode);
char*   pari_strdup(char *s);
char*   pari_unique_filename(char *s);
void    pari_unlink(char *s);
void    pariflush(void);
void    pariputc(char c);
void    pariputs(char *s);
void    pariputsf(char *format, ...);
int     popinfile(void);
GEN     readbin(char *name, FILE *f);
void    sor(GEN g, char fo, long dd, long chmp);
void    switchin(char *name);
void    switchout(char *name);
void    texe(GEN g, char format, long dec);
pariFILE* try_pipe(char *cmd, int flag);
char*   type_name(long t);
void    voir(GEN x, long nb);
void    vpariputs(char* format, va_list args);
void    writebin(char *name, GEN x);

/* galconj.c */

GEN     checkgal(GEN gal);
GEN     galoisconj(GEN nf);
GEN     galoisconj0(GEN nf, long flag, GEN d, long prec);
GEN     galoisconj2(GEN x, long nbmax, long prec);
GEN     galoisconj4(GEN T, GEN den, long flag, long karma);
GEN     galoisfixedfield(GEN gal, GEN v, long flag, long y);
GEN     galoisinit(GEN nf, GEN den, long karma);
GEN     galoisisabelian(GEN gal, long flag);
GEN     galoispermtopol(GEN gal, GEN perm);
GEN     galoissubgroups(GEN G);
GEN     galoissubfields(GEN G, long flag, long v);
long    numberofconjugates(GEN T, long pdepart);
GEN     vandermondeinverse(GEN L, GEN T, GEN den, GEN prep);
/* gen1.c */

GEN     gadd(GEN x, GEN y);
GEN     gdiv(GEN x, GEN y);
GEN     gmul(GEN x, GEN y);
GEN     gred(GEN x);
GEN     gred_rfrac(GEN x);
GEN     gsqr(GEN x);
GEN     gsub(GEN x, GEN y);

/* gen2.c */
void    gop1z(GEN (*f)(GEN), GEN x, GEN y);
void    gop2z(GEN (*f)(GEN, GEN), GEN x, GEN y, GEN z);
GEN     gopgs2(GEN (*f)(GEN, GEN), GEN y, long s);
void    gops2gsz(GEN (*f)(GEN, long), GEN x, long s, GEN z);
void    gops2sgz(GEN (*f)(long, GEN), long s, GEN y, GEN z);
void    gops2ssz(GEN (*f)(long, long), long s, long y, GEN z);
GEN     gopsg2(GEN (*f)(GEN, GEN), long s, GEN y);
void    gopsg2z(GEN (*f)(GEN, GEN), long s, GEN y, GEN z);
long    opgs2(int (*f)(GEN, GEN), GEN y, long s);

GEN     cgetp(GEN x);
GEN     co8(GEN x, long l);
GEN     cvtop(GEN x, GEN p, long l);
GEN     from_Kronecker(GEN z, GEN pol);
GEN     gabs(GEN x, long prec);
void    gaffect(GEN x, GEN y);
void    gaffsg(long s, GEN x);
GEN     gclone(GEN x);
int     gcmp(GEN x, GEN y);
int     gcmp0(GEN x);
int     gcmp1(GEN x);
int     gcmp_1(GEN x);
GEN     gcvtop(GEN x, GEN p, long r);
int     gegal(GEN x, GEN y);
long    gexpo(GEN x);
long    ggval(GEN x, GEN p);
long    glength(GEN x);
GEN     gmax(GEN x, GEN y);
GEN     gmin(GEN x, GEN y);
GEN     gneg(GEN x);
GEN     gneg_i(GEN x);
GEN     greffe(GEN x, long l, long use_stack);
int     gsigne(GEN x);
GEN     gtolist(GEN x);
long    gtolong(GEN x);
int     lexcmp(GEN x, GEN y);
GEN     listconcat(GEN list1, GEN list2);
GEN     listcreate(long n);
GEN     listinsert(GEN list, GEN object, long index);
void    listkill(GEN list);
GEN     listput(GEN list, GEN object, long index);
GEN     listsort(GEN list, long flag);
GEN     matsize(GEN x);
GEN     normalize(GEN x);
GEN     normalizepol(GEN x);
GEN     normalizepol_i(GEN x, long lx);
long    polvaluation(GEN x, GEN *z);
GEN     pureimag(GEN x);
long    pvaluation(GEN x, GEN p, GEN *py);
long    sizedigit(GEN x);
long    svaluation(ulong x, ulong p, ulong *py);
GEN     vecmax(GEN x);
GEN     vecmin(GEN x);

/* gen3.c */

GEN     Mod0(GEN x, GEN y,long flag);
GEN     ceil_safe(GEN x);
GEN     centerlift(GEN x);
GEN     centerlift0(GEN x,long v);
GEN     coefs_to_int(long n, ...);
GEN     coefs_to_pol(long n, ...);
GEN     compo(GEN x, long n);
GEN     deg1pol(GEN x1, GEN x0,long v);
GEN     deg1pol_i(GEN x1, GEN x0,long v);
long    degree(GEN x);
GEN     denom(GEN x);
GEN     deriv(GEN x, long v);
GEN     derivpol(GEN x);
GEN     derivser(GEN x);
GEN     diviiround(GEN x, GEN y);
GEN     divrem(GEN x, GEN y, long v);
GEN     gand(GEN x, GEN y);
GEN     gceil(GEN x);
GEN     gcvtoi(GEN x, long *e);
GEN     gdivent(GEN x, GEN y);
GEN     gdiventres(GEN x, GEN y);
GEN     gdivgs(GEN x, long s);
GEN     gdivmod(GEN x, GEN y, GEN *pr);
GEN     gdivround(GEN x, GEN y);
GEN     geq(GEN x, GEN y);
GEN     geval(GEN x);
GEN     gfloor(GEN x);
GEN     gfrac(GEN x);
GEN     gge(GEN x, GEN y);
GEN     ggprecision(GEN x);
GEN     ggt(GEN x, GEN y);
GEN     gimag(GEN x);
GEN     ginv(GEN x);
GEN     gle(GEN x, GEN y);
GEN     glt(GEN x, GEN y);
GEN     gmod(GEN x, GEN y);
GEN     gmodulcp(GEN x,GEN y);
GEN     gmodulo(GEN x,GEN y);
GEN     gmodulsg(long x, GEN y);
GEN     gmodulss(long x, long y);
GEN     gmul2n(GEN x, long n);
GEN     gmulsg(long s, GEN y);
GEN     gne(GEN x, GEN y);
GEN     gnot(GEN x);
GEN     gor(GEN x, GEN y);
GEN     gpolvar(GEN y);
long    gprecision(GEN x);
GEN     gram_matrix(GEN M);
GEN     greal(GEN x);
GEN     grndtoi(GEN x, long *e);
GEN     ground(GEN x);
GEN     gshift(GEN x, long n);
GEN     gshift3(GEN x, long n, long flag);
GEN     gsubst(GEN x, long v, GEN y);
GEN     gsubst0(GEN x, GEN v, GEN y);
GEN     gtopoly(GEN x, long v);
GEN     gtopolyrev(GEN x, long v);
GEN     gtoser(GEN x, long v);
GEN     gtovec(GEN x);
GEN     gtovecsmall(GEN x);
GEN     gtrunc(GEN x);
int     gvar(GEN x);
int     gvar2(GEN x);
int     gvar9(GEN x);
GEN     hqfeval(GEN q, GEN x);
GEN     integ(GEN x, long v);
int     iscomplex(GEN x);
int     isexactzero(GEN g);
int     isinexactreal(GEN x);
int     ismonome(GEN x);
GEN     lift(GEN x);
GEN     lift0(GEN x,long v);
GEN     lift_intern0(GEN x,long v);
GEN     mulmat_real(GEN x, GEN y);
GEN     numer(GEN x);
long    padicprec(GEN x, GEN p);
GEN     polcoeff0(GEN x,long n,long v);
GEN     polcoeff_i(GEN x, long n, long v);
long    poldegree(GEN x,long v);
GEN     poleval(GEN x, GEN y);
GEN     pollead(GEN x,long v);
long    precision(GEN x);
GEN     precision0(GEN x,long n);
GEN     qf_base_change(GEN q, GEN M, int flag);
GEN     qfeval(GEN q, GEN x);
GEN     real2n(long n, long prec);
GEN     recip(GEN x);
GEN     round0(GEN x, GEN *pte);
GEN     scalarpol(GEN x, long v);
GEN     scalarser(GEN x, long v, long prec);
GEN     simplify(GEN x);
GEN     simplify_i(GEN x);
GEN     truecoeff(GEN x, long n);
GEN     trunc0(GEN x, GEN *pte);
GEN     u2toi(ulong a, ulong b);
GEN     zeropol(long v);
GEN     zeroser(long v, long prec);

/* ifactor1.c */

long    BSW_psp(GEN N);
long    millerrabin(GEN n, long k);
GEN     nextprime(GEN n);
GEN     plisprime(GEN N, long flag);
GEN     precprime(GEN n);

/* init.c */

long    TIMER(pari_timer *T);
long    allocatemoremem(size_t newsize);
GEN     changevar(GEN x, GEN y);
void    checkmemory(GEN x);
void    disable_dbg(long val);
GEN     dummycopy(GEN x);
void    err(long numerr, ...);
void   *err_catch(long errnum, jmp_buf env, void *data);
void    err_leave(void **v);
GEN     forcecopy(GEN x);
void    freeall(void);
GEN     gcopy(GEN x);
GEN     gcopy_i(GEN x, long lx);
GEN     gerepile(gpmem_t ltop, gpmem_t lbot, GEN q);
void    gerepileall(ulong av, int n, ...);
GEN     gerepilecopy(gpmem_t av, GEN x);
void    gerepilemany(gpmem_t av, GEN* g[], int n);
void    gerepilemanycoeffs(gpmem_t av, GEN x, int n);
void    gerepilemanysp(gpmem_t av, gpmem_t tetpil, GEN* g[], int n);
void    gerepilemanyvec(gpmem_t av, gpmem_t tetpil, long *g, int n);
GEN     gerepileupto(gpmem_t av, GEN q);
GEN     gerepileuptoint(gpmem_t av, GEN q);
GEN     gerepileuptoleaf(gpmem_t av, GEN q);
char*   gpmalloc(size_t bytes);
char*   gprealloc(void *pointer,size_t size);
void    gunclone(GEN x);
void    killbloc(GEN x);
void    msgTIMER(pari_timer *T, char *format, ...);
void    msgtimer(char *format, ...);
GEN     newbloc(long n);
void    pari_init(size_t parisize, long maxprime);
GEN     reorder(GEN x);
void    stackdummy(GEN x, long l);
stackzone* switch_stack(stackzone *z, long n);
long    taille(GEN x);
long    taille2(GEN x);
long    timer(void);
long    timer2(void);

/* mp.c ou mp.s */

int     absi_cmp(GEN x, GEN y);
int     absi_equal(GEN x, GEN y);
int     absr_cmp(GEN x, GEN y);
GEN     addii(GEN x, GEN y);
GEN     addir(GEN x, GEN y);
GEN     addrr(GEN x, GEN y);
GEN     addsi(long x, GEN y);
GEN     addsr(long x, GEN y);
GEN     addss(long x, long y);
void    affir(GEN x, GEN y);
void    affrr(GEN x, GEN y);
GEN     bezout(GEN a, GEN b, GEN *u, GEN *v);
long    cbezout(long a,long b,long *uu,long *vv);
void    cgiv(GEN x);
int     cmpii(GEN x, GEN y);
int     cmprr(GEN x, GEN y);
int     cmpsi(long x, GEN y);
GEN     dbltor(double x);
GEN     diviiexact(GEN x, GEN y);
void    diviiz(GEN x, GEN y, GEN z);
GEN     divir(GEN x, GEN y);
GEN     divis(GEN y, long x);
GEN     divri(GEN x, GEN y);
GEN     divrr(GEN x, GEN y);
GEN     divrs(GEN x, long y);
GEN     divsi(long x, GEN y);
GEN     divsr(long x, GEN y);
GEN     dvmdii(GEN x, GEN y, GEN *z);
int     egalii(GEN x, GEN y);
int     invmod(GEN a, GEN b, GEN *res);
GEN     modii(GEN x, GEN y);
void    modiiz(GEN x, GEN y, GEN z);
GEN     modiu(GEN y, ulong x);
GEN     modsi(long x, GEN y);
GEN     modss(long x, long y);
GEN     modui(ulong x, GEN y);
void    mpdivz(GEN x, GEN y, GEN z);
GEN     mpent(GEN x);
GEN     mptrunc(GEN x);
GEN     mulii(GEN x, GEN y);
GEN     mulir(GEN x, GEN y);
GEN     mulrr(GEN x, GEN y);
GEN     mulsi(long x, GEN y);
GEN     mulsr(long x, GEN y);
GEN     mulss(long x, long y);
GEN     mului(ulong x, GEN y);
GEN     muluu(ulong x, ulong y);
int     ratlift(GEN x, GEN m, GEN *a, GEN *b, GEN amax, GEN bmax);
GEN     resmod2n(GEN x, long n);
GEN     resss(long x, long y);
double  rtodbl(GEN x);
GEN     shifti(GEN x, long n);
void	shift_r(ulong *target, ulong *source, ulong *source_end, ulong prepend, ulong sh);
GEN     shifti3(GEN x, long n, long flag);
long    smodsi(long x, GEN y);
GEN     sqri(GEN x);
GEN     truedvmdii(GEN x, GEN y, GEN *z);
ulong   umodiu(GEN y, ulong x);
long    vals(ulong x);

/* nffactor.c */

GEN     nffactor(GEN nf,GEN x);
GEN     nffactormod(GEN nf,GEN pol,GEN pr);
GEN     nfroots(GEN nf,GEN pol);
GEN     rnfcharpoly(GEN nf,GEN T,GEN alpha,int n);
GEN     rnfdedekind(GEN nf,GEN T,GEN pr);
GEN     unifpol(GEN nf,GEN pol,long flag);

/* perm.c */

GEN     abelian_group(GEN G);
GEN     bitvec_alloc(long n);
long    bitvec_test(GEN bitvec, long b);
void    bitvec_set(GEN bitvec, long b);
void    bitvec_clear(GEN bitvec, long b);
GEN     cyclicperm(long l, long d);
GEN     cyc_powtoperm(GEN cyc, long exp);
GEN     group_elts(GEN G, long n);
long    group_isabelian(GEN G);
GEN     group_subgroups(GEN G);
GEN     perm_cycles(GEN v);
GEN     perm_identity(long l);
GEN     perm_inv(GEN x);
GEN     perm_mul(GEN s, GEN t);
GEN     perm_pow(GEN perm, long exp);
GEN     vecperm_orbits(GEN v, long n);
GEN     vecsmall_append(GEN V, long s);
GEN     vecsmall_prepend(GEN V, long s);
GEN     vecsmall_const(long n, long c);
int     vecsmall_lexcmp(GEN x, GEN y);
int     vecsmall_prefixcmp(GEN x, GEN y);
void    vecsmall_sort(GEN V);
GEN     vecsmall_uniq(GEN V);

/* polarit1.c */

GEN     FpV_roots_to_pol(GEN V, GEN p, long v);
long    FpX_is_irred(GEN f, GEN p);
long    FpX_is_squarefree(GEN f, GEN p);
long    FpX_is_totally_split(GEN f, GEN p);
long    FpX_nbfact(GEN f, GEN p);
long    FpX_nbroots(GEN f, GEN p);
GEN     FpX_rand(long d1, long v, GEN p);
GEN     apprgen(GEN f, GEN a);
GEN     apprgen9(GEN f, GEN a);
GEN     factcantor(GEN x, GEN p);
GEN     factmod(GEN f, GEN p);
GEN     factmod0(GEN f, GEN p);
GEN     factmod9(GEN f, GEN p, GEN a);
GEN     factormod0(GEN f, GEN p,long flag);
GEN     factorpadic0(GEN f,GEN p,long r,long flag);
GEN     factorpadic2(GEN x, GEN p, long r);
GEN     factorpadic4(GEN x, GEN p, long r);
GEN     ffinit(GEN p,long n, long v);
int     gdivise(GEN x, GEN y);
long    hensel_lift_accel(long n, long *pmask);
GEN     incloop(GEN a);
GEN     mat_to_polpol(GEN x, long v,long w);
GEN     mat_to_vecpol(GEN x, long v);
GEN     padicsqrtnlift(GEN a, GEN n, GEN S, GEN p, long e);
GEN     pol_to_vec(GEN x, long N);
int     poldivis(GEN x, GEN y, GEN *z);
GEN     poldivres(GEN x, GEN y, GEN *pr);
GEN     polpol_to_mat(GEN v, long n);
GEN     rootmod(GEN f, GEN p);
GEN     rootmod0(GEN f, GEN p,long flag);
GEN     rootmod2(GEN f, GEN p);
GEN     rootpadic(GEN f, GEN p, long r);
GEN     rootpadicfast(GEN f, GEN p, long e);
GEN     rootpadiclift(GEN T, GEN S, GEN q, long e);
GEN     rootpadicliftroots(GEN f, GEN S, GEN q, long e);
GEN     roots2(GEN pol,long PREC);
GEN     rootsold(GEN x, long l);
GEN     setloop(GEN a);
GEN     simplefactmod(GEN f, GEN p);
GEN     swap_polpol(GEN x, long n, long w);
GEN     vec_to_pol(GEN x, long v);
GEN     vecpol_to_mat(GEN v, long n);

/* polarit2.c */

GEN     Q_denom(GEN x);
GEN     Q_div_to_int(GEN x, GEN c);
GEN     Q_muli_to_int(GEN x, GEN d);
GEN     Q_primitive_part(GEN x, GEN *ptc);
GEN     Q_remove_denom(GEN x, GEN *ptd);
GEN     Q_primpart(GEN x);
GEN     bezoutpol(GEN a, GEN b, GEN *u, GEN *v);
GEN     centermod(GEN x, GEN p);
GEN     centermodii(GEN x, GEN p, GEN po2);
GEN     concat_factor(GEN f, GEN g);
GEN     content(GEN x);
GEN     discsr(GEN x);
GEN     divide_conquer_prod(GEN x, GEN (*mul)(GEN,GEN));
GEN     leftright_pow(GEN,GEN,void*,GEN (*sqr)(void*,GEN),GEN (*mul)(void*,GEN,GEN));
GEN     factor(GEN x);
GEN     factor0(GEN x,long flag);
GEN     factorback(GEN fa,GEN nf);
GEN     factorback0(GEN fa,GEN e, GEN nf);
GEN     factpol(GEN x, long hint);
GEN     gbezout(GEN x, GEN y, GEN *u, GEN *v);
GEN     gcd0(GEN x, GEN y,long flag);
GEN     gdeflate(GEN x, long v, long d);
GEN     gdivexact(GEN x, GEN y);
GEN     ggcd(GEN x, GEN y);
GEN     ggcd0(GEN x, GEN y);
GEN     ginvmod(GEN x, GEN y);
GEN     gisirreducible(GEN x);
GEN     glcm(GEN x, GEN y);
GEN     glcm0(GEN x, GEN y);
long    logint(GEN B, GEN y, GEN *ptq);
GEN     newtonpoly(GEN x, GEN p);
GEN     nfisincl(GEN a, GEN b);
GEN     nfisisom(GEN a, GEN b);
GEN     poldeflate(GEN x0, long *m);
GEN     poldisc0(GEN x, long v);
GEN     polfnf(GEN a, GEN t);
GEN     polhensellift(GEN pol, GEN fct, GEN p, long exp);
GEN     polinflate(GEN x0, long d);
GEN     polresultant0(GEN x, GEN y,long v,long flag);
GEN     polsym(GEN x, long n);
GEN     primitive_part(GEN x, GEN *c);
GEN     primpart(GEN x);
GEN     pseudorem(GEN x, GEN y);
GEN     quadgen(GEN x);
GEN     quadpoly(GEN x);
GEN     quadpoly0(GEN x, long v);
GEN     reduceddiscsmith(GEN pol);
GEN     resultant2(GEN x, GEN y);
GEN     resultantducos(GEN x, GEN y);
GEN     sort_factor(GEN y, int (*cmp)(GEN,GEN));
GEN     sort_factor_gen(GEN y, int (*cmp)(GEN,GEN));
GEN     sort_vecpol(GEN a);
GEN     srgcd(GEN x, GEN y);
long    sturmpart(GEN x, GEN a, GEN b);
GEN     subresall(GEN u, GEN v, GEN *sol);
GEN     subresext(GEN x, GEN y, GEN *U, GEN *V);
GEN     sylvestermatrix(GEN x,GEN y);
GEN     vecbezout(GEN x, GEN y);
GEN     vecbezoutres(GEN x, GEN y);

/* polarit3.c */

GEN     FpM(GEN z, GEN p);
GEN     FpM_red(GEN z, GEN p);
GEN     FpV(GEN z, GEN p);
GEN     FpV_red(GEN z, GEN p);
GEN     FpX(GEN z, GEN p);
GEN     FpX_FpXQ_compo(GEN T,GEN x,GEN pol,GEN p);
GEN     FpX_FpXQV_compo(GEN T,GEN x,GEN pol,GEN p);
GEN     FpX_Fp_add(GEN y,GEN x,GEN p);
GEN     FpX_Fp_mul(GEN y,GEN x,GEN p);
GEN     FpX_add(GEN x,GEN y,GEN p);
GEN     FpX_center(GEN T,GEN mod);
GEN     FpX_chinese_coprime(GEN x,GEN y,GEN Tx,GEN Ty,GEN Tz,GEN p);
GEN     FpX_divres(GEN x, GEN y, GEN p, GEN *pr);
GEN     FpX_eval(GEN x,GEN y,GEN p);
GEN     FpX_extgcd(GEN x, GEN y, GEN p, GEN *ptu, GEN *ptv);
GEN     FpX_gcd(GEN x, GEN y, GEN p);
GEN     FpX_mul(GEN x,GEN y,GEN p);
GEN     FpX_neg(GEN x,GEN p);
GEN     FpX_normalize(GEN z, GEN p);
GEN     FpX_red(GEN z, GEN p);
GEN     FpX_small(GEN z, GEN p, long l);
GEN     FpX_sqr(GEN x,GEN p);
GEN     FpX_sub(GEN x,GEN y,GEN p);
GEN     FpXQ_charpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_div(GEN x,GEN y,GEN T,GEN p);
GEN     FpXQ_inv(GEN x,GEN pol,GEN p);
GEN     FpXQ_minpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_mul(GEN y,GEN x,GEN pol,GEN p);
GEN     FpXQ_pow(GEN x, GEN n, GEN pol, GEN p);
GEN     FpXQ_powers(GEN x, long l, GEN T, GEN p);
GEN     FpXQ_sqr(GEN y, GEN pol, GEN p);
GEN     FpXQX_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FpXQX_red(GEN z, GEN T, GEN p);
GEN     FpXQX_sqr(GEN x, GEN T, GEN p);
GEN     FpXQX_extgcd(GEN x, GEN y, GEN T, GEN p, GEN *ptu, GEN *ptv);
GEN     FpXQX_FpXQ_mul(GEN P, GEN U, GEN T, GEN p);
GEN     FpXQX_divres(GEN x, GEN y, GEN T, GEN p, GEN *pr);
GEN     FpXQX_normalize(GEN z, GEN T, GEN p);
GEN     FpXV_FpV_innerprod(GEN V, GEN W, GEN p);
GEN     FpXV_red(GEN z, GEN p);
GEN     FpXX_red(GEN z, GEN p);
GEN     FpY_FpXY_resultant(GEN a, GEN b0, GEN p);
GEN     Fp_factor_rel(GEN P, GEN l, GEN Q);
GEN     Fp_factor_rel0(GEN P, GEN l, GEN Q);
void    Fp_intersect(long n,GEN P,GEN Q,GEN l,GEN *SP,GEN *SQ,GEN MA,GEN MB);
GEN     Fp_inv_isom(GEN S,GEN Tp, GEN p);
GEN     Fp_isom(GEN P,GEN Q,GEN l);
GEN     FqV_roots_to_pol(GEN V, GEN p, GEN Tp, long v);
GEN     ZX_caract(GEN A, GEN B, long v);
GEN     ZX_disc(GEN x);
GEN     QX_invmod(GEN A, GEN B);
GEN     QX_caract(GEN A, GEN B, long v);
int     ZX_is_squarefree(GEN x);
GEN     ZX_resultant(GEN A, GEN B);
GEN     ZX_QX_resultant(GEN A, GEN B);
GEN     ZX_s_add(GEN y,long x);
long    brent_kung_optpow(long d, long n);
GEN     ffsqrtnmod(GEN a, GEN n, GEN T, GEN p, GEN *zetan);
GEN     modulargcd(GEN a,GEN b);
GEN     quickmul(GEN a, GEN b, long na, long nb);
GEN     quicksqr(GEN a, long na);
GEN     small_to_col(GEN z);
GEN     small_to_mat(GEN z);
GEN     small_to_pol(GEN z, long v);
GEN     small_to_vec(GEN z);
GEN     pol_to_small(GEN x);
ulong   powuumod(ulong x, ulong n0, ulong p);
GEN     rescale_pol(GEN P, GEN h);
GEN     unscale_pol(GEN P, GEN h);
GEN     stopoly(long m, long p, long v);
GEN     stopoly_gen(GEN m, GEN p, long v);
GEN     u_FpXQ_pow(GEN x, GEN n, GEN pol, ulong p);
GEN     u_FpX_divrem(GEN x, GEN y, ulong p, int malloc, GEN *pr);
GEN     u_FpX_rem(GEN x, GEN y, ulong p);
GEN     u_Fp_FpM(GEN x, ulong p);
GEN     u_Fp_FpV(GEN x, ulong p);
GEN     u_Fp_FpX(GEN x,int malloc, ulong p);
int     u_FpX_is_squarefree(GEN z, ulong p);
GEN     u_FpX_normalize(GEN z, ulong p);
GEN     u_FpX_sub(GEN x, GEN y, ulong p);
GEN     u_FpX_gcd(GEN a, GEN b, ulong p);
ulong   u_invmod(ulong x, ulong p);
int     u_pow(int p, int k);
int     u_val(ulong n, ulong p);

/* rootpol.c */

int     isrealappr(GEN x, long l);
GEN     roots(GEN x,long l);
GEN     roots0(GEN x,long flag,long l);

/*subcyclo.c */

GEN     galoissubcyclo(GEN N, GEN sg, long flag, long v);
GEN     polsubcyclo(long n, long d, long v);
GEN     subcyclo(long n, long d, long v);
GEN     znstar_small(GEN zn);

/* subfields.c */

GEN     subfields(GEN nf,GEN d);
GEN     subfields0(GEN nf,GEN d);
GEN     conjugates(GEN pol);

/* subgroup.c */

void    forsubgroup(entree *oep, GEN cyc, GEN bound, char *och);
GEN     subgrouplist(GEN cyc, GEN bound);

/* stark.c */

GEN     bnrL1(GEN bnr, GEN sbgrp, long flag, long prec);
GEN     bnrrootnumber(GEN bnr, GEN chi, long flag, long prec);
GEN     bnrstark(GEN bnr, GEN subgroup, long flag, long prec);

/* sumiter.c */

GEN     direulerall(entree *ep, GEN a, GEN b, char *ch, GEN c);
GEN     direuler(entree *ep, GEN a, GEN b, char *ch);
GEN     divsum(GEN num,entree *ep, char *ch);
void    fordiv(GEN a, entree *ep, char *ch);
void    forpari(entree *ep, GEN a, GEN b, char *ch);
void    forprime(entree *ep, GEN a, GEN b, char *ch);
void    forstep(entree *ep, GEN a, GEN b, GEN s, char *ch);
void    forvec(entree *ep, GEN x, char *ch, long flag);
GEN     intnum0(entree *ep, GEN a, GEN b, char *ch,long flag,long prec);
GEN     matrice(GEN nlig, GEN ncol,entree *ep1, entree *ep2, char *ch);
GEN     polzag(long n, long m);
GEN     polzagreel(long n, long m, long prec);
GEN     prodeuler(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     prodinf(entree *ep, GEN a, char *ch, long prec);
GEN     prodinf0(entree *ep, GEN a, char *ch, long flag, long prec);
GEN     prodinf1(entree *ep, GEN a, char *ch, long prec);
GEN     produit(entree *ep, GEN a, GEN b, char *ch, GEN x);
GEN     qromb(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     qromi(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     qromo(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     rombint(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     somme(entree *ep, GEN a, GEN b, char *ch, GEN x);
GEN     sumalt(entree *ep, GEN a, char *ch, long prec);
GEN     sumalt0(entree *ep, GEN a, char *ch,long flag, long prec);
GEN     sumalt2(entree *ep, GEN a, char *ch, long prec);
GEN     sumpos(entree *ep, GEN a, char *ch, long prec);
GEN     sumpos0(entree *ep, GEN a, char *ch, long flag,long prec);
GEN     sumpos2(entree *ep, GEN a, char *ch, long prec);
GEN     suminf(entree *ep, GEN a, char *ch, long prec);
GEN     vecteur(GEN nmax, entree *ep, char *ch);
GEN     vecteursmall(GEN nmax, entree *ep, char *ch);
GEN     vvecteur(GEN nmax, entree *ep, char *ch);
GEN     zbrent(entree *ep, GEN a, GEN b, char *ch, long prec);

/* thue.c */

GEN     bnfisintnorm(GEN x, GEN y);
GEN     thue(GEN thueres, GEN rhs, GEN ne);
GEN     thueinit(GEN poly, long flag, long prec);

/* trans1.c */

GEN     Pi2n(long n, long prec);
GEN     PiI2(long prec);
GEN     PiI2n(long n, long prec);
void    consteuler(long prec);
void    constpi(long prec);
GEN     exp_Ir(GEN x);
GEN     gcos(GEN x, long prec);
void    gcosz(GEN x, GEN y);
GEN     gcotan(GEN x, long prec);
GEN     gexp(GEN x, long prec);
void    gexpz(GEN x, GEN y);
GEN     glog(GEN x, long prec);
void    glogz(GEN x, GEN y);
GEN     gpow(GEN x, GEN n, long prec);
GEN     gpowgs(GEN x, long n);
GEN     gsin(GEN x, long prec);
void    gsincos(GEN x, GEN *s, GEN *c, long prec);
void    gsinz(GEN x, GEN y);
GEN     gsqrt(GEN x, long prec);
void    gsqrtz(GEN x, GEN y);
GEN     gsqrtn(GEN x, GEN n, GEN *zetan, long prec);
GEN     gtan(GEN x, long prec);
void    gtanz(GEN x, GEN y);
GEN     log0(GEN x,long flag, long prec);
GEN     mpeuler(long prec);
GEN     mpexp(GEN x);
GEN     mpexp1(GEN x);
GEN     mplog(GEN x);
GEN     mplog2(long prec);
GEN     mppi(long prec);
GEN     mpsqrt(GEN x);
GEN     padiczero(GEN p, long e);
GEN     palog(GEN x);
GEN     powgi(GEN x, GEN n);
GEN     teich(GEN x);
GEN     transc(GEN (*f) (GEN, long), GEN x, long prec);

/* trans2.c */

GEN     bernfrac(long n);
GEN     bernreal(long n, long prec);
GEN     bernvec(long nomb);
GEN     gach(GEN x, long prec);
void    gachz(GEN x, GEN y);
GEN     gacos(GEN x, long prec);
void    gacosz(GEN x, GEN y);
GEN     garg(GEN x, long prec);
GEN     gash(GEN x, long prec);
void    gashz(GEN x, GEN y);
GEN     gasin(GEN x, long prec);
void    gasinz(GEN x, GEN y);
GEN     gatan(GEN x, long prec);
void    gatanz(GEN x, GEN y);
GEN     gath(GEN x, long prec);
void    gathz(GEN x, GEN y);
GEN     gch(GEN x, long prec);
void    gchz(GEN x, GEN y);
GEN     ggamd(GEN x, long prec);
void    ggamdz(GEN x, GEN y);
GEN     ggamma(GEN x, long prec);
void    ggammaz(GEN x, GEN y);
GEN     glngamma(GEN x, long prec);
void    glngammaz(GEN x, GEN y);
GEN     gpsi(GEN x, long prec);
void    gpsiz(GEN x, GEN y);
GEN     gsh(GEN x, long prec);
void    gshz(GEN x, GEN y);
GEN     gth(GEN x, long prec);
void    gthz(GEN x, GEN y);
void    mpbern(long nomb, long prec);
void    mpgamdz(long s, GEN y);

/* trans3.c */

GEN     agm(GEN x, GEN y, long prec);
GEN     cgetc(long l);
GEN     dilog(GEN x, long prec);
GEN     eint1(GEN x, long prec);
GEN     eta(GEN x, long prec);
GEN     eta0(GEN x, long flag,long prec);
GEN     gerfc(GEN x, long prec);
GEN     glogagm(GEN x, long prec);
GEN     gpolylog(long m, GEN x, long prec);
void    gpolylogz(long m, GEN x, GEN y);
GEN     gzeta(GEN x, long prec);
void    gzetaz(GEN x, GEN y);
GEN     hyperu(GEN a, GEN b, GEN gx, long prec);
GEN     incgam(GEN a, GEN x, long prec);
GEN     incgam0(GEN a, GEN x, GEN z,long prec);
GEN     incgam1(GEN a, GEN x, long prec);
GEN     incgam2(GEN a, GEN x, long prec);
GEN     incgam3(GEN a, GEN x, long prec);
GEN     incgam4(GEN a, GEN x, GEN z, long prec);
GEN     hbessel1(GEN n, GEN z, long prec);
GEN     hbessel2(GEN n, GEN z, long prec);
GEN     ibessel(GEN n, GEN z, long prec);
GEN     jbessel(GEN n, GEN z, long prec);
GEN     jbesselh(GEN n, GEN z, long prec);
GEN     nbessel(GEN n, GEN z, long prec);
GEN     jell(GEN x, long prec);
GEN     kbessel(GEN nu, GEN gx, long prec);
GEN     kbessel0(GEN nu, GEN gx, long flag,long prec);
GEN     kbessel2(GEN nu, GEN x, long prec);
GEN     logagm(GEN q);
GEN     polylog(long m, GEN x, long prec);
GEN     polylog0(long m, GEN x, long flag, long prec);
GEN     polylogd(long m, GEN x, long prec);
GEN     polylogdold(long m, GEN x, long prec);
GEN     polylogp(long m, GEN x, long prec);
GEN     theta(GEN q, GEN z, long prec);
GEN     thetanullk(GEN q, long k, long prec);
GEN     trueeta(GEN x, long prec);
GEN     veceint1(GEN nmax, GEN C, long prec);
GEN     weber0(GEN x, long flag,long prec);
GEN     wf(GEN x, long prec);
GEN     wf2(GEN x, long prec);
ENDEXTERN
