/* $Id: helpmsg.c,v 1.44 2002/05/15 17:23:45 karim Exp $

Copyright (C) 2000  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

char *helpmessages_basic[]={
  "Euler=Euler(): Euler's constant with current precision",
  "I=I(): square root of -1",
  "List({x=[]}): transforms the vector or list x into a list. Empty list if x is omitted",
  "Mat({x=[]}): transforms any GEN x into a matrix. Empty matrix if x is omitted",
  "Mod(x,y,{flag=0}): creates the object x modulo y. flag is optional, and can be 0: default, creates on the Pari stack, or 1: creates a permanent object on the heap",
  "O(a^b): p-adic or power series zero with precision given by b",
  "Pi=Pi(): the constant pi, with current precision",
  "Pol(x,{v=x}): convert x (usually a vector or a power series) into a polynomial with variable v, starting with the leading coefficient",
  "Polrev(x,{v=x}): convert x (usually a vector or a power series) into a polynomial with variable v, starting with the constant term",
  "Qfb(a,b,c,{D=0.}): binary quadratic form a*x^2+b*x*y+c*y^2. D is optional (0.0 by default) and initializes Shanks's distance if b^2-4*a*c>0",
  "Ser(x,{v=x}): convert x (usually a vector) into a power series with variable v, starting with the constant coefficient",
  "Set({x=[]}): convert x into a set, i.e. a row vector with strictly increasing coefficients. Empty set if x is omitted",
  "Str({x=\"\"},{flag=0}): transforms any GEN x into a string. Empty string if x is omitted. If flag is set, perform tilde expansion on string",
  "Vec({x=[]}): transforms the object x into a vector. Used mainly if x is a polynomial or a power series. Empty vector if x is omitted",
  "Vecsmall({x=[]}): transforms the object x into a VECSMALL. Empty vector if x is omitted",
  "abs(x): absolute value (or modulus) of x",
  "acos(x): inverse cosine of x",
  "acosh(x): inverse hyperbolic cosine of x",
  "addprimes({x=[]}): add primes in the vector x (with at most 100 components) to the prime table. x may also be a single integer. The \"primes\" may in fact be composite, obtained for example by the function factor(x,0), and in that case the message \"impossible inverse modulo\" will give you some factors. List the current extra primes if x is omitted. If some primes are added which divide non trivially the existing table, suitable updating is done",
  "agm(x,y): arithmetic-geometric mean of x and y",
  "algdep(x,n,{flag=0}): algebraic relations up to degree n of x. flag is optional, and can be 0: default, uses the algorithm of Hastad et al, or non-zero, and in that case is a number of decimal digits which should be between 0.5 and 1.0 times the number of decimal digits of accuracy of x, and uses a standard LLL",
  "alias(\"new\",\"old\"): new is now an alias for old",
  "arg(x): argument of x,such that -pi<arg(x)<=pi",
  "asin(x): inverse sine of x",
  "asinh(x): inverse hyperbolic sine of x",
  "atan(x): inverse tangent of x",
  "atanh(x): inverse hyperbolic tangent of x",
  "bernfrac(x): Bernoulli number B_x, as a rational number",
  "bernreal(x): Bernoulli number B_x, as a real number with the current precision",
  "bernvec(x): Vector of rational Bernoulli numbers B_0, B_2,...up to B_(2x)",
  "besselh1(nu,x): H^1-bessel function of index nu and argument x",
  "besselh2(nu,x): H^2-bessel function of index nu and argument x",
  "besseli(nu,x): I-bessel function of index nu and argument x",
  "besselj(nu,x): J-bessel function of index nu and argument x",  
  "besseljh(n,x): J-bessel function of index n+1/2 and argument x, where n is a non-negative integer",
  "besselk(nu,x,{flag=0}): K-bessel function of index nu and argument x (x positive real of type real, nu of any scalar type). flag is optional, and may be set to 0: default; 1: use hyperu",
  "besseln(nu,x): N-bessel function of index nu and argument x",  
  "bestappr(x,k): gives the best approximation to the real x with denominator less or equal to k",
  "bezout(x,y):  gives a 3-dimensional row vector [u,v,d] such that d=gcd(x,y) and u*x+v*y=d",
  "bezoutres(x,y):  gives a 3-dimensional row vector [u,v,d] such that d=resultant(x,y) and u*x+v*y=d, where x and y are polynomials",
  "bigomega(x): number of prime divisors of x, counted with multiplicity",
  "binary(x): gives the vector formed by the binary digits of x (x integer)",
  "binomial(x,y): binomial coefficient x*(x-1)...*(x-y+1)/y! defined for y in Z and any x",
  "bitand(x,y): bitwise \"and\" of two integers x and y.  Negative numbers behave as if modulo big power of 2",
  "bitneg(x,{n=-1}): bitwise negation of an integers x truncated to n bits.  n=-1 means represent infinite sequences of bit 1 as negative numbers.  Negative numbers behave as if modulo big power of 2",
  "bitnegimply(x,y): bitwise \"negated imply\" of two integers x and y, in other words, x BITAND BITNEG(y).  Negative numbers behave as if modulo big power of 2",
  "bitor(x,y): bitwise \"or\" of two integers x and y.  Negative numbers behave as if modulo big power of 2",
  "bittest(x,n,{c=1}): extracts |c| bits starting from  number n (coefficient of 2^n) of the integer x, returning the bits as an integer bitmap; negative c means: treat negative values of x as if modulo big power of 2; bits at negative offsets are zeros",
  "bitxor(x,y): bitwise \"exclusive or\" of two integers x and y.  Negative numbers behave as if modulo big power of 2",
  "bnfcertify(bnf): certify the correctness (i.e. remove the GRH) of the bnf data output by bnfclassunit or bnfinit",
  "bnfclassunit(P,{flag=0},{tech=[]}): compute the class group, regulator of the number field defined by the polynomial P, and also the fundamental units if they are not too large. flag and tech are both optional. flag can be any of 0: default, 1: insist on having fundamental units, 2: do not compute units. See manual for details about tech. P may also be a non-zero integer, and is then considered as the discriminant of a quadratic order",
  "bnfclgp(P,{tech=[]}): compute the class group of the number field defined by the polynomial P. If P is a non-zero integer, it is interpreted as a quadratic discriminant. See manual for details about tech",
  "bnfdecodemodule(nf,fa): given a coded module fa as in bnrdisclist, gives the true module",
  "bnfinit(P,{flag=0},{tech=[]}): compute the necessary data for future use in ideal and unit group computations, including fundamental units if they are not too large. flag and tech are both optional. flag can be any of 0: default, 1: insist on having fundamental units, 2: do not compute units, 3: small bnfinit, which can be converted to a big one using bnfmake. See manual for details about tech",
  "bnfisintnorm(bnf,x): compute a complete system of solutions (modulo units of positive norm) of the absolute norm equation N(a)=x, where a belongs to the maximal order of big number field bnf (if bnf is not certified, this depends on GRH)",
  "bnfisnorm(bnf,x,{flag=1}): Tries to tell whether x (in Q) is the norm of some fractional y (in bnf). Returns a vector [a,b] where x=Norm(a)*b. Looks for a solution which is a S-unit, with S a certain list of primes (in bnf) containing (among others) all primes dividing x. If bnf is known to be Galois, set flag=0 (in this case, x is a norm iff b=1). If flag is non zero the program adds to S all the primes : dividing flag if flag<0, or less than flag if flag>0. The answer is guaranteed (i.e x norm iff b=1) under GRH, if S contains all primes less than 12.log(disc(Bnf))^2, where Bnf is the Galois closure of bnf",
  "bnfisprincipal(bnf,x,{flag=1}): bnf being output by bnfinit (with flag<=2), gives [v,alpha,bitaccuracy], where v is the vector of exponents on the class group generators and alpha is the generator of the resulting principal ideal. In particular x is principal if and only if v is the zero vector. flag is optional, whose meaning is: 0: output only v; 1: default; 2: output only v, precision being doubled until the result is obtained; 3: as 2 but output generators",
  "bnfissunit(bnf,sfu,x): bnf being output by bnfinit (with flag<=2), sfu by bnfsunit, gives the column vector of exponents of x on the fundamental S-units and the roots of unity if x is a unit, the empty vector otherwise",
  "bnfisunit(bnf,x): bnf being output by bnfinit (with flag<=2), gives the column vector of exponents of x on the fundamental units and the roots of unity if x is a unit, the empty vector otherwise",
  "bnfmake(sbnf): transforms small sbnf as output by bnfinit with flag=3 into a true big bnf",
  "bnfnarrow(bnf): given a big number field as output by bnfinit, gives as a 3-component vector the structure of the narrow class group",
  "bnfreg(P,{tech=[]}): compute the regulator of the number field defined by the polynomial P. If P is a non-zero integer, it is interpreted as a quadratic discriminant. See manual for details about tech",
  "bnfsignunit(bnf): matrix of signs of the real embeddings of the system of fundamental units found by bnfinit",
  "bnfsunit(bnf,S): compute the fundamental S-units of the number field bnf output by bnfinit, S being a list of prime ideals. res[1] contains the S-units, res[5] the S-classgroup. See manual for details",
  "bnfunit(bnf): compute the fundamental units of the number field bnf output by bnfinit when they have not yet been computed (i.e. with flag=2)",
  "bnrL1(bnr, {subgroup}, {flag=0}): bnr being output by bnrinit(,,1) and subgroup being a square matrix defining a congruence subgroup of bnr (the trivial subgroup if omitted), for each character of bnr trivial on this subgroup, compute L(1, chi) (or equivalently the first non-zero term c(chi) of the expansion at s = 0). The binary digits of flag mean 1: if 0 then compute the term c(chi) and return [r(chi), c(chi)] where r(chi) is the order of L(s, chi) at s = 0, or if 1 then compute the value at s = 1 (and in this case, only for non-trivial characters), 2: if 0 then compute the value of the primitive L-function associated to chi, if 1 then compute the value of the L-function L_S(s, chi) where S is the set of places dividing the modulus of bnr (and the infinite places), 3: return also the characters",
  "bnrclass(bnf,ideal,{flag=0}): given a big number field as output by bnfinit (only) and an ideal or a 2-component row vector formed by an ideal and a list of R1 zeros or ones representing a module, finds the ray class group structure corresponding to this module. flag is optional, and can be 0: default, 1: compute data necessary for working in the ray class group, for example with functions such as bnrisprincipal or bnrdisc, without computing the generators of the ray class group, or 2: with the generators. When flag=1 or 2, the fifth component is the ray class group structure obtained when flag=0",
  "bnrclassno(bnf,x): ray class number of the module x for the big number field bnf. Faster than bnrclass if only the ray class number is wanted",
  "bnrclassnolist(bnf,list): if list is as output by ideallist or similar, gives list of corresponding ray class numbers",
  "bnrconductor(a1,{a2},{a3},{flag=0}): conductor of the subfield of the ray class field given by a1,a2,a3 (see bnrdisc). flag is optional and can be 0: default, or nonzero positive: returns [conductor,rayclassgroup,subgroup], or nonzero negative: returns 1 if modulus is the conductor and 0 otherwise (same as bnrisconductor)",
  "bnrconductorofchar(bnr,chi): conductor of the character chi on the ray class group bnr",
  "bnrdisc(a1,{a2},{a3},{flag=0}): absolute or relative [N,R1,discf] of the field defined by a1,a2,a3. [a1,{a2},{a3}] is of type [bnr], [bnr,subgroup], [bnf, module] or [bnf,module,subgroup], where bnf is as output by bnfclassunit (with flag<=2), bnr by bnrclass (with flag>0), and subgroup is the HNF matrix of a subgroup of the corresponding ray class group (if omitted, the trivial subgroup). flag is optional whose binary digits mean 1: give relative data; 2: return 0 if module is not the conductor",
  "bnrdisclist(bnf,bound,{arch},{flag=0}): gives list of discriminants of ray class fields of all conductors up to norm bound, where the ramified Archimedean places are given by arch (unramified at infinity if arch is void), in a long vector format. If (optional) flag is present and non-null, give arch all the possible values. Supports the alternative syntax bnrdisclist(bnf,list), where list is as output by ideallist or ideallistarch (with units)",
  "bnrinit(bnf,ideal,{flag=0}): given a big number field as output by bnfinit (only) and an ideal or a 2-component row vector formed by an ideal and a list of R1 zeros or ones representing a module, initializes data linked to the ray class group structure corresponding to this module. flag is optional, and can be 0: default (same as bnrclass with flag = 1), 1: compute also the generators (same as bnrclass with flag = 2). The fifth component is the ray class group structure",
  "bnrisconductor(a1,{a2},{a3}): returns 1 if the modulus is the conductor of the subfield of the ray class field given by a1,a2,a3 (see bnrdisc), and 0 otherwise. Slightly faster than bnrconductor if this is the only desired result",
  "bnrisprincipal(bnr,x,{flag=1}): bnr being output by bnrinit, gives [v,alpha,bitaccuracy], where v is the vector of exponents on the class group generators and alpha is the generator of the resulting principal ideal. In particular x is principal if and only if v is the zero vector. If (optional) flag is set to 0, output only v",
  "bnrrootnumber(bnr,chi,{flag=0}); returns the so-called Artin Root Number, i.e. the constant W appearing in the functional equation of the Hecke L-function associated to chi. Set flag = 1 if the character is known to be primitive",
  "bnrstark(bnr,{subgroup},{flag=0}): bnr being as output by bnrinit(,,1), finds a relative equation for the class field corresponding to the module in bnr and the given congruence subgroup (the trivial subgroup if omitted) using Stark's units. The ground field and the class field must be totally real. flag is optional and may be set to 0 to obtain a reduced polynomial, 1 to obtain a non reduced polynomial, 2 to obtain an absolute polynomial and 3 to obtain the irreducible polynomial of the Stark unit, 0 being default. If 4 is added to the value of flag, try hard to find the best modulus",
  "break({n=1}): interrupt execution of current instruction sequence, and exit from the n innermost enclosing loops",
  "ceil(x): ceiling of x=smallest integer>=x",
  "centerlift(x,{v}): centered lift of x. Same as lift except for integermods",
  "changevar(x,y): change variables of x according to the vector y",
  "charpoly(A,{v=x},{flag=0}): det(v*Id-A)=characteristic polynomial of the matrix A using the comatrix. flag is optional and may be set to 1 (use Lagrange interpolation) or 2 (use Hessenberg form), 0 being the default",
  "chinese(x,{y}): x,y being integers modulo mx and my, finds z such that z is congruent to x mod mx and y mod my",
  "component(x,s): the s'th component of the internal representation of x. For vectors or matrices, it is simpler to use x[]. For list objects such as nf, bnf, bnr or ell, it is much easier to use member functions starting with \".\" ",
  "concat(x,{y}): concatenation of x and y, which can be scalars, vectors or matrices, or lists (in this last case, both x and y have to be lists). If y is omitted, x has to be a list or row vector and its elements are concatenated",
  "conj(x): the algebraic conjugate of x",
  "conjvec(x): conjugate vector of the algebraic number x",
  "content(x): gcd of all the components of x, when this makes sense",
  "contfrac(x,{b},{lmax}): continued fraction expansion of x (x rational,real or rational function). b and lmax are both optional, where b is the vector of numerators of the continued fraction, and lmax is a bound for the number of terms in the continued fraction expansion",
  "contfracpnqn(x): [p_n,p_{n-1}; q_n,q_{n-1}] corresponding to the continued fraction x",
  "core(n,{flag=0}): unique (positive of negative) squarefree integer d dividing n such that n/d is a square. If (optional) flag is non-null, output the two-component row vector [d,f], where d is the unique squarefree integer dividing n such that n/d=f^2 is a square",
  "coredisc(n,{flag=0}): discriminant of the quadratic field Q(sqrt(n)). If (optional) flag is non-null, output a two-component row vector [d,f], where d is the discriminant of the quadratic field Q(sqrt(n)) and n=df^2. f may be a half integer",
  "cos(x): cosine of x",
  "cosh(x): hyperbolic cosine of x",
  "cotan(x): cotangent of x",
  "denominator(x): denominator of x (or lowest common denominator in case of an array)",
  "deriv(x,{y}): derivative of x with respect to the main variable of y, or to the main variable of x if y is omitted",
  "dilog(x): dilogarithm of x",
  "dirdiv(x,y): division of the Dirichlet series x by the Dirichlet series y",
  "direuler(p=a,b,expr,{c}): Dirichlet Euler product of expression expr from p=a to p=b, limited to b terms. Expr should be a polynomial or rational function in p and X, and X is understood to mean p^(-s). If c is present, output only the first c terms",
  "dirmul(x,y): multiplication of the Dirichlet series x by the Dirichlet series y",
  "dirzetak(nf,b): Dirichlet series of the Dedekind zeta function of the number field nf up to the bound b-1",
  "divisors(x): gives a vector formed by the divisors of x in increasing order",
  "divrem(x,y,{v}): euclidean division of x by y giving as a 2-dimensional column vector the quotient and the remainder, with respect to v (to main variable if v is omitted)",
  "eint1(x,{n}): exponential integral E1(x). If n is present, computes the vector of the first n values of the exponential integral E1(n.x) (x > 0)",
  "elladd(e,z1,z2): sum of the points z1 and z2 on elliptic curve e",
  "ellak(e,n): computes the n-th Fourier coefficient of the L-function of the elliptic curve e",
  "ellan(e,n): computes the first n Fourier coefficients of the L-function of the elliptic curve e (n<2^24 on a 32-bit machine)",
  "ellap(e,p,{flag=0}): computes a_p for the elliptic curve e using Shanks-Mestre's method. flag is optional and can be set to 0 (default) or 1 (use Jacobi symbols)",
  "ellbil(e,z1,z2): canonical bilinear form for the points z1,z2 on the elliptic curve e. Either z1 or z2 can also be a vector/matrix of points",
  "ellchangecurve(x,y): change data on elliptic curve according to y=[u,r,s,t]",
  "ellchangepoint(x,y): change data on point or vector of points x on an elliptic curve according to y=[u,r,s,t]",
  "elleisnum(om,k,{flag=0}): om=[om1,om2] being a 2-component vector giving a basis of a lattice L and k an even positive integer, computes the numerical value of the Eisenstein series of weight k. When flag is non-zero and k=4 or 6, this gives g2 or g3 with the correct normalization",
  "elleta(om): om=[om1,om2], returns the two-component row vector [eta1,eta2] of quasi-periods associated to [om1,om2]",
  "ellglobalred(e): e being an elliptic curve, returns [N,[u,r,s,t],c], where N is the conductor of e, [u,r,s,t] leads to the standard model for e, and c is the product of the local Tamagawa numbers c_p",
  "ellheight(e,x,{flag=0}): canonical height of point x on elliptic curve E defined by the vector e. flag is optional and should be 0 or 1 (0 by default): 0: use theta-functions, 1: use Tate's method",
  "ellheightmatrix(e,x): gives the height matrix for vector of points x on elliptic curve e using theta functions",
  "ellinit(x,{flag=0}): x being the vector [a1,a2,a3,a4,a6], gives the vector: [a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j,[e1,e2,e3],w1,w2,eta1,eta2,area]. If the curve is defined over a p-adic field, the last six components are replaced by root,u^2,u,q,w,0. If optional flag is 1, omit them altogether",
  "ellisoncurve(e,x): true(1) if x is on elliptic curve e, false(0) if not",
  "ellj(x): elliptic j invariant of x",
  "elllocalred(e,p):  e being an elliptic curve, returns [f,kod,[u,r,s,t],c], where f is the conductor's exponent, kod is the kodaira type for e at p, [u,r,s,t] is the change of variable needed to make e minimal at p, and c is the local Tamagawa number c_p",
  "elllseries(e,s,{A=1}): L-series at s of the elliptic curve e, where A a cut-off point close to 1",
  "ellminimalmodel(e,{&v}): return the standard minimal integral model of the rational elliptic curve e. Sets v to the corresponding change of variables",
  "ellorder(e,p): order of the point p on the elliptic curve e over Q, 0 if non-torsion",
  "ellordinate(e,x): y-coordinates corresponding to x-ordinate x on elliptic curve e",
  "ellpointtoz(e,P): lattice point z corresponding to the point P on the elliptic curve e",
  "ellpow(e,x,n): n times the point x on elliptic curve e (n in Z)",
  "ellrootno(e,{p=1}): root number for the L-function of the elliptic curve e. p can be 1 (default), global root number, or a prime p (including 0) for the local root number at p",
  "ellsigma(om,z,{flag=0}): om=[om1,om2], value of the Weierstrass sigma function of the lattice generated by om at z if flag = 0 (default). If flag = 1, arbitrary determination of the logarithm of sigma. If flag = 2 or 3, same but using the product expansion instead of theta series",
  "ellsub(e,z1,z2): difference of the points z1 and z2 on elliptic curve e",
  "elltaniyama(e): modular parametrization of elliptic curve e",
  "elltors(e,{flag=0}): torsion subgroup of elliptic curve e: order, structure, generators. If flag = 0, use Doud's algorithm; if flag = 1, use Lutz-Nagell",
  "ellwp(e,{z=x},{flag=0}): Complex value of Weierstrass P function at z on the lattice generated over Z by e=[om1,om2] (e as given by ellinit is also accepted). Optional flag means 0 (default), compute only P(z), 1 compute [P(z),P'(z)], 2 consider om as an elliptic curve and compute P(z) for that curve (identical to ellztopoint in that case). If z is omitted or is a simple variable, return formal expansion in z",
  "ellzeta(om,z): om=[om1,om2], value of the Weierstrass zeta function of the lattice generated by om at z",
  "ellztopoint(e,z): coordinates of point P on the curve e corresponding to the complex number z",
  "erfc(x): complementary error function",
  "eta(x,{flag=0}): if flag=0, eta function without the q^(1/24), otherwise eta of the complex number x in the upper half plane intelligently computed using SL(2,Z) transformations",
  "eulerphi(x): Euler's totient function of x",
  "eval(x): evaluation of x, replacing variables by their value",
  "exp(x): exponential of x",
  "factor(x,{lim}): factorization of x. lim is optional and can be set whenever x is of (possibly recursive) rational type. If lim is set return partial factorization, using primes up to lim (up to primelimit if lim=0)",
  "factorback(fa,{nf}): given a factorisation fa, gives the factored object back. If this is a prime ideal factorisation you must supply the corresponding number field as second argument",
  "factorcantor(x,p): factorization mod p of the polynomial x using Cantor-Zassenhaus",
  "factorff(x,p,a): factorization of the polynomial x in the finite field F_p[X]/a(X)F_p[X]",
  "factorial(x): factorial of x (x C-integer), the result being given as a real number",
  "factorint(x,{flag=0}): factor the integer x. flag is optional, whose binary digits mean 1: avoid MPQS, 2: avoid first-stage ECM (may fall back on it later),  4: avoid Pollard-Brent Rho and Shanks SQUFOF, 8: skip final ECM (huge composites will be declared prime)",
  "factormod(x,p,{flag=0}): factorization mod p of the polynomial x using Berlekamp. flag is optional, and can be 0: default or 1: simple factormod, same except that only the degrees of the irreducible factors are given",
  "factornf(x,t): factorization of the polynomial x over the number field defined by the polynomial t",
  "factorpadic(x,p,r,{flag=0}): p-adic factorization of the polynomial x to precision r. flag is optional and may be set to 0 (use round 4) or 1 (use Buchmann-Lenstra)",
  "ffinit(p,n,{v=x}): monic irreducible polynomial of degree n over F_p[v]",
  "fibonacci(x): fibonacci number of index x (x C-integer)",
  "floor(x): floor of x = largest integer<=x",
  "for(X=a,b,seq): the sequence is evaluated, X going from a up to b",
  "fordiv(n,X,seq): the sequence is evaluated, X running over the divisors of n",
  "forprime(X=a,b,seq): the sequence is evaluated, X running over the primes between a and b",
  "forstep(X=a,b,s,seq): the sequence is evaluated, X going from a to b in steps of s (can be a vector of steps)",
  "forsubgroup(H=G,{bound},seq): execute seq for each subgroup H of the abelian group G (in SNF form), whose index is bounded by bound. H is given as a left divisor of G in HNF form",
  "forvec(x=v,seq,{flag=0}): v being a vector of two-component vectors of length n, the sequence is evaluated with x[i] going from v[i][1] to v[i][2] for i=n,..,1 if flag is zero or omitted. If flag = 1 (resp. flag = 2), restrict to increasing (resp. strictly increasing) sequences",
  "frac(x): fractional part of x = x-floor(x)",
  "galoisfixedfield(gal,perm,{flag},{v=y}): gal being a galois field as output by galoisinit and perm an element of gal.group or a vector of such elements, return [P,x] such that P is a polynomial defining the fixed field of gal[1] by the subgroup generated by perm, and x is a root of P in gal expressed as a polmod in gal.pol. If flag is 1 return only P. If flag is 2 return [P,x,F] where F is the factorization of gal.pol over the field defined by P, where the variable v stands for a root of P",
  "galoisinit(pol,{den}): pol being a polynomial or a number field as output by nfinit defining a Galois extension of Q, compute the Galois group and all neccessary informations for computing fixed fields. den is optional and has the same meaning as in nfgaloisconj(,4)(see manual)",
  "galoisisabelian(gal,{flag=0}): gal being as output by galoisinit, return 0 if gal is not abelian, and the HNF matrix of gal over gal.gen if flag=0, 1 if flag is 1",
  "galoispermtopol(gal,perm): gal being a galois field as output by galoisinit and perm a element of gal.group, return the polynomial defining the corresponding Galois automorphism",
  "galoissubcyclo(N,H,{fl=0},{v}):Compute a polynomial (in variable v) defining the subfield of Q(zeta_n) fixed by the subgroup H of (Z/nZ)*. N can be an integer n, znstar(n) or bnrinit(bnfinit(y),[n,[1]],1). H can be given by a generator, a set of generator given by a vector or a HNF matrix (see manual). If flag is 1, output only the conductor of the abelian extension. If flag is 2 output [pol,f] where pol is the polynomial and f the conductor.",
  "galoissubfields(G,{flags=0},{v}):Output all the subfields of G. flags have the same meaning as for galoisfixedfield",
  "galoissubgroups(G):Output all the subgroups of G",
  "gamma(x): gamma function at x",
  "gammah(x): gamma of x+1/2 (x integer)",
  "gcd(x,{y},{flag=0}): greatest common divisor of x and y. flag is optional, and can be 0: default, 1: use the modular gcd algorithm (x and y must be polynomials), 2 use the subresultant algorithm (x and y must be polynomials)",
  "getheap(): 2-component vector giving the current number of objects in the heap and the space they occupy",
  "getrand(): current value of random number seed",
  "getstack(): current value of stack pointer avma",
  "gettime(): time (in milliseconds) since last call to gettime",
  "hilbert(x,y,{p}): Hilbert symbol at p of x,y. If x,y are integermods or p-adic, p can be omitted",
  "hyperu(a,b,x): U-confluent hypergeometric function",
  "idealadd(nf,x,y): sum of two ideals x and y in the number field defined by nf",
  "idealaddtoone(nf,x,{y}): if y is omitted, when the sum of the ideals in the number field K defined by nf and given in the vector x is equal to Z_K, gives a vector of elements of the corresponding ideals who sum to 1. Otherwise, x and y are ideals, and if they sum up to 1, find one element in each of them such that the sum is 1",
  "idealappr(nf,x,{flag=0}): x being a fractional ideal, gives an element b such that v_p(b)=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p. If (optional) flag is non-null x must be a prime ideal factorization with possibly zero exponents",
  "idealchinese(nf,x,y): x being a prime ideal factorization and y a vector of elements, gives an element b such that v_p(b-y_p)>=v_p(x) for all prime ideals p dividing x, and v_p(b)>=0 for all other p",
  "idealcoprime(nf,x,y): gives an element b in nf such that b. x is an integral ideal coprime to the integral ideal y",
  "idealdiv(nf,x,y,{flag=0}): quotient x/y of two ideals x and y in HNF in the number field nf. If (optional) flag is non-null, the quotient is supposed to be an integral ideal (slightly faster)",
  "idealfactor(nf,x): factorization of the ideal x given in HNF into prime ideals in the number field nf",
  "idealhnf(nf,a,{b}): hermite normal form of the ideal a in the number field nf, whatever form a may have. If called as idealhnf(nf,a,b), the ideal is given as aZ_K+bZ_K in the number field K defined by nf",
  "idealintersect(nf,x,y): intersection of two ideals x and y in the number field defined by nf",
  "idealinv(nf,x,{flag=0}): inverse of the ideal x in the number field nf. If flag is omitted or set to 0, use the different. If flag is 1 do not use it",
  "ideallist(nf,bound,{flag=4}): vector of vectors L of all idealstar of all ideals of norm<=bound. If (optional) flag is present, its binary digits are toggles meaning 1: give generators; 2: output [L,U], where L is as before, and U is a vector of vector of zinternallogs of the units; 4: give only the ideals and not the idealstar",
  "ideallistarch(nf,list,{arch=[]},{flag=0}): vector of vectors of all idealstarinit of all modules in list with archimedean arch (void if ommited or arch=[]) added. flag is optional whose binary digits are toggles meaning 1: give generators as well; 2: list format is [L,U], see ideallist",
  "ideallog(nf,x,bid): if bid is a big ideal, as given by idealstar(nf,I,1) or idealstar(nf,I,2), gives the vector of exponents on the generators bid[2][3] (even if these generators have not been computed)",
  "idealmin(nf,ix,{vdir}): minimum of the ideal ix in the direction vdir in the number field nf",
  "idealmul(nf,x,y,{flag=0}): product of the two ideals x and y in the number field nf. If (optional) flag is non-nul, reduce the result",
  "idealnorm(nf,x): norm of the ideal x in the number field nf",
  "idealpow(nf,x,n,{flag=0}): n-th power of the ideal x in HNF in the number field nf If (optional) flag is non-null, reduce the result",
  "idealprimedec(nf,p): prime ideal decomposition of the prime number p in the number field nf as a vector of 5 component vectors [p,a,e,f,b] representing the prime ideals pZ_K+a. Z_K, e,f as usual, a as vector of components on the integral basis, b Lenstra's constant",
  "idealprincipal(nf,x): returns the principal ideal generated by the algebraic number x in the number field nf",
  "idealred(nf,x,{vdir=0}): LLL reduction of the ideal x in the number field nf along direction vdir, in HNF",
  "idealstar(nf,I,{flag=1}): gives the structure of (Z_K/I)^*. flag is optional, and can be 0: simply gives the structure as a 3-component vector v such that v[1] is the order (i.e. eulerphi(I)), v[2] is a vector of cyclic components, and v[3] is a vector giving the corresponding generators. If flag=1 (default), gives idealstarinit, i.e. a 6-component vector [I,v,fa,f2,U,V] where v is as above without the generators, fa is the prime ideal factorisation of I and f2, U and V are technical but essential to work in (Z_K/I)^*. Finally if flag=2, same as with flag=1 except that the generators are also given",
  "idealtwoelt(nf,x,{a}): two-element representation of an ideal x in the number field nf. If (optional) a is non-zero, first element will be equal to a",
  "idealval(nf,x,p): valuation at p given in idealprimedec format of the ideal x in the number field nf",
  "ideleprincipal(nf,x): returns the principal idele generated by the algebraic number x in the number field nf",
  "if(a,seq1,seq2):  if a is nonzero, seq1 is evaluated, otherwise seq2. seq1 and seq2 are optional, and if seq2 is omitted, the preceding comma can be omitted also",
  "imag(x): imaginary part of x",
  "incgam(s,x,{y}): incomplete gamma function. y is optional and is the precomputed value of gamma(s)",
  "incgamc(s,x): complementary incomplete gamma function",
  "intformal(x,{y}): formal integration of x with respect to the main variable of y, or to the main variable of x if y is omitted",
  "intnum(X=a,b,s,{flag=0}): numerical integration of s (smooth in ]a,b[) from a to b with respect to X. flag is optional and mean 0: default. s can be evaluated exactly on [a,b]; 1: general function; 2: a or b can be plus or minus infinity (chosen suitably), but of same sign; 3: s has only limits at a or b",
  "isfundamental(x): true(1) if x is a fundamental discriminant (including 1), false(0) if not",
  "isprime(x,{flag=0}): if flag is omitted or 0, true(1) if x is a strong pseudoprime for 10 random bases, false(0) if not. If flag is 1, the primality is certified by the Pocklington-Lehmer Test. If flag is 2, the primality is certified using the APRCL test.",
  "ispseudoprime(x): true(1) if x is a strong pseudoprime, false(0) if not",
  "issquare(x,{&n}): true(1) if x is a square, false(0) if not. If n is given puts the exact square root there if it was computed",
  "issquarefree(x): true(1) if x is squarefree, false(0) if not",
  "kronecker(x,y): kronecker symbol (x/y)",
  "lcm(x,{y}): least common multiple of x and y=x*y/gcd(x,y)",
  "length(x): number of non code words in x, number of characters for a string",
  "lex(x,y): compare x and y lexicographically (1 if x>y, 0 if x=y, -1 if x<y)",
  "lift(x,{v}): lifts every element of Z/nZ to Z or T[x]/PT[x] to T[x] for a type T if v is omitted, otherwise lift only polymods with main variable v. If v does not occur in x, lift only intmods",
  "lindep(x,{flag=0}): Z-linear dependencies between components of x. flag is optional, and can be 0: default, using Hastad et al; positive, and in that case should be between 0.5 and 1.0 times the accuracy in decimal digits of x, using a standard LLL; or negative in which case it returns, once a relation has been found",
  "listcreate(n): creates an empty list of length n",
  "listinsert(list,x,n): insert x at index n in list, shifting the remaining elements to the right",
  "listkill(list): kills list",
  "listput(list,x,{n}): sets n-th element of list equal to x. If n is omitted or greater than the current list length, just append x",
  "listsort(list,{flag=0}): sort list in place. If flag is non-zero, suppress all but one occurence of each element in list",
  "lngamma(x): logarithm of the gamma function of x",
  "log(x,{flag=0}): natural logarithm of x. flag is optional, and can be 0: default, or 1: calls logagm, computed using the agm",
  "matadjoint(x): adjoint matrix of x",
  "matalgtobasis(nf,x): nfalgtobasis applied to every element of the matrix x",
  "matbasistoalg(nf,x): nfbasistoalg applied to every element of the matrix x",
  "matcompanion(x): companion matrix to polynomial x",
  "matdet(x,{flag=0}): determinant of the matrix x using Gauss-Bareiss. If (optional) flag is set to 1, use classical gaussian elimination (slightly better for integer entries)",
  "matdetint(x): some multiple of the determinant of the lattice generated by the columns of x (0 if not of maximal rank). Useful with mathnfmod",
  "matdiagonal(x): creates the diagonal matrix whose diagonal entries are the entries of the vector x",
  "mateigen(x): eigenvectors of the matrix x given as columns of a matrix",
  "mathess(x): Hessenberg form of x",
  "mathilbert(n): Hilbert matrix of order n (n C-integer)",
  "mathnf(x,{flag=0}): (upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x. flag is optional whose value range from 0 to 4 (0 if omitted), meaning : 0: naive algorithm. 1: Use Batut's algorithm. Output 2-component vector [H,U] such that H is the HNF of x, and U is a unimodular matrix such that xU=H. 2: Use Havas's algorithm. Output 3-component vector [H,U,P] such that H is the HNF of x, U is unimodular and P is a permutation of the rows such that P applied to xU gives H. 3: Use Batut's algorithm. Output [H,U,P] as in 2",
  "mathnfmod(x,d): (upper triangular) Hermite normal form of x, basis for the lattice formed by the columns of x, where d is a multiple of the non-zero determinant of this lattice",
  "mathnfmodid(x,d): (upper triangular) Hermite normal form of x concatenated with d times the identity matrix",
  "matid(n): identity matrix of order n (n C-integer)",
  "matimage(x,{flag=0}): basis of the image of the matrix x. flag is optional and can be set to 0 or 1, corresponding to two different algorithms",
  "matimagecompl(x): vector of column indices not corresponding to the indices given by the function matimage",
  "matindexrank(x): gives two extraction vectors (rows and columns) for the matrix x such that the extracted matrix is square of maximal rank",
  "matintersect(x,y): intersection of the vector spaces whose bases are the columns of x and y",
  "matinverseimage(x,y): an element of the inverse image of the vector y by the matrix x if one exists, the empty vector otherwise",
  "matisdiagonal(x): true(1) if x is a diagonal matrix, false(0) otherwise",
  "matker(x,{flag=0}): basis of the kernel of the matrix x. flag is optional, and may be set to 0: default; non-zero: x is known to have integral entries",
  "matkerint(x,{flag=0}): LLL-reduced Z-basis of the kernel of the matrix x with integral entries. flag is optional, and may be set to 0: default, uses a modified LLL, 1: uses matrixqz3 and the HNF, 2: uses another modified LLL",
  "matmuldiagonal(x,d): product of matrix x by diagonal matrix whose diagonal coefficients are those of the vector d, equivalent but faster than x*matdiagonal(d)",
  "matmultodiagonal(x,y): product of matrices x and y, knowing that the result will be a diagonal matrix. Much faster than general multiplication in that case",
  "matpascal(n,{q}): Pascal triangle of order n if q is omited. q-Pascal triangle otherwise",
  "matrank(x): rank of the matrix x",
  "matrix(m,n,{X},{Y},{expr=0}): mXn matrix of expression expr, the row variable X going from 1 to m and the column variable Y going from 1 to n. By default, fill with 0s",
  "matrixqz(x,p): if p>=0, transforms the rational or integral mxn (m>=n) matrix x into an integral matrix with gcd of maximal determinants equal to 1 if p is equal to 0, not divisible by p otherwise. If p=-1, finds a basis of the intersection with Z^n of the lattice spanned by the columns of x. If p=-2, finds a basis of the intersection with Z^n of the Q-vector space spanned by the columns of x",
  "matsize(x): number of rows and columns of the vector/matrix x as a 2-vector",
  "matsnf(x,{flag=0}): Smith normal form (i.e. elementary divisors) of the matrix x, expressed as a vector d. Binary digits of flag mean 1: returns [u,v,d] where d=u*x*v, otherwise only the diagonal d is returned, 2: allow polynomial entries, otherwise assume x is integral, 4: removes all information corresponding to entries equal to 1 in d",
  "matsolve(M,B): gaussian solution of MX=B (M matrix, B column vector)",
  "matsolvemod(M,D,B,{flag=0}): one solution of system of congruences MX=B mod D (M matrix, B and D column vectors). If (optional) flag is non-null return all solutions",
  "matsupplement(x): supplement the columns of the matrix x to an invertible matrix",
  "mattranspose(x): x~=transpose of x",
  "max(x,y): maximum of x and y",
  "min(x,y): minimum of x and y",
  "modreverse(x): reverse polymod of the polymod x, if it exists",
  "moebius(x): Moebius function of x",
  "newtonpoly(x,p): Newton polygon of polynomial x with respect to the prime p",
  "next({n=1}): interrupt execution of current instruction sequence, and start another iteration from the n-th innermost enclosing loops",
  "nextprime(x): smallest prime number>=x",
  "nfalgtobasis(nf,x): transforms the algebraic number x into a column vector on the integral basis nf.zk",
  "nfbasis(x,{flag=0},{p}): integral basis of the field Q[a], where a is a root of the polynomial x, using the round 4 algorithm. Second and third args are optional. Binary digits of flag mean 1: assume that no square of a prime>primelimit divides the discriminant of x, 2: use round 2 algorithm instead. If present, p provides the matrix of a partial factorization of the discriminant of x, useful if one wants only an order maximal at certain primes only",
  "nfbasistoalg(nf,x): transforms the column vector x on the integral basis into an algebraic number",
  "nfdetint(nf,x): multiple of the ideal determinant of the pseudo generating set x",
  "nfdisc(x,{flag=0},{p}): discriminant of the number field defined by the polynomial x using round 4. Optional args flag and p are as in nfbasis",
  "nfeltdiv(nf,a,b): element a/b in nf",
  "nfeltdiveuc(nf,a,b): gives algebraic integer q such that a-bq is small",
  "nfeltdivmodpr(nf,a,b,pr): element a/b modulo pr in nf, where pr is in modpr format (see nfmodprinit)",
  "nfeltdivrem(nf,a,b): gives [q,r] such that r=a-bq is small",
  "nfeltmod(nf,a,b): gives r such that r=a-bq is small with q algebraic integer",
  "nfeltmul(nf,a,b): element a. b in nf",
  "nfeltmulmodpr(nf,a,b,pr): element a. b modulo pr in nf, where pr is in modpr format (see nfmodprinit)",
  "nfeltpow(nf,a,k): element a^k in nf",
  "nfeltpowmodpr(nf,a,k,pr): element a^k modulo pr in nf, where pr is in modpr format (see nfmodprinit)",
  "nfeltreduce(nf,a,id): gives r such that a-r is in the ideal id and r is small",
  "nfeltreducemodpr(nf,a,pr): element a modulo pr in nf, where pr is in modpr format (see nfmodprinit)",
  "nfeltval(nf,a,pr): valuation of element a at the prime pr as output by idealprimedec",
  "nffactor(nf,x): factor polynomial x in number field nf",
  "nffactormod(nf,pol,pr): factorize polynomial pol modulo prime ideal pr in number field nf",
  "nfgaloisapply(nf,aut,x): Apply the Galois automorphism sigma (polynomial or polymod) to the object x (element or ideal) in the number field nf",
  "nfgaloisconj(nf,{flag=0},{den}): list of conjugates of a root of the polynomial x=nf.pol in the same number field. flag is optional (set to 0 by default), meaning 0: use combination of flag 4 and 1, always complete; 1: use nfroots; 2 : use complex numbers, LLL on integral basis (not always complete); 4: use Allombert's algorithm, complete if the field is Galois of degree <= 35 (see manual for detail). nf can be simply a polynomial with flag 0,2 and 4, meaning: 0: use combination of flag 4 and 2, not always complete (but a warning is issued when the list is not proven complete); 2 & 4: same meaning and restrictions. Note that only flag 4 can be applied to fields of large degrees (approx. >= 20)",
  "nfhilbert(nf,a,b,{p}): if p is omitted, global Hilbert symbol (a,b) in nf, that is 1 if X^2-aY^2-bZ^2 has a non-trivial solution (X,Y,Z) in nf, -1 otherwise. Otherwise compute the local symbol modulo the prime ideal p",
  "nfhnf(nf,x): if x=[A,I], gives a pseudo-basis of the module sum A_jI_j",
  "nfhnfmod(nf,x,detx): if x=[A,I], and detx is a multiple of the ideal determinant of x, gives a pseudo-basis of the module sum A_jI_j",
  "nfinit(pol,{flag=0}): pol being a nonconstant irreducible polynomial, gives the vector: [pol,[r1,r2],discf,index,[M,MC,T2,T,different] (see manual),r1+r2 first roots, integral basis, matrix of power basis in terms of integral basis, multiplication table of basis]. flag is optional and can be set to 0: default; 1: do not compute different; 2: first use polred to find a simpler polynomial; 3: outputs a two-element vector [nf,Mod(a,P)], where nf is as in 2 and Mod(a,P) is a polymod equal to Mod(x,pol) and P=nf.pol; 4: as 2 but use a partial polred; 5: is to 3 what 4 is to 2",
  "nfisideal(nf,x): true(1) if x is an ideal in the number field nf, false(0) if not",
  "nfisincl(x,y): tests whether the number field x is isomorphic to a subfield of y (where x and y are either polynomials or number fields as output by nfinit). Return 0 if not, and otherwise all the isomorphisms. If y is a number field, a faster algorithm is used",
  "nfisisom(x,y): as nfisincl but tests whether x is isomorphic to y",
  "nfkermodpr(nf,x,pr): kernel of the matrix x in Z_K/pr, where pr is in modpr format (see nfmodprinit)",
  "nfmodprinit(nf,pr): transform the 5 element row vector pr representing a prime ideal into modpr format necessary for all operations mod pr in the number field nf (see manual for details about the format)",
  "nfnewprec(nf): transform the number field data nf into new data using the current (usually larger) precision",
  "nfroots(nf,pol): roots of polynomial pol belonging to nf without multiplicity",
  "nfrootsof1(nf): number of roots of unity and primitive root of unity in the number field nf",
  "nfsnf(nf,x): if x=[A,I,J], outputs [c_1,...c_n] Smith normal form of x",
  "nfsolvemodpr(nf,a,b,pr): solution of a*x=b in Z_K/pr, where a is a matrix and b a column vector, and where pr is in modpr format (see nfmodprinit)",
  "nfsubfields(nf,{d=0}): find all subfields of degree d of number field nf (all subfields if d is null or omitted). Result is a vector of subfields, each being given by [g,h], where g is an absolute equation and h expresses one of the roots of g in terms of the root x of the polynomial defining nf",
  "norm(x): norm of x",
  "norml2(x): square of the L2-norm of the vector x",
  "numdiv(x): number of divisors of x",
  "numerator(x): numerator of x",
  "numtoperm(n,k): permutation number k (mod n!) of n letters (n C-integer)",
  "omega(x): number of distinct prime divisors of x",
  "padicappr(x,a): p-adic roots of the polynomial x congruent to a mod p",
  "padicprec(x,p): absolute p-adic precision of object x",
  "permtonum(vect): ordinal (between 1 and n!) of permutation vect",
  "polcoeff(x,s,{v}): coefficient of degree s of x, or the s-th component for vectors or matrices (for which it is simpler to use x[]). With respect to the main variable if v is omitted, with respect to the variable v otherwise",
  "polcompositum(pol1,pol2,{flag=0}): vector of all possible compositums of the number fields defined by the polynomials pol1 and pol2. If (optional) flag is set (i.e non-null), output for each compositum, not only the compositum polynomial pol, but a vector [pol,al1,al2,k] where al1 (resp. al2) is a root of pol1 (resp. pol2) expressed as a polynomial modulo pol, and a small integer k such that al2+k*al1 is the chosen root of pol",
  "polcyclo(n,{v=x}): n-th cyclotomic polynomial (in variable v)",
  "poldegree(x,{v}): degree of the polynomial or rational function x with respect to main variable if v is omitted, with respect to v otherwise. Return -1 if x = 0, and 0 if it's a non-zero scalar",
  "poldisc(x,{v}): discriminant of the polynomial x, with respect to main variable if v is omitted, with respect to v otherwise",
  "poldiscreduced(f): vector of elementary divisors of Z[a]/f'(a)Z[a], where a is a root of the polynomial f",
  "polgalois(x): Galois group of the polynomial x (see manual for group coding)",
  "polhensellift(x, y, p, e): lift the factorization y of x modulo p to a factorization modulo p^e using Hensel lift. The factors in y must be pairwise relatively prime modulo p",
  "polinterpolate(xa,{ya},{x},{&e}): polynomial interpolation at x according to data vectors xa, ya (ie return P such that P(xa[i]) = ya[i] for all i). If ya is omitter, return P such that P(i) = xa[i]. If present, e will contain an error estimate on the returned value",
  "polisirreducible(x): true(1) if x is an irreducible non-constant polynomial, false(0) if x is reducible or constant",
  "pollead(x,{v}): leading coefficient of polynomial or series x, or x itself if x is a scalar. Error otherwise. With respect to the main variable of x if v is omitted, with respect to the variable v otherwise",
  "pollegendre(n,{v=x}): legendre polynomial of degree n (n C-integer), in variable v",
  "polrecip(x): reciprocal polynomial of x",
  "polred(x,{flag=0},{p}): reduction of the polynomial x (gives minimal polynomials only). Second and third args are optional. The following binary digits of flag are significant 1: partial reduction, 2: gives also elements. p, if present, contains the complete factorization matrix of the discriminant",
  "polredabs(x,{flag=0}): a smallest generating polynomial of the number field for the T2 norm on the roots, with smallest index for the minimal T2 norm. flag is optional, whose binary digit mean 1: give the element whose characteristic polynomial is the given polynomial. 4: give all polynomials of minimal T2 norm (give only one of P(x) and P(-x)). 16: partial reduction",
  "polredord(x): reduction of the polynomial x, staying in the same order",
  "polresultant(x,y,{v},{flag=0}): resultant of the polynomials x and y, with respect to the main variables of x and y if v is omitted, with respect to the variable v otherwise. flag is optional, and can be 0: default, assumes that the polynomials have exact entries (uses the subresultant algorithm), 1 for arbitrary polynomials, using Sylvester's matrix, or 2: using a Ducos's modified subresultant algorithm",
  "polroots(x,{flag=0}): complex roots of the polynomial x. flag is optional, and can be 0: default, uses Schonhage's method modified by Gourdon, or 1: uses a modified Newton method",
  "polrootsmod(x,p,{flag=0}): roots mod p of the polynomial x. flag is optional, and can be 0: default, or 1: use a naive search, useful for small p",
  "polrootspadic(x,p,r): p-adic roots of the polynomial x to precision r",
  "polsturm(x,{a},{b}): number of real roots of the polynomial x in the interval]a,b] (which are respectively taken to be -oo or +oo when omitted)",
  "polsubcyclo(n,d,{v=x}): finds an equation (in variable v) for the d-th degree subfields of Q(zeta_n). Output is a polynomial or a vector of polynomials is there are several such fields, or none.",
  "polsylvestermatrix(x,y): forms the sylvester matrix associated to the two polynomials x and y. Warning: the polynomial coefficients are in columns, not in rows",
  "polsym(x,n): vector of symmetric powers of the roots of x up to n",
  "poltchebi(n,{v=x}): Tchebitcheff polynomial of degree n (n C-integer), in variable v",
  "poltschirnhaus(x): random Tschirnhausen transformation of the polynomial x",
  "polylog(m,x,{flag=0}): m-th polylogarithm of x. flag is optional, and can be 0: default, 1: D_m~-modified m-th polylog of x, 2: D_m-modified m-th polylog of x, 3: P_m-modified m-th polylog of x",
  "polzagier(n,m): Zagier's polynomials of index n,m",
  "precision(x,{n}): change the precision of x to be n (n C-integer). If n is omitted, output real precision of object x",
  "precprime(x): largest prime number<=x, 0 if x<=1",
  "prime(n): returns the n-th prime (n C-integer)",
  "primes(n): returns the vector of the first n primes (n C-integer)",
  "prod(X=a,b,expr,{x=1}): x times the product (X runs from a to b) of expression",
  "prodeuler(X=a,b,expr): Euler product (X runs over the primes between a and b) of real or complex expression",
  "prodinf(X=a,expr,{flag=0}): infinite product (X goes from a to infinity) of real or complex expression. flag can be 0 (default) or 1, in which case compute the product of the 1+expr instead",
  "psi(x): psi-function at x",
  "qfbclassno(x,{flag=0}): class number of discriminant x using Shanks's method by default. If (optional) flag is set to 1, use Euler products",
  "qfbcompraw(x,y): Gaussian composition without reduction of the binary quadratic forms x and y",
  "qfbhclassno(x): Hurwitz-Kronecker class number of x>0",
  "qfbnucomp(x,y,l): composite of primitive positive definite quadratic forms x and y using nucomp and nudupl, where l=[|D/4|^(1/4)] is precomputed",
  "qfbnupow(x,n): n-th power of primitive positive definite quadratic form x using nucomp and nudupl",
  "qfbpowraw(x,n): n-th power without reduction of the binary quadratic form x",
  "qfbprimeform(x,p): returns the prime form of discriminant x, whose first coefficient is p",
  "qfbred(x,{flag=0},{D},{isqrtD},{sqrtD}): reduction of the binary quadratic form x. All other args. are optional. D, isqrtD and sqrtD, if present, supply the values of the discriminant, floor(sqrt(D)) and sqrt(D) respectively. If D<0, its value is not used and all references to Shanks's distance hereafter are meaningless. flag can be any of 0: default, uses Shanks's distance function d; 1: use d, do a single reduction step; 2: do not use d; 3: do not use d, single reduction step. ",
  "qfgaussred(x): square reduction of the (symmetric) matrix x (returns a square matrix whose i-th diagonal term is the coefficient of the i-th square in which the coefficient of the i-th variable is 1)",
  "qfjacobi(x): eigenvalues and orthogonal matrix of eigenvectors of the real symmetric matrix x",
  "qflll(x,{flag=0}): LLL reduction of the vectors forming the matrix x (gives the unimodular transformation matrix). flag is optional, and can be 0: default, 1: lllint algorithm for integer matrices, 2: lllintpartial algorithm for integer matrices, 4: lllkerim giving the kernel and the LLL reduced image, 5: lllkerimgen same but if the matrix has polynomial coefficients, 8: lllgen, same as qflll when the coefficients are polynomials",
  "qflllgram(x,{flag=0}): LLL reduction of the lattice whose gram matrix is x (gives the unimodular transformation matrix). flag is optional and can be 0: default,1: lllgramint algorithm for integer matrices, 4: lllgramkerim giving the kernel and the LLL reduced image, 5: lllgramkerimgen same when the matrix has polynomial coefficients, 8: lllgramgen, same as qflllgram when the coefficients are polynomials",
  "qfminim(x,bound,maxnum,{flag=0}): number of vectors of square norm <= bound, maximum norm and list of vectors for the integral and definite quadratic form x; minimal non-zero vectors if bound=0. flag is optional, and can be 0: default; 1: returns the first minimal vector found (ignore maxnum); 2: as 0 but use Fincke-Pohst (valid for non integral quadratic forms)",
  "qfperfection(a): rank of matrix of xx~ for x minimal vectors of a gram matrix a",
  "qfsign(x): signature of the symmetric matrix x",
  "quadclassunit(D,{flag=0},{tech=[]}): compute the structure of the class group and the regulator of the quadratic field of discriminant D. If flag is non-null (and D>0), compute the narrow class group. See manual for the optional technical parameters",
  "quaddisc(x): discriminant of the quadratic field Q(sqrt(x))",
  "quadgen(x): standard generator of quadratic order of discriminant x",
  "quadhilbert(D,{flag=0}): relative equation for the Hilbert class field of the quadratic field of discriminant D (which can also be a bnf). If flag is a non-zero integer and D<0, list of [form,root(form)] (used for contructing subfields). If D<0, flag can also be a 2-component vector [p,q], where p,q are the prime numbers needed for Schertz's method. In that case, return 0 if [p,q] not suitable. If D>0 and flag is non-zero, try hard to find the best modulus",
  "quadpoly(D,{v=x}): quadratic polynomial corresponding to the discriminant D, in variable v",
  "quadray(D,f,{flag=0}): relative equation for the ray class field of conductor f for the quadratic field of discriminant D (which can also be a bnf). For D < 0, flag has the following meaning: if flag is an odd integer, output instead the vector of [ideal,corresponding root]. It can also be a two component vector [lambda,flag], where flag is as above and lambda is the technical element of bnf necessary for Schertz's method. In that case, return 0 if lambda is not suitable. For D > 0, if flag is non-zero, try hard to find the best modulus",
  "quadregulator(x): regulator of the real quadratic field of discriminant x",
  "quadunit(x): fundamental unit of the quadratic field of discriminant x where x must be positive",
  "random({N=2^31}): random integer between 0 and N-1",
  "real(x): real part of x",
  "removeprimes({x=[]}): remove primes in the vector x (with at most 100 components) from the prime table. x can also be a single integer. List the current extra primes if x is omitted",
  "reorder({x=[]}): reorder the variables for output according to the vector x. If x is void or omitted, print the current list of variables",
  "return({x=0}): return from current subroutine with result x",
  "rnfalgtobasis(rnf,x): relative version of nfalgtobasis, where rnf is a relative numberfield",
  "rnfbasis(bnf,order): given an order as output by rnfpseudobasis or rnfsteinitz, gives either a basis of the order if it is free, or an n+1-element generating set",
  "rnfbasistoalg(rnf,x): relative version of nfbasistoalg, where rnf is a relative numberfield",
  "rnfcharpoly(nf,T,alpha,{var=x}): characteristic polynomial of alpha over nf,  where alpha belongs to the algebra defined by T over nf. Returns a polynomial in variable var (x by default)",
  "rnfconductor(bnf,polrel,{flag=0}): conductor of the Abelian extension of bnf defined by polrel. The result is [conductor,rayclassgroup,subgroup], where conductor is the conductor itself, rayclassgroup the structure of the corresponding full ray class group, and subgroup the HNF defining the norm group (Artin or Takagi group) on the given generators rayclassgroup[3]. If flag is non-zero, check (under GRH) that polrel indeed defines an Abelian extension",
  "rnfdedekind(nf,T,pr): relative Dedekind criterion over nf, applied to the order defined by a root of irreducible polynomial T, modulo the prime ideal pr. Returns [flag,basis,val], where basis is a pseudo-basis of the enlarged order, flag is 1 iff this order is pr-maximal, and val is the valuation in pr of the order discriminant",
  "rnfdet(nf,order): given a pseudomatrix, compute its pseudodeterminant",
  "rnfdisc(nf,pol): given a pol with coefficients in nf, gives a 2-component vector [D,d], where D is the relative ideal discriminant, and d is the relative discriminant in nf^*/nf*^2",
  "rnfeltabstorel(rnf,x): transforms the element x from absolute to relative representation",
  "rnfeltdown(rnf,x): expresses x on the base field if possible; returns an error otherwise",
  "rnfeltreltoabs(rnf,x): transforms the element x from relative to absolute representation",
  "rnfeltup(rnf,x): expresses x (belonging to the base field) on the relative field",
  "rnfequation(nf,pol,{flag=0}): given a pol with coefficients in nf, gives the absolute equation apol of the number field defined by pol. flag is optional, and can be 0: default, or non-zero, gives [apol,th], where th expresses the root of nf.pol in terms of the root of apol",
  "rnfhnfbasis(bnf,order): given an order as output by rnfpseudobasis, gives either a true HNF basis of the order if it exists, zero otherwise",
  "rnfidealabstorel(rnf,x): transforms the ideal x from absolute to relative representation",
  "rnfidealdown(rnf,x): finds the intersection of the ideal x with the base field",
  "rnfidealhnf(rnf,x): relative version of idealhnf, where rnf is a relative numberfield",
  "rnfidealmul(rnf,x,y): relative version of idealmul, where rnf is a relative numberfield",
  "rnfidealnormabs(rnf,x): absolute norm of the ideal x",
  "rnfidealnormrel(rnf,x): relative norm of the ideal x",
  "rnfidealreltoabs(rnf,x): transforms the ideal x from relative to absolute representation",
  "rnfidealtwoelt(rnf,x): relative version of idealtwoelement, where rnf is a relative numberfield",
  "rnfidealup(rnf,x): lifts the ideal x (of the base field) to the relative field",
  "rnfinit(nf,pol): pol being a non constant irreducible polynomial defined over the number field nf, initializes a vector of data necessary for working in relative number fields (rnf functions). See manual for technical details",
  "rnfisfree(bnf,order): given an order as output by rnfpseudobasis or rnfsteinitz, outputs true (1) or false (0) according to whether the order is free or not",
  "rnfisnorm(bnf,ext,x,{flag=1}): Tries to tell whether x (in bnf) is the norm of some y (in ext). Returns a vector [a,b] where x=Norm(a)*b. Looks for a solution which is a S-integer, with S a list of places (in bnf) containing the ramified primes, generators of the class group of ext, as well as those primes dividing x. If ext/bnf is known to be Galois, set flag=0 (here x is a norm iff b=1). If flag is non zero add to S all the places above the primes: dividing flag if flag<0, less than flag if flag>0. The answer is guaranteed (i.e x norm iff b=1) under GRH, if S contains all primes less than 12.log(Ext)^2, where Ext is the normal closure of ext/bnf",
  "rnfkummer(bnr,{subgroup},{deg=0}): bnr being as output by bnrinit, finds a relative equation for the class field corresponding to the module in bnr and the given congruence subgroup (the ray class field if subgroup is omitted). deg can be zero (default), or positive, and in this case the output is the list of all relative equations of degree deg for the given bnr",
  "rnflllgram(nf,pol,order): given a pol with coefficients in nf and an order as output by rnfpseudobasis or similar, gives [[neworder],U], where neworder is a reduced order and U is the unimodular transformation matrix",
  "rnfnormgroup(bnr,polrel): norm group (or Artin or Takagi group) corresponding to the Abelian extension of bnr.bnf defined by polrel, where the module corresponding to bnr is assumed to be a multiple of the conductor. The result is the HNF defining the norm group on the given generators in bnr[5][3]",
  "rnfpolred(nf,pol): given a pol with coefficients in nf, finds a list of relative polynomials defining some subfields, hopefully simpler",
  "rnfpolredabs(nf,pol,{flag=0}): given a pol with coefficients in nf, finds a relative simpler polynomial defining the same field. flag is optional, 0 is default, 1 returns also the element whose characteristic polynomial is the given polynomial and 2 returns an absolute polynomial",
  "rnfpseudobasis(nf,pol): given a pol with coefficients in nf, gives a 4-component vector [A,I,D,d] where [A,I] is a pseudo basis of the maximal order in HNF on the power basis, D is the relative ideal discriminant, and d is the relative discriminant in nf^*/nf*^2",
  "rnfsteinitz(nf,order): given an order as output by rnfpseudobasis, gives [A,I,D,d] where (A,I) is a pseudo basis where all the ideals except perhaps the last are trivial",
  "round(x,{&e}): take the nearest integer to all the coefficients of x. If e is present, do not take into account loss of integer part precision, and set e = error estimate in bits",
  "serconvol(x,y): convolution (or Hadamard product) of two power series",
  "serlaplace(x): replaces the power series sum of a_n*x^n/n! by sum of a_n*x^n. For the reverse operation, use serconvol(x,exp(X))",
  "serreverse(x): reversion of the power series x",
  "setintersect(x,y): intersection of the sets x and y",
  "setisset(x): true(1) if x is a set (row vector with strictly increasing entries), false(0) if not",
  "setminus(x,y): set of elements of x not belonging to y",
  "setrand(n): reset the seed of the random number generator to n",
  "setsearch(x,y,{flag=0}): looks if y belongs to the set x. If flag is 0 or omitted, returns 0 if it is not, otherwise returns the index j such that y==x[j]. If flag is non-zero, return 0 if y belongs to x, otherwise the index j where it should be inserted",
  "setunion(x,y): union of the sets x and y",
  "shift(x,n,{flag=0}): shift x left n bits if n>=0, right -n bits if n<0. If flag is true and n is negative, will treat negative integer x as if modulo big power of 2, otherwise sign of x is ignored but preserved",
  "shiftmul(x,n): multiply x by 2^n (n>=0 or n<0)",
  "sigma(x,{k=1}): sum of the k-th powers of the divisors of x. k is optional and if omitted is assumed to be equal to 1",
  "sign(x): sign of x, of type integer, real or fraction",
  "simplify(x): simplify the object x as much as possible",
  "sin(x): sine of x",
  "sinh(x): hyperbolic sine of x",
  "sizebyte(x): number of bytes occupied by the complete tree of the object x",
  "sizedigit(x): maximum number of decimal digits minus one of (the coefficients of) x",
  "solve(X=a,b,expr): real root of expression expr (X between a and b), where expr(a)*expr(b)<=0",
  "sqr(x): square of x. NOT identical to x*x",
  "sqrt(x): square root of x",
  "sqrtint(x): integer square root of x (x integer)",
  "sqrtn(x,n,{&z}): nth-root of x, n must be integer. If present, z is set to a suitable root of unity to recover all solutions. If it was not possible, z is set to zero",
  "subgrouplist(bnr,{bound},{flag=0}): bnr being as output by bnrinit or a list of cyclic components of a finite Abelian group G, outputs the list of subgroups of G (of index bounded by bound, if not omitted), given as HNF left divisors of the SNF matrix corresponding to G. If flag=0 (default) and bnr is as output by bnrinit, gives only the subgroups for which the modulus is the conductor",
  "subst(x,y,z): in expression x, replace the variable y by the expression z",
  "sum(X=a,b,expr,{x=0}): x plus the sum (X goes from a to b) of expression expr",
  "sumalt(X=a,expr,{flag=0}): Cohen-Villegas-Zagier's acceleration of alternating series expr, X starting at a. flag is optional, and can be 0: default, or 1: uses a slightly different method using Zagier's polynomials",
  "sumdiv(n,X,expr): sum of expression expr, X running over the divisors of n",
  "suminf(X=a,expr): infinite sum (X goes from a to infinity) of real or complex expression expr",
  "sumpos(X=a,expr,{flag=0}): sum of positive series expr, the formal variable X starting at a. flag is optional, and can be 0: default, or 1: uses a slightly different method using Zagier's polynomials",
  "tan(x): tangent of x",
  "tanh(x): hyperbolic tangent of x",
  "taylor(x,y): taylor expansion of x with respect to the main variable of y",
  "teichmuller(x): teichmuller character of p-adic number x",
  "theta(q,z): Jacobi sine theta-function",
  "thetanullk(q,k): k'th derivative at z=0 of theta(q,z)",
  "thue(tnf,a,{sol}): solve the equation P(x,y)=a, where tnf was created with thueinit(P), and sol, if present, contains the solutions of Norm(x)=a modulo units in the number field defined by P. If tnf was computed without assuming GRH (flag 1 in thueinit), the result is unconditional",
  "thueinit(P,{flag=0}): initialize the tnf corresponding to P, that will be used to solve Thue equations P(x,y) = some-integer. If flag is non-zero, certify the result unconditionnaly. Otherwise, assume GRH (much faster of course)",
  "trace(x): trace of x",
  "truncate(x,{&e}): truncation of x; when x is a power series,take away the O(X^). If e is present, do not take into account loss of integer part precision, and set e = error estimate in bits",
  "until(a,seq): evaluate the expression sequence seq until a is nonzero",
  "valuation(x,p): valuation of x with respect to p",
  "variable(x): main variable of object x. Gives p for p-adic x, error for scalars",
  "vecextract(x,y,{z}): extraction of the components of the matrix or vector x according to y and z. If z is omitted, y designs columns, otherwise y corresponds to rows and z to columns. y and z can be vectors (of indices), strings (indicating ranges as in \"1..10\") or masks (integers whose binary representation indicates the indices to extract, from left to right 1, 2, 4, 8, etc.)",
  "vecmax(x): maximum of the elements of the vector/matrix x",
  "vecmin(x): minimum of the elements of the vector/matrix x",
  "vecsort(x,{k},{flag=0}): sorts the vector of vectors (or matrix) x, according to the value of its k-th component if k is not omitted. Binary digits of flag (if present) mean: 1: indirect sorting, return the permutation instead of the permuted vector, 2: sort using ascending lexicographic order",
  "vector(n,{X},{expr=0}): row vector with n components of expression expr (X ranges from 1 to n). By default, fill with 0s",
  "vectorsmall(n,{X},{expr=0}): VECSMALL with n components of expression expr (X ranges from 1 to n) which must be small integers. By default, fill with 0s",
  "vectorv(n,{X},{expr=0}): column vector with n components of expression expr (X ranges from 1 to n). By default, fill with 0s",
  "weber(x,{flag=0}): One of Weber's f function of x. flag is optional, and can be 0: default, function f(x)=exp(-i*Pi/24)*eta((x+1)/2)/eta(x) such that (j=(f^24-16)^3/f^24), 1: function f1(x)=eta(x/2)/eta(x) such that (j=(f1^24+16)^3/f2^24), 2: function f2(x)=sqrt(2)*eta(2*x)/eta(x) such that (j=(f2^24+16)^3/f2^24)",
  "while(a,seq):  while a is nonzero evaluate the expression sequence seq. Otherwise 0",
  "zeta(s): Riemann zeta function at s",
  "zetak(nfz,s,{flag=0}): Dedekind zeta function of the number field nfz at s, where nfz is the vector computed by zetakinit (NOT by nfinit) flag is optional, and can be 0: default, compute zetak, or non-zero: compute the lambdak function, i.e. with the gamma factors",
  "zetakinit(x): compute number field information necessary to use zetak, where x is an irreducible polynomial",
  "znlog(x,g): g as output by znprimroot (modulo a prime). Return smallest positive n such that g^n = x",
  "znorder(x): order of the integermod x in (Z/nZ)*",
  "znprimroot(n): returns a primitive root of n when it exists",
  "znstar(n): 3-component vector v, giving the structure of (Z/nZ)^*. v[1] is the order (i.e. eulerphi(n)), v[2] is a vector of cyclic components, and v[3] is a vector giving the corresponding generators",

/* DO NOT REMOVE THIS BLANK LINE: chname & helpsynchro depend on it */
};

