use ExtUtils::MakeMaker;
use Config;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile being created.

WriteMakefile(
    'NAME'		=>	'SHA',
    'VERSION_FROM'	=>	'SHA.pm',
    'OBJECT'		=>	q[SHA$(OBJ_EXT) sha_func$(OBJ_EXT)],
    'realclean'		=>	{'FILES' => 'endian.h'},
);

# Create the header file which influences byte swapping

if (exists($Config{'byteorder'}) and defined($Config{'byteorder'})) {
    if (-e 'endian.h') {
	warn "Warning: overwriting endian.h\n";
    } else {
	print "Writing endian.h for SHA\n";
    }
# the following commented out by warner for use in egd daemon. We always use
# SHA-1, and removing this lets the GnuPG configure process be noninteractive
#
#    print "Do you want to use the original SHA or the new standard SHA-1?\nEnter 0 for the original or 1 for the new standard. [1]";
#    $resp = <STDIN>;
#    if (defined($resp)) {
#	$resp =~ s/^\s+//;
#	$resp =~ s/\s+$//;
#	if ($resp =~ /^0/) {
#	    $resp = 0;
#	} else {
#	    $resp = 1;
#	}
#    } else {
	$resp = 1;
#    }
    open(EOUT, '>endian.h')
	or die "error: unable to open 'endian.h' for writing\n";
    print EOUT <<"END_OF_STRING";
#ifndef ENDIAN_H
#define ENDIAN_H

/* Warning! this file is automatically generated; changes WILL disappear */

#define SHA_BYTE_ORDER $Config{'byteorder'}

#define SHA_VERSION $resp

#endif /* ENDIAN_H */
END_OF_STRING
    close EOUT
	or die "error: unable to properly close 'endian.h'\n";
} else {
    die "error: the parameter 'byteorder' is not defined in Config.\n";
}
