/*
 * STAN - Stream Analyser
 * Copyright (c) 2001 Konrad Rieck <kr@roqe.org>
 * The Roqefellaz, http://www.roqe.org/stan
 *
 * This file handles the general data io, it splits the input in to blocks
 * and passes the information to the treap and the bit analysis.
 * $Id: data.c,v 1.20 2001/04/10 14:58:46 kr Exp $
 */

#include <sys/types.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>

#if HAVE_ALLOCA_H
#include <alloca.h>
#endif

#include <stan.h>
#include <data.h>
#include <treap.h>
#include <bits.h>
#include <bintree.h>
#include <stats.h>
#include <config.h>

extern int errno, verbose, progress, bits;
extern tnode_t **treap;
extern bnode_t *bintree;
size_t size = 0;

void init_data(size_t patlen)
{
    init_treap(patlen);
    init_bintree();
    init_stats();
}

void free_data(size_t patlen)
{
    free_treap(patlen);
    free_bintree();
}

void read_data(const char *path, int patlen, int opt)
{
    FILE *in;
    byte_t buf[BLOCK_SIZE];
    byte_t *pat_buf;
    int d, k, j, n, buf_filled = 0;

    if (strlen(path) > 0) {
	if (!(in = fopen(path, "r")))
	    print_error(path);
    } else {
	in = stdin;
    }

    pat_buf = (byte_t *) alloca(patlen);

    if (verbose)
	printf("Reading stream %s:  ", strlen(path) > 0 ? path : "stdin");

    for (k = BLOCK_SIZE, progress = 0; k > 0; progress++) {
	k = fread(&buf, sizeof(byte_t), BLOCK_SIZE, in);

	if (ferror(in))
	    print_error("fread():");

	for (j = 0; j < k; j++) {

	    for (n = 0; n < patlen - 1; n++)
		pat_buf[n] = pat_buf[n + 1];
	    pat_buf[n] = buf[j];

	    if (buf_filled < patlen)
		buf_filled++;

	    for (d = 0; d < patlen; d++) {

		if (buf_filled > d &&
		    (!opt ||
		     (opt == 1 && isprint(buf[j])) ||
		     (opt == 2 && isalpha(buf[j])))) {
		    tinsert(&treap[d], pat_buf + patlen - d - 1, d + 1);

		    if (!d) {
			if (bits)
			    analyse_byte(pat_buf[patlen - 1]);

			calc_correlation(pat_buf[patlen - 1]);

			size++;
		    }

		}
	    }
	}
	if (verbose)
	    print_progress();
    }

    if (fclose(in))
	print_error(path);

    if (verbose)
	printf("\bDone.\n");
}

size_t size_data()
{
    return size;
}
