/*
 * STAN - Stream Analyser
 * Copyright (c) 2001 Konrad Rieck <kr@roqe.org>
 * The Roqefellaz, http://www.roqe.org/stan
 *
 * $Id: treap.h,v 1.6 2001/02/28 18:25:58 kr Exp $
 */
typedef struct tnode tnode_t;

struct tnode {
    byte_t *pattern;
    size_t count;
    tnode_t *left, *right, *parent;
};

void init_treap(size_t patlen);
void free_treap(size_t patlen);
tnode_t **tlocate(tnode_t ** tnode, byte_t * pattern, size_t len);
tnode_t **tmin(tnode_t ** tnode);
tnode_t **tmax(tnode_t ** tnode);
size_t tdepth(tnode_t ** tnode);
size_t thigh(tnode_t ** tnode);
tnode_t **tsuccessor(tnode_t ** tnode);
tnode_t **tpredecessor(tnode_t ** tnode);
size_t tsize_tnodes(tnode_t ** tnode);
size_t tsize_total(tnode_t ** tnode);
void tprint(tnode_t * tnode);
void tfree(tnode_t * tnode);
tnode_t **tdelete(tnode_t ** tnode, size_t patlen);
void tinsert(tnode_t ** tnode, byte_t * pattern, size_t patlen);
void ttraverse(tnode_t ** tnode, void (*func) (tnode_t *), int order);
void check_heap(tnode_t * tnode);
void check_tree(tnode_t * tnode, size_t patlen);
void rotate_left(tnode_t ** tnode, size_t patlen);
void rotate_right(tnode_t ** tnode, size_t patlen);
